"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class DesktopImage(google.protobuf.message.Message):
    """A desktop image resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[DesktopImage._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: DesktopImage._Status.ValueType  # 0
        CREATING: DesktopImage._Status.ValueType  # 1
        """Image is being created."""
        ACTIVE: DesktopImage._Status.ValueType  # 2
        """Image is ready to use."""
        DELETING: DesktopImage._Status.ValueType  # 3
        """Image is being deleted."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNSPECIFIED: DesktopImage.Status.ValueType  # 0
    CREATING: DesktopImage.Status.ValueType  # 1
    """Image is being created."""
    ACTIVE: DesktopImage.Status.ValueType  # 2
    """Image is ready to use."""
    DELETING: DesktopImage.Status.ValueType  # 3
    """Image is being deleted."""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    STORAGE_SIZE_FIELD_NUMBER: builtins.int
    MIN_DISK_SIZE_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the image."""
    folder_id: builtins.str
    """ID of the folder that the image belongs to."""
    status: global___DesktopImage.Status.ValueType
    """Status of the image."""
    name: builtins.str
    """Name of the image."""
    storage_size: builtins.int
    """Size of the image, specified in bytes."""
    min_disk_size: builtins.int
    """Minimum disk size in bytes required to use the image."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Description of the image."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        status: global___DesktopImage.Status.ValueType = ...,
        name: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        storage_size: builtins.int = ...,
        min_disk_size: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["created_at", b"created_at", "folder_id", b"folder_id", "id", b"id", "labels", b"labels", "min_disk_size", b"min_disk_size", "name", b"name", "status", b"status", "storage_size", b"storage_size"]) -> None: ...

global___DesktopImage = DesktopImage
