"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Desktop(google.protobuf.message.Message):
    """A desktop resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Desktop._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: Desktop._Status.ValueType  # 0
        CREATING: Desktop._Status.ValueType  # 1
        """Desktop is being created."""
        ACTIVE: Desktop._Status.ValueType  # 2
        """Desktop is ready to be used."""
        DELETING: Desktop._Status.ValueType  # 3
        """Desktop is being deleted."""
        RESTARTING: Desktop._Status.ValueType  # 4
        """Desktop is restarting."""
        UPDATING: Desktop._Status.ValueType  # 5
        """Desktop is updating."""
        STARTING: Desktop._Status.ValueType  # 6
        """Desktop is starting."""
        STOPPING: Desktop._Status.ValueType  # 7
        """Desktop is stopping."""
        STOPPED: Desktop._Status.ValueType  # 8
        """Desktop is stopped."""
        ERROR: Desktop._Status.ValueType  # 9
        """Desktop did not manage start or restart."""
        CREATION_FAILED: Desktop._Status.ValueType  # 10
        """Desktop did not manage to get created or updated."""
        HEALTH_CHECK: Desktop._Status.ValueType  # 11
        """Desktop in the process of health check."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNSPECIFIED: Desktop.Status.ValueType  # 0
    CREATING: Desktop.Status.ValueType  # 1
    """Desktop is being created."""
    ACTIVE: Desktop.Status.ValueType  # 2
    """Desktop is ready to be used."""
    DELETING: Desktop.Status.ValueType  # 3
    """Desktop is being deleted."""
    RESTARTING: Desktop.Status.ValueType  # 4
    """Desktop is restarting."""
    UPDATING: Desktop.Status.ValueType  # 5
    """Desktop is updating."""
    STARTING: Desktop.Status.ValueType  # 6
    """Desktop is starting."""
    STOPPING: Desktop.Status.ValueType  # 7
    """Desktop is stopping."""
    STOPPED: Desktop.Status.ValueType  # 8
    """Desktop is stopped."""
    ERROR: Desktop.Status.ValueType  # 9
    """Desktop did not manage start or restart."""
    CREATION_FAILED: Desktop.Status.ValueType  # 10
    """Desktop did not manage to get created or updated."""
    HEALTH_CHECK: Desktop.Status.ValueType  # 11
    """Desktop in the process of health check."""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    DESKTOP_GROUP_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    RESOURCES_FIELD_NUMBER: builtins.int
    NETWORK_INTERFACES_FIELD_NUMBER: builtins.int
    USERS_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Desktop ID."""
    folder_id: builtins.str
    """ID of the folder that the desktop belongs to."""
    desktop_group_id: builtins.str
    """ID of the desktop group that the desktop belongs to."""
    status: global___Desktop.Status.ValueType
    """Status of the desktop."""
    name: builtins.str
    """Name of the desktop."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format."""

    @property
    def resources(self) -> global___Resources:
        """Resources of the desktop."""

    @property
    def network_interfaces(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___NetworkInterface]: ...
    @property
    def users(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___User]: ...
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Labels of the desktop."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        desktop_group_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        status: global___Desktop.Status.ValueType = ...,
        name: builtins.str = ...,
        resources: global___Resources | None = ...,
        network_interfaces: collections.abc.Iterable[global___NetworkInterface] | None = ...,
        users: collections.abc.Iterable[global___User] | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "resources", b"resources"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["created_at", b"created_at", "desktop_group_id", b"desktop_group_id", "folder_id", b"folder_id", "id", b"id", "labels", b"labels", "name", b"name", "network_interfaces", b"network_interfaces", "resources", b"resources", "status", b"status", "users", b"users"]) -> None: ...

global___Desktop = Desktop

@typing.final
class Resources(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MEMORY_FIELD_NUMBER: builtins.int
    CORES_FIELD_NUMBER: builtins.int
    CORE_FRACTION_FIELD_NUMBER: builtins.int
    memory: builtins.int
    cores: builtins.int
    core_fraction: builtins.int
    def __init__(
        self,
        *,
        memory: builtins.int = ...,
        cores: builtins.int = ...,
        core_fraction: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["core_fraction", b"core_fraction", "cores", b"cores", "memory", b"memory"]) -> None: ...

global___Resources = Resources

@typing.final
class User(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBJECT_ID_FIELD_NUMBER: builtins.int
    SUBJECT_TYPE_FIELD_NUMBER: builtins.int
    subject_id: builtins.str
    """Identity of the access binding."""
    subject_type: builtins.str
    """Type of the access binding, e.g. userAccount, serviceAccount, system."""
    def __init__(
        self,
        *,
        subject_id: builtins.str = ...,
        subject_type: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["subject_id", b"subject_id", "subject_type", b"subject_type"]) -> None: ...

global___User = User

@typing.final
class NetworkInterface(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NETWORK_ID_FIELD_NUMBER: builtins.int
    SUBNET_ID_FIELD_NUMBER: builtins.int
    network_id: builtins.str
    subnet_id: builtins.str
    def __init__(
        self,
        *,
        network_id: builtins.str = ...,
        subnet_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["network_id", b"network_id", "subnet_id", b"subnet_id"]) -> None: ...

global___NetworkInterface = NetworkInterface
