"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _DeleteLifecycleRuleKind:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _DeleteLifecycleRuleKindEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_DeleteLifecycleRuleKind.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    DELETE_LIFECYCLE_RULE_KIND_UNSPECIFIED: _DeleteLifecycleRuleKind.ValueType  # 0
    HARD_DELETE: _DeleteLifecycleRuleKind.ValueType  # 1
    """Hard delete - artifacts are permanently removed."""
    SOFT_DELETE: _DeleteLifecycleRuleKind.ValueType  # 2
    """Soft delete - artifacts are marked for deletion but can be recovered."""

class DeleteLifecycleRuleKind(_DeleteLifecycleRuleKind, metaclass=_DeleteLifecycleRuleKindEnumTypeWrapper):
    """Type of deletion for lifecycle rules."""

DELETE_LIFECYCLE_RULE_KIND_UNSPECIFIED: DeleteLifecycleRuleKind.ValueType  # 0
HARD_DELETE: DeleteLifecycleRuleKind.ValueType  # 1
"""Hard delete - artifacts are permanently removed."""
SOFT_DELETE: DeleteLifecycleRuleKind.ValueType  # 2
"""Soft delete - artifacts are marked for deletion but can be recovered."""
global___DeleteLifecycleRuleKind = DeleteLifecycleRuleKind

class _LifecyclePolicyState:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _LifecyclePolicyStateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_LifecyclePolicyState.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    LIFECYCLE_POLICY_STATE_UNSPECIFIED: _LifecyclePolicyState.ValueType  # 0
    DISABLED: _LifecyclePolicyState.ValueType  # 1
    """Policy is disabled and won't be executed."""
    ENABLED: _LifecyclePolicyState.ValueType  # 2
    """Policy is enabled and will be executed according to schedule."""

class LifecyclePolicyState(_LifecyclePolicyState, metaclass=_LifecyclePolicyStateEnumTypeWrapper):
    """State of the lifecycle policy."""

LIFECYCLE_POLICY_STATE_UNSPECIFIED: LifecyclePolicyState.ValueType  # 0
DISABLED: LifecyclePolicyState.ValueType  # 1
"""Policy is disabled and won't be executed."""
ENABLED: LifecyclePolicyState.ValueType  # 2
"""Policy is enabled and will be executed according to schedule."""
global___LifecyclePolicyState = LifecyclePolicyState

@typing.final
class LifecyclePolicy(google.protobuf.message.Message):
    """A LifecyclePolicy resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    RULES_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    REGISTRY_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    MODIFIED_AT_FIELD_NUMBER: builtins.int
    CREATED_BY_FIELD_NUMBER: builtins.int
    MODIFIED_BY_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the lifecycle policy."""
    name: builtins.str
    """Name of the lifecycle policy."""
    description: builtins.str
    """Description of the lifecycle policy. 0-1024 characters long."""
    state: global___LifecyclePolicyState.ValueType
    """Current state of the lifecycle policy."""
    registry_id: builtins.str
    """ID of the registry that the lifecycle policy belongs to."""
    created_by: builtins.str
    """Output only. ID of the user who created the lifecycle policy."""
    modified_by: builtins.str
    """Output only. ID of the user who last modified the lifecycle policy."""
    @property
    def rules(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___LifecycleRule]:
        """List of lifecycle rules."""

    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Output only. Creation timestamp."""

    @property
    def modified_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Output only. Modification timestamp."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        rules: collections.abc.Iterable[global___LifecycleRule] | None = ...,
        state: global___LifecyclePolicyState.ValueType = ...,
        registry_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        created_by: builtins.str = ...,
        modified_by: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "modified_at", b"modified_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["created_at", b"created_at", "created_by", b"created_by", "description", b"description", "id", b"id", "modified_at", b"modified_at", "modified_by", b"modified_by", "name", b"name", "registry_id", b"registry_id", "rules", b"rules", "state", b"state"]) -> None: ...

global___LifecyclePolicy = LifecyclePolicy

@typing.final
class LifecycleRule(google.protobuf.message.Message):
    """A rule that defines lifecycle policy behavior."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PATH_PREFIX_FIELD_NUMBER: builtins.int
    KEEP_BY_AGE_FIELD_NUMBER: builtins.int
    KEEP_BY_VERSION_FIELD_NUMBER: builtins.int
    DELETE_FIELD_NUMBER: builtins.int
    DOCKER_FILTERS_FIELD_NUMBER: builtins.int
    MAVEN_FILTERS_FIELD_NUMBER: builtins.int
    path_prefix: builtins.str
    """Path prefix to which the rule applies."""
    @property
    def keep_by_age(self) -> global___KeepByAgeLifecycleRule:
        """Rule that keeps artifacts by age."""

    @property
    def keep_by_version(self) -> global___KeepByVersionLifecycleRule:
        """Rule that keeps artifacts by version count."""

    @property
    def delete(self) -> global___DeleteLifecycleRule:
        """Rule that deletes artifacts."""

    @property
    def docker_filters(self) -> global___DockerFilters:
        """Docker-specific filters."""

    @property
    def maven_filters(self) -> global___MavenFilters:
        """Maven-specific filters."""

    def __init__(
        self,
        *,
        path_prefix: builtins.str = ...,
        keep_by_age: global___KeepByAgeLifecycleRule | None = ...,
        keep_by_version: global___KeepByVersionLifecycleRule | None = ...,
        delete: global___DeleteLifecycleRule | None = ...,
        docker_filters: global___DockerFilters | None = ...,
        maven_filters: global___MavenFilters | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["delete", b"delete", "docker_filters", b"docker_filters", "filter", b"filter", "keep_by_age", b"keep_by_age", "keep_by_version", b"keep_by_version", "kind", b"kind", "maven_filters", b"maven_filters"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["delete", b"delete", "docker_filters", b"docker_filters", "filter", b"filter", "keep_by_age", b"keep_by_age", "keep_by_version", b"keep_by_version", "kind", b"kind", "maven_filters", b"maven_filters", "path_prefix", b"path_prefix"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["filter", b"filter"]) -> typing.Literal["docker_filters", "maven_filters"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["kind", b"kind"]) -> typing.Literal["keep_by_age", "keep_by_version", "delete"] | None: ...

global___LifecycleRule = LifecycleRule

@typing.final
class DockerFilters(google.protobuf.message.Message):
    """Docker-specific filters for lifecycle rules."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _TagStatus:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TagStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[DockerFilters._TagStatus.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TAG_STATUS_UNSPECIFIED: DockerFilters._TagStatus.ValueType  # 0
        TAG_STATUS_ANY: DockerFilters._TagStatus.ValueType  # 1
        """Any tag status."""
        TAGGED: DockerFilters._TagStatus.ValueType  # 2
        """Only tagged images."""
        UNTAGGED: DockerFilters._TagStatus.ValueType  # 3
        """Only untagged images."""

    class TagStatus(_TagStatus, metaclass=_TagStatusEnumTypeWrapper): ...
    TAG_STATUS_UNSPECIFIED: DockerFilters.TagStatus.ValueType  # 0
    TAG_STATUS_ANY: DockerFilters.TagStatus.ValueType  # 1
    """Any tag status."""
    TAGGED: DockerFilters.TagStatus.ValueType  # 2
    """Only tagged images."""
    UNTAGGED: DockerFilters.TagStatus.ValueType  # 3
    """Only untagged images."""

    TAG_STATUS_FIELD_NUMBER: builtins.int
    tag_status: global___DockerFilters.TagStatus.ValueType
    """Filter by tag status."""
    def __init__(
        self,
        *,
        tag_status: global___DockerFilters.TagStatus.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["tag_status", b"tag_status"]) -> None: ...

global___DockerFilters = DockerFilters

@typing.final
class MavenFilters(google.protobuf.message.Message):
    """Maven-specific filters for lifecycle rules."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _VersionType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _VersionTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MavenFilters._VersionType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        VERSION_TYPE_UNSPECIFIED: MavenFilters._VersionType.ValueType  # 0
        VERSION_TYPE_ANY: MavenFilters._VersionType.ValueType  # 1
        """Any version type."""
        RELEASE: MavenFilters._VersionType.ValueType  # 2
        """Only release versions."""
        SNAPSHOT: MavenFilters._VersionType.ValueType  # 3
        """Only snapshot versions."""

    class VersionType(_VersionType, metaclass=_VersionTypeEnumTypeWrapper): ...
    VERSION_TYPE_UNSPECIFIED: MavenFilters.VersionType.ValueType  # 0
    VERSION_TYPE_ANY: MavenFilters.VersionType.ValueType  # 1
    """Any version type."""
    RELEASE: MavenFilters.VersionType.ValueType  # 2
    """Only release versions."""
    SNAPSHOT: MavenFilters.VersionType.ValueType  # 3
    """Only snapshot versions."""

    VERSION_TYPE_FIELD_NUMBER: builtins.int
    version_type: global___MavenFilters.VersionType.ValueType
    """Filter by version type."""
    def __init__(
        self,
        *,
        version_type: global___MavenFilters.VersionType.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["version_type", b"version_type"]) -> None: ...

global___MavenFilters = MavenFilters

@typing.final
class KeepByVersionLifecycleRule(google.protobuf.message.Message):
    """Rule that keeps a specified number of recent versions."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEEP_VERSIONS_COUNT_FIELD_NUMBER: builtins.int
    keep_versions_count: builtins.int
    """Number of versions to keep."""
    def __init__(
        self,
        *,
        keep_versions_count: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["keep_versions_count", b"keep_versions_count"]) -> None: ...

global___KeepByVersionLifecycleRule = KeepByVersionLifecycleRule

@typing.final
class KeepByAgeLifecycleRule(google.protobuf.message.Message):
    """Rule that keeps artifacts younger than specified age."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    YOUNGER_THAN_DAYS_FIELD_NUMBER: builtins.int
    younger_than_days: builtins.int
    """Keep artifacts younger than this number of days."""
    def __init__(
        self,
        *,
        younger_than_days: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["younger_than_days", b"younger_than_days"]) -> None: ...

global___KeepByAgeLifecycleRule = KeepByAgeLifecycleRule

@typing.final
class DeleteLifecycleRule(google.protobuf.message.Message):
    """Rule that deletes artifacts based on specified conditions."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYPE_FIELD_NUMBER: builtins.int
    COOLDOWN_PERIOD_DAYS_FIELD_NUMBER: builtins.int
    OLDER_THAN_DAYS_FIELD_NUMBER: builtins.int
    VERSION_CONDITION_FIELD_NUMBER: builtins.int
    ALWAYS_FIELD_NUMBER: builtins.int
    type: global___DeleteLifecycleRuleKind.ValueType
    """Type of deletion."""
    cooldown_period_days: builtins.int
    """Cooldown period in days before deletion."""
    older_than_days: builtins.int
    """Delete artifacts older than specified days."""
    always: builtins.bool
    """Always delete (use with caution)."""
    @property
    def version_condition(self) -> global___DeleteByVersionCondition:
        """Delete artifacts by version count condition."""

    def __init__(
        self,
        *,
        type: global___DeleteLifecycleRuleKind.ValueType = ...,
        cooldown_period_days: builtins.int = ...,
        older_than_days: builtins.int = ...,
        version_condition: global___DeleteByVersionCondition | None = ...,
        always: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["always", b"always", "condition", b"condition", "older_than_days", b"older_than_days", "version_condition", b"version_condition"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["always", b"always", "condition", b"condition", "cooldown_period_days", b"cooldown_period_days", "older_than_days", b"older_than_days", "type", b"type", "version_condition", b"version_condition"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["condition", b"condition"]) -> typing.Literal["older_than_days", "version_condition", "always"] | None: ...

global___DeleteLifecycleRule = DeleteLifecycleRule

@typing.final
class DeleteByVersionCondition(google.protobuf.message.Message):
    """Condition for deletion based on version count."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VERSIONS_COUNT_GREATER_THAN_FIELD_NUMBER: builtins.int
    versions_count_greater_than: builtins.int
    """Delete when version count exceeds this number."""
    def __init__(
        self,
        *,
        versions_count_greater_than: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["versions_count_greater_than", b"versions_count_greater_than"]) -> None: ...

global___DeleteByVersionCondition = DeleteByVersionCondition
