"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.compute.v1.disk_pb2
import yandex.cloud.compute.v1.disk_placement_group_pb2
import yandex.cloud.operation.operation_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetDiskPlacementGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DISK_PLACEMENT_GROUP_ID_FIELD_NUMBER: builtins.int
    disk_placement_group_id: builtins.str
    """ID of the placement group to return.
    To get the placement group ID, use [DiskPlacementGroupService.List] request.
    """
    def __init__(
        self,
        *,
        disk_placement_group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["disk_placement_group_id", b"disk_placement_group_id"]) -> None: ...

global___GetDiskPlacementGroupRequest = GetDiskPlacementGroupRequest

@typing.final
class ListDiskPlacementGroupsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to list placement groups in.
    To get the folder ID, use [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size],
    the service returns a [ListDiskPlacementGroupsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results,
    set [page_token] to the [ListDiskPlacementGroupsResponse.next_page_token]
    returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response.
    The expression consists of one or more conditions united by `AND` operator: `<condition1> [AND <condition2> [<...> AND <conditionN>]]`.

    Each condition has the form `<field> <operator> <value>`, where:
    1. `<field>` is the field name. Currently you can use filtering only on the limited number of fields.
    2. `<operator>` is a logical operator, one of `=`, `!=`, `IN`, `NOT IN`.
    3. `<value>` represents a value.
    String values should be written in double (`"`) or single (`'`) quotes. C-style escape sequences are supported (`\\"` turns to `"`, `\\'` to `'`, `\\\\` to backslash).
    """
    order_by: builtins.str
    """By which column the listing should be ordered and in which direction,
    format is "createdAt desc". "id asc" if omitted.
    The default sorting order is ascending
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
        order_by: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "folder_id", b"folder_id", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListDiskPlacementGroupsRequest = ListDiskPlacementGroupsRequest

@typing.final
class ListDiskPlacementGroupsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DISK_PLACEMENT_GROUPS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListDiskPlacementGroupsRequest.page_size], use
    [next_page_token] as the value
    for the [ListDiskPlacementGroupsRequest.page_token] query parameter
    in the next list request. Each subsequent list request will have its own
    [next_page_token] to continue paging through the results.
    """
    @property
    def disk_placement_groups(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.compute.v1.disk_placement_group_pb2.DiskPlacementGroup]:
        """Lists placement groups for the specified folder."""

    def __init__(
        self,
        *,
        disk_placement_groups: collections.abc.Iterable[yandex.cloud.compute.v1.disk_placement_group_pb2.DiskPlacementGroup] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["disk_placement_groups", b"disk_placement_groups", "next_page_token", b"next_page_token"]) -> None: ...

global___ListDiskPlacementGroupsResponse = ListDiskPlacementGroupsResponse

@typing.final
class CreateDiskPlacementGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ZONE_ID_FIELD_NUMBER: builtins.int
    SPREAD_PLACEMENT_STRATEGY_FIELD_NUMBER: builtins.int
    PARTITION_PLACEMENT_STRATEGY_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to create a placement group in.
    To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    name: builtins.str
    """Name of the placement group."""
    description: builtins.str
    """Description of the placement group."""
    zone_id: builtins.str
    """ID of the availability zone where the placement group resides.
    To get a list of available zones use the [yandex.cloud.compute.v1.ZoneService.List] request.
    """
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs."""

    @property
    def spread_placement_strategy(self) -> yandex.cloud.compute.v1.disk_placement_group_pb2.DiskSpreadPlacementStrategy:
        """Distribute disks over distinct failure domains."""

    @property
    def partition_placement_strategy(self) -> yandex.cloud.compute.v1.disk_placement_group_pb2.DiskPartitionPlacementStrategy:
        """Distribute disks over partitions."""

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        zone_id: builtins.str = ...,
        spread_placement_strategy: yandex.cloud.compute.v1.disk_placement_group_pb2.DiskSpreadPlacementStrategy | None = ...,
        partition_placement_strategy: yandex.cloud.compute.v1.disk_placement_group_pb2.DiskPartitionPlacementStrategy | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["partition_placement_strategy", b"partition_placement_strategy", "placement_strategy", b"placement_strategy", "spread_placement_strategy", b"spread_placement_strategy"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "folder_id", b"folder_id", "labels", b"labels", "name", b"name", "partition_placement_strategy", b"partition_placement_strategy", "placement_strategy", b"placement_strategy", "spread_placement_strategy", b"spread_placement_strategy", "zone_id", b"zone_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["placement_strategy", b"placement_strategy"]) -> typing.Literal["spread_placement_strategy", "partition_placement_strategy"] | None: ...

global___CreateDiskPlacementGroupRequest = CreateDiskPlacementGroupRequest

@typing.final
class CreateDiskPlacementGroupMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DISK_PLACEMENT_GROUP_ID_FIELD_NUMBER: builtins.int
    disk_placement_group_id: builtins.str
    """ID of the placement group that is being created."""
    def __init__(
        self,
        *,
        disk_placement_group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["disk_placement_group_id", b"disk_placement_group_id"]) -> None: ...

global___CreateDiskPlacementGroupMetadata = CreateDiskPlacementGroupMetadata

@typing.final
class UpdateDiskPlacementGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    DISK_PLACEMENT_GROUP_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    disk_placement_group_id: builtins.str
    """ID of the placement group to update.
    To get the placement group ID, use an [DiskPlacementGroupService.List] request.
    """
    name: builtins.str
    """Name of the placement group."""
    description: builtins.str
    """Description of the placement group."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which fields of the DiskPlacementGroup resource are going to be updated."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs.

        The existing set of `labels` is completely replaced by the provided set.
        """

    def __init__(
        self,
        *,
        disk_placement_group_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "disk_placement_group_id", b"disk_placement_group_id", "labels", b"labels", "name", b"name", "update_mask", b"update_mask"]) -> None: ...

global___UpdateDiskPlacementGroupRequest = UpdateDiskPlacementGroupRequest

@typing.final
class UpdateDiskPlacementGroupMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DISK_PLACEMENT_GROUP_ID_FIELD_NUMBER: builtins.int
    disk_placement_group_id: builtins.str
    """ID of the placement group that is being updated."""
    def __init__(
        self,
        *,
        disk_placement_group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["disk_placement_group_id", b"disk_placement_group_id"]) -> None: ...

global___UpdateDiskPlacementGroupMetadata = UpdateDiskPlacementGroupMetadata

@typing.final
class DeleteDiskPlacementGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DISK_PLACEMENT_GROUP_ID_FIELD_NUMBER: builtins.int
    disk_placement_group_id: builtins.str
    """ID of the placement group to delete.
    To get the placement group ID, use [DiskPlacementGroupService.List] request.
    """
    def __init__(
        self,
        *,
        disk_placement_group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["disk_placement_group_id", b"disk_placement_group_id"]) -> None: ...

global___DeleteDiskPlacementGroupRequest = DeleteDiskPlacementGroupRequest

@typing.final
class DeleteDiskPlacementGroupMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DISK_PLACEMENT_GROUP_ID_FIELD_NUMBER: builtins.int
    disk_placement_group_id: builtins.str
    """ID of the placement group that is being deleted."""
    def __init__(
        self,
        *,
        disk_placement_group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["disk_placement_group_id", b"disk_placement_group_id"]) -> None: ...

global___DeleteDiskPlacementGroupMetadata = DeleteDiskPlacementGroupMetadata

@typing.final
class ListDiskPlacementGroupDisksRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DISK_PLACEMENT_GROUP_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    disk_placement_group_id: builtins.str
    """ID of the placement group to list disks for.
    To get the placement group ID, use [DiskPlacementGroupService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size],
    the service returns a [ListDiskPlacementGroupDisksResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results,
    set [page_token] to the [ListDiskPlacementGroupDisksResponse.next_page_token]
    returned by a previous list request.
    """
    def __init__(
        self,
        *,
        disk_placement_group_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["disk_placement_group_id", b"disk_placement_group_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListDiskPlacementGroupDisksRequest = ListDiskPlacementGroupDisksRequest

@typing.final
class ListDiskPlacementGroupDisksResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DISKS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is more than [ListDiskPlacementGroupDisksRequest.page_size], use
    [next_page_token] as the value
    for the [ListDiskPlacementGroupDisksRequest.page_token] query parameter
    in the next list request. Each subsequent list request will have its own
    [next_page_token] to continue paging through the results.
    """
    @property
    def disks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.compute.v1.disk_pb2.Disk]:
        """Lists disks for the specified placement group."""

    def __init__(
        self,
        *,
        disks: collections.abc.Iterable[yandex.cloud.compute.v1.disk_pb2.Disk] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["disks", b"disks", "next_page_token", b"next_page_token"]) -> None: ...

global___ListDiskPlacementGroupDisksResponse = ListDiskPlacementGroupDisksResponse

@typing.final
class ListDiskPlacementGroupOperationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DISK_PLACEMENT_GROUP_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    disk_placement_group_id: builtins.str
    """ID of the placement group to list operations for.
    To get the placement group ID, use [DiskPlacementGroupService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size], the service returns a [ListDiskPlacementGroupOperationsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the
    [ListDiskPlacementGroupOperationsResponse.next_page_token] returned by a previous list request.
    """
    def __init__(
        self,
        *,
        disk_placement_group_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["disk_placement_group_id", b"disk_placement_group_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListDiskPlacementGroupOperationsRequest = ListDiskPlacementGroupOperationsRequest

@typing.final
class ListDiskPlacementGroupOperationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListDiskPlacementGroupOperationsRequest.page_size], use the [next_page_token] as the value
    for the [ListDiskPlacementGroupOperationsRequest.page_token] query parameter in the next list request.
    Each subsequent list request will have its own [next_page_token] to continue paging through the results.
    """
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """List of operations for the specified placement group."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListDiskPlacementGroupOperationsResponse = ListDiskPlacementGroupOperationsResponse
