"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.compute.v1.filesystem_pb2
import yandex.cloud.operation.operation_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetFilesystemRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILESYSTEM_ID_FIELD_NUMBER: builtins.int
    filesystem_id: builtins.str
    """ID of the filesystem to return.

    To get the filesystem ID, make a [FilesystemService.List] request.
    """
    def __init__(
        self,
        *,
        filesystem_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filesystem_id", b"filesystem_id"]) -> None: ...

global___GetFilesystemRequest = GetFilesystemRequest

@typing.final
class ListFilesystemsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to list filesystems in.

    To get the folder ID, make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than `page_size`,
    the service returns a [ListFilesystemsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `page_token` to the
    [ListFilesystemsResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response.
    The expression consists of one or more conditions united by `AND` operator: `<condition1> [AND <condition2> [<...> AND <conditionN>]]`.

    Each condition has the form `<field> <operator> <value>`, where:
    1. `<field>` is the field name. Currently you can use filtering only on the limited number of fields.
    2. `<operator>` is a logical operator, one of `=`, `!=`, `IN`, `NOT IN`.
    3. `<value>` represents a value.
    String values should be written in double (`"`) or single (`'`) quotes. C-style escape sequences are supported (`\\"` turns to `"`, `\\'` to `'`, `\\\\` to backslash).
    """
    order_by: builtins.str
    """By which column the listing should be ordered and in which direction,
    format is "createdAt desc". "id asc" if omitted.
    The default sorting order is ascending
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
        order_by: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "folder_id", b"folder_id", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListFilesystemsRequest = ListFilesystemsRequest

@typing.final
class ListFilesystemsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILESYSTEMS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListFilesystemsRequest.page_size], use `next_page_token` as the value
    for the [ListFilesystemsRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def filesystems(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.compute.v1.filesystem_pb2.Filesystem]:
        """List of filesystems in the specified folder."""

    def __init__(
        self,
        *,
        filesystems: collections.abc.Iterable[yandex.cloud.compute.v1.filesystem_pb2.Filesystem] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filesystems", b"filesystems", "next_page_token", b"next_page_token"]) -> None: ...

global___ListFilesystemsResponse = ListFilesystemsResponse

@typing.final
class CreateFilesystemRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    TYPE_ID_FIELD_NUMBER: builtins.int
    ZONE_ID_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    BLOCK_SIZE_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to create a filesystem in.

    To get the folder ID, make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    name: builtins.str
    """Name of the filesystem. The name must be unique within the folder."""
    description: builtins.str
    """Description of the filesystem."""
    type_id: builtins.str
    """ID of the filesystem type.

    To get a list of available filesystem types, make a [yandex.cloud.compute.v1.DiskTypeService.List] request.

    The filesystem type cannot be updated after the filesystem creation.
    """
    zone_id: builtins.str
    """ID of the availability zone where the filesystem resides.

    To get a list of available zones, make a [yandex.cloud.compute.v1.ZoneService.List] request.

    A filesystem can be attached only to virtual machines residing in the same availability zone.
    The filesystem availability zone cannot be updated after the filesystem creation.
    """
    size: builtins.int
    """Size of the filesystem, specified in bytes.

    The size of the filesystem cannot be updated after the filesystem creation.
    """
    block_size: builtins.int
    """Block size used for the filesystem, specified in bytes.

    The block size cannot be updated after the filesystem creation.

    Default value: 4096.
    """
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Filesystem labels as `key:value` pairs.
        For details about the concept, see [documentation](/docs/overview/concepts/services#labels).
        """

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        type_id: builtins.str = ...,
        zone_id: builtins.str = ...,
        size: builtins.int = ...,
        block_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["block_size", b"block_size", "description", b"description", "folder_id", b"folder_id", "labels", b"labels", "name", b"name", "size", b"size", "type_id", b"type_id", "zone_id", b"zone_id"]) -> None: ...

global___CreateFilesystemRequest = CreateFilesystemRequest

@typing.final
class CreateFilesystemMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILESYSTEM_ID_FIELD_NUMBER: builtins.int
    filesystem_id: builtins.str
    """ID of the filesystem that is being created."""
    def __init__(
        self,
        *,
        filesystem_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filesystem_id", b"filesystem_id"]) -> None: ...

global___CreateFilesystemMetadata = CreateFilesystemMetadata

@typing.final
class UpdateFilesystemRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FILESYSTEM_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    filesystem_id: builtins.str
    """ID of the filesystem to update.

    To get the filesystem ID, make a [FilesystemService.List] request.
    """
    name: builtins.str
    """New name of the filesystem. The name must be unique within the folder."""
    description: builtins.str
    """New description of the filesystem."""
    size: builtins.int
    """Size of the filesystem, specified in bytes."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which attributes of the filesystem should be updated."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """New filesystem labels as `key:value` pairs.
        For details about the concept, see [documentation](/docs/overview/concepts/services#labels).

        Existing set of labels is completely replaced by the provided set, so if you just want
        to add or remove a label:
        1. Get the current set of labels with a [FilesystemService.Get] request.
        2. Add or remove a label in this set.
        3. Send the new set in this field.
        """

    def __init__(
        self,
        *,
        filesystem_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        size: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "filesystem_id", b"filesystem_id", "labels", b"labels", "name", b"name", "size", b"size", "update_mask", b"update_mask"]) -> None: ...

global___UpdateFilesystemRequest = UpdateFilesystemRequest

@typing.final
class UpdateFilesystemMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILESYSTEM_ID_FIELD_NUMBER: builtins.int
    filesystem_id: builtins.str
    """ID of the filesystem that is being updated."""
    def __init__(
        self,
        *,
        filesystem_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filesystem_id", b"filesystem_id"]) -> None: ...

global___UpdateFilesystemMetadata = UpdateFilesystemMetadata

@typing.final
class DeleteFilesystemRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILESYSTEM_ID_FIELD_NUMBER: builtins.int
    filesystem_id: builtins.str
    """ID of the filesystem to delete.

    To get the filesystem ID, make a [FilesystemService.List] request.
    """
    def __init__(
        self,
        *,
        filesystem_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filesystem_id", b"filesystem_id"]) -> None: ...

global___DeleteFilesystemRequest = DeleteFilesystemRequest

@typing.final
class DeleteFilesystemMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILESYSTEM_ID_FIELD_NUMBER: builtins.int
    filesystem_id: builtins.str
    """ID of the filesystem that is being deleted."""
    def __init__(
        self,
        *,
        filesystem_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filesystem_id", b"filesystem_id"]) -> None: ...

global___DeleteFilesystemMetadata = DeleteFilesystemMetadata

@typing.final
class ListFilesystemOperationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FILESYSTEM_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    filesystem_id: builtins.str
    """ID of the filesystem to list operations for.

    To get the filesystem ID, make a [FilesystemService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than `page_size`, the service returns a [ListFilesystemOperationsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `page_token` to the
    [ListFilesystemOperationsResponse.next_page_token] returned by a previous list request.
    """
    def __init__(
        self,
        *,
        filesystem_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filesystem_id", b"filesystem_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListFilesystemOperationsRequest = ListFilesystemOperationsRequest

@typing.final
class ListFilesystemOperationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListFilesystemOperationsRequest.page_size], use `next_page_token` as the value
    for the [ListFilesystemOperationsRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """List of operations for the specified filesystem."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListFilesystemOperationsResponse = ListFilesystemOperationsResponse
