"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.compute.v1.gpu_cluster_pb2
import yandex.cloud.compute.v1.instance_pb2
import yandex.cloud.operation.operation_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetGpuClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GPU_CLUSTER_ID_FIELD_NUMBER: builtins.int
    gpu_cluster_id: builtins.str
    """ID of the GPU cluster to return.

    To get a GPU cluster ID, make a [GpuClusterService.List] request.
    """
    def __init__(
        self,
        *,
        gpu_cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["gpu_cluster_id", b"gpu_cluster_id"]) -> None: ...

global___GetGpuClusterRequest = GetGpuClusterRequest

@typing.final
class ListGpuClustersRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to list GPU clusters in.

    To get the folder ID, make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than `page_size`, the service returns a [ListGpuClustersResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `page_token` to the
    [ListGpuClustersResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters GPU clusters listed in the response.

    The expression must specify:
    1. The field name. Currently you can use filtering only on [GpuCluster.name] field.
    2. An operator. Can be either `=` or `!=` for single values, `IN` or `NOT IN` for lists of values.
    3. The value. Must be 3-63 characters long and match the regular expression `^[a-z][-a-z0-9]{1,61}[a-z0-9]`.
    Example of a filter: `name=my-schedule`.
    """
    order_by: builtins.str
    """A sorting expression that sorts GPU clusters listed in the response.

    The expression must specify the field name from [GpuCluster] and `asc`ending or `desc`ending order,
    e.g. `createdAt desc`.

    Default value: `id asc`.
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
        order_by: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "folder_id", b"folder_id", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListGpuClustersRequest = ListGpuClustersRequest

@typing.final
class ListGpuClustersResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GPU_CLUSTERS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListGpuClustersRequest.page_size], use `next_page_token` as the value
    for the [ListGpuClustersRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def gpu_clusters(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.compute.v1.gpu_cluster_pb2.GpuCluster]:
        """List of GPU clusters in the specified folder."""

    def __init__(
        self,
        *,
        gpu_clusters: collections.abc.Iterable[yandex.cloud.compute.v1.gpu_cluster_pb2.GpuCluster] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["gpu_clusters", b"gpu_clusters", "next_page_token", b"next_page_token"]) -> None: ...

global___ListGpuClustersResponse = ListGpuClustersResponse

@typing.final
class CreateGpuClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    ZONE_ID_FIELD_NUMBER: builtins.int
    INTERCONNECT_TYPE_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to create a GPU cluster in.

    To get a folder ID, make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    name: builtins.str
    """Name of the GPU cluster.

    The name must be unique within the folder.
    """
    description: builtins.str
    """Description of the GPU cluster."""
    zone_id: builtins.str
    """ID of the availability zone where the GPU cluster resides.
    To get a list of available zones use the [yandex.cloud.compute.v1.ZoneService.List] request.
    """
    interconnect_type: yandex.cloud.compute.v1.gpu_cluster_pb2.GpuInterconnectType.ValueType
    """Type of interconnect to use for this GPU cluster."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """GPU cluster labels as `key:value` pairs."""

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        zone_id: builtins.str = ...,
        interconnect_type: yandex.cloud.compute.v1.gpu_cluster_pb2.GpuInterconnectType.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "folder_id", b"folder_id", "interconnect_type", b"interconnect_type", "labels", b"labels", "name", b"name", "zone_id", b"zone_id"]) -> None: ...

global___CreateGpuClusterRequest = CreateGpuClusterRequest

@typing.final
class CreateGpuClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GPU_CLUSTER_ID_FIELD_NUMBER: builtins.int
    gpu_cluster_id: builtins.str
    """ID of the GPU cluster that is being created."""
    def __init__(
        self,
        *,
        gpu_cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["gpu_cluster_id", b"gpu_cluster_id"]) -> None: ...

global___CreateGpuClusterMetadata = CreateGpuClusterMetadata

@typing.final
class UpdateGpuClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    GPU_CLUSTER_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    gpu_cluster_id: builtins.str
    """ID of the GPU cluster to update.

    To get the GPU cluster ID, make a [GpuClusterService.List] request.
    """
    name: builtins.str
    """New name for the GPU cluster.

    The name must be unique within the folder.
    """
    description: builtins.str
    """New description of the GPU cluster."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which attributes of the GPU cluster should be updated."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """New GPU cluster labels as `key:value` pairs.

        Existing set of labels is completely replaced by the provided set, so if you just want
        to add or remove a label:
        1. Get the current set of labels with a [GpuClusterService.Get] request.
        2. Add or remove a label in this set.
        3. Send the new set in this field.
        """

    def __init__(
        self,
        *,
        gpu_cluster_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "gpu_cluster_id", b"gpu_cluster_id", "labels", b"labels", "name", b"name", "update_mask", b"update_mask"]) -> None: ...

global___UpdateGpuClusterRequest = UpdateGpuClusterRequest

@typing.final
class UpdateGpuClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GPU_CLUSTER_ID_FIELD_NUMBER: builtins.int
    gpu_cluster_id: builtins.str
    """ID of the GPU cluster that is being updated."""
    def __init__(
        self,
        *,
        gpu_cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["gpu_cluster_id", b"gpu_cluster_id"]) -> None: ...

global___UpdateGpuClusterMetadata = UpdateGpuClusterMetadata

@typing.final
class DeleteGpuClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GPU_CLUSTER_ID_FIELD_NUMBER: builtins.int
    gpu_cluster_id: builtins.str
    """ID of the GPU cluster to delete.

    To get a GPU cluster ID, make a [GpuClusterService.List] request.
    """
    def __init__(
        self,
        *,
        gpu_cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["gpu_cluster_id", b"gpu_cluster_id"]) -> None: ...

global___DeleteGpuClusterRequest = DeleteGpuClusterRequest

@typing.final
class DeleteGpuClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GPU_CLUSTER_ID_FIELD_NUMBER: builtins.int
    gpu_cluster_id: builtins.str
    """ID of the GPU cluster that is being deleted."""
    def __init__(
        self,
        *,
        gpu_cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["gpu_cluster_id", b"gpu_cluster_id"]) -> None: ...

global___DeleteGpuClusterMetadata = DeleteGpuClusterMetadata

@typing.final
class ListGpuClusterOperationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GPU_CLUSTER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    gpu_cluster_id: builtins.str
    """ID of the GPU cluster to list operations for.

    To get a GPU cluster ID, make a [GpuClusterService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size], the service returns a [ListGpuClusterOperationsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.

    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the
    [ListGpuClusterOperationsResponse.next_page_token] returned by a previous list request.
    """
    def __init__(
        self,
        *,
        gpu_cluster_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["gpu_cluster_id", b"gpu_cluster_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListGpuClusterOperationsRequest = ListGpuClusterOperationsRequest

@typing.final
class ListGpuClusterOperationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListGpuClusterOperationsRequest.page_size], use `next_page_token` as the value
    for the [ListGpuClusterOperationsRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """List of operations for the specified GPU cluster."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListGpuClusterOperationsResponse = ListGpuClusterOperationsResponse

@typing.final
class ListGpuClusterInstancesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GPU_CLUSTER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    gpu_cluster_id: builtins.str
    """ID of the GPU cluster to list instances in.

    To get a GPU cluster ID, make a [GpuClusterService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size], the service returns a [ListGpuClusterInstancesResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.

    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the
    [ListGpuClusterInstancesResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response.
    Currently you can use filtering only on the [Instance.name] field.
    """
    def __init__(
        self,
        *,
        gpu_cluster_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "gpu_cluster_id", b"gpu_cluster_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListGpuClusterInstancesRequest = ListGpuClusterInstancesRequest

@typing.final
class ListGpuClusterInstancesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListGpuClusterInstancesRequest.page_size], use `next_page_token` as the value
    for the [ListGpuClusterInstancesRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def instances(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.compute.v1.instance_pb2.Instance]:
        """List of instances in the specified GPU cluster."""

    def __init__(
        self,
        *,
        instances: collections.abc.Iterable[yandex.cloud.compute.v1.instance_pb2.Instance] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instances", b"instances", "next_page_token", b"next_page_token"]) -> None: ...

global___ListGpuClusterInstancesResponse = ListGpuClusterInstancesResponse
