"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _IpVersion:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _IpVersionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_IpVersion.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    IP_VERSION_UNSPECIFIED: _IpVersion.ValueType  # 0
    IPV4: _IpVersion.ValueType  # 1
    """IPv4 address, for example 192.168.0.0."""
    IPV6: _IpVersion.ValueType  # 2
    """IPv6 address, not available yet."""

class IpVersion(_IpVersion, metaclass=_IpVersionEnumTypeWrapper): ...

IP_VERSION_UNSPECIFIED: IpVersion.ValueType  # 0
IPV4: IpVersion.ValueType  # 1
"""IPv4 address, for example 192.168.0.0."""
IPV6: IpVersion.ValueType  # 2
"""IPv6 address, not available yet."""
global___IpVersion = IpVersion

class _MetadataOption:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _MetadataOptionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_MetadataOption.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    METADATA_OPTION_UNSPECIFIED: _MetadataOption.ValueType  # 0
    ENABLED: _MetadataOption.ValueType  # 1
    """Option is enabled"""
    DISABLED: _MetadataOption.ValueType  # 2
    """Option is disabled"""

class MetadataOption(_MetadataOption, metaclass=_MetadataOptionEnumTypeWrapper): ...

METADATA_OPTION_UNSPECIFIED: MetadataOption.ValueType  # 0
ENABLED: MetadataOption.ValueType  # 1
"""Option is enabled"""
DISABLED: MetadataOption.ValueType  # 2
"""Option is disabled"""
global___MetadataOption = MetadataOption

@typing.final
class InstanceGroup(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[InstanceGroup._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: InstanceGroup._Status.ValueType  # 0
        STARTING: InstanceGroup._Status.ValueType  # 1
        """Instance group is being started and will become active soon."""
        ACTIVE: InstanceGroup._Status.ValueType  # 2
        """Instance group is active.
        In this state the group manages its instances and monitors their health,
        creating, deleting, stopping, updating and starting instances as needed.

        To stop the instance group, call [yandex.cloud.compute.v1.instancegroup.InstanceGroupService.Stop].
        To pause the processes in the instance group, i.e. scaling, checking instances' health,
        auto-healing and updating them, without stopping the instances,
        call [yandex.cloud.compute.v1.instancegroup.InstanceGroupService.PauseProcesses].
        """
        STOPPING: InstanceGroup._Status.ValueType  # 3
        """Instance group is being stopped.
        Group's instances stop receiving traffic from the load balancer (if any) and are then stopped.
        """
        STOPPED: InstanceGroup._Status.ValueType  # 4
        """Instance group is stopped.
        In this state the group cannot be updated and does not react to any changes made to its instances.
        To start the instance group, call [yandex.cloud.compute.v1.instancegroup.InstanceGroupService.Start].
        """
        DELETING: InstanceGroup._Status.ValueType  # 5
        """Instance group is being deleted."""
        PAUSED: InstanceGroup._Status.ValueType  # 6
        """Instance group is paused.
        In this state all the processes regarding the group management, i.e. scaling, checking instances' health,
        auto-healing and updating them, are paused. The instances that were running prior to pausing the group, however,
        may still be running.

        To resume the processes in the instance group,
        call [yandex.cloud.compute.v1.instancegroup.InstanceGroupService.ResumeProcesses].
        The group status will change to `ACTIVE`.
        """

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNSPECIFIED: InstanceGroup.Status.ValueType  # 0
    STARTING: InstanceGroup.Status.ValueType  # 1
    """Instance group is being started and will become active soon."""
    ACTIVE: InstanceGroup.Status.ValueType  # 2
    """Instance group is active.
    In this state the group manages its instances and monitors their health,
    creating, deleting, stopping, updating and starting instances as needed.

    To stop the instance group, call [yandex.cloud.compute.v1.instancegroup.InstanceGroupService.Stop].
    To pause the processes in the instance group, i.e. scaling, checking instances' health,
    auto-healing and updating them, without stopping the instances,
    call [yandex.cloud.compute.v1.instancegroup.InstanceGroupService.PauseProcesses].
    """
    STOPPING: InstanceGroup.Status.ValueType  # 3
    """Instance group is being stopped.
    Group's instances stop receiving traffic from the load balancer (if any) and are then stopped.
    """
    STOPPED: InstanceGroup.Status.ValueType  # 4
    """Instance group is stopped.
    In this state the group cannot be updated and does not react to any changes made to its instances.
    To start the instance group, call [yandex.cloud.compute.v1.instancegroup.InstanceGroupService.Start].
    """
    DELETING: InstanceGroup.Status.ValueType  # 5
    """Instance group is being deleted."""
    PAUSED: InstanceGroup.Status.ValueType  # 6
    """Instance group is paused.
    In this state all the processes regarding the group management, i.e. scaling, checking instances' health,
    auto-healing and updating them, are paused. The instances that were running prior to pausing the group, however,
    may still be running.

    To resume the processes in the instance group,
    call [yandex.cloud.compute.v1.instancegroup.InstanceGroupService.ResumeProcesses].
    The group status will change to `ACTIVE`.
    """

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    INSTANCE_TEMPLATE_FIELD_NUMBER: builtins.int
    SCALE_POLICY_FIELD_NUMBER: builtins.int
    DEPLOY_POLICY_FIELD_NUMBER: builtins.int
    ALLOCATION_POLICY_FIELD_NUMBER: builtins.int
    LOAD_BALANCER_STATE_FIELD_NUMBER: builtins.int
    MANAGED_INSTANCES_STATE_FIELD_NUMBER: builtins.int
    LOAD_BALANCER_SPEC_FIELD_NUMBER: builtins.int
    HEALTH_CHECKS_SPEC_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    VARIABLES_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    APPLICATION_LOAD_BALANCER_SPEC_FIELD_NUMBER: builtins.int
    APPLICATION_LOAD_BALANCER_STATE_FIELD_NUMBER: builtins.int
    AUTO_HEALING_POLICY_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the instance group."""
    folder_id: builtins.str
    """ID of the folder that the instance group belongs to."""
    name: builtins.str
    """Name of the instance group.
    The name is unique within the folder.
    """
    description: builtins.str
    """Description of the instance group."""
    service_account_id: builtins.str
    """ID of the service account. The service account will be used for all API calls
    made by the Instance Groups component on behalf of the user (for example, creating instances, adding them to load balancer target group, etc.). For more information, see [Service accounts](/docs/iam/concepts/users/service-accounts).
    To get the service account ID, use a [yandex.cloud.iam.v1.ServiceAccountService.List] request.
    """
    status: global___InstanceGroup.Status.ValueType
    """Status of the instance group."""
    deletion_protection: builtins.bool
    """Flag prohibiting deletion of the instance group.

    Allowed values:</br>- `false`: The instance group can be deleted.</br>- `true`: The instance group cannot be deleted.

    The default is `false`.
    """
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs."""

    @property
    def instance_template(self) -> global___InstanceTemplate:
        """Instance template for creating the instance group.
        For more information, see [Instance Templates](/docs/compute/concepts/instance-groups/instance-template).
        """

    @property
    def scale_policy(self) -> global___ScalePolicy:
        """[Scaling policy](/docs/compute/concepts/instance-groups/scale) of the instance group."""

    @property
    def deploy_policy(self) -> global___DeployPolicy:
        """Deployment policy of the instance group."""

    @property
    def allocation_policy(self) -> global___AllocationPolicy:
        """Allocation policy of the instance group by zones and regions."""

    @property
    def load_balancer_state(self) -> global___LoadBalancerState:
        """Status of the Network Load Balancer target group attributed to the instance group."""

    @property
    def managed_instances_state(self) -> global___ManagedInstancesState:
        """States of instances for this instance group."""

    @property
    def load_balancer_spec(self) -> global___LoadBalancerSpec:
        """Settings for balancing load between instances via [Network Load Balancer](/docs/network-load-balancer/concepts)
        (OSI model layer 3).
        """

    @property
    def health_checks_spec(self) -> global___HealthChecksSpec:
        """Health checking specification. For more information, see [Health check](/docs/network-load-balancer/concepts/health-check)."""

    @property
    def variables(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Variable]: ...
    @property
    def application_load_balancer_spec(self) -> global___ApplicationLoadBalancerSpec:
        """Settings for balancing load between instances via [Application Load Balancer](/docs/application-load-balancer/concepts)
        (OSI model layer 7).
        """

    @property
    def application_load_balancer_state(self) -> global___ApplicationLoadBalancerState:
        """Status of the Application Load Balancer target group attributed to the instance group.

        Returned if there is a working load balancer that the target group is connected to.
        """

    @property
    def auto_healing_policy(self) -> global___AutoHealingPolicy:
        """AutoHealingPolicy policy of the instance group."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        instance_template: global___InstanceTemplate | None = ...,
        scale_policy: global___ScalePolicy | None = ...,
        deploy_policy: global___DeployPolicy | None = ...,
        allocation_policy: global___AllocationPolicy | None = ...,
        load_balancer_state: global___LoadBalancerState | None = ...,
        managed_instances_state: global___ManagedInstancesState | None = ...,
        load_balancer_spec: global___LoadBalancerSpec | None = ...,
        health_checks_spec: global___HealthChecksSpec | None = ...,
        service_account_id: builtins.str = ...,
        status: global___InstanceGroup.Status.ValueType = ...,
        variables: collections.abc.Iterable[global___Variable] | None = ...,
        deletion_protection: builtins.bool = ...,
        application_load_balancer_spec: global___ApplicationLoadBalancerSpec | None = ...,
        application_load_balancer_state: global___ApplicationLoadBalancerState | None = ...,
        auto_healing_policy: global___AutoHealingPolicy | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["allocation_policy", b"allocation_policy", "application_load_balancer_spec", b"application_load_balancer_spec", "application_load_balancer_state", b"application_load_balancer_state", "auto_healing_policy", b"auto_healing_policy", "created_at", b"created_at", "deploy_policy", b"deploy_policy", "health_checks_spec", b"health_checks_spec", "instance_template", b"instance_template", "load_balancer_spec", b"load_balancer_spec", "load_balancer_state", b"load_balancer_state", "managed_instances_state", b"managed_instances_state", "scale_policy", b"scale_policy"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["allocation_policy", b"allocation_policy", "application_load_balancer_spec", b"application_load_balancer_spec", "application_load_balancer_state", b"application_load_balancer_state", "auto_healing_policy", b"auto_healing_policy", "created_at", b"created_at", "deletion_protection", b"deletion_protection", "deploy_policy", b"deploy_policy", "description", b"description", "folder_id", b"folder_id", "health_checks_spec", b"health_checks_spec", "id", b"id", "instance_template", b"instance_template", "labels", b"labels", "load_balancer_spec", b"load_balancer_spec", "load_balancer_state", b"load_balancer_state", "managed_instances_state", b"managed_instances_state", "name", b"name", "scale_policy", b"scale_policy", "service_account_id", b"service_account_id", "status", b"status", "variables", b"variables"]) -> None: ...

global___InstanceGroup = InstanceGroup

@typing.final
class ApplicationLoadBalancerState(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TARGET_GROUP_ID_FIELD_NUMBER: builtins.int
    STATUS_MESSAGE_FIELD_NUMBER: builtins.int
    target_group_id: builtins.str
    """ID of the Application Load Balancer target group attributed to the instance group."""
    status_message: builtins.str
    """Status message of the target group."""
    def __init__(
        self,
        *,
        target_group_id: builtins.str = ...,
        status_message: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["status_message", b"status_message", "target_group_id", b"target_group_id"]) -> None: ...

global___ApplicationLoadBalancerState = ApplicationLoadBalancerState

@typing.final
class Variable(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    key: builtins.str
    value: builtins.str
    def __init__(
        self,
        *,
        key: builtins.str = ...,
        value: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

global___Variable = Variable

@typing.final
class LoadBalancerState(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TARGET_GROUP_ID_FIELD_NUMBER: builtins.int
    STATUS_MESSAGE_FIELD_NUMBER: builtins.int
    target_group_id: builtins.str
    """ID of the Network Load Balancer target group attributed to the instance group."""
    status_message: builtins.str
    """Status message of the target group."""
    def __init__(
        self,
        *,
        target_group_id: builtins.str = ...,
        status_message: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["status_message", b"status_message", "target_group_id", b"target_group_id"]) -> None: ...

global___LoadBalancerState = LoadBalancerState

@typing.final
class ManagedInstancesState(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class Statuses(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CREATING_FIELD_NUMBER: builtins.int
        STARTING_FIELD_NUMBER: builtins.int
        OPENING_FIELD_NUMBER: builtins.int
        WARMING_FIELD_NUMBER: builtins.int
        RUNNING_FIELD_NUMBER: builtins.int
        CLOSING_FIELD_NUMBER: builtins.int
        STOPPING_FIELD_NUMBER: builtins.int
        UPDATING_FIELD_NUMBER: builtins.int
        DELETING_FIELD_NUMBER: builtins.int
        FAILED_FIELD_NUMBER: builtins.int
        creating: builtins.int
        """Instance is being created."""
        starting: builtins.int
        """Instance is being started."""
        opening: builtins.int
        """Instance is being opened to receive traffic."""
        warming: builtins.int
        """Instance is being warmed."""
        running: builtins.int
        """Instance is running normally."""
        closing: builtins.int
        """Instance is being closed to traffic."""
        stopping: builtins.int
        """Instance is being stopped."""
        updating: builtins.int
        """Instance is being updated."""
        deleting: builtins.int
        """Instance is being deleted."""
        failed: builtins.int
        """Instance failed and needs to be recreated."""
        def __init__(
            self,
            *,
            creating: builtins.int = ...,
            starting: builtins.int = ...,
            opening: builtins.int = ...,
            warming: builtins.int = ...,
            running: builtins.int = ...,
            closing: builtins.int = ...,
            stopping: builtins.int = ...,
            updating: builtins.int = ...,
            deleting: builtins.int = ...,
            failed: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["closing", b"closing", "creating", b"creating", "deleting", b"deleting", "failed", b"failed", "opening", b"opening", "running", b"running", "starting", b"starting", "stopping", b"stopping", "updating", b"updating", "warming", b"warming"]) -> None: ...

    TARGET_SIZE_FIELD_NUMBER: builtins.int
    RUNNING_ACTUAL_COUNT_FIELD_NUMBER: builtins.int
    RUNNING_OUTDATED_COUNT_FIELD_NUMBER: builtins.int
    PROCESSING_COUNT_FIELD_NUMBER: builtins.int
    target_size: builtins.int
    """Target number of instances for this instance group."""
    running_actual_count: builtins.int
    """The number of running instances that match the current instance template. For more information, see [ManagedInstance.Status.RUNNING_ACTUAL]."""
    running_outdated_count: builtins.int
    """The number of running instances that does not match the current instance template. For more information, see [ManagedInstance.Status.RUNNING_OUTDATED]."""
    processing_count: builtins.int
    """The number of instances in flight (for example, updating, starting, deleting). For more information, see [ManagedInstance.Status]."""
    def __init__(
        self,
        *,
        target_size: builtins.int = ...,
        running_actual_count: builtins.int = ...,
        running_outdated_count: builtins.int = ...,
        processing_count: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["processing_count", b"processing_count", "running_actual_count", b"running_actual_count", "running_outdated_count", b"running_outdated_count", "target_size", b"target_size"]) -> None: ...

global___ManagedInstancesState = ManagedInstancesState

@typing.final
class ScalePolicy(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class AutoScale(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _AutoScaleType:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _AutoScaleTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ScalePolicy.AutoScale._AutoScaleType.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            AUTO_SCALE_TYPE_UNSPECIFIED: ScalePolicy.AutoScale._AutoScaleType.ValueType  # 0
            ZONAL: ScalePolicy.AutoScale._AutoScaleType.ValueType  # 1
            """Scale each zone independently. This is the default."""
            REGIONAL: ScalePolicy.AutoScale._AutoScaleType.ValueType  # 2
            """Scale group as a whole."""

        class AutoScaleType(_AutoScaleType, metaclass=_AutoScaleTypeEnumTypeWrapper): ...
        AUTO_SCALE_TYPE_UNSPECIFIED: ScalePolicy.AutoScale.AutoScaleType.ValueType  # 0
        ZONAL: ScalePolicy.AutoScale.AutoScaleType.ValueType  # 1
        """Scale each zone independently. This is the default."""
        REGIONAL: ScalePolicy.AutoScale.AutoScaleType.ValueType  # 2
        """Scale group as a whole."""

        MIN_ZONE_SIZE_FIELD_NUMBER: builtins.int
        MAX_SIZE_FIELD_NUMBER: builtins.int
        MEASUREMENT_DURATION_FIELD_NUMBER: builtins.int
        WARMUP_DURATION_FIELD_NUMBER: builtins.int
        STABILIZATION_DURATION_FIELD_NUMBER: builtins.int
        INITIAL_SIZE_FIELD_NUMBER: builtins.int
        CPU_UTILIZATION_RULE_FIELD_NUMBER: builtins.int
        CUSTOM_RULES_FIELD_NUMBER: builtins.int
        AUTO_SCALE_TYPE_FIELD_NUMBER: builtins.int
        min_zone_size: builtins.int
        """Lower limit for instance count in each zone."""
        max_size: builtins.int
        """Upper limit for total instance count (across all zones).
        0 means maximum limit = 100.
        """
        initial_size: builtins.int
        """Target group size."""
        auto_scale_type: global___ScalePolicy.AutoScale.AutoScaleType.ValueType
        """Autoscaling type."""
        @property
        def measurement_duration(self) -> google.protobuf.duration_pb2.Duration:
            """Time in seconds allotted for averaging metrics.
            1 minute by default.
            """

        @property
        def warmup_duration(self) -> google.protobuf.duration_pb2.Duration:
            """The warmup time of the instance in seconds. During this time,
            traffic is sent to the instance, but instance metrics are not collected.
            """

        @property
        def stabilization_duration(self) -> google.protobuf.duration_pb2.Duration:
            """Minimum amount of time in seconds allotted for monitoring before
            Instance Groups can reduce the number of instances in the group.
            During this time, the group size doesn't decrease, even if the new metric values
            indicate that it should.
            """

        @property
        def cpu_utilization_rule(self) -> global___ScalePolicy.CpuUtilizationRule:
            """Defines an autoscaling rule based on the average CPU utilization of the instance group.

            If more than one rule is specified, e.g. CPU utilization and one or more Monitoring metrics ([custom_rules]),
            the size of the instance group will be equal to the maximum of sizes calculated according to each metric.
            """

        @property
        def custom_rules(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ScalePolicy.CustomRule]:
            """Defines an autoscaling rule based on a [custom metric](/docs/monitoring/operations/metric/add) from Monitoring.

            If more than one rule is specified, e.g. CPU utilization ([cpu_utilization_rule]) and one or more Monitoring
            metrics, the size of the instance group will be equal to the maximum of sizes calculated according to each metric.
            """

        def __init__(
            self,
            *,
            min_zone_size: builtins.int = ...,
            max_size: builtins.int = ...,
            measurement_duration: google.protobuf.duration_pb2.Duration | None = ...,
            warmup_duration: google.protobuf.duration_pb2.Duration | None = ...,
            stabilization_duration: google.protobuf.duration_pb2.Duration | None = ...,
            initial_size: builtins.int = ...,
            cpu_utilization_rule: global___ScalePolicy.CpuUtilizationRule | None = ...,
            custom_rules: collections.abc.Iterable[global___ScalePolicy.CustomRule] | None = ...,
            auto_scale_type: global___ScalePolicy.AutoScale.AutoScaleType.ValueType = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["cpu_utilization_rule", b"cpu_utilization_rule", "measurement_duration", b"measurement_duration", "stabilization_duration", b"stabilization_duration", "warmup_duration", b"warmup_duration"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["auto_scale_type", b"auto_scale_type", "cpu_utilization_rule", b"cpu_utilization_rule", "custom_rules", b"custom_rules", "initial_size", b"initial_size", "max_size", b"max_size", "measurement_duration", b"measurement_duration", "min_zone_size", b"min_zone_size", "stabilization_duration", b"stabilization_duration", "warmup_duration", b"warmup_duration"]) -> None: ...

    @typing.final
    class CpuUtilizationRule(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        UTILIZATION_TARGET_FIELD_NUMBER: builtins.int
        utilization_target: builtins.float
        """Target CPU utilization level. Instance Groups maintains this level for each availability zone."""
        def __init__(
            self,
            *,
            utilization_target: builtins.float = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["utilization_target", b"utilization_target"]) -> None: ...

    @typing.final
    class CustomRule(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _RuleType:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _RuleTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ScalePolicy.CustomRule._RuleType.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            RULE_TYPE_UNSPECIFIED: ScalePolicy.CustomRule._RuleType.ValueType  # 0
            UTILIZATION: ScalePolicy.CustomRule._RuleType.ValueType  # 1
            """This type means that the metric applies to one instance.
            First, Instance Groups calculates the average metric value for each instance,
            then averages the values for instances in one availability zone or in whole group depends on autoscaling type.
            This type of metric must have the `instance_id` label.
            """
            WORKLOAD: ScalePolicy.CustomRule._RuleType.ValueType  # 2
            """This type means that the metric applies to instances in one availability zone or to whole group depends on autoscaling type.
            This type of metric must have the `zone_id` label if ZONAL autoscaling type is chosen.
            """

        class RuleType(_RuleType, metaclass=_RuleTypeEnumTypeWrapper): ...
        RULE_TYPE_UNSPECIFIED: ScalePolicy.CustomRule.RuleType.ValueType  # 0
        UTILIZATION: ScalePolicy.CustomRule.RuleType.ValueType  # 1
        """This type means that the metric applies to one instance.
        First, Instance Groups calculates the average metric value for each instance,
        then averages the values for instances in one availability zone or in whole group depends on autoscaling type.
        This type of metric must have the `instance_id` label.
        """
        WORKLOAD: ScalePolicy.CustomRule.RuleType.ValueType  # 2
        """This type means that the metric applies to instances in one availability zone or to whole group depends on autoscaling type.
        This type of metric must have the `zone_id` label if ZONAL autoscaling type is chosen.
        """

        class _MetricType:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _MetricTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ScalePolicy.CustomRule._MetricType.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            METRIC_TYPE_UNSPECIFIED: ScalePolicy.CustomRule._MetricType.ValueType  # 0
            GAUGE: ScalePolicy.CustomRule._MetricType.ValueType  # 1
            """This type is used for metrics that show the metric value at a certain point in time,
            such as requests per second to the server on an instance.

            Instance Groups calculates the average metric value for the period
            specified in the [AutoScale.measurement_duration] field.
            """
            COUNTER: ScalePolicy.CustomRule._MetricType.ValueType  # 2
            """This type is used for metrics that monotonically increase over time,
            such as the total number of requests to the server on an instance.

            Instance Groups calculates the average value increase for the period
            specified in the [AutoScale.measurement_duration] field.
            """

        class MetricType(_MetricType, metaclass=_MetricTypeEnumTypeWrapper): ...
        METRIC_TYPE_UNSPECIFIED: ScalePolicy.CustomRule.MetricType.ValueType  # 0
        GAUGE: ScalePolicy.CustomRule.MetricType.ValueType  # 1
        """This type is used for metrics that show the metric value at a certain point in time,
        such as requests per second to the server on an instance.

        Instance Groups calculates the average metric value for the period
        specified in the [AutoScale.measurement_duration] field.
        """
        COUNTER: ScalePolicy.CustomRule.MetricType.ValueType  # 2
        """This type is used for metrics that monotonically increase over time,
        such as the total number of requests to the server on an instance.

        Instance Groups calculates the average value increase for the period
        specified in the [AutoScale.measurement_duration] field.
        """

        @typing.final
        class LabelsEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: builtins.str
            value: builtins.str
            def __init__(
                self,
                *,
                key: builtins.str = ...,
                value: builtins.str = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

        RULE_TYPE_FIELD_NUMBER: builtins.int
        METRIC_TYPE_FIELD_NUMBER: builtins.int
        METRIC_NAME_FIELD_NUMBER: builtins.int
        LABELS_FIELD_NUMBER: builtins.int
        TARGET_FIELD_NUMBER: builtins.int
        FOLDER_ID_FIELD_NUMBER: builtins.int
        SERVICE_FIELD_NUMBER: builtins.int
        rule_type: global___ScalePolicy.CustomRule.RuleType.ValueType
        """Custom metric rule type. This field affects which label from
        the custom metric should be used: `zone_id` or `instance_id`.
        """
        metric_type: global___ScalePolicy.CustomRule.MetricType.ValueType
        """Type of custom metric. This field affects how Instance Groups calculates the average metric value."""
        metric_name: builtins.str
        """Name of custom metric in Monitoring that should be used for scaling."""
        target: builtins.float
        """Target value for the custom metric. Instance Groups maintains this level for each availability zone."""
        folder_id: builtins.str
        """Folder id of custom metric in Monitoring that should be used for scaling."""
        service: builtins.str
        """Service of custom metric in Monitoring that should be used for scaling."""
        @property
        def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
            """Labels of custom metric in Monitoring that should be used for scaling."""

        def __init__(
            self,
            *,
            rule_type: global___ScalePolicy.CustomRule.RuleType.ValueType = ...,
            metric_type: global___ScalePolicy.CustomRule.MetricType.ValueType = ...,
            metric_name: builtins.str = ...,
            labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
            target: builtins.float = ...,
            folder_id: builtins.str = ...,
            service: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["folder_id", b"folder_id", "labels", b"labels", "metric_name", b"metric_name", "metric_type", b"metric_type", "rule_type", b"rule_type", "service", b"service", "target", b"target"]) -> None: ...

    @typing.final
    class FixedScale(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        SIZE_FIELD_NUMBER: builtins.int
        size: builtins.int
        """Number of instances in the instance group."""
        def __init__(
            self,
            *,
            size: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["size", b"size"]) -> None: ...

    FIXED_SCALE_FIELD_NUMBER: builtins.int
    AUTO_SCALE_FIELD_NUMBER: builtins.int
    TEST_AUTO_SCALE_FIELD_NUMBER: builtins.int
    @property
    def fixed_scale(self) -> global___ScalePolicy.FixedScale:
        """[Manual scaling policy](/docs/compute/concepts/instance-groups/scale#fixed-policy) of the instance group."""

    @property
    def auto_scale(self) -> global___ScalePolicy.AutoScale:
        """[Automatic scaling policy](/docs/compute/concepts/instance-groups/scale#auto-scale) of the instance group."""

    @property
    def test_auto_scale(self) -> global___ScalePolicy.AutoScale:
        """Test spec for [automatic scaling policy](/docs/compute/concepts/instance-groups/scale#auto-scale) of the instance group."""

    def __init__(
        self,
        *,
        fixed_scale: global___ScalePolicy.FixedScale | None = ...,
        auto_scale: global___ScalePolicy.AutoScale | None = ...,
        test_auto_scale: global___ScalePolicy.AutoScale | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["auto_scale", b"auto_scale", "fixed_scale", b"fixed_scale", "scale_type", b"scale_type", "test_auto_scale", b"test_auto_scale"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["auto_scale", b"auto_scale", "fixed_scale", b"fixed_scale", "scale_type", b"scale_type", "test_auto_scale", b"test_auto_scale"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["scale_type", b"scale_type"]) -> typing.Literal["fixed_scale", "auto_scale"] | None: ...

global___ScalePolicy = ScalePolicy

@typing.final
class DeployPolicy(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Strategy:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StrategyEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[DeployPolicy._Strategy.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STRATEGY_UNSPECIFIED: DeployPolicy._Strategy.ValueType  # 0
        PROACTIVE: DeployPolicy._Strategy.ValueType  # 1
        """Instance Groups can forcefully stop a running instance. This is the default."""
        OPPORTUNISTIC: DeployPolicy._Strategy.ValueType  # 2
        """Instance Groups does not stop a running instance.
        Instead, it will wait until the instance stops itself or becomes unhealthy.
        """

    class Strategy(_Strategy, metaclass=_StrategyEnumTypeWrapper): ...
    STRATEGY_UNSPECIFIED: DeployPolicy.Strategy.ValueType  # 0
    PROACTIVE: DeployPolicy.Strategy.ValueType  # 1
    """Instance Groups can forcefully stop a running instance. This is the default."""
    OPPORTUNISTIC: DeployPolicy.Strategy.ValueType  # 2
    """Instance Groups does not stop a running instance.
    Instead, it will wait until the instance stops itself or becomes unhealthy.
    """

    class _MinimalAction:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _MinimalActionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[DeployPolicy._MinimalAction.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        MINIMAL_ACTION_UNSPECIFIED: DeployPolicy._MinimalAction.ValueType  # 0
        LIVE_UPDATE: DeployPolicy._MinimalAction.ValueType  # 1
        """Updating an instance without stopping. This is the default."""
        RESTART: DeployPolicy._MinimalAction.ValueType  # 2
        """Updating an instance with restart: stopping and then starting the instance."""
        RECREATE: DeployPolicy._MinimalAction.ValueType  # 3
        """Re-creating an instance: deleting an instance and creating a new one."""

    class MinimalAction(_MinimalAction, metaclass=_MinimalActionEnumTypeWrapper): ...
    MINIMAL_ACTION_UNSPECIFIED: DeployPolicy.MinimalAction.ValueType  # 0
    LIVE_UPDATE: DeployPolicy.MinimalAction.ValueType  # 1
    """Updating an instance without stopping. This is the default."""
    RESTART: DeployPolicy.MinimalAction.ValueType  # 2
    """Updating an instance with restart: stopping and then starting the instance."""
    RECREATE: DeployPolicy.MinimalAction.ValueType  # 3
    """Re-creating an instance: deleting an instance and creating a new one."""

    MAX_UNAVAILABLE_FIELD_NUMBER: builtins.int
    MAX_DELETING_FIELD_NUMBER: builtins.int
    MAX_CREATING_FIELD_NUMBER: builtins.int
    MAX_EXPANSION_FIELD_NUMBER: builtins.int
    STARTUP_DURATION_FIELD_NUMBER: builtins.int
    STRATEGY_FIELD_NUMBER: builtins.int
    MINIMAL_ACTION_FIELD_NUMBER: builtins.int
    max_unavailable: builtins.int
    """The maximum number of running instances that can be taken offline (i.e., stopped or deleted) at the same time
    during the update process.
    If [max_expansion] is not specified or set to zero, [max_unavailable] must be set to a non-zero value.
    """
    max_deleting: builtins.int
    """The maximum number of instances that can be deleted at the same time.

    The value 0 is any number of virtual machines within the allowed values.
    """
    max_creating: builtins.int
    """The maximum number of instances that can be created at the same time.

    The value 0 is any number of virtual machines within the allowed values.
    """
    max_expansion: builtins.int
    """The maximum number of instances that can be temporarily allocated above the group's target size
    during the update process.
    If [max_unavailable] is not specified or set to zero, [max_expansion] must be set to a non-zero value.
    """
    strategy: global___DeployPolicy.Strategy.ValueType
    """Affects the lifecycle of the instance during deployment."""
    minimal_action: global___DeployPolicy.MinimalAction.ValueType
    """If instance update requires a less disruptive action than [minimal_action],
    Instance Groups performs [minimal_action] to execute the update
    """
    @property
    def startup_duration(self) -> google.protobuf.duration_pb2.Duration:
        """Instance startup duration.
        Instance will be considered up and running (and start receiving traffic) only after startup_duration
        has elapsed and all health checks are passed.
        See [ManagedInstance.Status] for more information.
        """

    def __init__(
        self,
        *,
        max_unavailable: builtins.int = ...,
        max_deleting: builtins.int = ...,
        max_creating: builtins.int = ...,
        max_expansion: builtins.int = ...,
        startup_duration: google.protobuf.duration_pb2.Duration | None = ...,
        strategy: global___DeployPolicy.Strategy.ValueType = ...,
        minimal_action: global___DeployPolicy.MinimalAction.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["startup_duration", b"startup_duration"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["max_creating", b"max_creating", "max_deleting", b"max_deleting", "max_expansion", b"max_expansion", "max_unavailable", b"max_unavailable", "minimal_action", b"minimal_action", "startup_duration", b"startup_duration", "strategy", b"strategy"]) -> None: ...

global___DeployPolicy = DeployPolicy

@typing.final
class AllocationPolicy(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class Zone(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ZONE_ID_FIELD_NUMBER: builtins.int
        INSTANCE_TAGS_POOL_FIELD_NUMBER: builtins.int
        zone_id: builtins.str
        """ID of the availability zone where the instance resides."""
        @property
        def instance_tags_pool(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """Each instance in a zone will be associated with exactly one of a tag from a pool below.
            All specified tags must be unique across the whole group not only the zone.
            It is guaranteed that during whole deploy only tags from prefix of the specified list will be used.
            It is possible to use tag associated with instance in templating via {instance.tag}.
            """

        def __init__(
            self,
            *,
            zone_id: builtins.str = ...,
            instance_tags_pool: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["instance_tags_pool", b"instance_tags_pool", "zone_id", b"zone_id"]) -> None: ...

    ZONES_FIELD_NUMBER: builtins.int
    @property
    def zones(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AllocationPolicy.Zone]:
        """List of availability zones."""

    def __init__(
        self,
        *,
        zones: collections.abc.Iterable[global___AllocationPolicy.Zone] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["zones", b"zones"]) -> None: ...

global___AllocationPolicy = AllocationPolicy

@typing.final
class InstanceTemplate(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    PLATFORM_ID_FIELD_NUMBER: builtins.int
    RESOURCES_SPEC_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    BOOT_DISK_SPEC_FIELD_NUMBER: builtins.int
    SECONDARY_DISK_SPECS_FIELD_NUMBER: builtins.int
    NETWORK_INTERFACE_SPECS_FIELD_NUMBER: builtins.int
    SCHEDULING_POLICY_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    NETWORK_SETTINGS_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    HOSTNAME_FIELD_NUMBER: builtins.int
    PLACEMENT_POLICY_FIELD_NUMBER: builtins.int
    FILESYSTEM_SPECS_FIELD_NUMBER: builtins.int
    METADATA_OPTIONS_FIELD_NUMBER: builtins.int
    description: builtins.str
    """Description of the instance template."""
    platform_id: builtins.str
    """ID of the hardware platform configuration for the instance.
    Platforms allows you to create various types of instances: with a large amount of memory,
    with a large number of cores, with a burstable performance.
    For more information, see [Platforms](/docs/compute/concepts/vm-platforms).
    """
    service_account_id: builtins.str
    """Service account ID for the instance."""
    name: builtins.str
    """Name of the instance.
    In order to be unique it must contain at least on of instance unique placeholders:
      {instance.short_id}
      {instance.index}
      combination of {instance.zone_id} and {instance.index_in_zone}
    Example: my-instance-{instance.index}
    If not set, default is used: {instance_group.id}-{instance.short_id}
    It may also contain another placeholders, see metadata doc for full list.
    """
    hostname: builtins.str
    """Host name for the instance.
    This field is used to generate the [yandex.cloud.compute.v1.Instance.fqdn] value.
    The host name must be unique within the network and region.
    If not specified, the host name will be equal to [yandex.cloud.compute.v1.Instance.id] of the instance
    and FQDN will be `<id>.auto.internal`. Otherwise FQDN will be `<hostname>.<region_id>.internal`.

    In order to be unique it must contain at least on of instance unique placeholders:
      {instance.short_id}
      {instance.index}
      combination of {instance.zone_id} and {instance.index_in_zone}
    Example: my-instance-{instance.index}
    If not set, `name` value will be used
    It may also contain another placeholders, see metadata doc for full list.
    """
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs."""

    @property
    def resources_spec(self) -> global___ResourcesSpec:
        """Computing resources of the instance such as the amount of memory and number of cores."""

    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata `key:value` pairs assigned to this instance template. This includes custom metadata and predefined keys.

        Metadata values may contain one of the supported placeholders:
          {instance_group.id}
          {instance.short_id}
          {instance.index}
          {instance.index_in_zone}
          {instance.zone_id}
        InstanceGroup and Instance labels may be copied to metadata following way:
          {instance_group.labels.some_label_key}
          {instance.labels.another_label_key}
        These placeholders will be substituted for each created instance anywhere in the value text.
        In the rare case the value requires to contain this placeholder explicitly,
        it must be escaped with double brackets, in example {instance.index}.

        For example, you may use the metadata in order to provide your public SSH key to the instance.
        For more information, see [Metadata](/docs/compute/concepts/vm-metadata).
        """

    @property
    def boot_disk_spec(self) -> global___AttachedDiskSpec:
        """Boot disk specification that will be attached to the instance."""

    @property
    def secondary_disk_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AttachedDiskSpec]:
        """Array of secondary disks that will be attached to the instance."""

    @property
    def network_interface_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___NetworkInterfaceSpec]:
        """Array of network interfaces that will be attached to the instance."""

    @property
    def scheduling_policy(self) -> global___SchedulingPolicy:
        """Scheduling policy for the instance."""

    @property
    def network_settings(self) -> global___NetworkSettings:
        """Network settings for the instance."""

    @property
    def placement_policy(self) -> global___PlacementPolicy:
        """Placement Group"""

    @property
    def filesystem_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AttachedFilesystemSpec]:
        """Array of filesystems to attach to the instance.

        The filesystems must reside in the same availability zone as the instance.

        To use the instance with an attached filesystem, the latter must be mounted.
        For details, see [documentation](/docs/compute/operations/filesystem/attach-to-vm).
        """

    @property
    def metadata_options(self) -> global___MetadataOptions:
        """Metadata options for the instance"""

    def __init__(
        self,
        *,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        platform_id: builtins.str = ...,
        resources_spec: global___ResourcesSpec | None = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        boot_disk_spec: global___AttachedDiskSpec | None = ...,
        secondary_disk_specs: collections.abc.Iterable[global___AttachedDiskSpec] | None = ...,
        network_interface_specs: collections.abc.Iterable[global___NetworkInterfaceSpec] | None = ...,
        scheduling_policy: global___SchedulingPolicy | None = ...,
        service_account_id: builtins.str = ...,
        network_settings: global___NetworkSettings | None = ...,
        name: builtins.str = ...,
        hostname: builtins.str = ...,
        placement_policy: global___PlacementPolicy | None = ...,
        filesystem_specs: collections.abc.Iterable[global___AttachedFilesystemSpec] | None = ...,
        metadata_options: global___MetadataOptions | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["boot_disk_spec", b"boot_disk_spec", "metadata_options", b"metadata_options", "network_settings", b"network_settings", "placement_policy", b"placement_policy", "resources_spec", b"resources_spec", "scheduling_policy", b"scheduling_policy"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["boot_disk_spec", b"boot_disk_spec", "description", b"description", "filesystem_specs", b"filesystem_specs", "hostname", b"hostname", "labels", b"labels", "metadata", b"metadata", "metadata_options", b"metadata_options", "name", b"name", "network_interface_specs", b"network_interface_specs", "network_settings", b"network_settings", "placement_policy", b"placement_policy", "platform_id", b"platform_id", "resources_spec", b"resources_spec", "scheduling_policy", b"scheduling_policy", "secondary_disk_specs", b"secondary_disk_specs", "service_account_id", b"service_account_id"]) -> None: ...

global___InstanceTemplate = InstanceTemplate

@typing.final
class AttachedFilesystemSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Mode:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[AttachedFilesystemSpec._Mode.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        MODE_UNSPECIFIED: AttachedFilesystemSpec._Mode.ValueType  # 0
        READ_ONLY: AttachedFilesystemSpec._Mode.ValueType  # 1
        """Read-only access."""
        READ_WRITE: AttachedFilesystemSpec._Mode.ValueType  # 2
        """Read/Write access. Default value."""

    class Mode(_Mode, metaclass=_ModeEnumTypeWrapper): ...
    MODE_UNSPECIFIED: AttachedFilesystemSpec.Mode.ValueType  # 0
    READ_ONLY: AttachedFilesystemSpec.Mode.ValueType  # 1
    """Read-only access."""
    READ_WRITE: AttachedFilesystemSpec.Mode.ValueType  # 2
    """Read/Write access. Default value."""

    MODE_FIELD_NUMBER: builtins.int
    DEVICE_NAME_FIELD_NUMBER: builtins.int
    FILESYSTEM_ID_FIELD_NUMBER: builtins.int
    mode: global___AttachedFilesystemSpec.Mode.ValueType
    """Mode of access to the filesystem that should be attached."""
    device_name: builtins.str
    """Name of the device representing the filesystem on the instance.

    The name should be used for referencing the filesystem from within the instance
    when it's being mounted, resized etc.

    If not specified, a random value will be generated.
    """
    filesystem_id: builtins.str
    """ID of the filesystem that should be attached."""
    def __init__(
        self,
        *,
        mode: global___AttachedFilesystemSpec.Mode.ValueType = ...,
        device_name: builtins.str = ...,
        filesystem_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["device_name", b"device_name", "filesystem_id", b"filesystem_id", "mode", b"mode"]) -> None: ...

global___AttachedFilesystemSpec = AttachedFilesystemSpec

@typing.final
class PlacementPolicy(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class HostAffinityRule(google.protobuf.message.Message):
        """Affinity definition"""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _Operator:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _OperatorEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[PlacementPolicy.HostAffinityRule._Operator.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            OPERATOR_UNSPECIFIED: PlacementPolicy.HostAffinityRule._Operator.ValueType  # 0
            IN: PlacementPolicy.HostAffinityRule._Operator.ValueType  # 1
            NOT_IN: PlacementPolicy.HostAffinityRule._Operator.ValueType  # 2

        class Operator(_Operator, metaclass=_OperatorEnumTypeWrapper): ...
        OPERATOR_UNSPECIFIED: PlacementPolicy.HostAffinityRule.Operator.ValueType  # 0
        IN: PlacementPolicy.HostAffinityRule.Operator.ValueType  # 1
        NOT_IN: PlacementPolicy.HostAffinityRule.Operator.ValueType  # 2

        KEY_FIELD_NUMBER: builtins.int
        OP_FIELD_NUMBER: builtins.int
        VALUES_FIELD_NUMBER: builtins.int
        key: builtins.str
        """Affinity label or one of reserved values - 'yc.hostId', 'yc.hostGroupId'"""
        op: global___PlacementPolicy.HostAffinityRule.Operator.ValueType
        """Include or exclude action"""
        @property
        def values(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """Affinity value or host ID or host group ID"""

        def __init__(
            self,
            *,
            key: builtins.str = ...,
            op: global___PlacementPolicy.HostAffinityRule.Operator.ValueType = ...,
            values: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "op", b"op", "values", b"values"]) -> None: ...

    PLACEMENT_GROUP_ID_FIELD_NUMBER: builtins.int
    HOST_AFFINITY_RULES_FIELD_NUMBER: builtins.int
    placement_group_id: builtins.str
    """Identifier of placement group"""
    @property
    def host_affinity_rules(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___PlacementPolicy.HostAffinityRule]:
        """List of affinity rules. Scheduler will attempt to allocate instances according to order of rules."""

    def __init__(
        self,
        *,
        placement_group_id: builtins.str = ...,
        host_affinity_rules: collections.abc.Iterable[global___PlacementPolicy.HostAffinityRule] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["host_affinity_rules", b"host_affinity_rules", "placement_group_id", b"placement_group_id"]) -> None: ...

global___PlacementPolicy = PlacementPolicy

@typing.final
class ResourcesSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MEMORY_FIELD_NUMBER: builtins.int
    CORES_FIELD_NUMBER: builtins.int
    CORE_FRACTION_FIELD_NUMBER: builtins.int
    GPUS_FIELD_NUMBER: builtins.int
    memory: builtins.int
    """The amount of memory available to the instance, specified in bytes."""
    cores: builtins.int
    """The number of cores available to the instance."""
    core_fraction: builtins.int
    """Baseline level of CPU performance with the ability to burst performance above that baseline level.
    This field sets baseline performance for each core.
    """
    gpus: builtins.int
    """The number of GPUs available to the instance."""
    def __init__(
        self,
        *,
        memory: builtins.int = ...,
        cores: builtins.int = ...,
        core_fraction: builtins.int = ...,
        gpus: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["core_fraction", b"core_fraction", "cores", b"cores", "gpus", b"gpus", "memory", b"memory"]) -> None: ...

global___ResourcesSpec = ResourcesSpec

@typing.final
class AttachedDiskSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Mode:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[AttachedDiskSpec._Mode.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        MODE_UNSPECIFIED: AttachedDiskSpec._Mode.ValueType  # 0
        READ_ONLY: AttachedDiskSpec._Mode.ValueType  # 1
        """Read-only access."""
        READ_WRITE: AttachedDiskSpec._Mode.ValueType  # 2
        """Read/Write access."""

    class Mode(_Mode, metaclass=_ModeEnumTypeWrapper): ...
    MODE_UNSPECIFIED: AttachedDiskSpec.Mode.ValueType  # 0
    READ_ONLY: AttachedDiskSpec.Mode.ValueType  # 1
    """Read-only access."""
    READ_WRITE: AttachedDiskSpec.Mode.ValueType  # 2
    """Read/Write access."""

    @typing.final
    class DiskSpec(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        DESCRIPTION_FIELD_NUMBER: builtins.int
        TYPE_ID_FIELD_NUMBER: builtins.int
        SIZE_FIELD_NUMBER: builtins.int
        IMAGE_ID_FIELD_NUMBER: builtins.int
        SNAPSHOT_ID_FIELD_NUMBER: builtins.int
        PRESERVE_AFTER_INSTANCE_DELETE_FIELD_NUMBER: builtins.int
        description: builtins.str
        """Description of the disk."""
        type_id: builtins.str
        """ID of the disk type."""
        size: builtins.int
        """Size of the disk, specified in bytes."""
        image_id: builtins.str
        """ID of the image that will be used for disk creation."""
        snapshot_id: builtins.str
        """ID of the snapshot that will be used for disk creation."""
        preserve_after_instance_delete: builtins.bool
        """When set to true, disk will not be deleted even after managed instance is deleted.
        It will be a user's responsibility to delete such disks.
        """
        def __init__(
            self,
            *,
            description: builtins.str = ...,
            type_id: builtins.str = ...,
            size: builtins.int = ...,
            image_id: builtins.str = ...,
            snapshot_id: builtins.str = ...,
            preserve_after_instance_delete: builtins.bool = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["image_id", b"image_id", "snapshot_id", b"snapshot_id", "source_oneof", b"source_oneof"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["description", b"description", "image_id", b"image_id", "preserve_after_instance_delete", b"preserve_after_instance_delete", "size", b"size", "snapshot_id", b"snapshot_id", "source_oneof", b"source_oneof", "type_id", b"type_id"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["source_oneof", b"source_oneof"]) -> typing.Literal["image_id", "snapshot_id"] | None: ...

    MODE_FIELD_NUMBER: builtins.int
    DEVICE_NAME_FIELD_NUMBER: builtins.int
    DISK_SPEC_FIELD_NUMBER: builtins.int
    DISK_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    mode: global___AttachedDiskSpec.Mode.ValueType
    """Access mode to the Disk resource."""
    device_name: builtins.str
    """Serial number that is reflected in the /dev/disk/by-id/ tree
    of a Linux operating system running within the instance.

    This value can be used to reference the device for mounting, resizing, and so on, from within the instance.
    """
    disk_id: builtins.str
    """Set to use an existing disk. To set use variables."""
    name: builtins.str
    """When set can be later used to change DiskSpec of actual disk."""
    @property
    def disk_spec(self) -> global___AttachedDiskSpec.DiskSpec:
        """oneof disk_spec or disk_id
        Disk specification that is attached to the instance. For more information, see [Disks](/docs/compute/concepts/disk).
        """

    def __init__(
        self,
        *,
        mode: global___AttachedDiskSpec.Mode.ValueType = ...,
        device_name: builtins.str = ...,
        disk_spec: global___AttachedDiskSpec.DiskSpec | None = ...,
        disk_id: builtins.str = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["disk_spec", b"disk_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["device_name", b"device_name", "disk_id", b"disk_id", "disk_spec", b"disk_spec", "mode", b"mode", "name", b"name"]) -> None: ...

global___AttachedDiskSpec = AttachedDiskSpec

@typing.final
class NetworkInterfaceSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NETWORK_ID_FIELD_NUMBER: builtins.int
    SUBNET_IDS_FIELD_NUMBER: builtins.int
    PRIMARY_V4_ADDRESS_SPEC_FIELD_NUMBER: builtins.int
    PRIMARY_V6_ADDRESS_SPEC_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    network_id: builtins.str
    """ID of the network."""
    @property
    def subnet_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IDs of the subnets."""

    @property
    def primary_v4_address_spec(self) -> global___PrimaryAddressSpec:
        """Primary IPv4 address that is assigned to the instance for this network interface."""

    @property
    def primary_v6_address_spec(self) -> global___PrimaryAddressSpec:
        """Primary IPv6 address that is assigned to the instance for this network interface. IPv6 not available yet."""

    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IDs of security groups."""

    def __init__(
        self,
        *,
        network_id: builtins.str = ...,
        subnet_ids: collections.abc.Iterable[builtins.str] | None = ...,
        primary_v4_address_spec: global___PrimaryAddressSpec | None = ...,
        primary_v6_address_spec: global___PrimaryAddressSpec | None = ...,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["primary_v4_address_spec", b"primary_v4_address_spec", "primary_v6_address_spec", b"primary_v6_address_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["network_id", b"network_id", "primary_v4_address_spec", b"primary_v4_address_spec", "primary_v6_address_spec", b"primary_v6_address_spec", "security_group_ids", b"security_group_ids", "subnet_ids", b"subnet_ids"]) -> None: ...

global___NetworkInterfaceSpec = NetworkInterfaceSpec

@typing.final
class PrimaryAddressSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ONE_TO_ONE_NAT_SPEC_FIELD_NUMBER: builtins.int
    DNS_RECORD_SPECS_FIELD_NUMBER: builtins.int
    ADDRESS_FIELD_NUMBER: builtins.int
    address: builtins.str
    """Optional. Manual set static internal IP. To set use variables."""
    @property
    def one_to_one_nat_spec(self) -> global___OneToOneNatSpec:
        """An external IP address configuration.
        If not specified, then this managed instance will have no external internet access.
        """

    @property
    def dns_record_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DnsRecordSpec]:
        """Internal DNS configuration"""

    def __init__(
        self,
        *,
        one_to_one_nat_spec: global___OneToOneNatSpec | None = ...,
        dns_record_specs: collections.abc.Iterable[global___DnsRecordSpec] | None = ...,
        address: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["one_to_one_nat_spec", b"one_to_one_nat_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["address", b"address", "dns_record_specs", b"dns_record_specs", "one_to_one_nat_spec", b"one_to_one_nat_spec"]) -> None: ...

global___PrimaryAddressSpec = PrimaryAddressSpec

@typing.final
class OneToOneNatSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IP_VERSION_FIELD_NUMBER: builtins.int
    ADDRESS_FIELD_NUMBER: builtins.int
    DNS_RECORD_SPECS_FIELD_NUMBER: builtins.int
    ip_version: global___IpVersion.ValueType
    """IP version for the public IP address."""
    address: builtins.str
    """Manual set static public IP. To set use variables. (optional)"""
    @property
    def dns_record_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DnsRecordSpec]:
        """External DNS configuration"""

    def __init__(
        self,
        *,
        ip_version: global___IpVersion.ValueType = ...,
        address: builtins.str = ...,
        dns_record_specs: collections.abc.Iterable[global___DnsRecordSpec] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["address", b"address", "dns_record_specs", b"dns_record_specs", "ip_version", b"ip_version"]) -> None: ...

global___OneToOneNatSpec = OneToOneNatSpec

@typing.final
class DnsRecordSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FQDN_FIELD_NUMBER: builtins.int
    DNS_ZONE_ID_FIELD_NUMBER: builtins.int
    TTL_FIELD_NUMBER: builtins.int
    PTR_FIELD_NUMBER: builtins.int
    fqdn: builtins.str
    """FQDN (required)"""
    dns_zone_id: builtins.str
    """DNS zone id (optional, if not set, private zone used)"""
    ttl: builtins.int
    """DNS record ttl, values in 0-86400 (optional)"""
    ptr: builtins.bool
    """When set to true, also create PTR DNS record (optional)"""
    def __init__(
        self,
        *,
        fqdn: builtins.str = ...,
        dns_zone_id: builtins.str = ...,
        ttl: builtins.int = ...,
        ptr: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dns_zone_id", b"dns_zone_id", "fqdn", b"fqdn", "ptr", b"ptr", "ttl", b"ttl"]) -> None: ...

global___DnsRecordSpec = DnsRecordSpec

@typing.final
class SchedulingPolicy(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PREEMPTIBLE_FIELD_NUMBER: builtins.int
    preemptible: builtins.bool
    """Preemptible instances are stopped at least once every 24 hours, and can be stopped at any time
    if their resources are needed by Compute.
    For more information, see [Preemptible Virtual Machines](/docs/compute/concepts/preemptible-vm).
    """
    def __init__(
        self,
        *,
        preemptible: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["preemptible", b"preemptible"]) -> None: ...

global___SchedulingPolicy = SchedulingPolicy

@typing.final
class NetworkSettings(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Type:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[NetworkSettings._Type.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TYPE_UNSPECIFIED: NetworkSettings._Type.ValueType  # 0
        STANDARD: NetworkSettings._Type.ValueType  # 1
        SOFTWARE_ACCELERATED: NetworkSettings._Type.ValueType  # 2
        HARDWARE_ACCELERATED: NetworkSettings._Type.ValueType  # 3

    class Type(_Type, metaclass=_TypeEnumTypeWrapper): ...
    TYPE_UNSPECIFIED: NetworkSettings.Type.ValueType  # 0
    STANDARD: NetworkSettings.Type.ValueType  # 1
    SOFTWARE_ACCELERATED: NetworkSettings.Type.ValueType  # 2
    HARDWARE_ACCELERATED: NetworkSettings.Type.ValueType  # 3

    TYPE_FIELD_NUMBER: builtins.int
    type: global___NetworkSettings.Type.ValueType
    """Type of instance network."""
    def __init__(
        self,
        *,
        type: global___NetworkSettings.Type.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["type", b"type"]) -> None: ...

global___NetworkSettings = NetworkSettings

@typing.final
class LoadBalancerSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TARGET_GROUP_SPEC_FIELD_NUMBER: builtins.int
    MAX_OPENING_TRAFFIC_DURATION_FIELD_NUMBER: builtins.int
    IGNORE_HEALTH_CHECKS_FIELD_NUMBER: builtins.int
    ignore_health_checks: builtins.bool
    """Do not wait load balancer health checks."""
    @property
    def target_group_spec(self) -> global___TargetGroupSpec:
        """Specification of the target group that the instance group will be added to. For more information, see [Target groups and resources](/docs/network-load-balancer/concepts/target-resources)."""

    @property
    def max_opening_traffic_duration(self) -> google.protobuf.duration_pb2.Duration:
        """Timeout for waiting for the VM to be checked by the load balancer. If the timeout is exceeded,
        the VM will be turned off based on the deployment policy. Specified in seconds.
        """

    def __init__(
        self,
        *,
        target_group_spec: global___TargetGroupSpec | None = ...,
        max_opening_traffic_duration: google.protobuf.duration_pb2.Duration | None = ...,
        ignore_health_checks: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["max_opening_traffic_duration", b"max_opening_traffic_duration", "target_group_spec", b"target_group_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["ignore_health_checks", b"ignore_health_checks", "max_opening_traffic_duration", b"max_opening_traffic_duration", "target_group_spec", b"target_group_spec"]) -> None: ...

global___LoadBalancerSpec = LoadBalancerSpec

@typing.final
class TargetGroupSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the target group."""
    description: builtins.str
    """Description of the target group."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "labels", b"labels", "name", b"name"]) -> None: ...

global___TargetGroupSpec = TargetGroupSpec

@typing.final
class ApplicationLoadBalancerSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TARGET_GROUP_SPEC_FIELD_NUMBER: builtins.int
    MAX_OPENING_TRAFFIC_DURATION_FIELD_NUMBER: builtins.int
    IGNORE_HEALTH_CHECKS_FIELD_NUMBER: builtins.int
    ignore_health_checks: builtins.bool
    """Do not wait load balancer health checks."""
    @property
    def target_group_spec(self) -> global___ApplicationTargetGroupSpec:
        """Basic properties of the Application Load Balancer target group attributed to the instance group."""

    @property
    def max_opening_traffic_duration(self) -> google.protobuf.duration_pb2.Duration:
        """Timeout for waiting for the VM to be checked by the load balancer. If the timeout is exceeded,
        the VM will be turned off based on the deployment policy. Specified in seconds.
        """

    def __init__(
        self,
        *,
        target_group_spec: global___ApplicationTargetGroupSpec | None = ...,
        max_opening_traffic_duration: google.protobuf.duration_pb2.Duration | None = ...,
        ignore_health_checks: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["max_opening_traffic_duration", b"max_opening_traffic_duration", "target_group_spec", b"target_group_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["ignore_health_checks", b"ignore_health_checks", "max_opening_traffic_duration", b"max_opening_traffic_duration", "target_group_spec", b"target_group_spec"]) -> None: ...

global___ApplicationLoadBalancerSpec = ApplicationLoadBalancerSpec

@typing.final
class ApplicationTargetGroupSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the target group."""
    description: builtins.str
    """Description of the target group."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "labels", b"labels", "name", b"name"]) -> None: ...

global___ApplicationTargetGroupSpec = ApplicationTargetGroupSpec

@typing.final
class HealthChecksSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_SPECS_FIELD_NUMBER: builtins.int
    MAX_CHECKING_HEALTH_DURATION_FIELD_NUMBER: builtins.int
    @property
    def health_check_specs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___HealthCheckSpec]:
        """Health checking specification. For more information, see [Health check](/docs/network-load-balancer/concepts/health-check)."""

    @property
    def max_checking_health_duration(self) -> google.protobuf.duration_pb2.Duration:
        """Timeout for waiting for the VM to become healthy. If the timeout is exceeded,
        the VM will be turned off based on the deployment policy. Specified in seconds.
        """

    def __init__(
        self,
        *,
        health_check_specs: collections.abc.Iterable[global___HealthCheckSpec] | None = ...,
        max_checking_health_duration: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["max_checking_health_duration", b"max_checking_health_duration"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["health_check_specs", b"health_check_specs", "max_checking_health_duration", b"max_checking_health_duration"]) -> None: ...

global___HealthChecksSpec = HealthChecksSpec

@typing.final
class HealthCheckSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class TcpOptions(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        PORT_FIELD_NUMBER: builtins.int
        port: builtins.int
        """Port to use for TCP health checks."""
        def __init__(
            self,
            *,
            port: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["port", b"port"]) -> None: ...

    @typing.final
    class HttpOptions(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        PORT_FIELD_NUMBER: builtins.int
        PATH_FIELD_NUMBER: builtins.int
        port: builtins.int
        """Port to use for HTTP health checks."""
        path: builtins.str
        """URL path to set for health checking requests."""
        def __init__(
            self,
            *,
            port: builtins.int = ...,
            path: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["path", b"path", "port", b"port"]) -> None: ...

    INTERVAL_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    UNHEALTHY_THRESHOLD_FIELD_NUMBER: builtins.int
    HEALTHY_THRESHOLD_FIELD_NUMBER: builtins.int
    TCP_OPTIONS_FIELD_NUMBER: builtins.int
    HTTP_OPTIONS_FIELD_NUMBER: builtins.int
    unhealthy_threshold: builtins.int
    """The number of failed health checks for the managed instance to be considered unhealthy. The default (0) is 2."""
    healthy_threshold: builtins.int
    """The number of successful health checks required in order for the managed instance to be considered healthy. The default (0) is 2."""
    @property
    def interval(self) -> google.protobuf.duration_pb2.Duration:
        """The interval between health checks. The default is 2 seconds."""

    @property
    def timeout(self) -> google.protobuf.duration_pb2.Duration:
        """Timeout for the managed instance to return a response for the health check. The default is 1 second."""

    @property
    def tcp_options(self) -> global___HealthCheckSpec.TcpOptions:
        """Configuration options for a TCP health check."""

    @property
    def http_options(self) -> global___HealthCheckSpec.HttpOptions:
        """Configuration options for an HTTP health check."""

    def __init__(
        self,
        *,
        interval: google.protobuf.duration_pb2.Duration | None = ...,
        timeout: google.protobuf.duration_pb2.Duration | None = ...,
        unhealthy_threshold: builtins.int = ...,
        healthy_threshold: builtins.int = ...,
        tcp_options: global___HealthCheckSpec.TcpOptions | None = ...,
        http_options: global___HealthCheckSpec.HttpOptions | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["health_check_options", b"health_check_options", "http_options", b"http_options", "interval", b"interval", "tcp_options", b"tcp_options", "timeout", b"timeout"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["health_check_options", b"health_check_options", "healthy_threshold", b"healthy_threshold", "http_options", b"http_options", "interval", b"interval", "tcp_options", b"tcp_options", "timeout", b"timeout", "unhealthy_threshold", b"unhealthy_threshold"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["health_check_options", b"health_check_options"]) -> typing.Literal["tcp_options", "http_options"] | None: ...

global___HealthCheckSpec = HealthCheckSpec

@typing.final
class ManagedInstance(google.protobuf.message.Message):
    """A ManagedInstance resource. For more information, see [Instance Groups Concepts](/docs/compute/concepts/instance-groups/)."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ManagedInstance._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: ManagedInstance._Status.ValueType  # 0
        CREATING_INSTANCE: ManagedInstance._Status.ValueType  # 11
        """Instance is being created."""
        UPDATING_INSTANCE: ManagedInstance._Status.ValueType  # 12
        """Instance is being updated."""
        DELETING_INSTANCE: ManagedInstance._Status.ValueType  # 13
        """Instance is being deleted."""
        STARTING_INSTANCE: ManagedInstance._Status.ValueType  # 14
        """Instance is being started."""
        STOPPING_INSTANCE: ManagedInstance._Status.ValueType  # 15
        """Instance is being stopped."""
        AWAITING_STARTUP_DURATION: ManagedInstance._Status.ValueType  # 16
        """Instance has been created successfully, but startup duration has not elapsed yet."""
        CHECKING_HEALTH: ManagedInstance._Status.ValueType  # 17
        """Instance has been created successfully and startup duration has elapsed, but health checks have not passed yet and the managed instance is not ready to receive traffic."""
        OPENING_TRAFFIC: ManagedInstance._Status.ValueType  # 18
        """Instance Groups is initiating health checks and routing traffic to the instances."""
        AWAITING_WARMUP_DURATION: ManagedInstance._Status.ValueType  # 19
        """Instance is now receiving traffic, but warmup duration has not elapsed yet."""
        CLOSING_TRAFFIC: ManagedInstance._Status.ValueType  # 20
        """Instance Groups has initiated the process of stopping routing traffic to the instances."""
        RUNNING_ACTUAL: ManagedInstance._Status.ValueType  # 21
        """Instance is running normally and its attributes match the current InstanceTemplate."""
        RUNNING_OUTDATED: ManagedInstance._Status.ValueType  # 22
        """Instance is running normally, but its attributes do not match the current InstanceTemplate.
        It will be updated, recreated or deleted shortly.
        """
        STOPPED: ManagedInstance._Status.ValueType  # 23
        """Instance was stopped."""
        DELETED: ManagedInstance._Status.ValueType  # 24
        """Instance was deleted."""
        PREPARING_RESOURCES: ManagedInstance._Status.ValueType  # 25
        """Instance Groups is preparing dependent resources."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNSPECIFIED: ManagedInstance.Status.ValueType  # 0
    CREATING_INSTANCE: ManagedInstance.Status.ValueType  # 11
    """Instance is being created."""
    UPDATING_INSTANCE: ManagedInstance.Status.ValueType  # 12
    """Instance is being updated."""
    DELETING_INSTANCE: ManagedInstance.Status.ValueType  # 13
    """Instance is being deleted."""
    STARTING_INSTANCE: ManagedInstance.Status.ValueType  # 14
    """Instance is being started."""
    STOPPING_INSTANCE: ManagedInstance.Status.ValueType  # 15
    """Instance is being stopped."""
    AWAITING_STARTUP_DURATION: ManagedInstance.Status.ValueType  # 16
    """Instance has been created successfully, but startup duration has not elapsed yet."""
    CHECKING_HEALTH: ManagedInstance.Status.ValueType  # 17
    """Instance has been created successfully and startup duration has elapsed, but health checks have not passed yet and the managed instance is not ready to receive traffic."""
    OPENING_TRAFFIC: ManagedInstance.Status.ValueType  # 18
    """Instance Groups is initiating health checks and routing traffic to the instances."""
    AWAITING_WARMUP_DURATION: ManagedInstance.Status.ValueType  # 19
    """Instance is now receiving traffic, but warmup duration has not elapsed yet."""
    CLOSING_TRAFFIC: ManagedInstance.Status.ValueType  # 20
    """Instance Groups has initiated the process of stopping routing traffic to the instances."""
    RUNNING_ACTUAL: ManagedInstance.Status.ValueType  # 21
    """Instance is running normally and its attributes match the current InstanceTemplate."""
    RUNNING_OUTDATED: ManagedInstance.Status.ValueType  # 22
    """Instance is running normally, but its attributes do not match the current InstanceTemplate.
    It will be updated, recreated or deleted shortly.
    """
    STOPPED: ManagedInstance.Status.ValueType  # 23
    """Instance was stopped."""
    DELETED: ManagedInstance.Status.ValueType  # 24
    """Instance was deleted."""
    PREPARING_RESOURCES: ManagedInstance.Status.ValueType  # 25
    """Instance Groups is preparing dependent resources."""

    ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    INSTANCE_ID_FIELD_NUMBER: builtins.int
    FQDN_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    STATUS_MESSAGE_FIELD_NUMBER: builtins.int
    ZONE_ID_FIELD_NUMBER: builtins.int
    NETWORK_INTERFACES_FIELD_NUMBER: builtins.int
    STATUS_CHANGED_AT_FIELD_NUMBER: builtins.int
    INSTANCE_TAG_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the managed instance."""
    status: global___ManagedInstance.Status.ValueType
    """Status of the managed instance."""
    instance_id: builtins.str
    """ID of the instance."""
    fqdn: builtins.str
    """Fully Qualified Domain Name."""
    name: builtins.str
    """The name of the managed instance."""
    status_message: builtins.str
    """Status message for the managed instance."""
    zone_id: builtins.str
    """ID of the availability zone where the instance resides."""
    instance_tag: builtins.str
    """Managed instance tag."""
    @property
    def network_interfaces(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___NetworkInterface]:
        """Array of network interfaces that are attached to the managed instance."""

    @property
    def status_changed_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format when the status of the managed instance was last changed."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        status: global___ManagedInstance.Status.ValueType = ...,
        instance_id: builtins.str = ...,
        fqdn: builtins.str = ...,
        name: builtins.str = ...,
        status_message: builtins.str = ...,
        zone_id: builtins.str = ...,
        network_interfaces: collections.abc.Iterable[global___NetworkInterface] | None = ...,
        status_changed_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        instance_tag: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["status_changed_at", b"status_changed_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["fqdn", b"fqdn", "id", b"id", "instance_id", b"instance_id", "instance_tag", b"instance_tag", "name", b"name", "network_interfaces", b"network_interfaces", "status", b"status", "status_changed_at", b"status_changed_at", "status_message", b"status_message", "zone_id", b"zone_id"]) -> None: ...

global___ManagedInstance = ManagedInstance

@typing.final
class NetworkInterface(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INDEX_FIELD_NUMBER: builtins.int
    MAC_ADDRESS_FIELD_NUMBER: builtins.int
    SUBNET_ID_FIELD_NUMBER: builtins.int
    PRIMARY_V4_ADDRESS_FIELD_NUMBER: builtins.int
    PRIMARY_V6_ADDRESS_FIELD_NUMBER: builtins.int
    index: builtins.str
    """The index of the network interface, generated by the server, 0,1,2... etc."""
    mac_address: builtins.str
    """MAC address that is assigned to the network interface."""
    subnet_id: builtins.str
    """ID of the subnet."""
    @property
    def primary_v4_address(self) -> global___PrimaryAddress:
        """Primary IPv4 address that is assigned to the instance for this network interface."""

    @property
    def primary_v6_address(self) -> global___PrimaryAddress:
        """Primary IPv6 address that is assigned to the instance for this network interface. IPv6 is not available yet."""

    def __init__(
        self,
        *,
        index: builtins.str = ...,
        mac_address: builtins.str = ...,
        subnet_id: builtins.str = ...,
        primary_v4_address: global___PrimaryAddress | None = ...,
        primary_v6_address: global___PrimaryAddress | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["primary_v4_address", b"primary_v4_address", "primary_v6_address", b"primary_v6_address"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["index", b"index", "mac_address", b"mac_address", "primary_v4_address", b"primary_v4_address", "primary_v6_address", b"primary_v6_address", "subnet_id", b"subnet_id"]) -> None: ...

global___NetworkInterface = NetworkInterface

@typing.final
class PrimaryAddress(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ADDRESS_FIELD_NUMBER: builtins.int
    ONE_TO_ONE_NAT_FIELD_NUMBER: builtins.int
    DNS_RECORDS_FIELD_NUMBER: builtins.int
    address: builtins.str
    """An IPv4 internal network address that is assigned to the managed instance for this network interface.
    If not specified by the user, an unused internal IP is assigned by the system.
    """
    @property
    def one_to_one_nat(self) -> global___OneToOneNat:
        """One-to-one NAT configuration. If missing, NAT has not been set up."""

    @property
    def dns_records(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DnsRecord]:
        """Internal DNS configuration."""

    def __init__(
        self,
        *,
        address: builtins.str = ...,
        one_to_one_nat: global___OneToOneNat | None = ...,
        dns_records: collections.abc.Iterable[global___DnsRecord] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["one_to_one_nat", b"one_to_one_nat"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["address", b"address", "dns_records", b"dns_records", "one_to_one_nat", b"one_to_one_nat"]) -> None: ...

global___PrimaryAddress = PrimaryAddress

@typing.final
class OneToOneNat(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ADDRESS_FIELD_NUMBER: builtins.int
    IP_VERSION_FIELD_NUMBER: builtins.int
    DNS_RECORDS_FIELD_NUMBER: builtins.int
    address: builtins.str
    """An IPv4 external network address that is assigned to the managed instance for this network interface."""
    ip_version: global___IpVersion.ValueType
    """External IP address version."""
    @property
    def dns_records(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DnsRecord]:
        """External DNS configuration."""

    def __init__(
        self,
        *,
        address: builtins.str = ...,
        ip_version: global___IpVersion.ValueType = ...,
        dns_records: collections.abc.Iterable[global___DnsRecord] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["address", b"address", "dns_records", b"dns_records", "ip_version", b"ip_version"]) -> None: ...

global___OneToOneNat = OneToOneNat

@typing.final
class DnsRecord(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FQDN_FIELD_NUMBER: builtins.int
    DNS_ZONE_ID_FIELD_NUMBER: builtins.int
    TTL_FIELD_NUMBER: builtins.int
    PTR_FIELD_NUMBER: builtins.int
    fqdn: builtins.str
    """Name of the A/AAAA record as specified when creating the instance.
    Note that if `fqdn' has no trailing '.', it is specified relative to the zone (@see dns_zone_id).
    """
    dns_zone_id: builtins.str
    """DNS zone id (optional, if not set, some private zone is used)."""
    ttl: builtins.int
    """DNS record ttl (optional, if 0, a reasonable default is used)."""
    ptr: builtins.bool
    """When true, indicates there is a corresponding auto-created PTR DNS record."""
    def __init__(
        self,
        *,
        fqdn: builtins.str = ...,
        dns_zone_id: builtins.str = ...,
        ttl: builtins.int = ...,
        ptr: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["dns_zone_id", b"dns_zone_id", "fqdn", b"fqdn", "ptr", b"ptr", "ttl", b"ttl"]) -> None: ...

global___DnsRecord = DnsRecord

@typing.final
class LogRecord(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIMESTAMP_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    message: builtins.str
    """The log message."""
    @property
    def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Log timestamp in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format."""

    def __init__(
        self,
        *,
        timestamp: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        message: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["timestamp", b"timestamp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["message", b"message", "timestamp", b"timestamp"]) -> None: ...

global___LogRecord = LogRecord

@typing.final
class AutoHealingPolicy(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _AutoHealingAction:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _AutoHealingActionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[AutoHealingPolicy._AutoHealingAction.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        AUTO_HEALING_ACTION_UNSPECIFIED: AutoHealingPolicy._AutoHealingAction.ValueType  # 0
        RESTART: AutoHealingPolicy._AutoHealingAction.ValueType  # 1
        """Re-starting an instance with restart: stopping and then starting the instance."""
        RECREATE: AutoHealingPolicy._AutoHealingAction.ValueType  # 2
        """Re-creating an instance: deleting an instance and creating a new one."""
        NONE: AutoHealingPolicy._AutoHealingAction.ValueType  # 3
        """No action"""

    class AutoHealingAction(_AutoHealingAction, metaclass=_AutoHealingActionEnumTypeWrapper): ...
    AUTO_HEALING_ACTION_UNSPECIFIED: AutoHealingPolicy.AutoHealingAction.ValueType  # 0
    RESTART: AutoHealingPolicy.AutoHealingAction.ValueType  # 1
    """Re-starting an instance with restart: stopping and then starting the instance."""
    RECREATE: AutoHealingPolicy.AutoHealingAction.ValueType  # 2
    """Re-creating an instance: deleting an instance and creating a new one."""
    NONE: AutoHealingPolicy.AutoHealingAction.ValueType  # 3
    """No action"""

    AUTO_HEALING_ACTION_FIELD_NUMBER: builtins.int
    auto_healing_action: global___AutoHealingPolicy.AutoHealingAction.ValueType
    """Instance Groups performs [auto_healing_action] when instance becomes unhealthy."""
    def __init__(
        self,
        *,
        auto_healing_action: global___AutoHealingPolicy.AutoHealingAction.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["auto_healing_action", b"auto_healing_action"]) -> None: ...

global___AutoHealingPolicy = AutoHealingPolicy

@typing.final
class MetadataOptions(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GCE_HTTP_ENDPOINT_FIELD_NUMBER: builtins.int
    AWS_V1_HTTP_ENDPOINT_FIELD_NUMBER: builtins.int
    GCE_HTTP_TOKEN_FIELD_NUMBER: builtins.int
    AWS_V1_HTTP_TOKEN_FIELD_NUMBER: builtins.int
    gce_http_endpoint: global___MetadataOption.ValueType
    """Enabled access to GCE flavored metadata"""
    aws_v1_http_endpoint: global___MetadataOption.ValueType
    """Enabled access to AWS flavored metadata (IMDSv1)"""
    gce_http_token: global___MetadataOption.ValueType
    """Enabled access to IAM credentials with GCE flavored metadata"""
    aws_v1_http_token: global___MetadataOption.ValueType
    """Enabled access to IAM credentials with AWS flavored metadata (IMDSv1)"""
    def __init__(
        self,
        *,
        gce_http_endpoint: global___MetadataOption.ValueType = ...,
        aws_v1_http_endpoint: global___MetadataOption.ValueType = ...,
        gce_http_token: global___MetadataOption.ValueType = ...,
        aws_v1_http_token: global___MetadataOption.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["aws_v1_http_endpoint", b"aws_v1_http_endpoint", "aws_v1_http_token", b"aws_v1_http_token", "gce_http_endpoint", b"gce_http_endpoint", "gce_http_token", b"gce_http_token"]) -> None: ...

global___MetadataOptions = MetadataOptions
