"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing
import yandex.cloud.compute.v1.instancegroup.instance_group_pb2
import yandex.cloud.operation.operation_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _InstanceGroupView:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _InstanceGroupViewEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_InstanceGroupView.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    BASIC: _InstanceGroupView.ValueType  # 0
    """Doesn't include the metadata of the instance template in the server response."""
    FULL: _InstanceGroupView.ValueType  # 1
    """Returns the metadata of the instance template in the server response."""

class InstanceGroupView(_InstanceGroupView, metaclass=_InstanceGroupViewEnumTypeWrapper): ...

BASIC: InstanceGroupView.ValueType  # 0
"""Doesn't include the metadata of the instance template in the server response."""
FULL: InstanceGroupView.ValueType  # 1
"""Returns the metadata of the instance template in the server response."""
global___InstanceGroupView = InstanceGroupView

@typing.final
class ResumeInstanceGroupProcessesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_GROUP_ID_FIELD_NUMBER: builtins.int
    instance_group_id: builtins.str
    """ID of the instance group to resume processes in.

    The instance group must have a `PAUSED` status ([InstanceGroup.status]).

    To get the instance group ID, make a [InstanceGroupService.List] request.
    """
    def __init__(
        self,
        *,
        instance_group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_group_id", b"instance_group_id"]) -> None: ...

global___ResumeInstanceGroupProcessesRequest = ResumeInstanceGroupProcessesRequest

@typing.final
class ResumeInstanceGroupProcessMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_GROUP_ID_FIELD_NUMBER: builtins.int
    instance_group_id: builtins.str
    """ID of the instance group that processes are being resumed in."""
    def __init__(
        self,
        *,
        instance_group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_group_id", b"instance_group_id"]) -> None: ...

global___ResumeInstanceGroupProcessMetadata = ResumeInstanceGroupProcessMetadata

@typing.final
class PauseInstanceGroupProcessesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_GROUP_ID_FIELD_NUMBER: builtins.int
    instance_group_id: builtins.str
    """ID of the instance group to pause processes in.

    The instance group must have an `ACTIVE` status ([InstanceGroup.status]).

    To get the instance group ID, make a [InstanceGroupService.List] request.
    """
    def __init__(
        self,
        *,
        instance_group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_group_id", b"instance_group_id"]) -> None: ...

global___PauseInstanceGroupProcessesRequest = PauseInstanceGroupProcessesRequest

@typing.final
class PauseInstanceGroupProcessMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_GROUP_ID_FIELD_NUMBER: builtins.int
    instance_group_id: builtins.str
    """ID of the instance group that processes are being paused in."""
    def __init__(
        self,
        *,
        instance_group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_group_id", b"instance_group_id"]) -> None: ...

global___PauseInstanceGroupProcessMetadata = PauseInstanceGroupProcessMetadata

@typing.final
class GetInstanceGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_GROUP_ID_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    instance_group_id: builtins.str
    """ID of the InstanceGroup resource to return.
    To get the instance group ID, use a [InstanceGroupService.List] request.
    """
    view: global___InstanceGroupView.ValueType
    """Defines which information about the Instance template should be returned in the server response."""
    def __init__(
        self,
        *,
        instance_group_id: builtins.str = ...,
        view: global___InstanceGroupView.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_group_id", b"instance_group_id", "view", b"view"]) -> None: ...

global___GetInstanceGroupRequest = GetInstanceGroupRequest

@typing.final
class CreateInstanceGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    INSTANCE_TEMPLATE_FIELD_NUMBER: builtins.int
    SCALE_POLICY_FIELD_NUMBER: builtins.int
    DEPLOY_POLICY_FIELD_NUMBER: builtins.int
    ALLOCATION_POLICY_FIELD_NUMBER: builtins.int
    LOAD_BALANCER_SPEC_FIELD_NUMBER: builtins.int
    HEALTH_CHECKS_SPEC_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    VARIABLES_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    APPLICATION_LOAD_BALANCER_SPEC_FIELD_NUMBER: builtins.int
    AUTO_HEALING_POLICY_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to create an instance group in.
    To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    name: builtins.str
    """Name of the instance group."""
    description: builtins.str
    """Description of the instance group."""
    service_account_id: builtins.str
    """ID of the service account. The service account will be used for all API calls
    made by the Instance Groups component on behalf of the user (for example, creating instances, adding them to load balancer target group, etc.). For more information, see [Service accounts](/docs/iam/concepts/users/service-accounts).
    To get the service account ID, use a [yandex.cloud.iam.v1.ServiceAccountService.List] request.
    """
    deletion_protection: builtins.bool
    """Flag prohibiting deletion of the instance group.

    Allowed values:</br>- `false`: The instance group can be deleted.</br>- `true`: The instance group cannot be deleted.

    The default is `false`.
    """
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs."""

    @property
    def instance_template(self) -> yandex.cloud.compute.v1.instancegroup.instance_group_pb2.InstanceTemplate:
        """Instance template that the instance group belongs to."""

    @property
    def scale_policy(self) -> yandex.cloud.compute.v1.instancegroup.instance_group_pb2.ScalePolicy:
        """[Scaling policy](/docs/compute/concepts/instance-groups/scale) of the instance group."""

    @property
    def deploy_policy(self) -> yandex.cloud.compute.v1.instancegroup.instance_group_pb2.DeployPolicy:
        """Deployment policy of the instance group."""

    @property
    def allocation_policy(self) -> yandex.cloud.compute.v1.instancegroup.instance_group_pb2.AllocationPolicy:
        """Allocation policy of the instance group by zones and regions."""

    @property
    def load_balancer_spec(self) -> yandex.cloud.compute.v1.instancegroup.instance_group_pb2.LoadBalancerSpec:
        """Settings for balancing load between instances via [Network Load Balancer](/docs/network-load-balancer/concepts)
        (OSI model layer 3).

        If specified, a Network Load Balancer target group containing all instances from the instance group will be created
        and attributed to the instance group.
        """

    @property
    def health_checks_spec(self) -> yandex.cloud.compute.v1.instancegroup.instance_group_pb2.HealthChecksSpec:
        """Health checking specification. For more information, see [Health check](/docs/network-load-balancer/concepts/health-check)."""

    @property
    def variables(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.compute.v1.instancegroup.instance_group_pb2.Variable]: ...
    @property
    def application_load_balancer_spec(self) -> yandex.cloud.compute.v1.instancegroup.instance_group_pb2.ApplicationLoadBalancerSpec:
        """Settings for balancing load between instances via [Application Load Balancer](/docs/application-load-balancer/concepts)
        (OSI model layer 7).

        If specified, an Application Load Balancer target group containing all instances from the instance group will be created
        and attributed to the instance group.
        """

    @property
    def auto_healing_policy(self) -> yandex.cloud.compute.v1.instancegroup.instance_group_pb2.AutoHealingPolicy:
        """AutoHealingPolicy policy of the instance group."""

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        instance_template: yandex.cloud.compute.v1.instancegroup.instance_group_pb2.InstanceTemplate | None = ...,
        scale_policy: yandex.cloud.compute.v1.instancegroup.instance_group_pb2.ScalePolicy | None = ...,
        deploy_policy: yandex.cloud.compute.v1.instancegroup.instance_group_pb2.DeployPolicy | None = ...,
        allocation_policy: yandex.cloud.compute.v1.instancegroup.instance_group_pb2.AllocationPolicy | None = ...,
        load_balancer_spec: yandex.cloud.compute.v1.instancegroup.instance_group_pb2.LoadBalancerSpec | None = ...,
        health_checks_spec: yandex.cloud.compute.v1.instancegroup.instance_group_pb2.HealthChecksSpec | None = ...,
        service_account_id: builtins.str = ...,
        variables: collections.abc.Iterable[yandex.cloud.compute.v1.instancegroup.instance_group_pb2.Variable] | None = ...,
        deletion_protection: builtins.bool = ...,
        application_load_balancer_spec: yandex.cloud.compute.v1.instancegroup.instance_group_pb2.ApplicationLoadBalancerSpec | None = ...,
        auto_healing_policy: yandex.cloud.compute.v1.instancegroup.instance_group_pb2.AutoHealingPolicy | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["allocation_policy", b"allocation_policy", "application_load_balancer_spec", b"application_load_balancer_spec", "auto_healing_policy", b"auto_healing_policy", "deploy_policy", b"deploy_policy", "health_checks_spec", b"health_checks_spec", "instance_template", b"instance_template", "load_balancer_spec", b"load_balancer_spec", "scale_policy", b"scale_policy"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["allocation_policy", b"allocation_policy", "application_load_balancer_spec", b"application_load_balancer_spec", "auto_healing_policy", b"auto_healing_policy", "deletion_protection", b"deletion_protection", "deploy_policy", b"deploy_policy", "description", b"description", "folder_id", b"folder_id", "health_checks_spec", b"health_checks_spec", "instance_template", b"instance_template", "labels", b"labels", "load_balancer_spec", b"load_balancer_spec", "name", b"name", "scale_policy", b"scale_policy", "service_account_id", b"service_account_id", "variables", b"variables"]) -> None: ...

global___CreateInstanceGroupRequest = CreateInstanceGroupRequest

@typing.final
class CreateInstanceGroupFromYamlRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    INSTANCE_GROUP_YAML_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to create an instance group in.
    To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    instance_group_yaml: builtins.str
    """[InstanceGroupService.Create] request in YAML format."""
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        instance_group_yaml: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["folder_id", b"folder_id", "instance_group_yaml", b"instance_group_yaml"]) -> None: ...

global___CreateInstanceGroupFromYamlRequest = CreateInstanceGroupFromYamlRequest

@typing.final
class CreateInstanceGroupMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_GROUP_ID_FIELD_NUMBER: builtins.int
    instance_group_id: builtins.str
    """ID of the instance group that is being created."""
    def __init__(
        self,
        *,
        instance_group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_group_id", b"instance_group_id"]) -> None: ...

global___CreateInstanceGroupMetadata = CreateInstanceGroupMetadata

@typing.final
class UpdateInstanceGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    INSTANCE_GROUP_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    INSTANCE_TEMPLATE_FIELD_NUMBER: builtins.int
    SCALE_POLICY_FIELD_NUMBER: builtins.int
    DEPLOY_POLICY_FIELD_NUMBER: builtins.int
    ALLOCATION_POLICY_FIELD_NUMBER: builtins.int
    HEALTH_CHECKS_SPEC_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    LOAD_BALANCER_SPEC_FIELD_NUMBER: builtins.int
    VARIABLES_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    APPLICATION_LOAD_BALANCER_SPEC_FIELD_NUMBER: builtins.int
    AUTO_HEALING_POLICY_FIELD_NUMBER: builtins.int
    instance_group_id: builtins.str
    """ID of the instance group to update.
    To get the instance group ID, use a [InstanceGroupService.List] request.
    """
    name: builtins.str
    """Name of the instance group."""
    description: builtins.str
    """Description of the instance group."""
    service_account_id: builtins.str
    """ID of the service account. The service account will be used for all API calls
    made by the Instance Groups component on behalf of the user (for example, creating instances, adding them to load balancer target group, etc.). For more information, see [Service accounts](/docs/iam/concepts/users/service-accounts).
    To get the service account ID, use a [yandex.cloud.iam.v1.ServiceAccountService.List] request.
    """
    deletion_protection: builtins.bool
    """Flag that inhibits deletion of the instance group"""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which fields of the InstanceGroup resource are going to be updated."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs.

        The existing set of `labels` is completely replaced by the provided set.
        """

    @property
    def instance_template(self) -> yandex.cloud.compute.v1.instancegroup.instance_group_pb2.InstanceTemplate:
        """Instance template that the instance group belongs to."""

    @property
    def scale_policy(self) -> yandex.cloud.compute.v1.instancegroup.instance_group_pb2.ScalePolicy:
        """[Scaling policy](/docs/compute/concepts/instance-groups/scale) of the instance group."""

    @property
    def deploy_policy(self) -> yandex.cloud.compute.v1.instancegroup.instance_group_pb2.DeployPolicy:
        """Deployment policy of the instance group."""

    @property
    def allocation_policy(self) -> yandex.cloud.compute.v1.instancegroup.instance_group_pb2.AllocationPolicy:
        """Allocation policy of the instance group by zones and regions."""

    @property
    def health_checks_spec(self) -> yandex.cloud.compute.v1.instancegroup.instance_group_pb2.HealthChecksSpec:
        """Health checking specification. For more information, see [Health check](/docs/network-load-balancer/concepts/health-check)."""

    @property
    def load_balancer_spec(self) -> yandex.cloud.compute.v1.instancegroup.instance_group_pb2.LoadBalancerSpec:
        """Settings for balancing load between instances via [Network Load Balancer](/docs/network-load-balancer/concepts)
        (OSI model layer 3).
        """

    @property
    def variables(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.compute.v1.instancegroup.instance_group_pb2.Variable]: ...
    @property
    def application_load_balancer_spec(self) -> yandex.cloud.compute.v1.instancegroup.instance_group_pb2.ApplicationLoadBalancerSpec:
        """Settings for balancing load between instances via [Application Load Balancer](/docs/application-load-balancer/concepts)
        (OSI model layer 7).
        """

    @property
    def auto_healing_policy(self) -> yandex.cloud.compute.v1.instancegroup.instance_group_pb2.AutoHealingPolicy:
        """AutoHealingPolicy policy of the instance group."""

    def __init__(
        self,
        *,
        instance_group_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        instance_template: yandex.cloud.compute.v1.instancegroup.instance_group_pb2.InstanceTemplate | None = ...,
        scale_policy: yandex.cloud.compute.v1.instancegroup.instance_group_pb2.ScalePolicy | None = ...,
        deploy_policy: yandex.cloud.compute.v1.instancegroup.instance_group_pb2.DeployPolicy | None = ...,
        allocation_policy: yandex.cloud.compute.v1.instancegroup.instance_group_pb2.AllocationPolicy | None = ...,
        health_checks_spec: yandex.cloud.compute.v1.instancegroup.instance_group_pb2.HealthChecksSpec | None = ...,
        service_account_id: builtins.str = ...,
        load_balancer_spec: yandex.cloud.compute.v1.instancegroup.instance_group_pb2.LoadBalancerSpec | None = ...,
        variables: collections.abc.Iterable[yandex.cloud.compute.v1.instancegroup.instance_group_pb2.Variable] | None = ...,
        deletion_protection: builtins.bool = ...,
        application_load_balancer_spec: yandex.cloud.compute.v1.instancegroup.instance_group_pb2.ApplicationLoadBalancerSpec | None = ...,
        auto_healing_policy: yandex.cloud.compute.v1.instancegroup.instance_group_pb2.AutoHealingPolicy | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["allocation_policy", b"allocation_policy", "application_load_balancer_spec", b"application_load_balancer_spec", "auto_healing_policy", b"auto_healing_policy", "deploy_policy", b"deploy_policy", "health_checks_spec", b"health_checks_spec", "instance_template", b"instance_template", "load_balancer_spec", b"load_balancer_spec", "scale_policy", b"scale_policy", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["allocation_policy", b"allocation_policy", "application_load_balancer_spec", b"application_load_balancer_spec", "auto_healing_policy", b"auto_healing_policy", "deletion_protection", b"deletion_protection", "deploy_policy", b"deploy_policy", "description", b"description", "health_checks_spec", b"health_checks_spec", "instance_group_id", b"instance_group_id", "instance_template", b"instance_template", "labels", b"labels", "load_balancer_spec", b"load_balancer_spec", "name", b"name", "scale_policy", b"scale_policy", "service_account_id", b"service_account_id", "update_mask", b"update_mask", "variables", b"variables"]) -> None: ...

global___UpdateInstanceGroupRequest = UpdateInstanceGroupRequest

@typing.final
class UpdateInstanceGroupFromYamlRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_GROUP_ID_FIELD_NUMBER: builtins.int
    INSTANCE_GROUP_YAML_FIELD_NUMBER: builtins.int
    instance_group_id: builtins.str
    """ID of the instance group to update.
    To get the instance group ID, use a [InstanceGroupService.List] request.
    """
    instance_group_yaml: builtins.str
    """[InstanceGroupService.Update] request in YAML format."""
    def __init__(
        self,
        *,
        instance_group_id: builtins.str = ...,
        instance_group_yaml: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_group_id", b"instance_group_id", "instance_group_yaml", b"instance_group_yaml"]) -> None: ...

global___UpdateInstanceGroupFromYamlRequest = UpdateInstanceGroupFromYamlRequest

@typing.final
class UpdateInstanceGroupMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_GROUP_ID_FIELD_NUMBER: builtins.int
    instance_group_id: builtins.str
    """ID of the InstanceGroup resource that is being updated.
    To get the instance group ID, use a [InstanceGroupService.List] request.
    """
    def __init__(
        self,
        *,
        instance_group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_group_id", b"instance_group_id"]) -> None: ...

global___UpdateInstanceGroupMetadata = UpdateInstanceGroupMetadata

@typing.final
class StartInstanceGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_GROUP_ID_FIELD_NUMBER: builtins.int
    instance_group_id: builtins.str
    """ID of the instance group to start.
    To get the instance group ID, use a [InstanceGroupService.List] request.
    """
    def __init__(
        self,
        *,
        instance_group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_group_id", b"instance_group_id"]) -> None: ...

global___StartInstanceGroupRequest = StartInstanceGroupRequest

@typing.final
class StartInstanceGroupMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_GROUP_ID_FIELD_NUMBER: builtins.int
    instance_group_id: builtins.str
    """ID of the InstanceGroup resource that is being started."""
    def __init__(
        self,
        *,
        instance_group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_group_id", b"instance_group_id"]) -> None: ...

global___StartInstanceGroupMetadata = StartInstanceGroupMetadata

@typing.final
class StopInstanceGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_GROUP_ID_FIELD_NUMBER: builtins.int
    instance_group_id: builtins.str
    """ID of the instance group to stop.
    To get the instance group ID, use a [InstanceGroupService.List] request.
    """
    def __init__(
        self,
        *,
        instance_group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_group_id", b"instance_group_id"]) -> None: ...

global___StopInstanceGroupRequest = StopInstanceGroupRequest

@typing.final
class StopInstanceGroupMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_GROUP_ID_FIELD_NUMBER: builtins.int
    instance_group_id: builtins.str
    """ID of the InstanceGroup resource that is being stopped."""
    def __init__(
        self,
        *,
        instance_group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_group_id", b"instance_group_id"]) -> None: ...

global___StopInstanceGroupMetadata = StopInstanceGroupMetadata

@typing.final
class RollingRestartRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_GROUP_ID_FIELD_NUMBER: builtins.int
    MANAGED_INSTANCE_IDS_FIELD_NUMBER: builtins.int
    instance_group_id: builtins.str
    """ID of the instance group to restart instances in.
    To get the instance group ID, use a [InstanceGroupService.List] request.
    """
    @property
    def managed_instance_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IDs of managed instances in the group to restart
        To get instance IDs, use a [InstanceGroupService.ListInstances] request.
        """

    def __init__(
        self,
        *,
        instance_group_id: builtins.str = ...,
        managed_instance_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_group_id", b"instance_group_id", "managed_instance_ids", b"managed_instance_ids"]) -> None: ...

global___RollingRestartRequest = RollingRestartRequest

@typing.final
class RollingRestartMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_GROUP_ID_FIELD_NUMBER: builtins.int
    instance_group_id: builtins.str
    """ID of the InstanceGroup resource that is being rolling restarted."""
    def __init__(
        self,
        *,
        instance_group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_group_id", b"instance_group_id"]) -> None: ...

global___RollingRestartMetadata = RollingRestartMetadata

@typing.final
class RollingRecreateRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_GROUP_ID_FIELD_NUMBER: builtins.int
    MANAGED_INSTANCE_IDS_FIELD_NUMBER: builtins.int
    instance_group_id: builtins.str
    """ID of the instance group to recreate instances in.
    To get the instance group ID, use a [InstanceGroupService.List] request.
    """
    @property
    def managed_instance_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IDs of managed instances in the group to recreate
        To get instance IDs, use a [InstanceGroupService.ListInstances] request.
        """

    def __init__(
        self,
        *,
        instance_group_id: builtins.str = ...,
        managed_instance_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_group_id", b"instance_group_id", "managed_instance_ids", b"managed_instance_ids"]) -> None: ...

global___RollingRecreateRequest = RollingRecreateRequest

@typing.final
class RollingRecreateMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_GROUP_ID_FIELD_NUMBER: builtins.int
    instance_group_id: builtins.str
    """ID of the InstanceGroup resource that is being rolling recreated."""
    def __init__(
        self,
        *,
        instance_group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_group_id", b"instance_group_id"]) -> None: ...

global___RollingRecreateMetadata = RollingRecreateMetadata

@typing.final
class DeleteInstanceGroupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_GROUP_ID_FIELD_NUMBER: builtins.int
    instance_group_id: builtins.str
    """ID of the instance group to delete.
    To get the instance group ID, use a [InstanceGroupService.List] request.
    """
    def __init__(
        self,
        *,
        instance_group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_group_id", b"instance_group_id"]) -> None: ...

global___DeleteInstanceGroupRequest = DeleteInstanceGroupRequest

@typing.final
class DeleteInstanceGroupMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_GROUP_ID_FIELD_NUMBER: builtins.int
    instance_group_id: builtins.str
    """ID of the instance group that is being deleted.
    To get the instance group ID, use a [InstanceGroupService.List] request.
    """
    def __init__(
        self,
        *,
        instance_group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_group_id", b"instance_group_id"]) -> None: ...

global___DeleteInstanceGroupMetadata = DeleteInstanceGroupMetadata

@typing.final
class DeleteInstancesMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_GROUP_ID_FIELD_NUMBER: builtins.int
    instance_group_id: builtins.str
    """ID of the instance group that the instances are being deleted from."""
    def __init__(
        self,
        *,
        instance_group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_group_id", b"instance_group_id"]) -> None: ...

global___DeleteInstancesMetadata = DeleteInstancesMetadata

@typing.final
class StopInstancesMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_GROUP_ID_FIELD_NUMBER: builtins.int
    instance_group_id: builtins.str
    """ID of the instance group that the instances are being stopped from."""
    def __init__(
        self,
        *,
        instance_group_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_group_id", b"instance_group_id"]) -> None: ...

global___StopInstancesMetadata = StopInstancesMetadata

@typing.final
class ListInstanceGroupsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    VIEW_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to list instance groups in.
    To get the folder ID, use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size],
    the service returns a [ListInstanceGroupsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results,
    set [page_token] to the [ListInstanceGroupsResponse.next_page_token]
    returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response.
    Currently you can use filtering only on the [InstanceGroup.name] field.
    """
    view: global___InstanceGroupView.ValueType
    """Defines which information about the Instance template should be returned in the server response."""
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
        view: global___InstanceGroupView.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "folder_id", b"folder_id", "page_size", b"page_size", "page_token", b"page_token", "view", b"view"]) -> None: ...

global___ListInstanceGroupsRequest = ListInstanceGroupsRequest

@typing.final
class ListInstanceGroupsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_GROUPS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListInstanceGroupsRequest.page_size], use
    [next_page_token] as the value
    for the [ListInstanceGroupsRequest.page_token] query parameter
    in the next list request. Each subsequent list request will have its own
    [next_page_token] to continue paging through the results.
    """
    @property
    def instance_groups(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.compute.v1.instancegroup.instance_group_pb2.InstanceGroup]:
        """Lists instance groups for the specified folder."""

    def __init__(
        self,
        *,
        instance_groups: collections.abc.Iterable[yandex.cloud.compute.v1.instancegroup.instance_group_pb2.InstanceGroup] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_groups", b"instance_groups", "next_page_token", b"next_page_token"]) -> None: ...

global___ListInstanceGroupsResponse = ListInstanceGroupsResponse

@typing.final
class ListInstanceGroupInstancesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_GROUP_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    instance_group_id: builtins.str
    """ID of the InstanceGroup resource to list instances for.
    To get the instance group ID, use a [InstanceGroupService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size],
    the service returns a [ListInstanceGroupInstancesResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results,
    set [page_token] to the [ListInstanceGroupInstancesResponse.next_page_token]
    returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response.
    Currently you can use filtering only on the [ManagedInstance.name] field.
    """
    def __init__(
        self,
        *,
        instance_group_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "instance_group_id", b"instance_group_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListInstanceGroupInstancesRequest = ListInstanceGroupInstancesRequest

@typing.final
class ListInstanceGroupInstancesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is more than [ListInstanceGroupInstancesRequest.page_size], use
    [next_page_token] as the value
    for the [ListInstanceGroupInstancesRequest.page_token] query parameter
    in the next list request. Each subsequent list request will have its own
    [next_page_token] to continue paging through the results.
    """
    @property
    def instances(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.compute.v1.instancegroup.instance_group_pb2.ManagedInstance]:
        """Lists instances for the specified instance group."""

    def __init__(
        self,
        *,
        instances: collections.abc.Iterable[yandex.cloud.compute.v1.instancegroup.instance_group_pb2.ManagedInstance] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instances", b"instances", "next_page_token", b"next_page_token"]) -> None: ...

global___ListInstanceGroupInstancesResponse = ListInstanceGroupInstancesResponse

@typing.final
class DeleteInstancesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_GROUP_ID_FIELD_NUMBER: builtins.int
    MANAGED_INSTANCE_IDS_FIELD_NUMBER: builtins.int
    CREATE_ANOTHER_FIELD_NUMBER: builtins.int
    instance_group_id: builtins.str
    """ID of the instance group that the instances are being deleted from.
    To get the ID of the instance group, use the [InstanceGroupService.List] request.
    """
    create_another: builtins.bool
    """If set to true, the target size of instance group will not be reduced and
    a new instance will be created instead of the deleted one. By default, the target size of instance group
    will be reduced by the specified number of instance IDs.
    """
    @property
    def managed_instance_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IDs of the instances to delete. Instances will be deleted along with all dependent resources.
        Only IDs from the ManagedInstance.id field are allowed, not ManagedInstance.instance_id.
        """

    def __init__(
        self,
        *,
        instance_group_id: builtins.str = ...,
        managed_instance_ids: collections.abc.Iterable[builtins.str] | None = ...,
        create_another: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["create_another", b"create_another", "instance_group_id", b"instance_group_id", "managed_instance_ids", b"managed_instance_ids"]) -> None: ...

global___DeleteInstancesRequest = DeleteInstancesRequest

@typing.final
class StopInstancesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_GROUP_ID_FIELD_NUMBER: builtins.int
    MANAGED_INSTANCE_IDS_FIELD_NUMBER: builtins.int
    instance_group_id: builtins.str
    """ID of the instance group that the instances are being stopped from.
    To get the ID of the instance group, use the [InstanceGroupService.List] request.
    """
    @property
    def managed_instance_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IDs of the instances to stop. After stopping, the instance can be updated, started, or deleted
        according to scale and deploy policies.
        Only IDs from the ManagedInstance.id field are allowed, not ManagedInstance.instance_id.
        """

    def __init__(
        self,
        *,
        instance_group_id: builtins.str = ...,
        managed_instance_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["instance_group_id", b"instance_group_id", "managed_instance_ids", b"managed_instance_ids"]) -> None: ...

global___StopInstancesRequest = StopInstancesRequest

@typing.final
class ListInstanceGroupOperationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_GROUP_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    instance_group_id: builtins.str
    """ID of the InstanceGroup resource to list operations for.
    To get the instance group ID, use a [InstanceGroupService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is more than [page_size], the service returns a [ListInstanceGroupOperationsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the
    [ListInstanceGroupOperationsResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response.
    Currently you can use filtering only on the [InstanceGroup.name] field.
    """
    def __init__(
        self,
        *,
        instance_group_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "instance_group_id", b"instance_group_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListInstanceGroupOperationsRequest = ListInstanceGroupOperationsRequest

@typing.final
class ListInstanceGroupOperationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is more than [ListInstanceGroupOperationsRequest.page_size], use the [next_page_token] as the value
    for the [ListInstanceGroupOperationsRequest.page_token] query parameter in the next list request.
    Each subsequent list request will have its own [next_page_token] to continue paging through the results.
    """
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """Lists operations for the specified instance group."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListInstanceGroupOperationsResponse = ListInstanceGroupOperationsResponse

@typing.final
class ListInstanceGroupLogRecordsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_GROUP_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    instance_group_id: builtins.str
    """ID of the InstanceGroup resource to list logs for.
    To get the instance group ID, use a [InstanceGroupService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size],
    the service returns a [ListInstanceGroupLogRecordsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results,
    set [page_token] to the [ListInstanceGroupLogRecordsResponse.next_page_token]
    returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response.
    Currently you can use filtering only on the [InstanceGroup.name] field.
    """
    def __init__(
        self,
        *,
        instance_group_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "instance_group_id", b"instance_group_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListInstanceGroupLogRecordsRequest = ListInstanceGroupLogRecordsRequest

@typing.final
class ListInstanceGroupLogRecordsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOG_RECORDS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListInstanceGroupLogRecordsRequest.page_size], use
    [next_page_token] as the value
    for the [ListInstanceGroupLogRecordsRequest.page_token] query parameter
    in the next list request. Each subsequent list request will have its own
    [next_page_token] to continue paging through the results.
    """
    @property
    def log_records(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.compute.v1.instancegroup.instance_group_pb2.LogRecord]:
        """Lists logs for the specified instance group."""

    def __init__(
        self,
        *,
        log_records: collections.abc.Iterable[yandex.cloud.compute.v1.instancegroup.instance_group_pb2.LogRecord] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["log_records", b"log_records", "next_page_token", b"next_page_token"]) -> None: ...

global___ListInstanceGroupLogRecordsResponse = ListInstanceGroupLogRecordsResponse
