"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing
import yandex.cloud.compute.v1.hardware_generation_pb2
import yandex.cloud.compute.v1.kek_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Snapshot(google.protobuf.message.Message):
    """A Snapshot resource. For more information, see [Snapshots](/docs/compute/concepts/snapshot)."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Snapshot._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: Snapshot._Status.ValueType  # 0
        CREATING: Snapshot._Status.ValueType  # 1
        """Snapshot is being created."""
        READY: Snapshot._Status.ValueType  # 2
        """Snapshot is ready to use."""
        ERROR: Snapshot._Status.ValueType  # 3
        """Snapshot encountered a problem and cannot operate."""
        DELETING: Snapshot._Status.ValueType  # 4
        """Snapshot is being deleted."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNSPECIFIED: Snapshot.Status.ValueType  # 0
    CREATING: Snapshot.Status.ValueType  # 1
    """Snapshot is being created."""
    READY: Snapshot.Status.ValueType  # 2
    """Snapshot is ready to use."""
    ERROR: Snapshot.Status.ValueType  # 3
    """Snapshot encountered a problem and cannot operate."""
    DELETING: Snapshot.Status.ValueType  # 4
    """Snapshot is being deleted."""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    STORAGE_SIZE_FIELD_NUMBER: builtins.int
    DISK_SIZE_FIELD_NUMBER: builtins.int
    PRODUCT_IDS_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    SOURCE_DISK_ID_FIELD_NUMBER: builtins.int
    HARDWARE_GENERATION_FIELD_NUMBER: builtins.int
    KMS_KEY_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the snapshot."""
    folder_id: builtins.str
    """ID of the folder that the snapshot belongs to."""
    name: builtins.str
    """Name of the snapshot. 1-63 characters long."""
    description: builtins.str
    """Description of the snapshot. 0-256 characters long."""
    storage_size: builtins.int
    """Size of the snapshot, specified in bytes.
    delta from prev snapshot from same disk
    """
    disk_size: builtins.int
    """Size of the disk when the snapshot was created, specified in bytes.
    at snapshot moment
    """
    status: global___Snapshot.Status.ValueType
    """Current status of the snapshot."""
    source_disk_id: builtins.str
    """ID of the source disk used to create this snapshot."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs. Maximum of 64 per resource."""

    @property
    def product_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """License IDs that indicate which licenses are attached to this resource.
        License IDs are used to calculate additional charges for the use of the virtual machine.

        The correct license ID is generated by the platform. IDs are inherited by new resources created from this resource.

        If you know the license IDs, specify them when you create the image.
        For example, if you create a disk image using a third-party utility and load it into Object Storage, the license IDs will be lost.
        You can specify them in the [yandex.cloud.compute.v1.ImageService.Create] request.
        """

    @property
    def hardware_generation(self) -> yandex.cloud.compute.v1.hardware_generation_pb2.HardwareGeneration:
        """If specified, forces the same HardwareGeneration features to be applied to the instance
        created using this snapshot as source for the boot disk. Otherwise the current default will be used.
        """

    @property
    def kms_key(self) -> yandex.cloud.compute.v1.kek_pb2.KMSKey:
        """Key encryption key info."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        storage_size: builtins.int = ...,
        disk_size: builtins.int = ...,
        product_ids: collections.abc.Iterable[builtins.str] | None = ...,
        status: global___Snapshot.Status.ValueType = ...,
        source_disk_id: builtins.str = ...,
        hardware_generation: yandex.cloud.compute.v1.hardware_generation_pb2.HardwareGeneration | None = ...,
        kms_key: yandex.cloud.compute.v1.kek_pb2.KMSKey | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "hardware_generation", b"hardware_generation", "kms_key", b"kms_key"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["created_at", b"created_at", "description", b"description", "disk_size", b"disk_size", "folder_id", b"folder_id", "hardware_generation", b"hardware_generation", "id", b"id", "kms_key", b"kms_key", "labels", b"labels", "name", b"name", "product_ids", b"product_ids", "source_disk_id", b"source_disk_id", "status", b"status", "storage_size", b"storage_size"]) -> None: ...

global___Snapshot = Snapshot
