"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import abc
import collections.abc
import grpc
import grpc.aio
import typing
import yandex.cloud.access.access_pb2
import yandex.cloud.compute.v1.snapshot_schedule_pb2
import yandex.cloud.compute.v1.snapshot_schedule_service_pb2
import yandex.cloud.operation.operation_pb2

_T = typing.TypeVar("_T")

class _MaybeAsyncIterator(collections.abc.AsyncIterator[_T], collections.abc.Iterator[_T], metaclass=abc.ABCMeta): ...

class _ServicerContext(grpc.ServicerContext, grpc.aio.ServicerContext):  # type: ignore[misc, type-arg]
    ...

class SnapshotScheduleServiceStub:
    """A set of methods for managing snapshot schedules."""

    def __init__(self, channel: typing.Union[grpc.Channel, grpc.aio.Channel]) -> None: ...
    Get: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.snapshot_schedule_service_pb2.GetSnapshotScheduleRequest,
        yandex.cloud.compute.v1.snapshot_schedule_pb2.SnapshotSchedule,
    ]
    """Returns the specified snapshot schedule.

    To get the list of available snapshot schedules, make a [List] request.
    """

    List: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.snapshot_schedule_service_pb2.ListSnapshotSchedulesRequest,
        yandex.cloud.compute.v1.snapshot_schedule_service_pb2.ListSnapshotSchedulesResponse,
    ]
    """Retrieves the list of snapshot schedules in the specified folder."""

    Create: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.snapshot_schedule_service_pb2.CreateSnapshotScheduleRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates a snapshot schedule in the specified folder."""

    Update: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.snapshot_schedule_service_pb2.UpdateSnapshotScheduleRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates the specified snapshot schedule.

    The schedule is updated only after all snapshot creations and deletions triggered by the schedule are completed.
    """

    Delete: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.snapshot_schedule_service_pb2.DeleteSnapshotScheduleRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes the specified snapshot schedule.

    Deleting a snapshot schedule removes its data permanently and is irreversible. However, deleting a schedule
    does not delete any snapshots created by the schedule. You must delete snapshots separately.

    The schedule is deleted only after all snapshot creations and deletions triggered by the schedule are completed.
    """

    UpdateDisks: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.snapshot_schedule_service_pb2.UpdateSnapshotScheduleDisksRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates the list of disks attached to the specified schedule.

    The schedule is updated only after all snapshot creations and deletions triggered by the schedule are completed.
    """

    Disable: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.snapshot_schedule_service_pb2.DisableSnapshotScheduleRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Disables the specified snapshot schedule.

    The [SnapshotSchedule.status] is changed to `INACTIVE`: the schedule is interrupted, snapshots won't be created
    or deleted.

    The schedule is disabled only after all snapshot creations and deletions triggered by the schedule are completed.
    """

    Enable: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.snapshot_schedule_service_pb2.EnableSnapshotScheduleRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Enables the specified snapshot schedule.

    The [SnapshotSchedule.status] is changed to `ACTIVE`: new disk snapshots will be created, old ones deleted
    (if [SnapshotSchedule.retention_policy] is specified).
    """

    ListOperations: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.snapshot_schedule_service_pb2.ListSnapshotScheduleOperationsRequest,
        yandex.cloud.compute.v1.snapshot_schedule_service_pb2.ListSnapshotScheduleOperationsResponse,
    ]
    """Lists operations for the specified snapshot schedule."""

    ListSnapshots: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.snapshot_schedule_service_pb2.ListSnapshotScheduleSnapshotsRequest,
        yandex.cloud.compute.v1.snapshot_schedule_service_pb2.ListSnapshotScheduleSnapshotsResponse,
    ]
    """Retrieves the list of snapshots created by the specified snapshot schedule."""

    ListDisks: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.snapshot_schedule_service_pb2.ListSnapshotScheduleDisksRequest,
        yandex.cloud.compute.v1.snapshot_schedule_service_pb2.ListSnapshotScheduleDisksResponse,
    ]
    """Retrieves the list of disks attached to the specified snapshot schedule."""

    ListAccessBindings: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.access.access_pb2.ListAccessBindingsRequest,
        yandex.cloud.access.access_pb2.ListAccessBindingsResponse,
    ]
    """access

    Lists access bindings for the snapshot schedule.
    """

    SetAccessBindings: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.access.access_pb2.SetAccessBindingsRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Sets access bindings for the snapshot schedule."""

    UpdateAccessBindings: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.access.access_pb2.UpdateAccessBindingsRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates access bindings for the snapshot schedule."""

class SnapshotScheduleServiceAsyncStub:
    """A set of methods for managing snapshot schedules."""

    Get: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.snapshot_schedule_service_pb2.GetSnapshotScheduleRequest,
        yandex.cloud.compute.v1.snapshot_schedule_pb2.SnapshotSchedule,
    ]
    """Returns the specified snapshot schedule.

    To get the list of available snapshot schedules, make a [List] request.
    """

    List: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.snapshot_schedule_service_pb2.ListSnapshotSchedulesRequest,
        yandex.cloud.compute.v1.snapshot_schedule_service_pb2.ListSnapshotSchedulesResponse,
    ]
    """Retrieves the list of snapshot schedules in the specified folder."""

    Create: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.snapshot_schedule_service_pb2.CreateSnapshotScheduleRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Creates a snapshot schedule in the specified folder."""

    Update: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.snapshot_schedule_service_pb2.UpdateSnapshotScheduleRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates the specified snapshot schedule.

    The schedule is updated only after all snapshot creations and deletions triggered by the schedule are completed.
    """

    Delete: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.snapshot_schedule_service_pb2.DeleteSnapshotScheduleRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes the specified snapshot schedule.

    Deleting a snapshot schedule removes its data permanently and is irreversible. However, deleting a schedule
    does not delete any snapshots created by the schedule. You must delete snapshots separately.

    The schedule is deleted only after all snapshot creations and deletions triggered by the schedule are completed.
    """

    UpdateDisks: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.snapshot_schedule_service_pb2.UpdateSnapshotScheduleDisksRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates the list of disks attached to the specified schedule.

    The schedule is updated only after all snapshot creations and deletions triggered by the schedule are completed.
    """

    Disable: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.snapshot_schedule_service_pb2.DisableSnapshotScheduleRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Disables the specified snapshot schedule.

    The [SnapshotSchedule.status] is changed to `INACTIVE`: the schedule is interrupted, snapshots won't be created
    or deleted.

    The schedule is disabled only after all snapshot creations and deletions triggered by the schedule are completed.
    """

    Enable: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.snapshot_schedule_service_pb2.EnableSnapshotScheduleRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Enables the specified snapshot schedule.

    The [SnapshotSchedule.status] is changed to `ACTIVE`: new disk snapshots will be created, old ones deleted
    (if [SnapshotSchedule.retention_policy] is specified).
    """

    ListOperations: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.snapshot_schedule_service_pb2.ListSnapshotScheduleOperationsRequest,
        yandex.cloud.compute.v1.snapshot_schedule_service_pb2.ListSnapshotScheduleOperationsResponse,
    ]
    """Lists operations for the specified snapshot schedule."""

    ListSnapshots: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.snapshot_schedule_service_pb2.ListSnapshotScheduleSnapshotsRequest,
        yandex.cloud.compute.v1.snapshot_schedule_service_pb2.ListSnapshotScheduleSnapshotsResponse,
    ]
    """Retrieves the list of snapshots created by the specified snapshot schedule."""

    ListDisks: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.compute.v1.snapshot_schedule_service_pb2.ListSnapshotScheduleDisksRequest,
        yandex.cloud.compute.v1.snapshot_schedule_service_pb2.ListSnapshotScheduleDisksResponse,
    ]
    """Retrieves the list of disks attached to the specified snapshot schedule."""

    ListAccessBindings: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.access.access_pb2.ListAccessBindingsRequest,
        yandex.cloud.access.access_pb2.ListAccessBindingsResponse,
    ]
    """access

    Lists access bindings for the snapshot schedule.
    """

    SetAccessBindings: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.access.access_pb2.SetAccessBindingsRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Sets access bindings for the snapshot schedule."""

    UpdateAccessBindings: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.access.access_pb2.UpdateAccessBindingsRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates access bindings for the snapshot schedule."""

class SnapshotScheduleServiceServicer(metaclass=abc.ABCMeta):
    """A set of methods for managing snapshot schedules."""

    @abc.abstractmethod
    def Get(
        self,
        request: yandex.cloud.compute.v1.snapshot_schedule_service_pb2.GetSnapshotScheduleRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.compute.v1.snapshot_schedule_pb2.SnapshotSchedule, collections.abc.Awaitable[yandex.cloud.compute.v1.snapshot_schedule_pb2.SnapshotSchedule]]:
        """Returns the specified snapshot schedule.

        To get the list of available snapshot schedules, make a [List] request.
        """

    @abc.abstractmethod
    def List(
        self,
        request: yandex.cloud.compute.v1.snapshot_schedule_service_pb2.ListSnapshotSchedulesRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.compute.v1.snapshot_schedule_service_pb2.ListSnapshotSchedulesResponse, collections.abc.Awaitable[yandex.cloud.compute.v1.snapshot_schedule_service_pb2.ListSnapshotSchedulesResponse]]:
        """Retrieves the list of snapshot schedules in the specified folder."""

    @abc.abstractmethod
    def Create(
        self,
        request: yandex.cloud.compute.v1.snapshot_schedule_service_pb2.CreateSnapshotScheduleRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Creates a snapshot schedule in the specified folder."""

    @abc.abstractmethod
    def Update(
        self,
        request: yandex.cloud.compute.v1.snapshot_schedule_service_pb2.UpdateSnapshotScheduleRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Updates the specified snapshot schedule.

        The schedule is updated only after all snapshot creations and deletions triggered by the schedule are completed.
        """

    @abc.abstractmethod
    def Delete(
        self,
        request: yandex.cloud.compute.v1.snapshot_schedule_service_pb2.DeleteSnapshotScheduleRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Deletes the specified snapshot schedule.

        Deleting a snapshot schedule removes its data permanently and is irreversible. However, deleting a schedule
        does not delete any snapshots created by the schedule. You must delete snapshots separately.

        The schedule is deleted only after all snapshot creations and deletions triggered by the schedule are completed.
        """

    @abc.abstractmethod
    def UpdateDisks(
        self,
        request: yandex.cloud.compute.v1.snapshot_schedule_service_pb2.UpdateSnapshotScheduleDisksRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Updates the list of disks attached to the specified schedule.

        The schedule is updated only after all snapshot creations and deletions triggered by the schedule are completed.
        """

    @abc.abstractmethod
    def Disable(
        self,
        request: yandex.cloud.compute.v1.snapshot_schedule_service_pb2.DisableSnapshotScheduleRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Disables the specified snapshot schedule.

        The [SnapshotSchedule.status] is changed to `INACTIVE`: the schedule is interrupted, snapshots won't be created
        or deleted.

        The schedule is disabled only after all snapshot creations and deletions triggered by the schedule are completed.
        """

    @abc.abstractmethod
    def Enable(
        self,
        request: yandex.cloud.compute.v1.snapshot_schedule_service_pb2.EnableSnapshotScheduleRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Enables the specified snapshot schedule.

        The [SnapshotSchedule.status] is changed to `ACTIVE`: new disk snapshots will be created, old ones deleted
        (if [SnapshotSchedule.retention_policy] is specified).
        """

    @abc.abstractmethod
    def ListOperations(
        self,
        request: yandex.cloud.compute.v1.snapshot_schedule_service_pb2.ListSnapshotScheduleOperationsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.compute.v1.snapshot_schedule_service_pb2.ListSnapshotScheduleOperationsResponse, collections.abc.Awaitable[yandex.cloud.compute.v1.snapshot_schedule_service_pb2.ListSnapshotScheduleOperationsResponse]]:
        """Lists operations for the specified snapshot schedule."""

    @abc.abstractmethod
    def ListSnapshots(
        self,
        request: yandex.cloud.compute.v1.snapshot_schedule_service_pb2.ListSnapshotScheduleSnapshotsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.compute.v1.snapshot_schedule_service_pb2.ListSnapshotScheduleSnapshotsResponse, collections.abc.Awaitable[yandex.cloud.compute.v1.snapshot_schedule_service_pb2.ListSnapshotScheduleSnapshotsResponse]]:
        """Retrieves the list of snapshots created by the specified snapshot schedule."""

    @abc.abstractmethod
    def ListDisks(
        self,
        request: yandex.cloud.compute.v1.snapshot_schedule_service_pb2.ListSnapshotScheduleDisksRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.compute.v1.snapshot_schedule_service_pb2.ListSnapshotScheduleDisksResponse, collections.abc.Awaitable[yandex.cloud.compute.v1.snapshot_schedule_service_pb2.ListSnapshotScheduleDisksResponse]]:
        """Retrieves the list of disks attached to the specified snapshot schedule."""

    @abc.abstractmethod
    def ListAccessBindings(
        self,
        request: yandex.cloud.access.access_pb2.ListAccessBindingsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.access.access_pb2.ListAccessBindingsResponse, collections.abc.Awaitable[yandex.cloud.access.access_pb2.ListAccessBindingsResponse]]:
        """access

        Lists access bindings for the snapshot schedule.
        """

    @abc.abstractmethod
    def SetAccessBindings(
        self,
        request: yandex.cloud.access.access_pb2.SetAccessBindingsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Sets access bindings for the snapshot schedule."""

    @abc.abstractmethod
    def UpdateAccessBindings(
        self,
        request: yandex.cloud.access.access_pb2.UpdateAccessBindingsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Updates access bindings for the snapshot schedule."""

def add_SnapshotScheduleServiceServicer_to_server(servicer: SnapshotScheduleServiceServicer, server: typing.Union[grpc.Server, grpc.aio.Server]) -> None: ...
