"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.containerregistry.v1.image_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class ListImagesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REGISTRY_ID_FIELD_NUMBER: builtins.int
    REPOSITORY_NAME_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    registry_id: builtins.str
    """ID of the registry to list Docker images in.

    [registry_id] is ignored if a [ListImagesRequest.repository_name] is specified in the request.

    To get the registry ID use a [RegistryService.List] request.
    """
    repository_name: builtins.str
    """Name of the repository to list Docker images in.

    To get the repository name use a [RepositoryService.List] request.
    """
    folder_id: builtins.str
    """ID of the folder to list Docker images in.

    [folder_id] is ignored if a [ListImagesRequest.repository_name] or a [ListImagesRequest.registry_id] are specified in the request.

    To get the folder ID use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size],
    the service returns a [ListImagesResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the
    [ListImagesResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response.
    The expression must specify:
    1. The field name. Currently you can use filtering only on [Image.name] field.
    2. An `=` operator.
    3. The value in double quotes (`"`). Must be a maximum of 256 characters long and match the regular expression `[a-z0-9]+(?:[._-][a-z0-9]+)*(/([a-z0-9]+(?:[._-][a-z0-9]+)*))`.
    """
    order_by: builtins.str
    def __init__(
        self,
        *,
        registry_id: builtins.str = ...,
        repository_name: builtins.str = ...,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
        order_by: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "folder_id", b"folder_id", "order_by", b"order_by", "page_size", b"page_size", "page_token", b"page_token", "registry_id", b"registry_id", "repository_name", b"repository_name"]) -> None: ...

global___ListImagesRequest = ListImagesRequest

@typing.final
class ListImagesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IMAGES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests. If the number of results
    is larger than [ListImagesRequest.page_size], use
    the [next_page_token] as the value
    for the [ListImagesRequest.page_token] query parameter
    in the next list request. Each subsequent list request will have its own
    [next_page_token] to continue paging through the results.
    """
    @property
    def images(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.containerregistry.v1.image_pb2.Image]:
        """List of Image resources."""

    def __init__(
        self,
        *,
        images: collections.abc.Iterable[yandex.cloud.containerregistry.v1.image_pb2.Image] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["images", b"images", "next_page_token", b"next_page_token"]) -> None: ...

global___ListImagesResponse = ListImagesResponse

@typing.final
class GetImageRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IMAGE_ID_FIELD_NUMBER: builtins.int
    image_id: builtins.str
    """ID of the Docker image resource to return.

    To get the Docker image ID use a [ImageService.List] request.
    """
    def __init__(
        self,
        *,
        image_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["image_id", b"image_id"]) -> None: ...

global___GetImageRequest = GetImageRequest

@typing.final
class DeleteImageRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IMAGE_ID_FIELD_NUMBER: builtins.int
    image_id: builtins.str
    """ID of the Docker image to delete.

    To get Docker image ID use a [ImageService.List] request.
    """
    def __init__(
        self,
        *,
        image_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["image_id", b"image_id"]) -> None: ...

global___DeleteImageRequest = DeleteImageRequest

@typing.final
class DeleteImageMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IMAGE_ID_FIELD_NUMBER: builtins.int
    image_id: builtins.str
    """ID of the Docker image that is being deleted."""
    def __init__(
        self,
        *,
        image_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["image_id", b"image_id"]) -> None: ...

global___DeleteImageMetadata = DeleteImageMetadata
