"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class LifecyclePolicy(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[LifecyclePolicy._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: LifecyclePolicy._Status.ValueType  # 0
        ACTIVE: LifecyclePolicy._Status.ValueType  # 1
        """Policy is active and regularly deletes Docker images according to the established rules."""
        DISABLED: LifecyclePolicy._Status.ValueType  # 2
        """Policy is disabled and does not delete Docker images in the repository.
        Policies in this status can be used for preparing and testing rules.
        """

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNSPECIFIED: LifecyclePolicy.Status.ValueType  # 0
    ACTIVE: LifecyclePolicy.Status.ValueType  # 1
    """Policy is active and regularly deletes Docker images according to the established rules."""
    DISABLED: LifecyclePolicy.Status.ValueType  # 2
    """Policy is disabled and does not delete Docker images in the repository.
    Policies in this status can be used for preparing and testing rules.
    """

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    REPOSITORY_ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    RULES_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the lifecycle policy."""
    name: builtins.str
    """Name of the lifecycle policy."""
    repository_id: builtins.str
    """ID of the repository that the lifecycle policy belongs to.
    Required. The maximum string length in characters is 50.
    """
    description: builtins.str
    """Description of the lifecycle policy.
    The maximum string length in characters is 256.
    """
    status: global___LifecyclePolicy.Status.ValueType
    """Status of lifecycle policy."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp."""

    @property
    def rules(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___LifecycleRule]:
        """The rules of lifecycle policy."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        repository_id: builtins.str = ...,
        description: builtins.str = ...,
        status: global___LifecyclePolicy.Status.ValueType = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        rules: collections.abc.Iterable[global___LifecycleRule] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["created_at", b"created_at", "description", b"description", "id", b"id", "name", b"name", "repository_id", b"repository_id", "rules", b"rules", "status", b"status"]) -> None: ...

global___LifecyclePolicy = LifecyclePolicy

@typing.final
class LifecycleRule(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DESCRIPTION_FIELD_NUMBER: builtins.int
    EXPIRE_PERIOD_FIELD_NUMBER: builtins.int
    TAG_REGEXP_FIELD_NUMBER: builtins.int
    UNTAGGED_FIELD_NUMBER: builtins.int
    RETAINED_TOP_FIELD_NUMBER: builtins.int
    description: builtins.str
    """Description of the lifecycle policy rule."""
    tag_regexp: builtins.str
    """Tag for specifying a filter in the form of a regular expression."""
    untagged: builtins.bool
    """Tag for applying the rule to Docker images without tags."""
    retained_top: builtins.int
    """Number of Docker images (falling under the specified filter by tags) that must be left, even if the expire_period has already expired."""
    @property
    def expire_period(self) -> google.protobuf.duration_pb2.Duration:
        """Period of time for automatic deletion.
        Period must be a multiple of 24 hours.
        """

    def __init__(
        self,
        *,
        description: builtins.str = ...,
        expire_period: google.protobuf.duration_pb2.Duration | None = ...,
        tag_regexp: builtins.str = ...,
        untagged: builtins.bool = ...,
        retained_top: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["expire_period", b"expire_period"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "expire_period", b"expire_period", "retained_top", b"retained_top", "tag_regexp", b"tag_regexp", "untagged", b"untagged"]) -> None: ...

global___LifecycleRule = LifecycleRule
