"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing
import yandex.cloud.dataproc.v1.common_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Cluster(google.protobuf.message.Message):
    """A Yandex Data Processing cluster. For details about the concept, see [documentation](/docs/data-proc/concepts/)."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Cluster._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNKNOWN: Cluster._Status.ValueType  # 0
        """Cluster state is unknown."""
        CREATING: Cluster._Status.ValueType  # 1
        """Cluster is being created."""
        RUNNING: Cluster._Status.ValueType  # 2
        """Cluster is running normally."""
        ERROR: Cluster._Status.ValueType  # 3
        """Cluster encountered a problem and cannot operate."""
        STOPPING: Cluster._Status.ValueType  # 4
        """Cluster is stopping."""
        STOPPED: Cluster._Status.ValueType  # 5
        """Cluster stopped."""
        STARTING: Cluster._Status.ValueType  # 6
        """Cluster is starting."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNKNOWN: Cluster.Status.ValueType  # 0
    """Cluster state is unknown."""
    CREATING: Cluster.Status.ValueType  # 1
    """Cluster is being created."""
    RUNNING: Cluster.Status.ValueType  # 2
    """Cluster is running normally."""
    ERROR: Cluster.Status.ValueType  # 3
    """Cluster encountered a problem and cannot operate."""
    STOPPING: Cluster.Status.ValueType  # 4
    """Cluster is stopping."""
    STOPPED: Cluster.Status.ValueType  # 5
    """Cluster stopped."""
    STARTING: Cluster.Status.ValueType  # 6
    """Cluster is starting."""

    class _Environment:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _EnvironmentEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Cluster._Environment.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        ENVIRONMENT_UNSPECIFIED: Cluster._Environment.ValueType  # 0
        PRODUCTION: Cluster._Environment.ValueType  # 1
        PRESTABLE: Cluster._Environment.ValueType  # 2

    class Environment(_Environment, metaclass=_EnvironmentEnumTypeWrapper): ...
    ENVIRONMENT_UNSPECIFIED: Cluster.Environment.ValueType  # 0
    PRODUCTION: Cluster.Environment.ValueType  # 1
    PRESTABLE: Cluster.Environment.ValueType  # 2

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    MONITORING_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    HEALTH_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    ZONE_ID_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    BUCKET_FIELD_NUMBER: builtins.int
    UI_PROXY_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    HOST_GROUP_IDS_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    LOG_GROUP_ID_FIELD_NUMBER: builtins.int
    ENVIRONMENT_FIELD_NUMBER: builtins.int
    AUTOSCALING_SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the cluster. Generated at creation time."""
    folder_id: builtins.str
    """ID of the folder that the cluster belongs to."""
    name: builtins.str
    """Name of the cluster. The name is unique within the folder."""
    description: builtins.str
    """Description of the cluster."""
    health: yandex.cloud.dataproc.v1.common_pb2.Health.ValueType
    """Aggregated cluster health."""
    status: global___Cluster.Status.ValueType
    """Cluster status."""
    zone_id: builtins.str
    """ID of the availability zone where the cluster resides."""
    service_account_id: builtins.str
    """ID of service account for the Yandex Data Processing manager agent."""
    bucket: builtins.str
    """Object Storage bucket to be used for Yandex Data Processing jobs that are run in the cluster."""
    ui_proxy: builtins.bool
    """Whether UI Proxy feature is enabled."""
    deletion_protection: builtins.bool
    """Deletion Protection inhibits deletion of the cluster"""
    log_group_id: builtins.str
    """ID of the cloud logging log group to write logs. If not set, default log group for the folder will be used.
    To prevent logs from being sent to the cloud set cluster property dataproc:disable_cloud_logging = true
    """
    environment: global___Cluster.Environment.ValueType
    """Environment of the cluster"""
    autoscaling_service_account_id: builtins.str
    """ID of service account for working with the Instance Groups service."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Cluster labels as `key:value` pairs."""

    @property
    def monitoring(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Monitoring]:
        """Monitoring systems relevant to the cluster."""

    @property
    def config(self) -> global___ClusterConfig:
        """Configuration of the cluster."""

    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """User security groups."""

    @property
    def host_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Host groups hosting VMs of the cluster."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        monitoring: collections.abc.Iterable[global___Monitoring] | None = ...,
        config: global___ClusterConfig | None = ...,
        health: yandex.cloud.dataproc.v1.common_pb2.Health.ValueType = ...,
        status: global___Cluster.Status.ValueType = ...,
        zone_id: builtins.str = ...,
        service_account_id: builtins.str = ...,
        bucket: builtins.str = ...,
        ui_proxy: builtins.bool = ...,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        host_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        deletion_protection: builtins.bool = ...,
        log_group_id: builtins.str = ...,
        environment: global___Cluster.Environment.ValueType = ...,
        autoscaling_service_account_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["config", b"config", "created_at", b"created_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["autoscaling_service_account_id", b"autoscaling_service_account_id", "bucket", b"bucket", "config", b"config", "created_at", b"created_at", "deletion_protection", b"deletion_protection", "description", b"description", "environment", b"environment", "folder_id", b"folder_id", "health", b"health", "host_group_ids", b"host_group_ids", "id", b"id", "labels", b"labels", "log_group_id", b"log_group_id", "monitoring", b"monitoring", "name", b"name", "security_group_ids", b"security_group_ids", "service_account_id", b"service_account_id", "status", b"status", "ui_proxy", b"ui_proxy", "zone_id", b"zone_id"]) -> None: ...

global___Cluster = Cluster

@typing.final
class Monitoring(google.protobuf.message.Message):
    """Metadata of a monitoring system for a Yandex Data Processing cluster."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LINK_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the monitoring system."""
    description: builtins.str
    """Description of the monitoring system."""
    link: builtins.str
    """Link to the monitoring system."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: builtins.str = ...,
        link: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "link", b"link", "name", b"name"]) -> None: ...

global___Monitoring = Monitoring

@typing.final
class HadoopConfig(google.protobuf.message.Message):
    """Hadoop configuration that describes services installed in a cluster,
    their properties and settings.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Service:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ServiceEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[HadoopConfig._Service.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SERVICE_UNSPECIFIED: HadoopConfig._Service.ValueType  # 0
        HDFS: HadoopConfig._Service.ValueType  # 1
        YARN: HadoopConfig._Service.ValueType  # 2
        MAPREDUCE: HadoopConfig._Service.ValueType  # 3
        HIVE: HadoopConfig._Service.ValueType  # 4
        TEZ: HadoopConfig._Service.ValueType  # 5
        ZOOKEEPER: HadoopConfig._Service.ValueType  # 6
        HBASE: HadoopConfig._Service.ValueType  # 7
        SQOOP: HadoopConfig._Service.ValueType  # 8
        FLUME: HadoopConfig._Service.ValueType  # 9
        SPARK: HadoopConfig._Service.ValueType  # 10
        ZEPPELIN: HadoopConfig._Service.ValueType  # 11
        OOZIE: HadoopConfig._Service.ValueType  # 12
        LIVY: HadoopConfig._Service.ValueType  # 13

    class Service(_Service, metaclass=_ServiceEnumTypeWrapper): ...
    SERVICE_UNSPECIFIED: HadoopConfig.Service.ValueType  # 0
    HDFS: HadoopConfig.Service.ValueType  # 1
    YARN: HadoopConfig.Service.ValueType  # 2
    MAPREDUCE: HadoopConfig.Service.ValueType  # 3
    HIVE: HadoopConfig.Service.ValueType  # 4
    TEZ: HadoopConfig.Service.ValueType  # 5
    ZOOKEEPER: HadoopConfig.Service.ValueType  # 6
    HBASE: HadoopConfig.Service.ValueType  # 7
    SQOOP: HadoopConfig.Service.ValueType  # 8
    FLUME: HadoopConfig.Service.ValueType  # 9
    SPARK: HadoopConfig.Service.ValueType  # 10
    ZEPPELIN: HadoopConfig.Service.ValueType  # 11
    OOZIE: HadoopConfig.Service.ValueType  # 12
    LIVY: HadoopConfig.Service.ValueType  # 13

    @typing.final
    class PropertiesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    SERVICES_FIELD_NUMBER: builtins.int
    PROPERTIES_FIELD_NUMBER: builtins.int
    SSH_PUBLIC_KEYS_FIELD_NUMBER: builtins.int
    INITIALIZATION_ACTIONS_FIELD_NUMBER: builtins.int
    OSLOGIN_ENABLED_FIELD_NUMBER: builtins.int
    oslogin_enabled: builtins.bool
    """Oslogin enable on cluster nodes"""
    @property
    def services(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___HadoopConfig.Service.ValueType]:
        """Set of services used in the cluster (if empty, the default set is used)."""

    @property
    def properties(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Properties set for all hosts in `*-site.xml` configurations. The key should indicate
        the service and the property.

        For example, use the key 'hdfs:dfs.replication' to set the `dfs.replication` property
        in the file `/etc/hadoop/conf/hdfs-site.xml`.
        """

    @property
    def ssh_public_keys(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of public SSH keys to access to cluster hosts."""

    @property
    def initialization_actions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___InitializationAction]:
        """Set of init-actions"""

    def __init__(
        self,
        *,
        services: collections.abc.Iterable[global___HadoopConfig.Service.ValueType] | None = ...,
        properties: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        ssh_public_keys: collections.abc.Iterable[builtins.str] | None = ...,
        initialization_actions: collections.abc.Iterable[global___InitializationAction] | None = ...,
        oslogin_enabled: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["initialization_actions", b"initialization_actions", "oslogin_enabled", b"oslogin_enabled", "properties", b"properties", "services", b"services", "ssh_public_keys", b"ssh_public_keys"]) -> None: ...

global___HadoopConfig = HadoopConfig

@typing.final
class ClusterConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VERSION_ID_FIELD_NUMBER: builtins.int
    HADOOP_FIELD_NUMBER: builtins.int
    version_id: builtins.str
    """Image version for cluster provisioning.
    All available versions are listed in the [documentation](/docs/data-proc/concepts/environment).
    """
    @property
    def hadoop(self) -> global___HadoopConfig:
        """Yandex Data Processing specific configuration options."""

    def __init__(
        self,
        *,
        version_id: builtins.str = ...,
        hadoop: global___HadoopConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["hadoop", b"hadoop"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["hadoop", b"hadoop", "version_id", b"version_id"]) -> None: ...

global___ClusterConfig = ClusterConfig

@typing.final
class InitializationAction(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    URI_FIELD_NUMBER: builtins.int
    ARGS_FIELD_NUMBER: builtins.int
    TIMEOUT_FIELD_NUMBER: builtins.int
    uri: builtins.str
    """URI of the executable file"""
    timeout: builtins.int
    """Execution timeout"""
    @property
    def args(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Arguments to the initialization action"""

    def __init__(
        self,
        *,
        uri: builtins.str = ...,
        args: collections.abc.Iterable[builtins.str] | None = ...,
        timeout: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["args", b"args", "timeout", b"timeout", "uri", b"uri"]) -> None: ...

global___InitializationAction = InitializationAction
