"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.dataproc.v1.cluster_pb2
import yandex.cloud.dataproc.v1.common_pb2
import yandex.cloud.dataproc.v1.subcluster_pb2
import yandex.cloud.operation.operation_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Yandex Data Processing cluster.

    To get a cluster ID make a [ClusterService.List] request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___GetClusterRequest = GetClusterRequest

@typing.final
class ListClustersRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to list clusters in.

    To get the folder ID make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size], the service returns a [ListClustersResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `page_token` to the
    [ListClustersResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters clusters listed in the response.

    The expression must specify:
    1. The field name. Currently you can use filtering only on [Cluster.name] field.
    2. An `=` operator.
    3. The value in double quotes (`"`). Must be 3-63 characters long and match the regular expression `[a-z][-a-z0-9]{1,61}[a-z0-9]`.
    Example of a filter: `name=my-cluster`.
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "folder_id", b"folder_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListClustersRequest = ListClustersRequest

@typing.final
class ListClustersResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTERS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListClustersRequest.page_size], use `next_page_token` as the value
    for the [ListClustersRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def clusters(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.dataproc.v1.cluster_pb2.Cluster]:
        """List of clusters in the specified folder."""

    def __init__(
        self,
        *,
        clusters: collections.abc.Iterable[yandex.cloud.dataproc.v1.cluster_pb2.Cluster] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["clusters", b"clusters", "next_page_token", b"next_page_token"]) -> None: ...

global___ListClustersResponse = ListClustersResponse

@typing.final
class CreateSubclusterConfigSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    ROLE_FIELD_NUMBER: builtins.int
    RESOURCES_FIELD_NUMBER: builtins.int
    SUBNET_ID_FIELD_NUMBER: builtins.int
    HOSTS_COUNT_FIELD_NUMBER: builtins.int
    ASSIGN_PUBLIC_IP_FIELD_NUMBER: builtins.int
    AUTOSCALING_CONFIG_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the subcluster."""
    role: yandex.cloud.dataproc.v1.subcluster_pb2.Role.ValueType
    """Role of the subcluster in the Yandex Data Processing cluster."""
    subnet_id: builtins.str
    """ID of the VPC subnet used for hosts in the subcluster."""
    hosts_count: builtins.int
    """Number of hosts in the subcluster."""
    assign_public_ip: builtins.bool
    """Assign public ip addresses for all hosts in subcluter."""
    @property
    def resources(self) -> yandex.cloud.dataproc.v1.common_pb2.Resources:
        """Resource configuration for hosts in the subcluster."""

    @property
    def autoscaling_config(self) -> yandex.cloud.dataproc.v1.subcluster_pb2.AutoscalingConfig:
        """Configuration for instance group based subclusters"""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        role: yandex.cloud.dataproc.v1.subcluster_pb2.Role.ValueType = ...,
        resources: yandex.cloud.dataproc.v1.common_pb2.Resources | None = ...,
        subnet_id: builtins.str = ...,
        hosts_count: builtins.int = ...,
        assign_public_ip: builtins.bool = ...,
        autoscaling_config: yandex.cloud.dataproc.v1.subcluster_pb2.AutoscalingConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["autoscaling_config", b"autoscaling_config", "resources", b"resources"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["assign_public_ip", b"assign_public_ip", "autoscaling_config", b"autoscaling_config", "hosts_count", b"hosts_count", "name", b"name", "resources", b"resources", "role", b"role", "subnet_id", b"subnet_id"]) -> None: ...

global___CreateSubclusterConfigSpec = CreateSubclusterConfigSpec

@typing.final
class UpdateSubclusterConfigSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    RESOURCES_FIELD_NUMBER: builtins.int
    HOSTS_COUNT_FIELD_NUMBER: builtins.int
    AUTOSCALING_CONFIG_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the subcluster to update.

    To get the subcluster ID make a [SubclusterService.List] request.
    """
    name: builtins.str
    """Name of the subcluster."""
    hosts_count: builtins.int
    """Number of hosts in the subcluster."""
    @property
    def resources(self) -> yandex.cloud.dataproc.v1.common_pb2.Resources:
        """Resource configuration for each host in the subcluster."""

    @property
    def autoscaling_config(self) -> yandex.cloud.dataproc.v1.subcluster_pb2.AutoscalingConfig:
        """Configuration for instance group based subclusters"""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        resources: yandex.cloud.dataproc.v1.common_pb2.Resources | None = ...,
        hosts_count: builtins.int = ...,
        autoscaling_config: yandex.cloud.dataproc.v1.subcluster_pb2.AutoscalingConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["autoscaling_config", b"autoscaling_config", "resources", b"resources"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["autoscaling_config", b"autoscaling_config", "hosts_count", b"hosts_count", "id", b"id", "name", b"name", "resources", b"resources"]) -> None: ...

global___UpdateSubclusterConfigSpec = UpdateSubclusterConfigSpec

@typing.final
class CreateClusterConfigSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VERSION_ID_FIELD_NUMBER: builtins.int
    HADOOP_FIELD_NUMBER: builtins.int
    SUBCLUSTERS_SPEC_FIELD_NUMBER: builtins.int
    version_id: builtins.str
    """Version of the image for cluster provisioning.

    All available versions are listed in the [documentation](/docs/data-proc/concepts/environment).
    """
    @property
    def hadoop(self) -> yandex.cloud.dataproc.v1.cluster_pb2.HadoopConfig:
        """Yandex Data Processing specific options."""

    @property
    def subclusters_spec(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___CreateSubclusterConfigSpec]:
        """Specification for creating subclusters."""

    def __init__(
        self,
        *,
        version_id: builtins.str = ...,
        hadoop: yandex.cloud.dataproc.v1.cluster_pb2.HadoopConfig | None = ...,
        subclusters_spec: collections.abc.Iterable[global___CreateSubclusterConfigSpec] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["hadoop", b"hadoop"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["hadoop", b"hadoop", "subclusters_spec", b"subclusters_spec", "version_id", b"version_id"]) -> None: ...

global___CreateClusterConfigSpec = CreateClusterConfigSpec

@typing.final
class UpdateClusterConfigSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBCLUSTERS_SPEC_FIELD_NUMBER: builtins.int
    HADOOP_FIELD_NUMBER: builtins.int
    @property
    def subclusters_spec(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___UpdateSubclusterConfigSpec]:
        """New configuration for subclusters in a cluster."""

    @property
    def hadoop(self) -> yandex.cloud.dataproc.v1.cluster_pb2.HadoopConfig:
        """Hadoop specific options"""

    def __init__(
        self,
        *,
        subclusters_spec: collections.abc.Iterable[global___UpdateSubclusterConfigSpec] | None = ...,
        hadoop: yandex.cloud.dataproc.v1.cluster_pb2.HadoopConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["hadoop", b"hadoop"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["hadoop", b"hadoop", "subclusters_spec", b"subclusters_spec"]) -> None: ...

global___UpdateClusterConfigSpec = UpdateClusterConfigSpec

@typing.final
class CreateClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    CONFIG_SPEC_FIELD_NUMBER: builtins.int
    ZONE_ID_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    BUCKET_FIELD_NUMBER: builtins.int
    UI_PROXY_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    HOST_GROUP_IDS_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    LOG_GROUP_ID_FIELD_NUMBER: builtins.int
    ENVIRONMENT_FIELD_NUMBER: builtins.int
    AUTOSCALING_SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to create a cluster in.

    To get a folder ID make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    name: builtins.str
    """Name of the cluster. The name must be unique within the folder.
    The name can't be changed after the Yandex Data Processing cluster is created.
    """
    description: builtins.str
    """Description of the cluster."""
    zone_id: builtins.str
    """ID of the availability zone where the cluster should be placed.

    To get the list of available zones make a [yandex.cloud.compute.v1.ZoneService.List] request.
    """
    service_account_id: builtins.str
    """ID of the service account to be used by the Yandex Data Processing manager agent."""
    bucket: builtins.str
    """Name of the Object Storage bucket to use for Yandex Data Processing jobs."""
    ui_proxy: builtins.bool
    """Enable UI Proxy feature."""
    deletion_protection: builtins.bool
    """Deletion Protection inhibits deletion of the cluster"""
    log_group_id: builtins.str
    """ID of the cloud logging log group to write logs. If not set, logs will not be sent to logging service"""
    environment: yandex.cloud.dataproc.v1.cluster_pb2.Cluster.Environment.ValueType
    """Environment of the cluster"""
    autoscaling_service_account_id: builtins.str
    """ID of the service account to be used by the Instance Groups service."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Cluster labels as `key:value` pairs."""

    @property
    def config_spec(self) -> global___CreateClusterConfigSpec:
        """Configuration and resources for hosts that should be created with the cluster."""

    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """User security groups."""

    @property
    def host_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Host groups to place VMs of cluster on."""

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        config_spec: global___CreateClusterConfigSpec | None = ...,
        zone_id: builtins.str = ...,
        service_account_id: builtins.str = ...,
        bucket: builtins.str = ...,
        ui_proxy: builtins.bool = ...,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        host_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        deletion_protection: builtins.bool = ...,
        log_group_id: builtins.str = ...,
        environment: yandex.cloud.dataproc.v1.cluster_pb2.Cluster.Environment.ValueType = ...,
        autoscaling_service_account_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["config_spec", b"config_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["autoscaling_service_account_id", b"autoscaling_service_account_id", "bucket", b"bucket", "config_spec", b"config_spec", "deletion_protection", b"deletion_protection", "description", b"description", "environment", b"environment", "folder_id", b"folder_id", "host_group_ids", b"host_group_ids", "labels", b"labels", "log_group_id", b"log_group_id", "name", b"name", "security_group_ids", b"security_group_ids", "service_account_id", b"service_account_id", "ui_proxy", b"ui_proxy", "zone_id", b"zone_id"]) -> None: ...

global___CreateClusterRequest = CreateClusterRequest

@typing.final
class CreateClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster that is being created."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___CreateClusterMetadata = CreateClusterMetadata

@typing.final
class UpdateClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    CONFIG_SPEC_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    BUCKET_FIELD_NUMBER: builtins.int
    DECOMMISSION_TIMEOUT_FIELD_NUMBER: builtins.int
    UI_PROXY_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    LOG_GROUP_ID_FIELD_NUMBER: builtins.int
    AUTOSCALING_SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster to update.

    To get the cluster ID, make a [ClusterService.List] request.
    """
    description: builtins.str
    """New description for the cluster."""
    name: builtins.str
    """New name for the Yandex Data Processing cluster. The name must be unique within the folder."""
    service_account_id: builtins.str
    """ID of the new service account to be used by the Yandex Data Processing manager agent."""
    bucket: builtins.str
    """Name of the new Object Storage bucket to use for Yandex Data Processing jobs."""
    decommission_timeout: builtins.int
    """Timeout to gracefully decommission nodes. In seconds. Default value: 0"""
    ui_proxy: builtins.bool
    """Enable UI Proxy feature."""
    deletion_protection: builtins.bool
    """Deletion Protection inhibits deletion of the cluster"""
    log_group_id: builtins.str
    """ID of the cloud logging log group to write logs. If not set, logs will not be sent to logging service"""
    autoscaling_service_account_id: builtins.str
    """ID of the new service account to be used by the Instance Groups service."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which attributes of the cluster should be updated."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """A new set of cluster labels as `key:value` pairs."""

    @property
    def config_spec(self) -> global___UpdateClusterConfigSpec:
        """Configuration and resources for hosts that should be created with the Yandex Data Processing cluster."""

    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """User security groups."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        config_spec: global___UpdateClusterConfigSpec | None = ...,
        name: builtins.str = ...,
        service_account_id: builtins.str = ...,
        bucket: builtins.str = ...,
        decommission_timeout: builtins.int = ...,
        ui_proxy: builtins.bool = ...,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
        deletion_protection: builtins.bool = ...,
        log_group_id: builtins.str = ...,
        autoscaling_service_account_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["config_spec", b"config_spec", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["autoscaling_service_account_id", b"autoscaling_service_account_id", "bucket", b"bucket", "cluster_id", b"cluster_id", "config_spec", b"config_spec", "decommission_timeout", b"decommission_timeout", "deletion_protection", b"deletion_protection", "description", b"description", "labels", b"labels", "log_group_id", b"log_group_id", "name", b"name", "security_group_ids", b"security_group_ids", "service_account_id", b"service_account_id", "ui_proxy", b"ui_proxy", "update_mask", b"update_mask"]) -> None: ...

global___UpdateClusterRequest = UpdateClusterRequest

@typing.final
class UpdateClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster that is being updated."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___UpdateClusterMetadata = UpdateClusterMetadata

@typing.final
class DeleteClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    DECOMMISSION_TIMEOUT_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster to delete.

    To get a cluster ID, make a [ClusterService.List] request.
    """
    decommission_timeout: builtins.int
    """Timeout to gracefully decommission nodes. In seconds. Default value: 0"""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        decommission_timeout: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "decommission_timeout", b"decommission_timeout"]) -> None: ...

global___DeleteClusterRequest = DeleteClusterRequest

@typing.final
class DeleteClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Yandex Data Processing cluster that is being deleted."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___DeleteClusterMetadata = DeleteClusterMetadata

@typing.final
class StartClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster to start.

    To get a cluster ID, make a [ClusterService.List] request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___StartClusterRequest = StartClusterRequest

@typing.final
class StartClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Yandex Data Processing cluster that is being started."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___StartClusterMetadata = StartClusterMetadata

@typing.final
class StopClusterRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    DECOMMISSION_TIMEOUT_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster to stop.

    To get a cluster ID, make a [ClusterService.List] request.
    """
    decommission_timeout: builtins.int
    """Timeout to gracefully decommission nodes. In seconds. Default value: 0"""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        decommission_timeout: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "decommission_timeout", b"decommission_timeout"]) -> None: ...

global___StopClusterRequest = StopClusterRequest

@typing.final
class StopClusterMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the Yandex Data Processing cluster that is being stopped."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___StopClusterMetadata = StopClusterMetadata

@typing.final
class ListClusterOperationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster to list operations for."""
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size], the service returns a [ListClusterOperationsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the
    [ListClusterOperationsResponse.next_page_token] returned by a previous list request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListClusterOperationsRequest = ListClusterOperationsRequest

@typing.final
class ListClusterOperationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListClusterOperationsRequest.page_size], use `next_page_token` as the value
    for the [ListClusterOperationsRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """List of operations for the specified cluster."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListClusterOperationsResponse = ListClusterOperationsResponse

@typing.final
class ListClusterHostsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster to list hosts for.

    To get a cluster ID, make a [ClusterService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size], the service returns a [ListClusterHostsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the
    [ListClusterHostsResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters hosts listed in the response.

    The expression must specify:
    1. The field name. Currently you can use filtering only on [Cluster.name] field.
    2. An `=` operator.
    3. The value in double quotes (`"`). Must be 3-63 characters long and match the regular expression `[a-z][-a-z0-9]{1,61}[a-z0-9]`.
    Example of a filter: `name=my-host`
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListClusterHostsRequest = ListClusterHostsRequest

@typing.final
class ListClusterHostsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HOSTS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListClusterHostsRequest.page_size], use `next_page_token` as the value
    for the [ListClusterHostsRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def hosts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.dataproc.v1.subcluster_pb2.Host]:
        """Requested list of hosts."""

    def __init__(
        self,
        *,
        hosts: collections.abc.Iterable[yandex.cloud.dataproc.v1.subcluster_pb2.Host] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["hosts", b"hosts", "next_page_token", b"next_page_token"]) -> None: ...

global___ListClusterHostsResponse = ListClusterHostsResponse

@typing.final
class ListUILinksRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """Required. ID of the Hadoop cluster."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___ListUILinksRequest = ListUILinksRequest

@typing.final
class UILink(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    URL_FIELD_NUMBER: builtins.int
    name: builtins.str
    url: builtins.str
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        url: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["name", b"name", "url", b"url"]) -> None: ...

global___UILink = UILink

@typing.final
class ListUILinksResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LINKS_FIELD_NUMBER: builtins.int
    @property
    def links(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___UILink]:
        """Requested list of ui links."""

    def __init__(
        self,
        *,
        links: collections.abc.Iterable[global___UILink] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["links", b"links"]) -> None: ...

global___ListUILinksResponse = ListUILinksResponse
