"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.dataproc.v1.job_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetJobRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    JOB_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster to request a job from."""
    job_id: builtins.str
    """ID of the job to return.

    To get a job ID make a [JobService.List] request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        job_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "job_id", b"job_id"]) -> None: ...

global___GetJobRequest = GetJobRequest

@typing.final
class ListJobsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster to list jobs for."""
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than [page_size], the service returns a [ListJobsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `page_token` to the
    [ListJobsResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters jobs listed in the response.

    The expression must specify:
    1. The field name. Currently you can use filtering only on [Job.name] field.
    2. An `=` operator.
    3. The value in double quotes (`"`). Must be 3-63 characters long and match the regular expression `[a-z][-a-z0-9]{1,61}[a-z0-9]`.
    Example of a filter: `name=my-job`.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListJobsRequest = ListJobsRequest

@typing.final
class ListJobsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    JOBS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListJobsRequest.page_size], use `next_page_token` as the value
    for the [ListJobsRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def jobs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.dataproc.v1.job_pb2.Job]:
        """List of jobs for the specified cluster."""

    def __init__(
        self,
        *,
        jobs: collections.abc.Iterable[yandex.cloud.dataproc.v1.job_pb2.Job] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["jobs", b"jobs", "next_page_token", b"next_page_token"]) -> None: ...

global___ListJobsResponse = ListJobsResponse

@typing.final
class CreateJobRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    MAPREDUCE_JOB_FIELD_NUMBER: builtins.int
    SPARK_JOB_FIELD_NUMBER: builtins.int
    PYSPARK_JOB_FIELD_NUMBER: builtins.int
    HIVE_JOB_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster to create a job for."""
    name: builtins.str
    """Name of the job."""
    @property
    def mapreduce_job(self) -> yandex.cloud.dataproc.v1.job_pb2.MapreduceJob:
        """Specification for a MapReduce job."""

    @property
    def spark_job(self) -> yandex.cloud.dataproc.v1.job_pb2.SparkJob:
        """Specification for a Spark job."""

    @property
    def pyspark_job(self) -> yandex.cloud.dataproc.v1.job_pb2.PysparkJob:
        """Specification for a PySpark job."""

    @property
    def hive_job(self) -> yandex.cloud.dataproc.v1.job_pb2.HiveJob:
        """Specification for a Hive job."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        name: builtins.str = ...,
        mapreduce_job: yandex.cloud.dataproc.v1.job_pb2.MapreduceJob | None = ...,
        spark_job: yandex.cloud.dataproc.v1.job_pb2.SparkJob | None = ...,
        pyspark_job: yandex.cloud.dataproc.v1.job_pb2.PysparkJob | None = ...,
        hive_job: yandex.cloud.dataproc.v1.job_pb2.HiveJob | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["hive_job", b"hive_job", "job_spec", b"job_spec", "mapreduce_job", b"mapreduce_job", "pyspark_job", b"pyspark_job", "spark_job", b"spark_job"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "hive_job", b"hive_job", "job_spec", b"job_spec", "mapreduce_job", b"mapreduce_job", "name", b"name", "pyspark_job", b"pyspark_job", "spark_job", b"spark_job"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["job_spec", b"job_spec"]) -> typing.Literal["mapreduce_job", "spark_job", "pyspark_job", "hive_job"] | None: ...

global___CreateJobRequest = CreateJobRequest

@typing.final
class CreateJobMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    JOB_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster that the job is being created for."""
    job_id: builtins.str
    """ID of the job being created."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        job_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "job_id", b"job_id"]) -> None: ...

global___CreateJobMetadata = CreateJobMetadata

@typing.final
class CancelJobRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    JOB_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """Required. ID of the Yandex Data Processing cluster."""
    job_id: builtins.str
    """Required. ID of the Yandex Data Processing job to cancel."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        job_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "job_id", b"job_id"]) -> None: ...

global___CancelJobRequest = CancelJobRequest

@typing.final
class ListJobLogRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    JOB_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the cluster that the job is being created for."""
    job_id: builtins.str
    """ID of the job being created."""
    page_size: builtins.int
    """The maximum bytes of job log per response to return. If the number of available
    bytes is larger than [page_size], the service returns a [ListJobLogResponse.next_page_token]
    that can be used to get the next page of output in subsequent list requests.
    Default value: 1048576.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `page_token` to the
    [ListJobLogResponse.next_page_token] returned by a previous list request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        job_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "job_id", b"job_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListJobLogRequest = ListJobLogRequest

@typing.final
class ListJobLogResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTENT_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    content: builtins.str
    """Requested part of Yandex Data Processing Job log."""
    next_page_token: builtins.str
    """This token allows you to get the next page of results for ListLog requests,
    if the number of results is larger than `page_size` specified in the request.
    To get the next page, specify the value of `next_page_token` as a value for
    the `page_token` parameter in the next ListLog request. Subsequent ListLog
    requests will have their own `next_page_token` to continue paging through the results.
    """
    def __init__(
        self,
        *,
        content: builtins.str = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["content", b"content", "next_page_token", b"next_page_token"]) -> None: ...

global___ListJobLogResponse = ListJobLogResponse
