"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import typing

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Federation(google.protobuf.message.Message):
    """A OIDC workload identity federation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    ENABLED_FIELD_NUMBER: builtins.int
    AUDIENCES_FIELD_NUMBER: builtins.int
    ISSUER_FIELD_NUMBER: builtins.int
    JWKS_URL_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Id of the OIDC workload identity federation."""
    name: builtins.str
    """Name of the OIDC workload identity federation
    The name is unique within the folder. 3-63 characters long.
    """
    folder_id: builtins.str
    """ID of the folder that the OIDC workload identity federation belongs to."""
    description: builtins.str
    """Description of the service account. 0-256 characters long."""
    enabled: builtins.bool
    """True - the OIDC workload identity federation is enabled and can be used for authentication.
    False - the OIDC workload identity federation is disabled and cannot be used for authentication.
    """
    issuer: builtins.str
    """URL of the external IdP server to be used for authentication."""
    jwks_url: builtins.str
    """URL reference to trusted keys in format of JSON Web Key Set."""
    @property
    def audiences(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of trusted values for aud claim."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `` key:value `` pairs"""

    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        folder_id: builtins.str = ...,
        description: builtins.str = ...,
        enabled: builtins.bool = ...,
        audiences: collections.abc.Iterable[builtins.str] | None = ...,
        issuer: builtins.str = ...,
        jwks_url: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["audiences", b"audiences", "created_at", b"created_at", "description", b"description", "enabled", b"enabled", "folder_id", b"folder_id", "id", b"id", "issuer", b"issuer", "jwks_url", b"jwks_url", "labels", b"labels", "name", b"name"]) -> None: ...

global___Federation = Federation
