"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing
import yandex.cloud.logging.v1.log_entry_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Registry(google.protobuf.message.Message):
    """A registry. For more information, see [Registry](/docs/iot-core/concepts/index#registry)."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Registry._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: Registry._Status.ValueType  # 0
        CREATING: Registry._Status.ValueType  # 1
        """Registry is being created."""
        ACTIVE: Registry._Status.ValueType  # 2
        """Registry is ready to use."""
        DELETING: Registry._Status.ValueType  # 3
        """Registry is being deleted."""
        DISABLED: Registry._Status.ValueType  # 4
        """Registry is disabled."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNSPECIFIED: Registry.Status.ValueType  # 0
    CREATING: Registry.Status.ValueType  # 1
    """Registry is being created."""
    ACTIVE: Registry.Status.ValueType  # 2
    """Registry is ready to use."""
    DELETING: Registry.Status.ValueType  # 3
    """Registry is being deleted."""
    DISABLED: Registry.Status.ValueType  # 4
    """Registry is disabled."""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    LOG_GROUP_ID_FIELD_NUMBER: builtins.int
    LOG_OPTIONS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the registry."""
    folder_id: builtins.str
    """ID of the folder that the registry belongs to."""
    name: builtins.str
    """Name of the registry. The name is unique within the folder."""
    description: builtins.str
    """Description of the registry. 0-256 characters long."""
    status: global___Registry.Status.ValueType
    """Status of the registry."""
    log_group_id: builtins.str
    """ID of the logs group for the specified registry."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs. Maximum of 64 per resource."""

    @property
    def log_options(self) -> global___LogOptions:
        """Options for logging registry events"""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        status: global___Registry.Status.ValueType = ...,
        log_group_id: builtins.str = ...,
        log_options: global___LogOptions | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "log_options", b"log_options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["created_at", b"created_at", "description", b"description", "folder_id", b"folder_id", "id", b"id", "labels", b"labels", "log_group_id", b"log_group_id", "log_options", b"log_options", "name", b"name", "status", b"status"]) -> None: ...

global___Registry = Registry

@typing.final
class RegistryCertificate(google.protobuf.message.Message):
    """A registry certificate. For more information, see [Managing registry certificates](/docs/iot-core/operations/certificates/registry-certificates)."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REGISTRY_ID_FIELD_NUMBER: builtins.int
    FINGERPRINT_FIELD_NUMBER: builtins.int
    CERTIFICATE_DATA_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    registry_id: builtins.str
    """ID of the registry that the certificate belongs to."""
    fingerprint: builtins.str
    """SHA256 hash of the certificates."""
    certificate_data: builtins.str
    """Public part of the certificate."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp."""

    def __init__(
        self,
        *,
        registry_id: builtins.str = ...,
        fingerprint: builtins.str = ...,
        certificate_data: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["certificate_data", b"certificate_data", "created_at", b"created_at", "fingerprint", b"fingerprint", "registry_id", b"registry_id"]) -> None: ...

global___RegistryCertificate = RegistryCertificate

@typing.final
class DeviceAlias(google.protobuf.message.Message):
    """A device topic alias.

    Alias is an alternate name of a device topic assigned by the user. Map alias to canonical topic name prefix, e.g. `my/custom/alias` match to `$device/abcdef/events`. For more information, see [Using topic aliases](/docs/iot-core/concepts/topic#aliases).
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DEVICE_ID_FIELD_NUMBER: builtins.int
    TOPIC_PREFIX_FIELD_NUMBER: builtins.int
    ALIAS_FIELD_NUMBER: builtins.int
    device_id: builtins.str
    """ID of the device that the alias belongs to."""
    topic_prefix: builtins.str
    """Prefix of a canonical topic name to be aliased, e.g. `$devices/abcdef`."""
    alias: builtins.str
    """Alias of a device topic."""
    def __init__(
        self,
        *,
        device_id: builtins.str = ...,
        topic_prefix: builtins.str = ...,
        alias: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["alias", b"alias", "device_id", b"device_id", "topic_prefix", b"topic_prefix"]) -> None: ...

global___DeviceAlias = DeviceAlias

@typing.final
class RegistryPassword(google.protobuf.message.Message):
    """A registry password."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REGISTRY_ID_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    registry_id: builtins.str
    """ID of the registry that the password belongs to."""
    id: builtins.str
    """ID of the password."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp."""

    def __init__(
        self,
        *,
        registry_id: builtins.str = ...,
        id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["created_at", b"created_at", "id", b"id", "registry_id", b"registry_id"]) -> None: ...

global___RegistryPassword = RegistryPassword

@typing.final
class DataStreamExport(google.protobuf.message.Message):
    """A Yandex Data Streams export."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    REGISTRY_ID_FIELD_NUMBER: builtins.int
    MQTT_TOPIC_FILTER_FIELD_NUMBER: builtins.int
    DATABASE_FIELD_NUMBER: builtins.int
    STREAM_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the YDS export."""
    name: builtins.str
    """Name of the YDS export."""
    registry_id: builtins.str
    """ID of the registry that the YDS export belongs to."""
    mqtt_topic_filter: builtins.str
    """MQTT topic whose messages export to YDS."""
    database: builtins.str
    """YDS database."""
    stream: builtins.str
    """YDS stream name."""
    service_account_id: builtins.str
    """ID of the service account which has permission to write to data stream."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        registry_id: builtins.str = ...,
        mqtt_topic_filter: builtins.str = ...,
        database: builtins.str = ...,
        stream: builtins.str = ...,
        service_account_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["created_at", b"created_at", "database", b"database", "id", b"id", "mqtt_topic_filter", b"mqtt_topic_filter", "name", b"name", "registry_id", b"registry_id", "service_account_id", b"service_account_id", "stream", b"stream"]) -> None: ...

global___DataStreamExport = DataStreamExport

@typing.final
class LogOptions(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DISABLED_FIELD_NUMBER: builtins.int
    LOG_GROUP_ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    MIN_LEVEL_FIELD_NUMBER: builtins.int
    disabled: builtins.bool
    """Is logging from registry disabled."""
    log_group_id: builtins.str
    """Entry should be written to log group resolved by ID."""
    folder_id: builtins.str
    """Entry should be written to default log group for specified folder."""
    min_level: yandex.cloud.logging.v1.log_entry_pb2.LogLevel.Level.ValueType
    """Minimum log entry level.

    See [LogLevel.Level] for details.
    """
    def __init__(
        self,
        *,
        disabled: builtins.bool = ...,
        log_group_id: builtins.str = ...,
        folder_id: builtins.str = ...,
        min_level: yandex.cloud.logging.v1.log_entry_pb2.LogLevel.Level.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["destination", b"destination", "folder_id", b"folder_id", "log_group_id", b"log_group_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["destination", b"destination", "disabled", b"disabled", "folder_id", b"folder_id", "log_group_id", b"log_group_id", "min_level", b"min_level"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["destination", b"destination"]) -> typing.Literal["log_group_id", "folder_id"] | None: ...

global___LogOptions = LogOptions
