"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import google.protobuf.descriptor
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class HelmRelease(google.protobuf.message.Message):
    """A Helm Release."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[HelmRelease._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: HelmRelease._Status.ValueType  # 0
        UNKNOWN: HelmRelease._Status.ValueType  # 1
        """Helm release status is unknown"""
        DEPLOYED: HelmRelease._Status.ValueType  # 2
        """Helm release deployed."""
        UNINSTALLED: HelmRelease._Status.ValueType  # 3
        """Helm release uninstalled."""
        SUPERSEDED: HelmRelease._Status.ValueType  # 4
        """Helm release superseded."""
        FAILED: HelmRelease._Status.ValueType  # 5
        """Helm release installation failed."""
        UNINSTALLING: HelmRelease._Status.ValueType  # 6
        """Helm release is being uninstalled."""
        PENDING_INSTALL: HelmRelease._Status.ValueType  # 7
        """Helm release is to be installed."""
        PENDING_UPGRADE: HelmRelease._Status.ValueType  # 8
        """Helm release is to be updated."""
        PENDING_ROLLBACK: HelmRelease._Status.ValueType  # 9
        """Helm release is to be rolled back."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNSPECIFIED: HelmRelease.Status.ValueType  # 0
    UNKNOWN: HelmRelease.Status.ValueType  # 1
    """Helm release status is unknown"""
    DEPLOYED: HelmRelease.Status.ValueType  # 2
    """Helm release deployed."""
    UNINSTALLED: HelmRelease.Status.ValueType  # 3
    """Helm release uninstalled."""
    SUPERSEDED: HelmRelease.Status.ValueType  # 4
    """Helm release superseded."""
    FAILED: HelmRelease.Status.ValueType  # 5
    """Helm release installation failed."""
    UNINSTALLING: HelmRelease.Status.ValueType  # 6
    """Helm release is being uninstalled."""
    PENDING_INSTALL: HelmRelease.Status.ValueType  # 7
    """Helm release is to be installed."""
    PENDING_UPGRADE: HelmRelease.Status.ValueType  # 8
    """Helm release is to be updated."""
    PENDING_ROLLBACK: HelmRelease.Status.ValueType  # 9
    """Helm release is to be rolled back."""

    ID_FIELD_NUMBER: builtins.int
    CLUSTER_ID_FIELD_NUMBER: builtins.int
    APP_NAME_FIELD_NUMBER: builtins.int
    APP_NAMESPACE_FIELD_NUMBER: builtins.int
    PRODUCT_ID_FIELD_NUMBER: builtins.int
    PRODUCT_NAME_FIELD_NUMBER: builtins.int
    PRODUCT_VERSION_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of a helm release."""
    cluster_id: builtins.str
    """ID of the Kubernetes cluster."""
    app_name: builtins.str
    """Name of the application."""
    app_namespace: builtins.str
    """Namespace of the application."""
    product_id: builtins.str
    """Kubernetes marketplace product id."""
    product_name: builtins.str
    """Kubernetes marketplace product name."""
    product_version: builtins.str
    """Kubernetes marketplace product version."""
    status: global___HelmRelease.Status.ValueType
    """Status of a helm release."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        cluster_id: builtins.str = ...,
        app_name: builtins.str = ...,
        app_namespace: builtins.str = ...,
        product_id: builtins.str = ...,
        product_name: builtins.str = ...,
        product_version: builtins.str = ...,
        status: global___HelmRelease.Status.ValueType = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["app_name", b"app_name", "app_namespace", b"app_namespace", "cluster_id", b"cluster_id", "created_at", b"created_at", "id", b"id", "product_id", b"product_id", "product_name", b"product_name", "product_version", b"product_version", "status", b"status"]) -> None: ...

global___HelmRelease = HelmRelease
