"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _AsymmetricEncryptionAlgorithm:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _AsymmetricEncryptionAlgorithmEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_AsymmetricEncryptionAlgorithm.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ASYMMETRIC_ENCRYPTION_ALGORITHM_UNSPECIFIED: _AsymmetricEncryptionAlgorithm.ValueType  # 0
    RSA_2048_ENC_OAEP_SHA_256: _AsymmetricEncryptionAlgorithm.ValueType  # 1
    """RSA-2048 encryption with OAEP padding and SHA-256"""
    RSA_3072_ENC_OAEP_SHA_256: _AsymmetricEncryptionAlgorithm.ValueType  # 2
    """RSA-3072 encryption with OAEP padding and SHA-256"""
    RSA_4096_ENC_OAEP_SHA_256: _AsymmetricEncryptionAlgorithm.ValueType  # 3
    """RSA-4096 encryption with OAEP padding and SHA-256"""

class AsymmetricEncryptionAlgorithm(_AsymmetricEncryptionAlgorithm, metaclass=_AsymmetricEncryptionAlgorithmEnumTypeWrapper):
    """Supported asymmetric encryption algorithms."""

ASYMMETRIC_ENCRYPTION_ALGORITHM_UNSPECIFIED: AsymmetricEncryptionAlgorithm.ValueType  # 0
RSA_2048_ENC_OAEP_SHA_256: AsymmetricEncryptionAlgorithm.ValueType  # 1
"""RSA-2048 encryption with OAEP padding and SHA-256"""
RSA_3072_ENC_OAEP_SHA_256: AsymmetricEncryptionAlgorithm.ValueType  # 2
"""RSA-3072 encryption with OAEP padding and SHA-256"""
RSA_4096_ENC_OAEP_SHA_256: AsymmetricEncryptionAlgorithm.ValueType  # 3
"""RSA-4096 encryption with OAEP padding and SHA-256"""
global___AsymmetricEncryptionAlgorithm = AsymmetricEncryptionAlgorithm

@typing.final
class AsymmetricEncryptionKey(google.protobuf.message.Message):
    """An asymmetric KMS key that may contain several versions of the cryptographic material."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[AsymmetricEncryptionKey._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: AsymmetricEncryptionKey._Status.ValueType  # 0
        CREATING: AsymmetricEncryptionKey._Status.ValueType  # 1
        """The key is being created."""
        ACTIVE: AsymmetricEncryptionKey._Status.ValueType  # 2
        """The key is active and can be used for encryption and decryption or signature and verification.
        Can be set to INACTIVE using the [AsymmetricKeyService.Update] method.
        """
        INACTIVE: AsymmetricEncryptionKey._Status.ValueType  # 3
        """The key is inactive and unusable.
        Can be set to ACTIVE using the [AsymmetricKeyService.Update] method.
        """

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNSPECIFIED: AsymmetricEncryptionKey.Status.ValueType  # 0
    CREATING: AsymmetricEncryptionKey.Status.ValueType  # 1
    """The key is being created."""
    ACTIVE: AsymmetricEncryptionKey.Status.ValueType  # 2
    """The key is active and can be used for encryption and decryption or signature and verification.
    Can be set to INACTIVE using the [AsymmetricKeyService.Update] method.
    """
    INACTIVE: AsymmetricEncryptionKey.Status.ValueType  # 3
    """The key is inactive and unusable.
    Can be set to ACTIVE using the [AsymmetricKeyService.Update] method.
    """

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    ENCRYPTION_ALGORITHM_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the key."""
    folder_id: builtins.str
    """ID of the folder that the key belongs to."""
    name: builtins.str
    """Name of the key."""
    description: builtins.str
    """Description of the key."""
    status: global___AsymmetricEncryptionKey.Status.ValueType
    """Current status of the key."""
    encryption_algorithm: global___AsymmetricEncryptionAlgorithm.ValueType
    """Asymmetric Encryption Algorithm ID."""
    deletion_protection: builtins.bool
    """Flag that inhibits deletion of the key"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Time when the key was created."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Custom labels for the key as `key:value` pairs. Maximum 64 per key."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        status: global___AsymmetricEncryptionKey.Status.ValueType = ...,
        encryption_algorithm: global___AsymmetricEncryptionAlgorithm.ValueType = ...,
        deletion_protection: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["created_at", b"created_at", "deletion_protection", b"deletion_protection", "description", b"description", "encryption_algorithm", b"encryption_algorithm", "folder_id", b"folder_id", "id", b"id", "labels", b"labels", "name", b"name", "status", b"status"]) -> None: ...

global___AsymmetricEncryptionKey = AsymmetricEncryptionKey
