"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _AsymmetricSignatureAlgorithm:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _AsymmetricSignatureAlgorithmEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_AsymmetricSignatureAlgorithm.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ASYMMETRIC_SIGNATURE_ALGORITHM_UNSPECIFIED: _AsymmetricSignatureAlgorithm.ValueType  # 0
    RSA_2048_SIGN_PSS_SHA_256: _AsymmetricSignatureAlgorithm.ValueType  # 1
    """RSA-2048 signature with PSS padding and SHA-256"""
    RSA_2048_SIGN_PSS_SHA_384: _AsymmetricSignatureAlgorithm.ValueType  # 2
    """RSA-2048 signature with PSS padding and SHA-384"""
    RSA_2048_SIGN_PSS_SHA_512: _AsymmetricSignatureAlgorithm.ValueType  # 3
    """RSA-2048 signature with PSS padding and SHA-512"""
    RSA_3072_SIGN_PSS_SHA_256: _AsymmetricSignatureAlgorithm.ValueType  # 4
    """RSA-3072 signature with PSS padding and SHA-256"""
    RSA_3072_SIGN_PSS_SHA_384: _AsymmetricSignatureAlgorithm.ValueType  # 5
    """RSA-3072 signature with PSS padding and SHA-384"""
    RSA_3072_SIGN_PSS_SHA_512: _AsymmetricSignatureAlgorithm.ValueType  # 6
    """RSA-3072 signature with PSS padding and SHA-512"""
    RSA_4096_SIGN_PSS_SHA_256: _AsymmetricSignatureAlgorithm.ValueType  # 7
    """RSA-4096 signature with PSS padding and SHA-256"""
    RSA_4096_SIGN_PSS_SHA_384: _AsymmetricSignatureAlgorithm.ValueType  # 8
    """RSA-4096 signature with PSS padding and SHA-384"""
    RSA_4096_SIGN_PSS_SHA_512: _AsymmetricSignatureAlgorithm.ValueType  # 9
    """RSA-4096 signature with PSS padding and SHA-512"""
    ECDSA_NIST_P256_SHA_256: _AsymmetricSignatureAlgorithm.ValueType  # 10
    """ECDSA signature with NIST P-256 curve and SHA-256"""
    ECDSA_NIST_P384_SHA_384: _AsymmetricSignatureAlgorithm.ValueType  # 11
    """ECDSA signature with NIST P-384 curve and SHA-384"""
    ECDSA_NIST_P521_SHA_512: _AsymmetricSignatureAlgorithm.ValueType  # 12
    """ECDSA signature with NIST P-521 curve and SHA-512"""
    ECDSA_SECP256_K1_SHA_256: _AsymmetricSignatureAlgorithm.ValueType  # 13
    """ECDSA signature with SECP256_K1 curve and SHA-256"""

class AsymmetricSignatureAlgorithm(_AsymmetricSignatureAlgorithm, metaclass=_AsymmetricSignatureAlgorithmEnumTypeWrapper):
    """Supported asymmetric signature algorithms."""

ASYMMETRIC_SIGNATURE_ALGORITHM_UNSPECIFIED: AsymmetricSignatureAlgorithm.ValueType  # 0
RSA_2048_SIGN_PSS_SHA_256: AsymmetricSignatureAlgorithm.ValueType  # 1
"""RSA-2048 signature with PSS padding and SHA-256"""
RSA_2048_SIGN_PSS_SHA_384: AsymmetricSignatureAlgorithm.ValueType  # 2
"""RSA-2048 signature with PSS padding and SHA-384"""
RSA_2048_SIGN_PSS_SHA_512: AsymmetricSignatureAlgorithm.ValueType  # 3
"""RSA-2048 signature with PSS padding and SHA-512"""
RSA_3072_SIGN_PSS_SHA_256: AsymmetricSignatureAlgorithm.ValueType  # 4
"""RSA-3072 signature with PSS padding and SHA-256"""
RSA_3072_SIGN_PSS_SHA_384: AsymmetricSignatureAlgorithm.ValueType  # 5
"""RSA-3072 signature with PSS padding and SHA-384"""
RSA_3072_SIGN_PSS_SHA_512: AsymmetricSignatureAlgorithm.ValueType  # 6
"""RSA-3072 signature with PSS padding and SHA-512"""
RSA_4096_SIGN_PSS_SHA_256: AsymmetricSignatureAlgorithm.ValueType  # 7
"""RSA-4096 signature with PSS padding and SHA-256"""
RSA_4096_SIGN_PSS_SHA_384: AsymmetricSignatureAlgorithm.ValueType  # 8
"""RSA-4096 signature with PSS padding and SHA-384"""
RSA_4096_SIGN_PSS_SHA_512: AsymmetricSignatureAlgorithm.ValueType  # 9
"""RSA-4096 signature with PSS padding and SHA-512"""
ECDSA_NIST_P256_SHA_256: AsymmetricSignatureAlgorithm.ValueType  # 10
"""ECDSA signature with NIST P-256 curve and SHA-256"""
ECDSA_NIST_P384_SHA_384: AsymmetricSignatureAlgorithm.ValueType  # 11
"""ECDSA signature with NIST P-384 curve and SHA-384"""
ECDSA_NIST_P521_SHA_512: AsymmetricSignatureAlgorithm.ValueType  # 12
"""ECDSA signature with NIST P-521 curve and SHA-512"""
ECDSA_SECP256_K1_SHA_256: AsymmetricSignatureAlgorithm.ValueType  # 13
"""ECDSA signature with SECP256_K1 curve and SHA-256"""
global___AsymmetricSignatureAlgorithm = AsymmetricSignatureAlgorithm

@typing.final
class AsymmetricSignatureKey(google.protobuf.message.Message):
    """An asymmetric KMS key that may contain several versions of the cryptographic material."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[AsymmetricSignatureKey._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: AsymmetricSignatureKey._Status.ValueType  # 0
        CREATING: AsymmetricSignatureKey._Status.ValueType  # 1
        """The key is being created."""
        ACTIVE: AsymmetricSignatureKey._Status.ValueType  # 2
        """The key is active and can be used for encryption and decryption or signature and verification.
        Can be set to INACTIVE using the [AsymmetricKeyService.Update] method.
        """
        INACTIVE: AsymmetricSignatureKey._Status.ValueType  # 3
        """The key is inactive and unusable.
        Can be set to ACTIVE using the [AsymmetricKeyService.Update] method.
        """

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNSPECIFIED: AsymmetricSignatureKey.Status.ValueType  # 0
    CREATING: AsymmetricSignatureKey.Status.ValueType  # 1
    """The key is being created."""
    ACTIVE: AsymmetricSignatureKey.Status.ValueType  # 2
    """The key is active and can be used for encryption and decryption or signature and verification.
    Can be set to INACTIVE using the [AsymmetricKeyService.Update] method.
    """
    INACTIVE: AsymmetricSignatureKey.Status.ValueType  # 3
    """The key is inactive and unusable.
    Can be set to ACTIVE using the [AsymmetricKeyService.Update] method.
    """

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    SIGNATURE_ALGORITHM_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the key."""
    folder_id: builtins.str
    """ID of the folder that the key belongs to."""
    name: builtins.str
    """Name of the key."""
    description: builtins.str
    """Description of the key."""
    status: global___AsymmetricSignatureKey.Status.ValueType
    """Current status of the key."""
    signature_algorithm: global___AsymmetricSignatureAlgorithm.ValueType
    """Signature Algorithm ID."""
    deletion_protection: builtins.bool
    """Flag that inhibits deletion of the key"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Time when the key was created."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Custom labels for the key as `key:value` pairs. Maximum 64 per key."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        status: global___AsymmetricSignatureKey.Status.ValueType = ...,
        signature_algorithm: global___AsymmetricSignatureAlgorithm.ValueType = ...,
        deletion_protection: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["created_at", b"created_at", "deletion_protection", b"deletion_protection", "description", b"description", "folder_id", b"folder_id", "id", b"id", "labels", b"labels", "name", b"name", "signature_algorithm", b"signature_algorithm", "status", b"status"]) -> None: ...

global___AsymmetricSignatureKey = AsymmetricSignatureKey
