"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import abc
import collections.abc
import grpc
import grpc.aio
import typing
import yandex.cloud.access.access_pb2
import yandex.cloud.kms.v1.symmetric_key_pb2
import yandex.cloud.kms.v1.symmetric_key_service_pb2
import yandex.cloud.operation.operation_pb2

_T = typing.TypeVar("_T")

class _MaybeAsyncIterator(collections.abc.AsyncIterator[_T], collections.abc.Iterator[_T], metaclass=abc.ABCMeta): ...

class _ServicerContext(grpc.ServicerContext, grpc.aio.ServicerContext):  # type: ignore[misc, type-arg]
    ...

class SymmetricKeyServiceStub:
    """Set of methods for managing symmetric KMS keys."""

    def __init__(self, channel: typing.Union[grpc.Channel, grpc.aio.Channel]) -> None: ...
    Create: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.kms.v1.symmetric_key_service_pb2.CreateSymmetricKeyRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """--- control plane

    Creates a symmetric KMS key in the specified folder.
    """

    Get: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.kms.v1.symmetric_key_service_pb2.GetSymmetricKeyRequest,
        yandex.cloud.kms.v1.symmetric_key_pb2.SymmetricKey,
    ]
    """Returns the specified symmetric KMS key.

     To get the list of available symmetric KMS keys, make a [SymmetricKeyService.List] request.
    """

    List: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.kms.v1.symmetric_key_service_pb2.ListSymmetricKeysRequest,
        yandex.cloud.kms.v1.symmetric_key_service_pb2.ListSymmetricKeysResponse,
    ]
    """Returns the list of symmetric KMS keys in the specified folder."""

    ListVersions: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.kms.v1.symmetric_key_service_pb2.ListSymmetricKeyVersionsRequest,
        yandex.cloud.kms.v1.symmetric_key_service_pb2.ListSymmetricKeyVersionsResponse,
    ]
    """Returns the list of versions of the specified symmetric KMS key."""

    Update: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.kms.v1.symmetric_key_service_pb2.UpdateSymmetricKeyRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates the specified symmetric KMS key."""

    Delete: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.kms.v1.symmetric_key_service_pb2.DeleteSymmetricKeyRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes the specified symmetric KMS key. This action also automatically schedules
    the destruction of all of the key's versions in 72 hours.

    The key and its versions appear absent in [SymmetricKeyService.Get] and [SymmetricKeyService.List]
    requests, but can be restored within 72 hours with a request to tech support.
    """

    SetPrimaryVersion: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.kms.v1.symmetric_key_service_pb2.SetPrimarySymmetricKeyVersionRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Sets the primary version for the specified key. The primary version is used
    by default for all encrypt/decrypt operations where no version ID is specified.
    """

    ScheduleVersionDestruction: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.kms.v1.symmetric_key_service_pb2.ScheduleSymmetricKeyVersionDestructionRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Schedules the specified key version for destruction.

    Scheduled destruction can be cancelled with the [SymmetricKeyService.CancelVersionDestruction] method.
    """

    CancelVersionDestruction: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.kms.v1.symmetric_key_service_pb2.CancelSymmetricKeyVersionDestructionRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Cancels previously scheduled version destruction, if the version hasn't been destroyed yet."""

    Rotate: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.kms.v1.symmetric_key_service_pb2.RotateSymmetricKeyRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Rotates the specified key: creates a new key version and makes it the primary version.
    The old version remains available for decryption of ciphertext encrypted with it.
    """

    ListOperations: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.kms.v1.symmetric_key_service_pb2.ListSymmetricKeyOperationsRequest,
        yandex.cloud.kms.v1.symmetric_key_service_pb2.ListSymmetricKeyOperationsResponse,
    ]
    """Lists operations for the specified symmetric KMS key."""

    ListAccessBindings: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.access.access_pb2.ListAccessBindingsRequest,
        yandex.cloud.access.access_pb2.ListAccessBindingsResponse,
    ]
    """Lists existing access bindings for the specified key."""

    SetAccessBindings: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.access.access_pb2.SetAccessBindingsRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Sets access bindings for the key."""

    UpdateAccessBindings: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.access.access_pb2.UpdateAccessBindingsRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates access bindings for the specified key."""

class SymmetricKeyServiceAsyncStub:
    """Set of methods for managing symmetric KMS keys."""

    Create: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.kms.v1.symmetric_key_service_pb2.CreateSymmetricKeyRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """--- control plane

    Creates a symmetric KMS key in the specified folder.
    """

    Get: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.kms.v1.symmetric_key_service_pb2.GetSymmetricKeyRequest,
        yandex.cloud.kms.v1.symmetric_key_pb2.SymmetricKey,
    ]
    """Returns the specified symmetric KMS key.

     To get the list of available symmetric KMS keys, make a [SymmetricKeyService.List] request.
    """

    List: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.kms.v1.symmetric_key_service_pb2.ListSymmetricKeysRequest,
        yandex.cloud.kms.v1.symmetric_key_service_pb2.ListSymmetricKeysResponse,
    ]
    """Returns the list of symmetric KMS keys in the specified folder."""

    ListVersions: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.kms.v1.symmetric_key_service_pb2.ListSymmetricKeyVersionsRequest,
        yandex.cloud.kms.v1.symmetric_key_service_pb2.ListSymmetricKeyVersionsResponse,
    ]
    """Returns the list of versions of the specified symmetric KMS key."""

    Update: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.kms.v1.symmetric_key_service_pb2.UpdateSymmetricKeyRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates the specified symmetric KMS key."""

    Delete: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.kms.v1.symmetric_key_service_pb2.DeleteSymmetricKeyRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes the specified symmetric KMS key. This action also automatically schedules
    the destruction of all of the key's versions in 72 hours.

    The key and its versions appear absent in [SymmetricKeyService.Get] and [SymmetricKeyService.List]
    requests, but can be restored within 72 hours with a request to tech support.
    """

    SetPrimaryVersion: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.kms.v1.symmetric_key_service_pb2.SetPrimarySymmetricKeyVersionRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Sets the primary version for the specified key. The primary version is used
    by default for all encrypt/decrypt operations where no version ID is specified.
    """

    ScheduleVersionDestruction: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.kms.v1.symmetric_key_service_pb2.ScheduleSymmetricKeyVersionDestructionRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Schedules the specified key version for destruction.

    Scheduled destruction can be cancelled with the [SymmetricKeyService.CancelVersionDestruction] method.
    """

    CancelVersionDestruction: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.kms.v1.symmetric_key_service_pb2.CancelSymmetricKeyVersionDestructionRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Cancels previously scheduled version destruction, if the version hasn't been destroyed yet."""

    Rotate: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.kms.v1.symmetric_key_service_pb2.RotateSymmetricKeyRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Rotates the specified key: creates a new key version and makes it the primary version.
    The old version remains available for decryption of ciphertext encrypted with it.
    """

    ListOperations: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.kms.v1.symmetric_key_service_pb2.ListSymmetricKeyOperationsRequest,
        yandex.cloud.kms.v1.symmetric_key_service_pb2.ListSymmetricKeyOperationsResponse,
    ]
    """Lists operations for the specified symmetric KMS key."""

    ListAccessBindings: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.access.access_pb2.ListAccessBindingsRequest,
        yandex.cloud.access.access_pb2.ListAccessBindingsResponse,
    ]
    """Lists existing access bindings for the specified key."""

    SetAccessBindings: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.access.access_pb2.SetAccessBindingsRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Sets access bindings for the key."""

    UpdateAccessBindings: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.access.access_pb2.UpdateAccessBindingsRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates access bindings for the specified key."""

class SymmetricKeyServiceServicer(metaclass=abc.ABCMeta):
    """Set of methods for managing symmetric KMS keys."""

    @abc.abstractmethod
    def Create(
        self,
        request: yandex.cloud.kms.v1.symmetric_key_service_pb2.CreateSymmetricKeyRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """--- control plane

        Creates a symmetric KMS key in the specified folder.
        """

    @abc.abstractmethod
    def Get(
        self,
        request: yandex.cloud.kms.v1.symmetric_key_service_pb2.GetSymmetricKeyRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.kms.v1.symmetric_key_pb2.SymmetricKey, collections.abc.Awaitable[yandex.cloud.kms.v1.symmetric_key_pb2.SymmetricKey]]:
        """Returns the specified symmetric KMS key.

         To get the list of available symmetric KMS keys, make a [SymmetricKeyService.List] request.
        """

    @abc.abstractmethod
    def List(
        self,
        request: yandex.cloud.kms.v1.symmetric_key_service_pb2.ListSymmetricKeysRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.kms.v1.symmetric_key_service_pb2.ListSymmetricKeysResponse, collections.abc.Awaitable[yandex.cloud.kms.v1.symmetric_key_service_pb2.ListSymmetricKeysResponse]]:
        """Returns the list of symmetric KMS keys in the specified folder."""

    @abc.abstractmethod
    def ListVersions(
        self,
        request: yandex.cloud.kms.v1.symmetric_key_service_pb2.ListSymmetricKeyVersionsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.kms.v1.symmetric_key_service_pb2.ListSymmetricKeyVersionsResponse, collections.abc.Awaitable[yandex.cloud.kms.v1.symmetric_key_service_pb2.ListSymmetricKeyVersionsResponse]]:
        """Returns the list of versions of the specified symmetric KMS key."""

    @abc.abstractmethod
    def Update(
        self,
        request: yandex.cloud.kms.v1.symmetric_key_service_pb2.UpdateSymmetricKeyRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Updates the specified symmetric KMS key."""

    @abc.abstractmethod
    def Delete(
        self,
        request: yandex.cloud.kms.v1.symmetric_key_service_pb2.DeleteSymmetricKeyRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Deletes the specified symmetric KMS key. This action also automatically schedules
        the destruction of all of the key's versions in 72 hours.

        The key and its versions appear absent in [SymmetricKeyService.Get] and [SymmetricKeyService.List]
        requests, but can be restored within 72 hours with a request to tech support.
        """

    @abc.abstractmethod
    def SetPrimaryVersion(
        self,
        request: yandex.cloud.kms.v1.symmetric_key_service_pb2.SetPrimarySymmetricKeyVersionRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Sets the primary version for the specified key. The primary version is used
        by default for all encrypt/decrypt operations where no version ID is specified.
        """

    @abc.abstractmethod
    def ScheduleVersionDestruction(
        self,
        request: yandex.cloud.kms.v1.symmetric_key_service_pb2.ScheduleSymmetricKeyVersionDestructionRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Schedules the specified key version for destruction.

        Scheduled destruction can be cancelled with the [SymmetricKeyService.CancelVersionDestruction] method.
        """

    @abc.abstractmethod
    def CancelVersionDestruction(
        self,
        request: yandex.cloud.kms.v1.symmetric_key_service_pb2.CancelSymmetricKeyVersionDestructionRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Cancels previously scheduled version destruction, if the version hasn't been destroyed yet."""

    @abc.abstractmethod
    def Rotate(
        self,
        request: yandex.cloud.kms.v1.symmetric_key_service_pb2.RotateSymmetricKeyRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Rotates the specified key: creates a new key version and makes it the primary version.
        The old version remains available for decryption of ciphertext encrypted with it.
        """

    @abc.abstractmethod
    def ListOperations(
        self,
        request: yandex.cloud.kms.v1.symmetric_key_service_pb2.ListSymmetricKeyOperationsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.kms.v1.symmetric_key_service_pb2.ListSymmetricKeyOperationsResponse, collections.abc.Awaitable[yandex.cloud.kms.v1.symmetric_key_service_pb2.ListSymmetricKeyOperationsResponse]]:
        """Lists operations for the specified symmetric KMS key."""

    @abc.abstractmethod
    def ListAccessBindings(
        self,
        request: yandex.cloud.access.access_pb2.ListAccessBindingsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.access.access_pb2.ListAccessBindingsResponse, collections.abc.Awaitable[yandex.cloud.access.access_pb2.ListAccessBindingsResponse]]:
        """Lists existing access bindings for the specified key."""

    @abc.abstractmethod
    def SetAccessBindings(
        self,
        request: yandex.cloud.access.access_pb2.SetAccessBindingsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Sets access bindings for the key."""

    @abc.abstractmethod
    def UpdateAccessBindings(
        self,
        request: yandex.cloud.access.access_pb2.UpdateAccessBindingsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Updates access bindings for the specified key."""

def add_SymmetricKeyServiceServicer_to_server(servicer: SymmetricKeyServiceServicer, server: typing.Union[grpc.Server, grpc.aio.Server]) -> None: ...
