"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.loadtesting.api.v1.agent.agent_pb2
import yandex.cloud.loadtesting.api.v1.agent.create_compute_instance_pb2
import yandex.cloud.loadtesting.api.v1.agent.log_settings_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class CreateAgentRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    COMPUTE_INSTANCE_PARAMS_FIELD_NUMBER: builtins.int
    AGENT_VERSION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    LOG_SETTINGS_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to create an agent in."""
    name: builtins.str
    """Name of the agent.

    A created compute instance will have the same name.
    """
    description: builtins.str
    """Description of the agent.

    A created compute instance will have the same description.
    """
    agent_version: builtins.str
    """Version of the agent.

    If not provided, the most recent agent version will be used.
    """
    @property
    def compute_instance_params(self) -> yandex.cloud.loadtesting.api.v1.agent.create_compute_instance_pb2.CreateComputeInstance:
        """Parameters for compute instance to be created."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Agent labels as `key:value` pairs."""

    @property
    def log_settings(self) -> yandex.cloud.loadtesting.api.v1.agent.log_settings_pb2.LogSettings:
        """Agent log settings"""

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        compute_instance_params: yandex.cloud.loadtesting.api.v1.agent.create_compute_instance_pb2.CreateComputeInstance | None = ...,
        agent_version: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        log_settings: yandex.cloud.loadtesting.api.v1.agent.log_settings_pb2.LogSettings | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["compute_instance_params", b"compute_instance_params", "log_settings", b"log_settings"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["agent_version", b"agent_version", "compute_instance_params", b"compute_instance_params", "description", b"description", "folder_id", b"folder_id", "labels", b"labels", "log_settings", b"log_settings", "name", b"name"]) -> None: ...

global___CreateAgentRequest = CreateAgentRequest

@typing.final
class CreateAgentMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AGENT_ID_FIELD_NUMBER: builtins.int
    agent_id: builtins.str
    """ID of the agent that is being created."""
    def __init__(
        self,
        *,
        agent_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["agent_id", b"agent_id"]) -> None: ...

global___CreateAgentMetadata = CreateAgentMetadata

@typing.final
class GetAgentRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AGENT_ID_FIELD_NUMBER: builtins.int
    agent_id: builtins.str
    """ID of the agent to return."""
    def __init__(
        self,
        *,
        agent_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["agent_id", b"agent_id"]) -> None: ...

global___GetAgentRequest = GetAgentRequest

@typing.final
class DeleteAgentRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AGENT_ID_FIELD_NUMBER: builtins.int
    agent_id: builtins.str
    """ID of the agent to delete."""
    def __init__(
        self,
        *,
        agent_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["agent_id", b"agent_id"]) -> None: ...

global___DeleteAgentRequest = DeleteAgentRequest

@typing.final
class DeleteAgentMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AGENT_ID_FIELD_NUMBER: builtins.int
    agent_id: builtins.str
    """ID of the agent that is being deleted."""
    def __init__(
        self,
        *,
        agent_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["agent_id", b"agent_id"]) -> None: ...

global___DeleteAgentMetadata = DeleteAgentMetadata

@typing.final
class ListAgentsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to list agents in."""
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than `page_size`, the service returns a [ListAgentsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `page_token` to the 
    [ListAgentsResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters agents listed in the response.

    The filter expression may contain multiple field expressions joined by `AND`.
    The field expression must specify:
    1. The field name.
    2. An operator:
       - `=`, `!=`, `CONTAINS`, for single values.
       - `IN` or `NOT IN` for lists of values.
    3. The value. String values must be encosed in `"`, boolean values are {`true`, `false`}, timestamp values in ISO-8601.

    Currently supported fields:
    - `id` [yandex.cloud.loadtesting.api.v1.agent.Agent.id]
      - operators: `=`, `!=`, `IN`, `NOT IN`
    - `name` [yandex.cloud.loadtesting.api.v1.agent.Agent.name]
      - operators: `=`, `!=`, `IN`, `NOT IN`, `CONTAINS`

    Examples: 
    - `id IN ("1", "2", "3")`
    - `name CONTAINS "compute-agent-large" AND id NOT IN ("4", "5")`
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "folder_id", b"folder_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListAgentsRequest = ListAgentsRequest

@typing.final
class ListAgentsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AGENTS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListAgentsRequest.page_size], use `next_page_token` as the value
    for the [ListAgentsRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def agents(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.loadtesting.api.v1.agent.agent_pb2.Agent]:
        """List of agents in the specified folder."""

    def __init__(
        self,
        *,
        agents: collections.abc.Iterable[yandex.cloud.loadtesting.api.v1.agent.agent_pb2.Agent] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["agents", b"agents", "next_page_token", b"next_page_token"]) -> None: ...

global___ListAgentsResponse = ListAgentsResponse

@typing.final
class UpdateAgentRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    AGENT_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    COMPUTE_INSTANCE_PARAMS_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    agent_id: builtins.str
    """ID of the agent to update."""
    name: builtins.str
    """New name of the agent."""
    description: builtins.str
    """New description of the agent."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which attributes of the agent are going to be updated."""

    @property
    def compute_instance_params(self) -> yandex.cloud.loadtesting.api.v1.agent.create_compute_instance_pb2.CreateComputeInstance:
        """New parameters of compute instance managed by the agent."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """New labels of the agent."""

    def __init__(
        self,
        *,
        agent_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        compute_instance_params: yandex.cloud.loadtesting.api.v1.agent.create_compute_instance_pb2.CreateComputeInstance | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["compute_instance_params", b"compute_instance_params", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["agent_id", b"agent_id", "compute_instance_params", b"compute_instance_params", "description", b"description", "labels", b"labels", "name", b"name", "update_mask", b"update_mask"]) -> None: ...

global___UpdateAgentRequest = UpdateAgentRequest

@typing.final
class UpdateAgentMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AGENT_ID_FIELD_NUMBER: builtins.int
    agent_id: builtins.str
    """ID of the agent that is being updated."""
    def __init__(
        self,
        *,
        agent_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["agent_id", b"agent_id"]) -> None: ...

global___UpdateAgentMetadata = UpdateAgentMetadata
