"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.logging.v1.sink_pb2
import yandex.cloud.operation.operation_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetSinkRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SINK_ID_FIELD_NUMBER: builtins.int
    sink_id: builtins.str
    """ID of the sink to return.

    To get a sink ID make a [SinkService.List] request.
    """
    def __init__(
        self,
        *,
        sink_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["sink_id", b"sink_id"]) -> None: ...

global___GetSinkRequest = GetSinkRequest

@typing.final
class ListSinksRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """Folder ID of the sinks to return.

    To get a folder ID make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than `page_size`, the service returns a [ListSinkssResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.

    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `page_token` to the
    [ListSinksResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters sinks listed in the response.

    The expression must specify:
    1. The field name. Currently filtering can only be applied to the [Sink.name] field.
    2. An `=` operator.
    3. The value in double quotes (`"`). Must be 3-63 characters long and match the regular expression `[a-z][-a-z0-9]{1,61}[a-z0-9]`.
    Example of a filter: `name="my-sink"`.
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "folder_id", b"folder_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListSinksRequest = ListSinksRequest

@typing.final
class ListSinksResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SINKS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListSinksRequest.page_size], use `next_page_token` as the value
    for the [ListSinksRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def sinks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.logging.v1.sink_pb2.Sink]:
        """List of sinks in the specified folder."""

    def __init__(
        self,
        *,
        sinks: collections.abc.Iterable[yandex.cloud.logging.v1.sink_pb2.Sink] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "sinks", b"sinks"]) -> None: ...

global___ListSinksResponse = ListSinksResponse

@typing.final
class CreateSinkRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    YDS_FIELD_NUMBER: builtins.int
    S3_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to create a sink in.

    To get a folder ID make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
    """
    name: builtins.str
    """Name of the sink.
    The name must be unique within the folder.
    """
    description: builtins.str
    """Description of the sink."""
    service_account_id: builtins.str
    """Logs will be written to the sink on behalf of this service account"""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Sink labels as `key:value` pairs."""

    @property
    def yds(self) -> yandex.cloud.logging.v1.sink_pb2.Sink.Yds:
        """Yandex data stream"""

    @property
    def s3(self) -> yandex.cloud.logging.v1.sink_pb2.Sink.S3:
        """Object storage"""

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        service_account_id: builtins.str = ...,
        yds: yandex.cloud.logging.v1.sink_pb2.Sink.Yds | None = ...,
        s3: yandex.cloud.logging.v1.sink_pb2.Sink.S3 | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["s3", b"s3", "sink", b"sink", "yds", b"yds"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "folder_id", b"folder_id", "labels", b"labels", "name", b"name", "s3", b"s3", "service_account_id", b"service_account_id", "sink", b"sink", "yds", b"yds"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["sink", b"sink"]) -> typing.Literal["yds", "s3"] | None: ...

global___CreateSinkRequest = CreateSinkRequest

@typing.final
class CreateSinkMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SINK_ID_FIELD_NUMBER: builtins.int
    sink_id: builtins.str
    """ID of the sink being created."""
    def __init__(
        self,
        *,
        sink_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["sink_id", b"sink_id"]) -> None: ...

global___CreateSinkMetadata = CreateSinkMetadata

@typing.final
class UpdateSinkRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    SINK_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    YDS_FIELD_NUMBER: builtins.int
    S3_FIELD_NUMBER: builtins.int
    sink_id: builtins.str
    """ID of the sink to update.

    To get a sink ID make a [SinkService.List] request.
    """
    name: builtins.str
    """New name of the sink.
    The name must be unique within the folder.
    """
    description: builtins.str
    """New Description of the sink."""
    service_account_id: builtins.str
    """new service account to use for logs writing to the sink."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which attributes of the function should be updated."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """New sink labels as `key:value` pairs."""

    @property
    def yds(self) -> yandex.cloud.logging.v1.sink_pb2.Sink.Yds:
        """Yandex data stream"""

    @property
    def s3(self) -> yandex.cloud.logging.v1.sink_pb2.Sink.S3:
        """Object storage"""

    def __init__(
        self,
        *,
        sink_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        service_account_id: builtins.str = ...,
        yds: yandex.cloud.logging.v1.sink_pb2.Sink.Yds | None = ...,
        s3: yandex.cloud.logging.v1.sink_pb2.Sink.S3 | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["s3", b"s3", "sink", b"sink", "update_mask", b"update_mask", "yds", b"yds"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "labels", b"labels", "name", b"name", "s3", b"s3", "service_account_id", b"service_account_id", "sink", b"sink", "sink_id", b"sink_id", "update_mask", b"update_mask", "yds", b"yds"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["sink", b"sink"]) -> typing.Literal["yds", "s3"] | None: ...

global___UpdateSinkRequest = UpdateSinkRequest

@typing.final
class UpdateSinkMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SINK_ID_FIELD_NUMBER: builtins.int
    sink_id: builtins.str
    """ID of the sink being updated."""
    def __init__(
        self,
        *,
        sink_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["sink_id", b"sink_id"]) -> None: ...

global___UpdateSinkMetadata = UpdateSinkMetadata

@typing.final
class DeleteSinkRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SINK_ID_FIELD_NUMBER: builtins.int
    sink_id: builtins.str
    """ID of the sink to delete.

    To get a sink ID make a [SinkService.List] request.
    """
    def __init__(
        self,
        *,
        sink_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["sink_id", b"sink_id"]) -> None: ...

global___DeleteSinkRequest = DeleteSinkRequest

@typing.final
class DeleteSinkMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SINK_ID_FIELD_NUMBER: builtins.int
    sink_id: builtins.str
    """ID of the sink being deleted."""
    def __init__(
        self,
        *,
        sink_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["sink_id", b"sink_id"]) -> None: ...

global___DeleteSinkMetadata = DeleteSinkMetadata

@typing.final
class ListSinkOperationsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SINK_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    sink_id: builtins.str
    """ID of the sink to list operations for.

    To get a sink ID make a [SinkService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return. If the number of available
    results is larger than `page_size`, the service returns a [ListSinkOperationsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.

    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set `page_token` to the
    [ListSinkOperationsResponse.next_page_token] returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response.

    The expression must specify:
    1. The field name. Currently filtering can be applied to the [operation.Operation.description], [operation.Operation.created_at], [operation.Operation.modified_at], [operation.Operation.created_by], [operation.Operation.done] fields.
    2. An `=` operator.
    3. The value in double quotes (`"`). Must be 3-63 characters long and match the regular expression `[a-z][-a-z0-9]{1,61}[a-z0-9]`.
    Examples of a filter: `done=false`, `created_by='John.Doe'`.
    """
    def __init__(
        self,
        *,
        sink_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "page_size", b"page_size", "page_token", b"page_token", "sink_id", b"sink_id"]) -> None: ...

global___ListSinkOperationsRequest = ListSinkOperationsRequest

@typing.final
class ListSinkOperationsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list. If the number of results is greater than
    the specified [ListOSinkperationsRequest.page_size], use `next_page_token` as the value
    for the [ListSinkOperationsRequest.page_token] parameter in the next list request.

    Each subsequent page will have its own `next_page_token` to continue paging through the results.
    """
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """List of operations for the specified sink."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListSinkOperationsResponse = ListSinkOperationsResponse
