"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _State:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _StateEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_State.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    STATE_UNSPECIFIED: _State.ValueType  # 0
    ACTIVATED: _State.ValueType  # 1
    """Product instance is activated."""
    DEACTIVATED: _State.ValueType  # 2
    """Product instance is deactivated."""
    PENDING_ACTIVATION: _State.ValueType  # 3
    """Product instance is pending activation."""
    DEPRECATED: _State.ValueType  # 4
    """Product instance is deprecated."""
    DELETED: _State.ValueType  # 5
    """Product instance is deleted."""

class State(_State, metaclass=_StateEnumTypeWrapper): ...

STATE_UNSPECIFIED: State.ValueType  # 0
ACTIVATED: State.ValueType  # 1
"""Product instance is activated."""
DEACTIVATED: State.ValueType  # 2
"""Product instance is deactivated."""
PENDING_ACTIVATION: State.ValueType  # 3
"""Product instance is pending activation."""
DEPRECATED: State.ValueType  # 4
"""Product instance is deprecated."""
DELETED: State.ValueType  # 5
"""Product instance is deleted."""
global___State = State

class _ResourceType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ResourceTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ResourceType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    RESOURCE_TYPE_UNSPECIFIED: _ResourceType.ValueType  # 0
    SAAS: _ResourceType.ValueType  # 1
    """SaaS resource."""
    K8S: _ResourceType.ValueType  # 2
    """Kubernetes resource."""
    COMPUTE: _ResourceType.ValueType  # 3
    """Compute resource."""
    CLOUD_APPS: _ResourceType.ValueType  # 4
    """Cloud Apps resource."""

class ResourceType(_ResourceType, metaclass=_ResourceTypeEnumTypeWrapper): ...

RESOURCE_TYPE_UNSPECIFIED: ResourceType.ValueType  # 0
SAAS: ResourceType.ValueType  # 1
"""SaaS resource."""
K8S: ResourceType.ValueType  # 2
"""Kubernetes resource."""
COMPUTE: ResourceType.ValueType  # 3
"""Compute resource."""
CLOUD_APPS: ResourceType.ValueType  # 4
"""Cloud Apps resource."""
global___ResourceType = ResourceType

@typing.final
class ProductInstance(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class ResourceMetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    RESOURCE_ID_FIELD_NUMBER: builtins.int
    RESOURCE_TYPE_FIELD_NUMBER: builtins.int
    RESOURCE_METADATA_FIELD_NUMBER: builtins.int
    STATE_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    UPDATED_AT_FIELD_NUMBER: builtins.int
    SAAS_INFO_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the product instance."""
    resource_id: builtins.str
    """ID of the resource."""
    resource_type: global___ResourceType.ValueType
    """Type of the resource."""
    state: global___State.ValueType
    """State of the product instance."""
    @property
    def resource_metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Metadata of the resource; Reserved for future use."""

    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp"""

    @property
    def updated_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Update timestamp"""

    @property
    def saas_info(self) -> global___SaasInfo: ...
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        resource_id: builtins.str = ...,
        resource_type: global___ResourceType.ValueType = ...,
        resource_metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        state: global___State.ValueType = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        updated_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        saas_info: global___SaasInfo | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "resource_info", b"resource_info", "saas_info", b"saas_info", "updated_at", b"updated_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["created_at", b"created_at", "id", b"id", "resource_id", b"resource_id", "resource_info", b"resource_info", "resource_metadata", b"resource_metadata", "resource_type", b"resource_type", "saas_info", b"saas_info", "state", b"state", "updated_at", b"updated_at"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["resource_info", b"resource_info"]) -> typing.Literal["saas_info"] | None: ...

global___ProductInstance = ProductInstance

@typing.final
class SaasInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class DataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the SaaS resource."""
    @property
    def data(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Additional data about the SaaS resource."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        data: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["data", b"data", "id", b"id"]) -> None: ...

global___SaasInfo = SaasInfo
