"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import google.protobuf.descriptor
import google.protobuf.message
import google.protobuf.wrappers_pb2
import typing

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class ElasticsearchConfig7(google.protobuf.message.Message):
    """Elasticsearch 7.x supported configuration options are listed here.

    Detailed description for each set of options is available in [Elasticsearch documentation](https://www.elastic.co/guide/en/elasticsearch/reference/current/index.html).

    Any options that are not listed here are not supported.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MAX_CLAUSE_COUNT_FIELD_NUMBER: builtins.int
    FIELDDATA_CACHE_SIZE_FIELD_NUMBER: builtins.int
    REINDEX_REMOTE_WHITELIST_FIELD_NUMBER: builtins.int
    REINDEX_SSL_CA_PATH_FIELD_NUMBER: builtins.int
    fielddata_cache_size: builtins.str
    """The maximum percentage or absolute value (10%, 512mb) of heap space that is allocated to field data cache.

    All the field values that are placed in this cache, get loaded to memory in order to provide fast document based access to those values.
    Building the field data cache for a field can be an expensive operations, so its recommended to have enough memory for this cache, and to keep it loaded.

    Default value: unbounded.

    See in-depth description in [Elasticsearch documentation](https://www.elastic.co/guide/en/elasticsearch/reference/current/modules-fielddata.html).
    """
    reindex_remote_whitelist: builtins.str
    """Remote hosts for reindex have to be explicitly allowed in elasticsearch.yml using the reindex.remote.whitelist property.
    It can be set to a comma delimited list of allowed remote host and port combinations.
    Scheme is ignored, only the host and port are used.
    """
    reindex_ssl_ca_path: builtins.str
    """List of paths to PEM encoded certificate files that should be trusted.

    See in-depth description in [Elasticsearch documentation](https://www.elastic.co/guide/en/elasticsearch/reference/current/docs-reindex.html#reindex-ssl)
    """
    @property
    def max_clause_count(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The maximum number of clauses a boolean query can contain.

        The limit is in place to prevent searches from becoming too large and taking up too much CPU and memory.
        It affects not only Elasticsearch's `bool` query, but many other queries that are implicitly converted to `bool` query by Elastcsearch.

        Default value: `1024`.

        See in-depth description in [Elasticsearch documentation](https://www.elastic.co/guide/en/elasticsearch/reference/current/search-settings.html).
        """

    def __init__(
        self,
        *,
        max_clause_count: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        fielddata_cache_size: builtins.str = ...,
        reindex_remote_whitelist: builtins.str = ...,
        reindex_ssl_ca_path: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["max_clause_count", b"max_clause_count"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["fielddata_cache_size", b"fielddata_cache_size", "max_clause_count", b"max_clause_count", "reindex_remote_whitelist", b"reindex_remote_whitelist", "reindex_ssl_ca_path", b"reindex_ssl_ca_path"]) -> None: ...

global___ElasticsearchConfig7 = ElasticsearchConfig7

@typing.final
class ElasticsearchConfigSet7(google.protobuf.message.Message):
    """Elasticsearch 7.x data node configuration."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EFFECTIVE_CONFIG_FIELD_NUMBER: builtins.int
    USER_CONFIG_FIELD_NUMBER: builtins.int
    DEFAULT_CONFIG_FIELD_NUMBER: builtins.int
    @property
    def effective_config(self) -> global___ElasticsearchConfig7:
        """Effective settings for an Elasticsearch cluster (a combination of settings defined in [user_config] and [default_config])."""

    @property
    def user_config(self) -> global___ElasticsearchConfig7:
        """User-defined settings for an Elasticsearch cluster."""

    @property
    def default_config(self) -> global___ElasticsearchConfig7:
        """Default settings for an Elasticsearch cluster."""

    def __init__(
        self,
        *,
        effective_config: global___ElasticsearchConfig7 | None = ...,
        user_config: global___ElasticsearchConfig7 | None = ...,
        default_config: global___ElasticsearchConfig7 | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["default_config", b"default_config", "effective_config", b"effective_config", "user_config", b"user_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["default_config", b"default_config", "effective_config", b"effective_config", "user_config", b"user_config"]) -> None: ...

global___ElasticsearchConfigSet7 = ElasticsearchConfigSet7
