"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.wrappers_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _LogStatement:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _LogStatementEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_LogStatement.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    LOG_STATEMENT_UNSPECIFIED: _LogStatement.ValueType  # 0
    NONE: _LogStatement.ValueType  # 1
    """None statements are logged."""
    DDL: _LogStatement.ValueType  # 2
    """Logs all data definition commands like `CREATE`, `ALTER`, and `DROP`. Default value."""
    MOD: _LogStatement.ValueType  # 3
    """Logs all `DDL` statements, plus `INSERT`, `UPDATE`, `DELETE`, `TRUNCATE`, and `COPY FROM`."""
    ALL: _LogStatement.ValueType  # 4
    """Logs all statements."""

class LogStatement(_LogStatement, metaclass=_LogStatementEnumTypeWrapper): ...

LOG_STATEMENT_UNSPECIFIED: LogStatement.ValueType  # 0
NONE: LogStatement.ValueType  # 1
"""None statements are logged."""
DDL: LogStatement.ValueType  # 2
"""Logs all data definition commands like `CREATE`, `ALTER`, and `DROP`. Default value."""
MOD: LogStatement.ValueType  # 3
"""Logs all `DDL` statements, plus `INSERT`, `UPDATE`, `DELETE`, `TRUNCATE`, and `COPY FROM`."""
ALL: LogStatement.ValueType  # 4
"""Logs all statements."""
global___LogStatement = LogStatement

@typing.final
class Resources(google.protobuf.message.Message):
    """A list of computational resources allocated to a host."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCE_PRESET_ID_FIELD_NUMBER: builtins.int
    DISK_SIZE_FIELD_NUMBER: builtins.int
    DISK_TYPE_ID_FIELD_NUMBER: builtins.int
    resource_preset_id: builtins.str
    """ID of the preset for computational resources allocated to a host.

    Available presets are listed in the [documentation](/docs/managed-greenplum/concepts/instance-types).
    """
    disk_size: builtins.int
    """Volume of the storage used by the host, in bytes."""
    disk_type_id: builtins.str
    """Type of the storage used by the host: `network-hdd`, `network-ssd` or `local-ssd`."""
    def __init__(
        self,
        *,
        resource_preset_id: builtins.str = ...,
        disk_size: builtins.int = ...,
        disk_type_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["disk_size", b"disk_size", "disk_type_id", b"disk_type_id", "resource_preset_id", b"resource_preset_id"]) -> None: ...

global___Resources = Resources

@typing.final
class ConnectionPoolerConfig(google.protobuf.message.Message):
    """Route server configuration."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _PoolMode:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _PoolModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ConnectionPoolerConfig._PoolMode.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        POOL_MODE_UNSPECIFIED: ConnectionPoolerConfig._PoolMode.ValueType  # 0
        SESSION: ConnectionPoolerConfig._PoolMode.ValueType  # 1
        """Assign server connection to a client until it disconnects. Default value."""
        TRANSACTION: ConnectionPoolerConfig._PoolMode.ValueType  # 2
        """Assign server connection to a client for a transaction processing."""

    class PoolMode(_PoolMode, metaclass=_PoolModeEnumTypeWrapper):
        """Route server pool mode."""

    POOL_MODE_UNSPECIFIED: ConnectionPoolerConfig.PoolMode.ValueType  # 0
    SESSION: ConnectionPoolerConfig.PoolMode.ValueType  # 1
    """Assign server connection to a client until it disconnects. Default value."""
    TRANSACTION: ConnectionPoolerConfig.PoolMode.ValueType  # 2
    """Assign server connection to a client for a transaction processing."""

    MODE_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    CLIENT_IDLE_TIMEOUT_FIELD_NUMBER: builtins.int
    IDLE_IN_TRANSACTION_TIMEOUT_FIELD_NUMBER: builtins.int
    mode: global___ConnectionPoolerConfig.PoolMode.ValueType
    """Route server pool mode."""
    @property
    def size(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The number of servers in the server pool. Clients are placed in a wait queue when all servers are busy.

        Set to zero to disable the limit.
        """

    @property
    def client_idle_timeout(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Client pool idle timeout, in seconds.

        Drop stale client connection after this much seconds of idleness, which is not in transaction.

        Set to zero to disable.
        """

    @property
    def idle_in_transaction_timeout(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Client pool idle in transaction timeout, in seconds.

        Drop client connection in transaction after this much seconds of idleness.

        Set to zero to disable.
        """

    def __init__(
        self,
        *,
        mode: global___ConnectionPoolerConfig.PoolMode.ValueType = ...,
        size: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        client_idle_timeout: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        idle_in_transaction_timeout: google.protobuf.wrappers_pb2.Int64Value | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["client_idle_timeout", b"client_idle_timeout", "idle_in_transaction_timeout", b"idle_in_transaction_timeout", "size", b"size"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["client_idle_timeout", b"client_idle_timeout", "idle_in_transaction_timeout", b"idle_in_transaction_timeout", "mode", b"mode", "size", b"size"]) -> None: ...

global___ConnectionPoolerConfig = ConnectionPoolerConfig

@typing.final
class BackgroundActivityStartAt(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HOURS_FIELD_NUMBER: builtins.int
    MINUTES_FIELD_NUMBER: builtins.int
    hours: builtins.int
    minutes: builtins.int
    def __init__(
        self,
        *,
        hours: builtins.int = ...,
        minutes: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["hours", b"hours", "minutes", b"minutes"]) -> None: ...

global___BackgroundActivityStartAt = BackgroundActivityStartAt

@typing.final
class TableSizes(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STARTS_FIELD_NUMBER: builtins.int
    @property
    def starts(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BackgroundActivityStartAt]: ...
    def __init__(
        self,
        *,
        starts: collections.abc.Iterable[global___BackgroundActivityStartAt] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["starts", b"starts"]) -> None: ...

global___TableSizes = TableSizes

@typing.final
class AnalyzeAndVacuum(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    START_FIELD_NUMBER: builtins.int
    ANALYZE_TIMEOUT_FIELD_NUMBER: builtins.int
    VACUUM_TIMEOUT_FIELD_NUMBER: builtins.int
    @property
    def start(self) -> global___BackgroundActivityStartAt: ...
    @property
    def analyze_timeout(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Maximum duration of the `ANALYZE` operation, in seconds. The default value is `36000`. As soon as this period expires, the `ANALYZE` operation will be forced to terminate."""

    @property
    def vacuum_timeout(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Maximum duration of the `VACUUM` operation, in seconds. The default value is `36000`. As soon as this period expires, the `VACUUM` operation will be forced to terminate."""

    def __init__(
        self,
        *,
        start: global___BackgroundActivityStartAt | None = ...,
        analyze_timeout: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        vacuum_timeout: google.protobuf.wrappers_pb2.Int64Value | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["analyze_timeout", b"analyze_timeout", "start", b"start", "vacuum_timeout", b"vacuum_timeout"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["analyze_timeout", b"analyze_timeout", "start", b"start", "vacuum_timeout", b"vacuum_timeout"]) -> None: ...

global___AnalyzeAndVacuum = AnalyzeAndVacuum

@typing.final
class BackgroundActivitiesConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TABLE_SIZES_FIELD_NUMBER: builtins.int
    ANALYZE_AND_VACUUM_FIELD_NUMBER: builtins.int
    QUERY_KILLER_SCRIPTS_FIELD_NUMBER: builtins.int
    @property
    def table_sizes(self) -> global___TableSizes:
        """Enables scripts that collects tables sizes to `*_sizes` tables in `mdb_toolkit` schema."""

    @property
    def analyze_and_vacuum(self) -> global___AnalyzeAndVacuum:
        """Configuration for `ANALYZE` and `VACUUM` operations."""

    @property
    def query_killer_scripts(self) -> global___QueryKillerScripts:
        """Configuration for long running queries killer."""

    def __init__(
        self,
        *,
        table_sizes: global___TableSizes | None = ...,
        analyze_and_vacuum: global___AnalyzeAndVacuum | None = ...,
        query_killer_scripts: global___QueryKillerScripts | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["analyze_and_vacuum", b"analyze_and_vacuum", "query_killer_scripts", b"query_killer_scripts", "table_sizes", b"table_sizes"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["analyze_and_vacuum", b"analyze_and_vacuum", "query_killer_scripts", b"query_killer_scripts", "table_sizes", b"table_sizes"]) -> None: ...

global___BackgroundActivitiesConfig = BackgroundActivitiesConfig

@typing.final
class QueryKiller(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENABLE_FIELD_NUMBER: builtins.int
    MAX_AGE_FIELD_NUMBER: builtins.int
    IGNORE_USERS_FIELD_NUMBER: builtins.int
    @property
    def enable(self) -> google.protobuf.wrappers_pb2.BoolValue: ...
    @property
    def max_age(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Maximum duration for this type of queries (in seconds)."""

    @property
    def ignore_users(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Ignore these users when considering queries to terminate"""

    def __init__(
        self,
        *,
        enable: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        max_age: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        ignore_users: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["enable", b"enable", "max_age", b"max_age"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["enable", b"enable", "ignore_users", b"ignore_users", "max_age", b"max_age"]) -> None: ...

global___QueryKiller = QueryKiller

@typing.final
class QueryKillerScripts(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IDLE_FIELD_NUMBER: builtins.int
    IDLE_IN_TRANSACTION_FIELD_NUMBER: builtins.int
    LONG_RUNNING_FIELD_NUMBER: builtins.int
    @property
    def idle(self) -> global___QueryKiller:
        """Configuration of script that kills long running queries that are in `idle` state."""

    @property
    def idle_in_transaction(self) -> global___QueryKiller:
        """Configuration of script that kills long running queries that are in `idle in transaction` state."""

    @property
    def long_running(self) -> global___QueryKiller:
        """Configuration of script that kills long running queries (in any state)."""

    def __init__(
        self,
        *,
        idle: global___QueryKiller | None = ...,
        idle_in_transaction: global___QueryKiller | None = ...,
        long_running: global___QueryKiller | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["idle", b"idle", "idle_in_transaction", b"idle_in_transaction", "long_running", b"long_running"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["idle", b"idle", "idle_in_transaction", b"idle_in_transaction", "long_running", b"long_running"]) -> None: ...

global___QueryKillerScripts = QueryKillerScripts

@typing.final
class MasterSubclusterConfig(google.protobuf.message.Message):
    """Configuration of the master subcluster."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCES_FIELD_NUMBER: builtins.int
    @property
    def resources(self) -> global___Resources:
        """Computational resources allocated to Greenplum® master subcluster hosts."""

    def __init__(
        self,
        *,
        resources: global___Resources | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["resources", b"resources"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["resources", b"resources"]) -> None: ...

global___MasterSubclusterConfig = MasterSubclusterConfig

@typing.final
class SegmentSubclusterConfig(google.protobuf.message.Message):
    """Configuration of the segment subcluster."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCES_FIELD_NUMBER: builtins.int
    @property
    def resources(self) -> global___Resources:
        """Computational resources allocated to Greenplum® segment subcluster hosts."""

    def __init__(
        self,
        *,
        resources: global___Resources | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["resources", b"resources"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["resources", b"resources"]) -> None: ...

global___SegmentSubclusterConfig = SegmentSubclusterConfig

@typing.final
class GreenplumConfig6(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MAX_CONNECTIONS_FIELD_NUMBER: builtins.int
    MAX_SLOT_WAL_KEEP_SIZE_FIELD_NUMBER: builtins.int
    GP_WORKFILE_LIMIT_PER_SEGMENT_FIELD_NUMBER: builtins.int
    GP_WORKFILE_LIMIT_PER_QUERY_FIELD_NUMBER: builtins.int
    GP_WORKFILE_LIMIT_FILES_PER_QUERY_FIELD_NUMBER: builtins.int
    MAX_PREPARED_TRANSACTIONS_FIELD_NUMBER: builtins.int
    GP_WORKFILE_COMPRESSION_FIELD_NUMBER: builtins.int
    MAX_STATEMENT_MEM_FIELD_NUMBER: builtins.int
    LOG_STATEMENT_FIELD_NUMBER: builtins.int
    GP_ADD_COLUMN_INHERITS_TABLE_SETTING_FIELD_NUMBER: builtins.int
    GP_ENABLE_GLOBAL_DEADLOCK_DETECTOR_FIELD_NUMBER: builtins.int
    GP_GLOBAL_DEADLOCK_DETECTOR_PERIOD_FIELD_NUMBER: builtins.int
    log_statement: global___LogStatement.ValueType
    """Controls which SQL statements are logged. DDL logs all data definition commands like CREATE, ALTER, and DROP commands.
    MOD logs all DDL statements, plus INSERT, UPDATE, DELETE, TRUNCATE, and COPY FROM.
    PREPARE and EXPLAIN ANALYZE statements are also logged if their contained command is of an appropriate type.
    https://docs.greenplum.org/6-5/ref_guide/config_params/guc-list.html#log_statement
    Default value is ddl
    """
    @property
    def max_connections(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Maximum number of inbound connections on master segment"""

    @property
    def max_slot_wal_keep_size(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Specify the maximum size of WAL files that replication slots are allowed to retain in the pg_wal directory at checkpoint time.
        https://www.postgresql.org/docs/current/runtime-config-replication.html
        """

    @property
    def gp_workfile_limit_per_segment(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Sets the maximum total disk size that all running queries are allowed to use for creating temporary spill files at each segment.
        The default value is 0, which means a limit is not enforced.
        https://docs.greenplum.org/6-5/ref_guide/config_params/guc-list.html#gp_workfile_limit_per_segment
        """

    @property
    def gp_workfile_limit_per_query(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Sets the maximum disk size an individual query is allowed to use for creating temporary spill files at each segment.
        The default value is 0, which means a limit is not enforced.
        https://docs.greenplum.org/6-5/ref_guide/config_params/guc-list.html#gp_workfile_limit_per_query
        """

    @property
    def gp_workfile_limit_files_per_query(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Sets the maximum number of temporary spill files (also known as workfiles) allowed per query per segment.
        Spill files are created when executing a query that requires more memory than it is allocated.
        The current query is terminated when the limit is exceeded.
        Set the value to 0 (zero) to allow an unlimited number of spill files. master session reload
        https://docs.greenplum.org/6-5/ref_guide/config_params/guc-list.html#gp_workfile_limit_files_per_query
        Default value is 10000
        """

    @property
    def max_prepared_transactions(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Sets the maximum number of transactions that can be in the "prepared" state simultaneously
        https://www.postgresql.org/docs/9.6/runtime-config-resource.html
        """

    @property
    def gp_workfile_compression(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Specifies whether the temporary files created, when a hash aggregation or hash join operation spills to disk, are compressed.
        https://docs.greenplum.org/6-5/ref_guide/config_params/guc-list.html#gp_workfile_compression
        """

    @property
    def max_statement_mem(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Sets the maximum memory limit for a query. Helps avoid out-of-memory errors on a segment host during query processing as a result of setting statement_mem too high.
        Taking into account the configuration of a single segment host, calculate max_statement_mem as follows:
        (seghost_physical_memory) / (average_number_concurrent_queries)
        When changing both max_statement_mem and statement_mem, max_statement_mem must be changed first, or listed first in the postgresql.conf file.
        https://greenplum.docs.pivotal.io/6-19/ref_guide/config_params/guc-list.html#max_statement_mem
        Default value is 2097152000 (2000MB)
        in bytes
        """

    @property
    def gp_add_column_inherits_table_setting(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """https://docs.vmware.com/en/VMware-Tanzu-Greenplum/6/greenplum-database/GUID-ref_guide-config_params-guc-list.html#gp_add_column_inherits_table_setting"""

    @property
    def gp_enable_global_deadlock_detector(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Controls whether the Greenplum Database Global Deadlock Detector is enabled to manage concurrent UPDATE and DELETE operations on heap tables to improve performance. See Inserting, Updating, and Deleting Datain the Greenplum Database Administrator Guide. The default is off, the Global Deadlock Detector is deactivated.
        If the Global Deadlock Detector is deactivated (the default), Greenplum Database runs concurrent update and delete operations on a heap table serially.
        If the Global Deadlock Detector is enabled, concurrent updates are permitted and the Global Deadlock Detector determines when a deadlock exists, and breaks the deadlock by cancelling one or more backend processes associated with the youngest transaction(s) involved.
        https://techdocs.broadcom.com/us/en/vmware-tanzu/data-solutions/tanzu-greenplum/6/greenplum-database/ref_guide-config_params-guc-list.html#gp_enable_global_deadlock_detector
        """

    @property
    def gp_global_deadlock_detector_period(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Specifies the executing interval (in seconds) of the global deadlock detector background worker process.
        https://techdocs.broadcom.com/us/en/vmware-tanzu/data-solutions/tanzu-greenplum/6/greenplum-database/ref_guide-config_params-guc-list.html#gp_global_deadlock_detector_period
        """

    def __init__(
        self,
        *,
        max_connections: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        max_slot_wal_keep_size: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        gp_workfile_limit_per_segment: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        gp_workfile_limit_per_query: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        gp_workfile_limit_files_per_query: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        max_prepared_transactions: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        gp_workfile_compression: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        max_statement_mem: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        log_statement: global___LogStatement.ValueType = ...,
        gp_add_column_inherits_table_setting: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        gp_enable_global_deadlock_detector: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        gp_global_deadlock_detector_period: google.protobuf.wrappers_pb2.Int64Value | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["gp_add_column_inherits_table_setting", b"gp_add_column_inherits_table_setting", "gp_enable_global_deadlock_detector", b"gp_enable_global_deadlock_detector", "gp_global_deadlock_detector_period", b"gp_global_deadlock_detector_period", "gp_workfile_compression", b"gp_workfile_compression", "gp_workfile_limit_files_per_query", b"gp_workfile_limit_files_per_query", "gp_workfile_limit_per_query", b"gp_workfile_limit_per_query", "gp_workfile_limit_per_segment", b"gp_workfile_limit_per_segment", "max_connections", b"max_connections", "max_prepared_transactions", b"max_prepared_transactions", "max_slot_wal_keep_size", b"max_slot_wal_keep_size", "max_statement_mem", b"max_statement_mem"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["gp_add_column_inherits_table_setting", b"gp_add_column_inherits_table_setting", "gp_enable_global_deadlock_detector", b"gp_enable_global_deadlock_detector", "gp_global_deadlock_detector_period", b"gp_global_deadlock_detector_period", "gp_workfile_compression", b"gp_workfile_compression", "gp_workfile_limit_files_per_query", b"gp_workfile_limit_files_per_query", "gp_workfile_limit_per_query", b"gp_workfile_limit_per_query", "gp_workfile_limit_per_segment", b"gp_workfile_limit_per_segment", "log_statement", b"log_statement", "max_connections", b"max_connections", "max_prepared_transactions", b"max_prepared_transactions", "max_slot_wal_keep_size", b"max_slot_wal_keep_size", "max_statement_mem", b"max_statement_mem"]) -> None: ...

global___GreenplumConfig6 = GreenplumConfig6

@typing.final
class GreenplumConfig6_22(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MAX_CONNECTIONS_FIELD_NUMBER: builtins.int
    MAX_SLOT_WAL_KEEP_SIZE_FIELD_NUMBER: builtins.int
    GP_WORKFILE_LIMIT_PER_SEGMENT_FIELD_NUMBER: builtins.int
    GP_WORKFILE_LIMIT_PER_QUERY_FIELD_NUMBER: builtins.int
    GP_WORKFILE_LIMIT_FILES_PER_QUERY_FIELD_NUMBER: builtins.int
    MAX_PREPARED_TRANSACTIONS_FIELD_NUMBER: builtins.int
    GP_WORKFILE_COMPRESSION_FIELD_NUMBER: builtins.int
    MAX_STATEMENT_MEM_FIELD_NUMBER: builtins.int
    LOG_STATEMENT_FIELD_NUMBER: builtins.int
    GP_ADD_COLUMN_INHERITS_TABLE_SETTING_FIELD_NUMBER: builtins.int
    log_statement: global___LogStatement.ValueType
    """Controls which SQL statements are logged. DDL logs all data definition commands like CREATE, ALTER, and DROP commands.
    MOD logs all DDL statements, plus INSERT, UPDATE, DELETE, TRUNCATE, and COPY FROM.
    PREPARE and EXPLAIN ANALYZE statements are also logged if their contained command is of an appropriate type.
    https://docs.vmware.com/en/VMware-Greenplum/6/greenplum-database/ref_guide-config_params-guc-list.html#log_statement
    Default value is ddl
    """
    @property
    def max_connections(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Maximum number of inbound connections on master segment"""

    @property
    def max_slot_wal_keep_size(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Specify the maximum size of WAL files that replication slots are allowed to retain in the pg_wal directory at checkpoint time.
        https://www.postgresql.org/docs/current/runtime-config-replication.html
        """

    @property
    def gp_workfile_limit_per_segment(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Sets the maximum total disk size that all running queries are allowed to use for creating temporary spill files at each segment.
        The default value is 0, which means a limit is not enforced.
        https://docs.vmware.com/en/VMware-Greenplum/6/greenplum-database/ref_guide-config_params-guc-list.html#gp_workfile_limit_per_segment
        """

    @property
    def gp_workfile_limit_per_query(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Sets the maximum disk size an individual query is allowed to use for creating temporary spill files at each segment.
        The default value is 0, which means a limit is not enforced.
        https://docs.vmware.com/en/VMware-Greenplum/6/greenplum-database/ref_guide-config_params-guc-list.html#gp_workfile_limit_per_query
        """

    @property
    def gp_workfile_limit_files_per_query(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Sets the maximum number of temporary spill files (also known as workfiles) allowed per query per segment.
        Spill files are created when executing a query that requires more memory than it is allocated.
        The current query is terminated when the limit is exceeded.
        Set the value to 0 (zero) to allow an unlimited number of spill files. master session reload
        https://docs.vmware.com/en/VMware-Greenplum/6/greenplum-database/ref_guide-config_params-guc-list.html#gp_workfile_limit_files_per_query
        Default value is 10000
        """

    @property
    def max_prepared_transactions(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Sets the maximum number of transactions that can be in the "prepared" state simultaneously
        https://www.postgresql.org/docs/9.6/runtime-config-resource.html
        """

    @property
    def gp_workfile_compression(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Specifies whether the temporary files created, when a hash aggregation or hash join operation spills to disk, are compressed.
        https://docs.vmware.com/en/VMware-Greenplum/6/greenplum-database/ref_guide-config_params-guc-list.html#gp_workfile_compression
        """

    @property
    def max_statement_mem(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Sets the maximum memory limit for a query. Helps avoid out-of-memory errors on a segment host during query processing as a result of setting statement_mem too high.
        Taking into account the configuration of a single segment host, calculate max_statement_mem as follows:
        (seghost_physical_memory) / (average_number_concurrent_queries)
        When changing both max_statement_mem and statement_mem, max_statement_mem must be changed first, or listed first in the postgresql.conf file.
        https://greenplum.docs.pivotal.io/6-19/ref_guide/config_params/guc-list.html#max_statement_mem
        Default value is 2097152000 (2000MB)
        in bytes
        """

    @property
    def gp_add_column_inherits_table_setting(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """https://docs.vmware.com/en/VMware-Tanzu-Greenplum/6/greenplum-database/GUID-ref_guide-config_params-guc-list.html#gp_add_column_inherits_table_setting"""

    def __init__(
        self,
        *,
        max_connections: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        max_slot_wal_keep_size: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        gp_workfile_limit_per_segment: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        gp_workfile_limit_per_query: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        gp_workfile_limit_files_per_query: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        max_prepared_transactions: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        gp_workfile_compression: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        max_statement_mem: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        log_statement: global___LogStatement.ValueType = ...,
        gp_add_column_inherits_table_setting: google.protobuf.wrappers_pb2.BoolValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["gp_add_column_inherits_table_setting", b"gp_add_column_inherits_table_setting", "gp_workfile_compression", b"gp_workfile_compression", "gp_workfile_limit_files_per_query", b"gp_workfile_limit_files_per_query", "gp_workfile_limit_per_query", b"gp_workfile_limit_per_query", "gp_workfile_limit_per_segment", b"gp_workfile_limit_per_segment", "max_connections", b"max_connections", "max_prepared_transactions", b"max_prepared_transactions", "max_slot_wal_keep_size", b"max_slot_wal_keep_size", "max_statement_mem", b"max_statement_mem"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["gp_add_column_inherits_table_setting", b"gp_add_column_inherits_table_setting", "gp_workfile_compression", b"gp_workfile_compression", "gp_workfile_limit_files_per_query", b"gp_workfile_limit_files_per_query", "gp_workfile_limit_per_query", b"gp_workfile_limit_per_query", "gp_workfile_limit_per_segment", b"gp_workfile_limit_per_segment", "log_statement", b"log_statement", "max_connections", b"max_connections", "max_prepared_transactions", b"max_prepared_transactions", "max_slot_wal_keep_size", b"max_slot_wal_keep_size", "max_statement_mem", b"max_statement_mem"]) -> None: ...

global___GreenplumConfig6_22 = GreenplumConfig6_22

@typing.final
class GreenplumConfigSet6_22(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EFFECTIVE_CONFIG_FIELD_NUMBER: builtins.int
    USER_CONFIG_FIELD_NUMBER: builtins.int
    DEFAULT_CONFIG_FIELD_NUMBER: builtins.int
    @property
    def effective_config(self) -> global___GreenplumConfig6_22:
        """Effective settings for a Greenplum®  cluster (a combination of settings defined in [user_config] and [default_config])."""

    @property
    def user_config(self) -> global___GreenplumConfig6_22:
        """User-defined settings for a Greenplum® cluster."""

    @property
    def default_config(self) -> global___GreenplumConfig6_22:
        """Default configuration for a Greenplum® cluster."""

    def __init__(
        self,
        *,
        effective_config: global___GreenplumConfig6_22 | None = ...,
        user_config: global___GreenplumConfig6_22 | None = ...,
        default_config: global___GreenplumConfig6_22 | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["default_config", b"default_config", "effective_config", b"effective_config", "user_config", b"user_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["default_config", b"default_config", "effective_config", b"effective_config", "user_config", b"user_config"]) -> None: ...

global___GreenplumConfigSet6_22 = GreenplumConfigSet6_22

@typing.final
class GreenplumConfigSet6(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EFFECTIVE_CONFIG_FIELD_NUMBER: builtins.int
    USER_CONFIG_FIELD_NUMBER: builtins.int
    DEFAULT_CONFIG_FIELD_NUMBER: builtins.int
    @property
    def effective_config(self) -> global___GreenplumConfig6:
        """Effective settings for a Greenplum (a combination of settings defined
        in [user_config] and [default_config]).
        """

    @property
    def user_config(self) -> global___GreenplumConfig6:
        """User-defined settings for a Greenplum."""

    @property
    def default_config(self) -> global___GreenplumConfig6:
        """Default configuration for a Greenplum."""

    def __init__(
        self,
        *,
        effective_config: global___GreenplumConfig6 | None = ...,
        user_config: global___GreenplumConfig6 | None = ...,
        default_config: global___GreenplumConfig6 | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["default_config", b"default_config", "effective_config", b"effective_config", "user_config", b"user_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["default_config", b"default_config", "effective_config", b"effective_config", "user_config", b"user_config"]) -> None: ...

global___GreenplumConfigSet6 = GreenplumConfigSet6

@typing.final
class ConnectionPoolerConfigSet(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EFFECTIVE_CONFIG_FIELD_NUMBER: builtins.int
    USER_CONFIG_FIELD_NUMBER: builtins.int
    DEFAULT_CONFIG_FIELD_NUMBER: builtins.int
    @property
    def effective_config(self) -> global___ConnectionPoolerConfig:
        """Effective settings for an Odyssey® pooler (a combination of settings defined in [ConnectionPoolerConfigSet.user_config] and [ConnectionPoolerConfigSet.default_config])."""

    @property
    def user_config(self) -> global___ConnectionPoolerConfig:
        """User-defined settings for an Odyssey® pooler."""

    @property
    def default_config(self) -> global___ConnectionPoolerConfig:
        """Default configuration for an Odyssey® pooler."""

    def __init__(
        self,
        *,
        effective_config: global___ConnectionPoolerConfig | None = ...,
        user_config: global___ConnectionPoolerConfig | None = ...,
        default_config: global___ConnectionPoolerConfig | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["default_config", b"default_config", "effective_config", b"effective_config", "user_config", b"user_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["default_config", b"default_config", "effective_config", b"effective_config", "user_config", b"user_config"]) -> None: ...

global___ConnectionPoolerConfigSet = ConnectionPoolerConfigSet
