"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.wrappers_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class MongodConfig4_2(google.protobuf.message.Message):
    """Configuration of a mongod daemon. Supported options are a limited subset of all
    options described in [MongoDB documentation](https://docs.mongodb.com/v4.2/reference/configuration-options/).
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class Storage(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing.final
        class WiredTiger(google.protobuf.message.Message):
            """Configuration of WiredTiger storage engine."""

            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            @typing.final
            class EngineConfig(google.protobuf.message.Message):
                DESCRIPTOR: google.protobuf.descriptor.Descriptor

                CACHE_SIZE_GB_FIELD_NUMBER: builtins.int
                @property
                def cache_size_gb(self) -> google.protobuf.wrappers_pb2.DoubleValue:
                    """The maximum size of the internal cache that WiredTiger will use for all data."""

                def __init__(
                    self,
                    *,
                    cache_size_gb: google.protobuf.wrappers_pb2.DoubleValue | None = ...,
                ) -> None: ...
                def HasField(self, field_name: typing.Literal["cache_size_gb", b"cache_size_gb"]) -> builtins.bool: ...
                def ClearField(self, field_name: typing.Literal["cache_size_gb", b"cache_size_gb"]) -> None: ...

            @typing.final
            class CollectionConfig(google.protobuf.message.Message):
                DESCRIPTOR: google.protobuf.descriptor.Descriptor

                class _Compressor:
                    ValueType = typing.NewType("ValueType", builtins.int)
                    V: typing_extensions.TypeAlias = ValueType

                class _CompressorEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MongodConfig4_2.Storage.WiredTiger.CollectionConfig._Compressor.ValueType], builtins.type):
                    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
                    COMPRESSOR_UNSPECIFIED: MongodConfig4_2.Storage.WiredTiger.CollectionConfig._Compressor.ValueType  # 0
                    NONE: MongodConfig4_2.Storage.WiredTiger.CollectionConfig._Compressor.ValueType  # 1
                    """No compression."""
                    SNAPPY: MongodConfig4_2.Storage.WiredTiger.CollectionConfig._Compressor.ValueType  # 2
                    """The [Snappy](https://docs.mongodb.com/v4.2/reference/glossary/#term-snappy) compression."""
                    ZLIB: MongodConfig4_2.Storage.WiredTiger.CollectionConfig._Compressor.ValueType  # 3
                    """The [zlib](https://docs.mongodb.com/v4.2/reference/glossary/#term-zlib) compression."""
                    ZSTD: MongodConfig4_2.Storage.WiredTiger.CollectionConfig._Compressor.ValueType  # 4
                    """The [zstd](https://docs.mongodb.com/v4.2/reference/glossary/#term-zstd) compression."""

                class Compressor(_Compressor, metaclass=_CompressorEnumTypeWrapper): ...
                COMPRESSOR_UNSPECIFIED: MongodConfig4_2.Storage.WiredTiger.CollectionConfig.Compressor.ValueType  # 0
                NONE: MongodConfig4_2.Storage.WiredTiger.CollectionConfig.Compressor.ValueType  # 1
                """No compression."""
                SNAPPY: MongodConfig4_2.Storage.WiredTiger.CollectionConfig.Compressor.ValueType  # 2
                """The [Snappy](https://docs.mongodb.com/v4.2/reference/glossary/#term-snappy) compression."""
                ZLIB: MongodConfig4_2.Storage.WiredTiger.CollectionConfig.Compressor.ValueType  # 3
                """The [zlib](https://docs.mongodb.com/v4.2/reference/glossary/#term-zlib) compression."""
                ZSTD: MongodConfig4_2.Storage.WiredTiger.CollectionConfig.Compressor.ValueType  # 4
                """The [zstd](https://docs.mongodb.com/v4.2/reference/glossary/#term-zstd) compression."""

                BLOCK_COMPRESSOR_FIELD_NUMBER: builtins.int
                block_compressor: global___MongodConfig4_2.Storage.WiredTiger.CollectionConfig.Compressor.ValueType
                """Default type of compression to use for collection data."""
                def __init__(
                    self,
                    *,
                    block_compressor: global___MongodConfig4_2.Storage.WiredTiger.CollectionConfig.Compressor.ValueType = ...,
                ) -> None: ...
                def ClearField(self, field_name: typing.Literal["block_compressor", b"block_compressor"]) -> None: ...

            @typing.final
            class IndexConfig(google.protobuf.message.Message):
                DESCRIPTOR: google.protobuf.descriptor.Descriptor

                PREFIX_COMPRESSION_FIELD_NUMBER: builtins.int
                @property
                def prefix_compression(self) -> google.protobuf.wrappers_pb2.BoolValue:
                    """Enables or disables [prefix compression](https://www.mongodb.com/docs/manual/reference/glossary/#std-term-prefix-compression)"""

                def __init__(
                    self,
                    *,
                    prefix_compression: google.protobuf.wrappers_pb2.BoolValue | None = ...,
                ) -> None: ...
                def HasField(self, field_name: typing.Literal["prefix_compression", b"prefix_compression"]) -> builtins.bool: ...
                def ClearField(self, field_name: typing.Literal["prefix_compression", b"prefix_compression"]) -> None: ...

            ENGINE_CONFIG_FIELD_NUMBER: builtins.int
            COLLECTION_CONFIG_FIELD_NUMBER: builtins.int
            INDEX_CONFIG_FIELD_NUMBER: builtins.int
            @property
            def engine_config(self) -> global___MongodConfig4_2.Storage.WiredTiger.EngineConfig:
                """Engine configuration for WiredTiger."""

            @property
            def collection_config(self) -> global___MongodConfig4_2.Storage.WiredTiger.CollectionConfig:
                """Collection configuration for WiredTiger."""

            @property
            def index_config(self) -> global___MongodConfig4_2.Storage.WiredTiger.IndexConfig:
                """Index configuration for WiredTiger"""

            def __init__(
                self,
                *,
                engine_config: global___MongodConfig4_2.Storage.WiredTiger.EngineConfig | None = ...,
                collection_config: global___MongodConfig4_2.Storage.WiredTiger.CollectionConfig | None = ...,
                index_config: global___MongodConfig4_2.Storage.WiredTiger.IndexConfig | None = ...,
            ) -> None: ...
            def HasField(self, field_name: typing.Literal["collection_config", b"collection_config", "engine_config", b"engine_config", "index_config", b"index_config"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing.Literal["collection_config", b"collection_config", "engine_config", b"engine_config", "index_config", b"index_config"]) -> None: ...

        @typing.final
        class Journal(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            COMMIT_INTERVAL_FIELD_NUMBER: builtins.int
            @property
            def commit_interval(self) -> google.protobuf.wrappers_pb2.Int64Value:
                """Commit interval between journal operations, in milliseconds.
                Default: 100.
                """

            def __init__(
                self,
                *,
                commit_interval: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            ) -> None: ...
            def HasField(self, field_name: typing.Literal["commit_interval", b"commit_interval"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing.Literal["commit_interval", b"commit_interval"]) -> None: ...

        WIRED_TIGER_FIELD_NUMBER: builtins.int
        JOURNAL_FIELD_NUMBER: builtins.int
        @property
        def wired_tiger(self) -> global___MongodConfig4_2.Storage.WiredTiger:
            """Configuration of the WiredTiger storage engine."""

        @property
        def journal(self) -> global___MongodConfig4_2.Storage.Journal:
            """Configuration of the MongoDB [journal](https://docs.mongodb.com/v4.2/reference/glossary/#term-journal)."""

        def __init__(
            self,
            *,
            wired_tiger: global___MongodConfig4_2.Storage.WiredTiger | None = ...,
            journal: global___MongodConfig4_2.Storage.Journal | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["journal", b"journal", "wired_tiger", b"wired_tiger"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["journal", b"journal", "wired_tiger", b"wired_tiger"]) -> None: ...

    @typing.final
    class OperationProfiling(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _Mode:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _ModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MongodConfig4_2.OperationProfiling._Mode.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            MODE_UNSPECIFIED: MongodConfig4_2.OperationProfiling._Mode.ValueType  # 0
            OFF: MongodConfig4_2.OperationProfiling._Mode.ValueType  # 1
            """The profiler is off and does not collect any data."""
            SLOW_OP: MongodConfig4_2.OperationProfiling._Mode.ValueType  # 2
            """The profiler collects data for operations that take longer than the value of [slow_op_threshold]."""
            ALL: MongodConfig4_2.OperationProfiling._Mode.ValueType  # 3
            """The profiler collects data for all operations."""

        class Mode(_Mode, metaclass=_ModeEnumTypeWrapper): ...
        MODE_UNSPECIFIED: MongodConfig4_2.OperationProfiling.Mode.ValueType  # 0
        OFF: MongodConfig4_2.OperationProfiling.Mode.ValueType  # 1
        """The profiler is off and does not collect any data."""
        SLOW_OP: MongodConfig4_2.OperationProfiling.Mode.ValueType  # 2
        """The profiler collects data for operations that take longer than the value of [slow_op_threshold]."""
        ALL: MongodConfig4_2.OperationProfiling.Mode.ValueType  # 3
        """The profiler collects data for all operations."""

        MODE_FIELD_NUMBER: builtins.int
        SLOW_OP_THRESHOLD_FIELD_NUMBER: builtins.int
        SLOW_OP_SAMPLE_RATE_FIELD_NUMBER: builtins.int
        mode: global___MongodConfig4_2.OperationProfiling.Mode.ValueType
        """Mode which specifies operations that should be profiled."""
        @property
        def slow_op_threshold(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """The slow operation time threshold, in milliseconds. Operations that run
            for longer than this threshold are considered slow, and are processed by the profiler
            running in the SLOW_OP mode.
            """

        @property
        def slow_op_sample_rate(self) -> google.protobuf.wrappers_pb2.DoubleValue:
            """The fraction of slow operations that should be profiled or logged.
            operationProfiling.slowOpSampleRate accepts values between 0 and 1, inclusive.
            """

        def __init__(
            self,
            *,
            mode: global___MongodConfig4_2.OperationProfiling.Mode.ValueType = ...,
            slow_op_threshold: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            slow_op_sample_rate: google.protobuf.wrappers_pb2.DoubleValue | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["slow_op_sample_rate", b"slow_op_sample_rate", "slow_op_threshold", b"slow_op_threshold"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["mode", b"mode", "slow_op_sample_rate", b"slow_op_sample_rate", "slow_op_threshold", b"slow_op_threshold"]) -> None: ...

    @typing.final
    class Network(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing.final
        class Compression(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            class _Compressor:
                ValueType = typing.NewType("ValueType", builtins.int)
                V: typing_extensions.TypeAlias = ValueType

            class _CompressorEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MongodConfig4_2.Network.Compression._Compressor.ValueType], builtins.type):
                DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
                COMPRESSOR_UNSPECIFIED: MongodConfig4_2.Network.Compression._Compressor.ValueType  # 0
                SNAPPY: MongodConfig4_2.Network.Compression._Compressor.ValueType  # 1
                """The [Snappy](https://docs.mongodb.com/v4.2/reference/glossary/#term-snappy) compression."""
                ZLIB: MongodConfig4_2.Network.Compression._Compressor.ValueType  # 2
                """The [zlib](https://docs.mongodb.com/v4.2/reference/glossary/#term-zlib) compression."""
                ZSTD: MongodConfig4_2.Network.Compression._Compressor.ValueType  # 3
                """The [zstd](https://docs.mongodb.com/v4.2/reference/glossary/#term-zstd) compression."""
                DISABLED: MongodConfig4_2.Network.Compression._Compressor.ValueType  # 4
                """No compression"""

            class Compressor(_Compressor, metaclass=_CompressorEnumTypeWrapper): ...
            COMPRESSOR_UNSPECIFIED: MongodConfig4_2.Network.Compression.Compressor.ValueType  # 0
            SNAPPY: MongodConfig4_2.Network.Compression.Compressor.ValueType  # 1
            """The [Snappy](https://docs.mongodb.com/v4.2/reference/glossary/#term-snappy) compression."""
            ZLIB: MongodConfig4_2.Network.Compression.Compressor.ValueType  # 2
            """The [zlib](https://docs.mongodb.com/v4.2/reference/glossary/#term-zlib) compression."""
            ZSTD: MongodConfig4_2.Network.Compression.Compressor.ValueType  # 3
            """The [zstd](https://docs.mongodb.com/v4.2/reference/glossary/#term-zstd) compression."""
            DISABLED: MongodConfig4_2.Network.Compression.Compressor.ValueType  # 4
            """No compression"""

            COMPRESSORS_FIELD_NUMBER: builtins.int
            @property
            def compressors(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___MongodConfig4_2.Network.Compression.Compressor.ValueType]:
                """Specifies the default compressor(s) to use for communication between this mongod or mongos instance and:
                - other members of the deployment if the instance is part of a replica set or a sharded cluster
                - mongosh
                - drivers that support the OP_COMPRESSED message format.
                MongoDB supports the following compressors:
                """

            def __init__(
                self,
                *,
                compressors: collections.abc.Iterable[global___MongodConfig4_2.Network.Compression.Compressor.ValueType] | None = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing.Literal["compressors", b"compressors"]) -> None: ...

        MAX_INCOMING_CONNECTIONS_FIELD_NUMBER: builtins.int
        COMPRESSION_FIELD_NUMBER: builtins.int
        @property
        def max_incoming_connections(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """The maximum number of simultaneous connections that mongod will accept."""

        @property
        def compression(self) -> global___MongodConfig4_2.Network.Compression:
            """Compression settings"""

        def __init__(
            self,
            *,
            max_incoming_connections: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            compression: global___MongodConfig4_2.Network.Compression | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["compression", b"compression", "max_incoming_connections", b"max_incoming_connections"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["compression", b"compression", "max_incoming_connections", b"max_incoming_connections"]) -> None: ...

    @typing.final
    class SetParameter(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ENABLE_FLOW_CONTROL_FIELD_NUMBER: builtins.int
        @property
        def enable_flow_control(self) -> google.protobuf.wrappers_pb2.BoolValue:
            """Enables or disables the mechanism that controls the rate at which the primary applies its writes with the
            goal of keeping the secondary members [majority committed](https://www.mongodb.com/docs/v4.2/reference/command/replSetGetStatus/#replSetGetStatus.optimes.lastCommittedOpTime)
            lag under a configurable maximum value.
            """

        def __init__(
            self,
            *,
            enable_flow_control: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["enable_flow_control", b"enable_flow_control"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["enable_flow_control", b"enable_flow_control"]) -> None: ...

    STORAGE_FIELD_NUMBER: builtins.int
    OPERATION_PROFILING_FIELD_NUMBER: builtins.int
    NET_FIELD_NUMBER: builtins.int
    SET_PARAMETER_FIELD_NUMBER: builtins.int
    @property
    def storage(self) -> global___MongodConfig4_2.Storage:
        """`storage` section of mongod configuration."""

    @property
    def operation_profiling(self) -> global___MongodConfig4_2.OperationProfiling:
        """`operationProfiling` section of mongod configuration."""

    @property
    def net(self) -> global___MongodConfig4_2.Network:
        """`net` section of mongod configuration."""

    @property
    def set_parameter(self) -> global___MongodConfig4_2.SetParameter:
        """`replication` section of mongod configuration."""

    def __init__(
        self,
        *,
        storage: global___MongodConfig4_2.Storage | None = ...,
        operation_profiling: global___MongodConfig4_2.OperationProfiling | None = ...,
        net: global___MongodConfig4_2.Network | None = ...,
        set_parameter: global___MongodConfig4_2.SetParameter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["net", b"net", "operation_profiling", b"operation_profiling", "set_parameter", b"set_parameter", "storage", b"storage"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["net", b"net", "operation_profiling", b"operation_profiling", "set_parameter", b"set_parameter", "storage", b"storage"]) -> None: ...

global___MongodConfig4_2 = MongodConfig4_2

@typing.final
class MongoCfgConfig4_2(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class Storage(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing.final
        class WiredTiger(google.protobuf.message.Message):
            """Configuration of WiredTiger storage engine."""

            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            @typing.final
            class EngineConfig(google.protobuf.message.Message):
                DESCRIPTOR: google.protobuf.descriptor.Descriptor

                CACHE_SIZE_GB_FIELD_NUMBER: builtins.int
                @property
                def cache_size_gb(self) -> google.protobuf.wrappers_pb2.DoubleValue:
                    """The maximum size of the internal cache that WiredTiger will use for all data."""

                def __init__(
                    self,
                    *,
                    cache_size_gb: google.protobuf.wrappers_pb2.DoubleValue | None = ...,
                ) -> None: ...
                def HasField(self, field_name: typing.Literal["cache_size_gb", b"cache_size_gb"]) -> builtins.bool: ...
                def ClearField(self, field_name: typing.Literal["cache_size_gb", b"cache_size_gb"]) -> None: ...

            ENGINE_CONFIG_FIELD_NUMBER: builtins.int
            @property
            def engine_config(self) -> global___MongoCfgConfig4_2.Storage.WiredTiger.EngineConfig:
                """Engine configuration for WiredTiger."""

            def __init__(
                self,
                *,
                engine_config: global___MongoCfgConfig4_2.Storage.WiredTiger.EngineConfig | None = ...,
            ) -> None: ...
            def HasField(self, field_name: typing.Literal["engine_config", b"engine_config"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing.Literal["engine_config", b"engine_config"]) -> None: ...

        WIRED_TIGER_FIELD_NUMBER: builtins.int
        @property
        def wired_tiger(self) -> global___MongoCfgConfig4_2.Storage.WiredTiger:
            """Configuration of the WiredTiger storage engine."""

        def __init__(
            self,
            *,
            wired_tiger: global___MongoCfgConfig4_2.Storage.WiredTiger | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["wired_tiger", b"wired_tiger"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["wired_tiger", b"wired_tiger"]) -> None: ...

    @typing.final
    class OperationProfiling(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _Mode:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _ModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MongoCfgConfig4_2.OperationProfiling._Mode.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            MODE_UNSPECIFIED: MongoCfgConfig4_2.OperationProfiling._Mode.ValueType  # 0
            OFF: MongoCfgConfig4_2.OperationProfiling._Mode.ValueType  # 1
            """The profiler is off and does not collect any data."""
            SLOW_OP: MongoCfgConfig4_2.OperationProfiling._Mode.ValueType  # 2
            """The profiler collects data for operations that take longer than the value of [slow_op_threshold]."""
            ALL: MongoCfgConfig4_2.OperationProfiling._Mode.ValueType  # 3
            """The profiler collects data for all operations."""

        class Mode(_Mode, metaclass=_ModeEnumTypeWrapper): ...
        MODE_UNSPECIFIED: MongoCfgConfig4_2.OperationProfiling.Mode.ValueType  # 0
        OFF: MongoCfgConfig4_2.OperationProfiling.Mode.ValueType  # 1
        """The profiler is off and does not collect any data."""
        SLOW_OP: MongoCfgConfig4_2.OperationProfiling.Mode.ValueType  # 2
        """The profiler collects data for operations that take longer than the value of [slow_op_threshold]."""
        ALL: MongoCfgConfig4_2.OperationProfiling.Mode.ValueType  # 3
        """The profiler collects data for all operations."""

        MODE_FIELD_NUMBER: builtins.int
        SLOW_OP_THRESHOLD_FIELD_NUMBER: builtins.int
        mode: global___MongoCfgConfig4_2.OperationProfiling.Mode.ValueType
        """Mode which specifies operations that should be profiled."""
        @property
        def slow_op_threshold(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """The slow operation time threshold, in milliseconds. Operations that run
            for longer than this threshold are considered slow, and are processed by the profiler
            running in the SLOW_OP mode. For details see [MongoDB documentation](https://docs.mongodb.com/v4.2/reference/configuration-options/#operationProfiling.slowOpThresholdMs).
            """

        def __init__(
            self,
            *,
            mode: global___MongoCfgConfig4_2.OperationProfiling.Mode.ValueType = ...,
            slow_op_threshold: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["slow_op_threshold", b"slow_op_threshold"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["mode", b"mode", "slow_op_threshold", b"slow_op_threshold"]) -> None: ...

    @typing.final
    class Network(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        MAX_INCOMING_CONNECTIONS_FIELD_NUMBER: builtins.int
        @property
        def max_incoming_connections(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """The maximum number of simultaneous connections that mongocfg will accept."""

        def __init__(
            self,
            *,
            max_incoming_connections: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["max_incoming_connections", b"max_incoming_connections"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["max_incoming_connections", b"max_incoming_connections"]) -> None: ...

    STORAGE_FIELD_NUMBER: builtins.int
    OPERATION_PROFILING_FIELD_NUMBER: builtins.int
    NET_FIELD_NUMBER: builtins.int
    @property
    def storage(self) -> global___MongoCfgConfig4_2.Storage:
        """`storage` section of mongocfg configuration."""

    @property
    def operation_profiling(self) -> global___MongoCfgConfig4_2.OperationProfiling:
        """`operationProfiling` section of mongocfg configuration."""

    @property
    def net(self) -> global___MongoCfgConfig4_2.Network:
        """`net` section of mongocfg configuration."""

    def __init__(
        self,
        *,
        storage: global___MongoCfgConfig4_2.Storage | None = ...,
        operation_profiling: global___MongoCfgConfig4_2.OperationProfiling | None = ...,
        net: global___MongoCfgConfig4_2.Network | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["net", b"net", "operation_profiling", b"operation_profiling", "storage", b"storage"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["net", b"net", "operation_profiling", b"operation_profiling", "storage", b"storage"]) -> None: ...

global___MongoCfgConfig4_2 = MongoCfgConfig4_2

@typing.final
class MongosConfig4_2(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class Network(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing.final
        class Compression(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            class _Compressor:
                ValueType = typing.NewType("ValueType", builtins.int)
                V: typing_extensions.TypeAlias = ValueType

            class _CompressorEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MongosConfig4_2.Network.Compression._Compressor.ValueType], builtins.type):
                DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
                COMPRESSOR_UNSPECIFIED: MongosConfig4_2.Network.Compression._Compressor.ValueType  # 0
                SNAPPY: MongosConfig4_2.Network.Compression._Compressor.ValueType  # 1
                """The [Snappy](https://docs.mongodb.com/v4.2/reference/glossary/#term-snappy) compression."""
                ZLIB: MongosConfig4_2.Network.Compression._Compressor.ValueType  # 2
                """The [zlib](https://docs.mongodb.com/v4.2/reference/glossary/#term-zlib) compression."""
                ZSTD: MongosConfig4_2.Network.Compression._Compressor.ValueType  # 3
                """The [zstd](https://docs.mongodb.com/v4.2/reference/glossary/#term-zstd) compression."""
                DISABLED: MongosConfig4_2.Network.Compression._Compressor.ValueType  # 4
                """No compression"""

            class Compressor(_Compressor, metaclass=_CompressorEnumTypeWrapper): ...
            COMPRESSOR_UNSPECIFIED: MongosConfig4_2.Network.Compression.Compressor.ValueType  # 0
            SNAPPY: MongosConfig4_2.Network.Compression.Compressor.ValueType  # 1
            """The [Snappy](https://docs.mongodb.com/v4.2/reference/glossary/#term-snappy) compression."""
            ZLIB: MongosConfig4_2.Network.Compression.Compressor.ValueType  # 2
            """The [zlib](https://docs.mongodb.com/v4.2/reference/glossary/#term-zlib) compression."""
            ZSTD: MongosConfig4_2.Network.Compression.Compressor.ValueType  # 3
            """The [zstd](https://docs.mongodb.com/v4.2/reference/glossary/#term-zstd) compression."""
            DISABLED: MongosConfig4_2.Network.Compression.Compressor.ValueType  # 4
            """No compression"""

            COMPRESSORS_FIELD_NUMBER: builtins.int
            @property
            def compressors(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___MongosConfig4_2.Network.Compression.Compressor.ValueType]:
                """Specifies the default compressor(s) to use for communication between this mongod or mongos instance and:
                - other members of the deployment if the instance is part of a replica set or a sharded cluster
                - mongosh
                - drivers that support the OP_COMPRESSED message format.
                MongoDB supports the following compressors:
                """

            def __init__(
                self,
                *,
                compressors: collections.abc.Iterable[global___MongosConfig4_2.Network.Compression.Compressor.ValueType] | None = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing.Literal["compressors", b"compressors"]) -> None: ...

        MAX_INCOMING_CONNECTIONS_FIELD_NUMBER: builtins.int
        COMPRESSION_FIELD_NUMBER: builtins.int
        @property
        def max_incoming_connections(self) -> google.protobuf.wrappers_pb2.Int64Value:
            """The maximum number of simultaneous connections that mongos will accept."""

        @property
        def compression(self) -> global___MongosConfig4_2.Network.Compression:
            """Compression settings"""

        def __init__(
            self,
            *,
            max_incoming_connections: google.protobuf.wrappers_pb2.Int64Value | None = ...,
            compression: global___MongosConfig4_2.Network.Compression | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["compression", b"compression", "max_incoming_connections", b"max_incoming_connections"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["compression", b"compression", "max_incoming_connections", b"max_incoming_connections"]) -> None: ...

    NET_FIELD_NUMBER: builtins.int
    @property
    def net(self) -> global___MongosConfig4_2.Network:
        """Network settings for mongos."""

    def __init__(
        self,
        *,
        net: global___MongosConfig4_2.Network | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["net", b"net"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["net", b"net"]) -> None: ...

global___MongosConfig4_2 = MongosConfig4_2

@typing.final
class MongodConfigSet4_2(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EFFECTIVE_CONFIG_FIELD_NUMBER: builtins.int
    USER_CONFIG_FIELD_NUMBER: builtins.int
    DEFAULT_CONFIG_FIELD_NUMBER: builtins.int
    @property
    def effective_config(self) -> global___MongodConfig4_2:
        """Effective mongod settings for a MongoDB 4.2 cluster (a combination of settings defined
        in [user_config] and [default_config]).
        """

    @property
    def user_config(self) -> global___MongodConfig4_2:
        """User-defined mongod settings for a MongoDB 4.2 cluster."""

    @property
    def default_config(self) -> global___MongodConfig4_2:
        """Default mongod configuration for a MongoDB 4.2 cluster."""

    def __init__(
        self,
        *,
        effective_config: global___MongodConfig4_2 | None = ...,
        user_config: global___MongodConfig4_2 | None = ...,
        default_config: global___MongodConfig4_2 | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["default_config", b"default_config", "effective_config", b"effective_config", "user_config", b"user_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["default_config", b"default_config", "effective_config", b"effective_config", "user_config", b"user_config"]) -> None: ...

global___MongodConfigSet4_2 = MongodConfigSet4_2

@typing.final
class MongoCfgConfigSet4_2(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EFFECTIVE_CONFIG_FIELD_NUMBER: builtins.int
    USER_CONFIG_FIELD_NUMBER: builtins.int
    DEFAULT_CONFIG_FIELD_NUMBER: builtins.int
    @property
    def effective_config(self) -> global___MongoCfgConfig4_2:
        """Effective mongocfg settings for a MongoDB 4.2 cluster (a combination of settings defined
        in [user_config] and [default_config]).
        """

    @property
    def user_config(self) -> global___MongoCfgConfig4_2:
        """User-defined mongocfg settings for a MongoDB 4.2 cluster."""

    @property
    def default_config(self) -> global___MongoCfgConfig4_2:
        """Default mongocfg configuration for a MongoDB 4.2 cluster."""

    def __init__(
        self,
        *,
        effective_config: global___MongoCfgConfig4_2 | None = ...,
        user_config: global___MongoCfgConfig4_2 | None = ...,
        default_config: global___MongoCfgConfig4_2 | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["default_config", b"default_config", "effective_config", b"effective_config", "user_config", b"user_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["default_config", b"default_config", "effective_config", b"effective_config", "user_config", b"user_config"]) -> None: ...

global___MongoCfgConfigSet4_2 = MongoCfgConfigSet4_2

@typing.final
class MongosConfigSet4_2(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EFFECTIVE_CONFIG_FIELD_NUMBER: builtins.int
    USER_CONFIG_FIELD_NUMBER: builtins.int
    DEFAULT_CONFIG_FIELD_NUMBER: builtins.int
    @property
    def effective_config(self) -> global___MongosConfig4_2:
        """Effective mongos settings for a MongoDB 4.2 cluster (a combination of settings defined
        in [user_config] and [default_config]).
        """

    @property
    def user_config(self) -> global___MongosConfig4_2:
        """User-defined mongos settings for a MongoDB 4.2 cluster."""

    @property
    def default_config(self) -> global___MongosConfig4_2:
        """Default mongos configuration for a MongoDB 4.2 cluster."""

    def __init__(
        self,
        *,
        effective_config: global___MongosConfig4_2 | None = ...,
        user_config: global___MongosConfig4_2 | None = ...,
        default_config: global___MongosConfig4_2 | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["default_config", b"default_config", "effective_config", b"effective_config", "user_config", b"user_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["default_config", b"default_config", "effective_config", b"effective_config", "user_config", b"user_config"]) -> None: ...

global___MongosConfigSet4_2 = MongosConfigSet4_2
