"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.wrappers_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class MysqlConfig8_0(google.protobuf.message.Message):
    """Options and structure of `MysqlConfig8_0` reflects MySQL 8.0 configuration file."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _SQLMode:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _SQLModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MysqlConfig8_0._SQLMode.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SQLMODE_UNSPECIFIED: MysqlConfig8_0._SQLMode.ValueType  # 0
        ALLOW_INVALID_DATES: MysqlConfig8_0._SQLMode.ValueType  # 1
        ANSI_QUOTES: MysqlConfig8_0._SQLMode.ValueType  # 2
        ERROR_FOR_DIVISION_BY_ZERO: MysqlConfig8_0._SQLMode.ValueType  # 3
        HIGH_NOT_PRECEDENCE: MysqlConfig8_0._SQLMode.ValueType  # 4
        IGNORE_SPACE: MysqlConfig8_0._SQLMode.ValueType  # 5
        NO_AUTO_VALUE_ON_ZERO: MysqlConfig8_0._SQLMode.ValueType  # 6
        NO_BACKSLASH_ESCAPES: MysqlConfig8_0._SQLMode.ValueType  # 7
        NO_ENGINE_SUBSTITUTION: MysqlConfig8_0._SQLMode.ValueType  # 8
        NO_UNSIGNED_SUBTRACTION: MysqlConfig8_0._SQLMode.ValueType  # 9
        NO_ZERO_DATE: MysqlConfig8_0._SQLMode.ValueType  # 10
        NO_ZERO_IN_DATE: MysqlConfig8_0._SQLMode.ValueType  # 11
        ONLY_FULL_GROUP_BY: MysqlConfig8_0._SQLMode.ValueType  # 15
        PAD_CHAR_TO_FULL_LENGTH: MysqlConfig8_0._SQLMode.ValueType  # 16
        PIPES_AS_CONCAT: MysqlConfig8_0._SQLMode.ValueType  # 17
        REAL_AS_FLOAT: MysqlConfig8_0._SQLMode.ValueType  # 18
        STRICT_ALL_TABLES: MysqlConfig8_0._SQLMode.ValueType  # 19
        STRICT_TRANS_TABLES: MysqlConfig8_0._SQLMode.ValueType  # 20
        TIME_TRUNCATE_FRACTIONAL: MysqlConfig8_0._SQLMode.ValueType  # 21
        ANSI: MysqlConfig8_0._SQLMode.ValueType  # 22
        TRADITIONAL: MysqlConfig8_0._SQLMode.ValueType  # 23
        NO_DIR_IN_CREATE: MysqlConfig8_0._SQLMode.ValueType  # 24

    class SQLMode(_SQLMode, metaclass=_SQLModeEnumTypeWrapper): ...
    SQLMODE_UNSPECIFIED: MysqlConfig8_0.SQLMode.ValueType  # 0
    ALLOW_INVALID_DATES: MysqlConfig8_0.SQLMode.ValueType  # 1
    ANSI_QUOTES: MysqlConfig8_0.SQLMode.ValueType  # 2
    ERROR_FOR_DIVISION_BY_ZERO: MysqlConfig8_0.SQLMode.ValueType  # 3
    HIGH_NOT_PRECEDENCE: MysqlConfig8_0.SQLMode.ValueType  # 4
    IGNORE_SPACE: MysqlConfig8_0.SQLMode.ValueType  # 5
    NO_AUTO_VALUE_ON_ZERO: MysqlConfig8_0.SQLMode.ValueType  # 6
    NO_BACKSLASH_ESCAPES: MysqlConfig8_0.SQLMode.ValueType  # 7
    NO_ENGINE_SUBSTITUTION: MysqlConfig8_0.SQLMode.ValueType  # 8
    NO_UNSIGNED_SUBTRACTION: MysqlConfig8_0.SQLMode.ValueType  # 9
    NO_ZERO_DATE: MysqlConfig8_0.SQLMode.ValueType  # 10
    NO_ZERO_IN_DATE: MysqlConfig8_0.SQLMode.ValueType  # 11
    ONLY_FULL_GROUP_BY: MysqlConfig8_0.SQLMode.ValueType  # 15
    PAD_CHAR_TO_FULL_LENGTH: MysqlConfig8_0.SQLMode.ValueType  # 16
    PIPES_AS_CONCAT: MysqlConfig8_0.SQLMode.ValueType  # 17
    REAL_AS_FLOAT: MysqlConfig8_0.SQLMode.ValueType  # 18
    STRICT_ALL_TABLES: MysqlConfig8_0.SQLMode.ValueType  # 19
    STRICT_TRANS_TABLES: MysqlConfig8_0.SQLMode.ValueType  # 20
    TIME_TRUNCATE_FRACTIONAL: MysqlConfig8_0.SQLMode.ValueType  # 21
    ANSI: MysqlConfig8_0.SQLMode.ValueType  # 22
    TRADITIONAL: MysqlConfig8_0.SQLMode.ValueType  # 23
    NO_DIR_IN_CREATE: MysqlConfig8_0.SQLMode.ValueType  # 24

    class _AuthPlugin:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _AuthPluginEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MysqlConfig8_0._AuthPlugin.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        AUTH_PLUGIN_UNSPECIFIED: MysqlConfig8_0._AuthPlugin.ValueType  # 0
        MYSQL_NATIVE_PASSWORD: MysqlConfig8_0._AuthPlugin.ValueType  # 1
        """Using [Native Pluggable Authentication](https://dev.mysql.com/doc/refman/8.0/en/native-pluggable-authentication.html)."""
        CACHING_SHA2_PASSWORD: MysqlConfig8_0._AuthPlugin.ValueType  # 2
        """Using [Caching SHA-2 Pluggable Authentication](https://dev.mysql.com/doc/refman/8.0/en/caching-sha2-pluggable-authentication.html)."""
        SHA256_PASSWORD: MysqlConfig8_0._AuthPlugin.ValueType  # 3
        """Using [SHA-256 Pluggable Authentication](https://dev.mysql.com/doc/refman/8.0/en/sha256-pluggable-authentication.html)."""
        MYSQL_NO_LOGIN: MysqlConfig8_0._AuthPlugin.ValueType  # 4
        """Use [MYSQL_NO_LOGIN Pluggable Authentication](https://dev.mysql.com/doc/refman/8.0/en/no-login-pluggable-authentication.html)."""
        MDB_IAMPROXY_AUTH: MysqlConfig8_0._AuthPlugin.ValueType  # 5
        """Use [IAM Pluggable Authentication](https://yandex.cloud/en/docs/iam/concepts/authorization/)."""

    class AuthPlugin(_AuthPlugin, metaclass=_AuthPluginEnumTypeWrapper): ...
    AUTH_PLUGIN_UNSPECIFIED: MysqlConfig8_0.AuthPlugin.ValueType  # 0
    MYSQL_NATIVE_PASSWORD: MysqlConfig8_0.AuthPlugin.ValueType  # 1
    """Using [Native Pluggable Authentication](https://dev.mysql.com/doc/refman/8.0/en/native-pluggable-authentication.html)."""
    CACHING_SHA2_PASSWORD: MysqlConfig8_0.AuthPlugin.ValueType  # 2
    """Using [Caching SHA-2 Pluggable Authentication](https://dev.mysql.com/doc/refman/8.0/en/caching-sha2-pluggable-authentication.html)."""
    SHA256_PASSWORD: MysqlConfig8_0.AuthPlugin.ValueType  # 3
    """Using [SHA-256 Pluggable Authentication](https://dev.mysql.com/doc/refman/8.0/en/sha256-pluggable-authentication.html)."""
    MYSQL_NO_LOGIN: MysqlConfig8_0.AuthPlugin.ValueType  # 4
    """Use [MYSQL_NO_LOGIN Pluggable Authentication](https://dev.mysql.com/doc/refman/8.0/en/no-login-pluggable-authentication.html)."""
    MDB_IAMPROXY_AUTH: MysqlConfig8_0.AuthPlugin.ValueType  # 5
    """Use [IAM Pluggable Authentication](https://yandex.cloud/en/docs/iam/concepts/authorization/)."""

    class _TransactionIsolation:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TransactionIsolationEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MysqlConfig8_0._TransactionIsolation.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TRANSACTION_ISOLATION_UNSPECIFIED: MysqlConfig8_0._TransactionIsolation.ValueType  # 0
        READ_COMMITTED: MysqlConfig8_0._TransactionIsolation.ValueType  # 1
        REPEATABLE_READ: MysqlConfig8_0._TransactionIsolation.ValueType  # 2
        SERIALIZABLE: MysqlConfig8_0._TransactionIsolation.ValueType  # 3

    class TransactionIsolation(_TransactionIsolation, metaclass=_TransactionIsolationEnumTypeWrapper): ...
    TRANSACTION_ISOLATION_UNSPECIFIED: MysqlConfig8_0.TransactionIsolation.ValueType  # 0
    READ_COMMITTED: MysqlConfig8_0.TransactionIsolation.ValueType  # 1
    REPEATABLE_READ: MysqlConfig8_0.TransactionIsolation.ValueType  # 2
    SERIALIZABLE: MysqlConfig8_0.TransactionIsolation.ValueType  # 3

    class _BinlogRowImage:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _BinlogRowImageEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MysqlConfig8_0._BinlogRowImage.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        BINLOG_ROW_IMAGE_UNSPECIFIED: MysqlConfig8_0._BinlogRowImage.ValueType  # 0
        FULL: MysqlConfig8_0._BinlogRowImage.ValueType  # 1
        MINIMAL: MysqlConfig8_0._BinlogRowImage.ValueType  # 2
        NOBLOB: MysqlConfig8_0._BinlogRowImage.ValueType  # 3

    class BinlogRowImage(_BinlogRowImage, metaclass=_BinlogRowImageEnumTypeWrapper): ...
    BINLOG_ROW_IMAGE_UNSPECIFIED: MysqlConfig8_0.BinlogRowImage.ValueType  # 0
    FULL: MysqlConfig8_0.BinlogRowImage.ValueType  # 1
    MINIMAL: MysqlConfig8_0.BinlogRowImage.ValueType  # 2
    NOBLOB: MysqlConfig8_0.BinlogRowImage.ValueType  # 3

    class _SlaveParallelType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _SlaveParallelTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MysqlConfig8_0._SlaveParallelType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SLAVE_PARALLEL_TYPE_UNSPECIFIED: MysqlConfig8_0._SlaveParallelType.ValueType  # 0
        DATABASE: MysqlConfig8_0._SlaveParallelType.ValueType  # 1
        LOGICAL_CLOCK: MysqlConfig8_0._SlaveParallelType.ValueType  # 2

    class SlaveParallelType(_SlaveParallelType, metaclass=_SlaveParallelTypeEnumTypeWrapper): ...
    SLAVE_PARALLEL_TYPE_UNSPECIFIED: MysqlConfig8_0.SlaveParallelType.ValueType  # 0
    DATABASE: MysqlConfig8_0.SlaveParallelType.ValueType  # 1
    LOGICAL_CLOCK: MysqlConfig8_0.SlaveParallelType.ValueType  # 2

    class _LogSlowRateType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _LogSlowRateTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MysqlConfig8_0._LogSlowRateType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        LOG_SLOW_RATE_TYPE_UNSPECIFIED: MysqlConfig8_0._LogSlowRateType.ValueType  # 0
        SESSION: MysqlConfig8_0._LogSlowRateType.ValueType  # 1
        QUERY: MysqlConfig8_0._LogSlowRateType.ValueType  # 2

    class LogSlowRateType(_LogSlowRateType, metaclass=_LogSlowRateTypeEnumTypeWrapper): ...
    LOG_SLOW_RATE_TYPE_UNSPECIFIED: MysqlConfig8_0.LogSlowRateType.ValueType  # 0
    SESSION: MysqlConfig8_0.LogSlowRateType.ValueType  # 1
    QUERY: MysqlConfig8_0.LogSlowRateType.ValueType  # 2

    class _LogSlowFilterType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _LogSlowFilterTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MysqlConfig8_0._LogSlowFilterType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        LOG_SLOW_FILTER_TYPE_UNSPECIFIED: MysqlConfig8_0._LogSlowFilterType.ValueType  # 0
        FULL_SCAN: MysqlConfig8_0._LogSlowFilterType.ValueType  # 1
        FULL_JOIN: MysqlConfig8_0._LogSlowFilterType.ValueType  # 2
        TMP_TABLE: MysqlConfig8_0._LogSlowFilterType.ValueType  # 3
        TMP_TABLE_ON_DISK: MysqlConfig8_0._LogSlowFilterType.ValueType  # 4
        FILESORT: MysqlConfig8_0._LogSlowFilterType.ValueType  # 5
        FILESORT_ON_DISK: MysqlConfig8_0._LogSlowFilterType.ValueType  # 6

    class LogSlowFilterType(_LogSlowFilterType, metaclass=_LogSlowFilterTypeEnumTypeWrapper): ...
    LOG_SLOW_FILTER_TYPE_UNSPECIFIED: MysqlConfig8_0.LogSlowFilterType.ValueType  # 0
    FULL_SCAN: MysqlConfig8_0.LogSlowFilterType.ValueType  # 1
    FULL_JOIN: MysqlConfig8_0.LogSlowFilterType.ValueType  # 2
    TMP_TABLE: MysqlConfig8_0.LogSlowFilterType.ValueType  # 3
    TMP_TABLE_ON_DISK: MysqlConfig8_0.LogSlowFilterType.ValueType  # 4
    FILESORT: MysqlConfig8_0.LogSlowFilterType.ValueType  # 5
    FILESORT_ON_DISK: MysqlConfig8_0.LogSlowFilterType.ValueType  # 6

    class _BinlogTransactionDependencyTracking:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _BinlogTransactionDependencyTrackingEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MysqlConfig8_0._BinlogTransactionDependencyTracking.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        BINLOG_TRANSACTION_DEPENDENCY_TRACKING_UNSPECIFIED: MysqlConfig8_0._BinlogTransactionDependencyTracking.ValueType  # 0
        COMMIT_ORDER: MysqlConfig8_0._BinlogTransactionDependencyTracking.ValueType  # 1
        WRITESET: MysqlConfig8_0._BinlogTransactionDependencyTracking.ValueType  # 2
        WRITESET_SESSION: MysqlConfig8_0._BinlogTransactionDependencyTracking.ValueType  # 3

    class BinlogTransactionDependencyTracking(_BinlogTransactionDependencyTracking, metaclass=_BinlogTransactionDependencyTrackingEnumTypeWrapper): ...
    BINLOG_TRANSACTION_DEPENDENCY_TRACKING_UNSPECIFIED: MysqlConfig8_0.BinlogTransactionDependencyTracking.ValueType  # 0
    COMMIT_ORDER: MysqlConfig8_0.BinlogTransactionDependencyTracking.ValueType  # 1
    WRITESET: MysqlConfig8_0.BinlogTransactionDependencyTracking.ValueType  # 2
    WRITESET_SESSION: MysqlConfig8_0.BinlogTransactionDependencyTracking.ValueType  # 3

    class _AuditLogPolicy:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _AuditLogPolicyEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MysqlConfig8_0._AuditLogPolicy.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        AUDIT_LOG_POLICY_UNSPECIFIED: MysqlConfig8_0._AuditLogPolicy.ValueType  # 0
        ALL: MysqlConfig8_0._AuditLogPolicy.ValueType  # 1
        LOGINS: MysqlConfig8_0._AuditLogPolicy.ValueType  # 2
        QUERIES: MysqlConfig8_0._AuditLogPolicy.ValueType  # 3
        NONE: MysqlConfig8_0._AuditLogPolicy.ValueType  # 4

    class AuditLogPolicy(_AuditLogPolicy, metaclass=_AuditLogPolicyEnumTypeWrapper): ...
    AUDIT_LOG_POLICY_UNSPECIFIED: MysqlConfig8_0.AuditLogPolicy.ValueType  # 0
    ALL: MysqlConfig8_0.AuditLogPolicy.ValueType  # 1
    LOGINS: MysqlConfig8_0.AuditLogPolicy.ValueType  # 2
    QUERIES: MysqlConfig8_0.AuditLogPolicy.ValueType  # 3
    NONE: MysqlConfig8_0.AuditLogPolicy.ValueType  # 4

    class _InnodbChangeBuffering:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _InnodbChangeBufferingEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MysqlConfig8_0._InnodbChangeBuffering.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        INNODB_CHANGE_BUFFERING_UNSPECIFIED: MysqlConfig8_0._InnodbChangeBuffering.ValueType  # 0
        INNODB_CHANGE_BUFFERING_NONE: MysqlConfig8_0._InnodbChangeBuffering.ValueType  # 1
        INNODB_CHANGE_BUFFERING_INSERTS: MysqlConfig8_0._InnodbChangeBuffering.ValueType  # 2
        INNODB_CHANGE_BUFFERING_DELETES: MysqlConfig8_0._InnodbChangeBuffering.ValueType  # 3
        INNODB_CHANGE_BUFFERING_CHANGES: MysqlConfig8_0._InnodbChangeBuffering.ValueType  # 4
        INNODB_CHANGE_BUFFERING_PURGES: MysqlConfig8_0._InnodbChangeBuffering.ValueType  # 5
        INNODB_CHANGE_BUFFERING_ALL: MysqlConfig8_0._InnodbChangeBuffering.ValueType  # 6

    class InnodbChangeBuffering(_InnodbChangeBuffering, metaclass=_InnodbChangeBufferingEnumTypeWrapper): ...
    INNODB_CHANGE_BUFFERING_UNSPECIFIED: MysqlConfig8_0.InnodbChangeBuffering.ValueType  # 0
    INNODB_CHANGE_BUFFERING_NONE: MysqlConfig8_0.InnodbChangeBuffering.ValueType  # 1
    INNODB_CHANGE_BUFFERING_INSERTS: MysqlConfig8_0.InnodbChangeBuffering.ValueType  # 2
    INNODB_CHANGE_BUFFERING_DELETES: MysqlConfig8_0.InnodbChangeBuffering.ValueType  # 3
    INNODB_CHANGE_BUFFERING_CHANGES: MysqlConfig8_0.InnodbChangeBuffering.ValueType  # 4
    INNODB_CHANGE_BUFFERING_PURGES: MysqlConfig8_0.InnodbChangeBuffering.ValueType  # 5
    INNODB_CHANGE_BUFFERING_ALL: MysqlConfig8_0.InnodbChangeBuffering.ValueType  # 6

    INNODB_BUFFER_POOL_SIZE_FIELD_NUMBER: builtins.int
    MAX_CONNECTIONS_FIELD_NUMBER: builtins.int
    LONG_QUERY_TIME_FIELD_NUMBER: builtins.int
    GENERAL_LOG_FIELD_NUMBER: builtins.int
    AUDIT_LOG_FIELD_NUMBER: builtins.int
    SQL_MODE_FIELD_NUMBER: builtins.int
    MAX_ALLOWED_PACKET_FIELD_NUMBER: builtins.int
    DEFAULT_AUTHENTICATION_PLUGIN_FIELD_NUMBER: builtins.int
    INNODB_FLUSH_LOG_AT_TRX_COMMIT_FIELD_NUMBER: builtins.int
    INNODB_LOCK_WAIT_TIMEOUT_FIELD_NUMBER: builtins.int
    TRANSACTION_ISOLATION_FIELD_NUMBER: builtins.int
    INNODB_PRINT_ALL_DEADLOCKS_FIELD_NUMBER: builtins.int
    NET_READ_TIMEOUT_FIELD_NUMBER: builtins.int
    NET_WRITE_TIMEOUT_FIELD_NUMBER: builtins.int
    GROUP_CONCAT_MAX_LEN_FIELD_NUMBER: builtins.int
    TMP_TABLE_SIZE_FIELD_NUMBER: builtins.int
    MAX_HEAP_TABLE_SIZE_FIELD_NUMBER: builtins.int
    DEFAULT_TIME_ZONE_FIELD_NUMBER: builtins.int
    CHARACTER_SET_SERVER_FIELD_NUMBER: builtins.int
    COLLATION_SERVER_FIELD_NUMBER: builtins.int
    INNODB_ADAPTIVE_HASH_INDEX_FIELD_NUMBER: builtins.int
    INNODB_NUMA_INTERLEAVE_FIELD_NUMBER: builtins.int
    INNODB_LOG_BUFFER_SIZE_FIELD_NUMBER: builtins.int
    INNODB_LOG_FILE_SIZE_FIELD_NUMBER: builtins.int
    INNODB_IO_CAPACITY_FIELD_NUMBER: builtins.int
    INNODB_IO_CAPACITY_MAX_FIELD_NUMBER: builtins.int
    INNODB_READ_IO_THREADS_FIELD_NUMBER: builtins.int
    INNODB_WRITE_IO_THREADS_FIELD_NUMBER: builtins.int
    INNODB_PURGE_THREADS_FIELD_NUMBER: builtins.int
    INNODB_THREAD_CONCURRENCY_FIELD_NUMBER: builtins.int
    INNODB_TEMP_DATA_FILE_MAX_SIZE_FIELD_NUMBER: builtins.int
    THREAD_CACHE_SIZE_FIELD_NUMBER: builtins.int
    THREAD_STACK_FIELD_NUMBER: builtins.int
    JOIN_BUFFER_SIZE_FIELD_NUMBER: builtins.int
    SORT_BUFFER_SIZE_FIELD_NUMBER: builtins.int
    TABLE_DEFINITION_CACHE_FIELD_NUMBER: builtins.int
    TABLE_OPEN_CACHE_FIELD_NUMBER: builtins.int
    TABLE_OPEN_CACHE_INSTANCES_FIELD_NUMBER: builtins.int
    EXPLICIT_DEFAULTS_FOR_TIMESTAMP_FIELD_NUMBER: builtins.int
    AUTO_INCREMENT_INCREMENT_FIELD_NUMBER: builtins.int
    AUTO_INCREMENT_OFFSET_FIELD_NUMBER: builtins.int
    SYNC_BINLOG_FIELD_NUMBER: builtins.int
    BINLOG_CACHE_SIZE_FIELD_NUMBER: builtins.int
    BINLOG_GROUP_COMMIT_SYNC_DELAY_FIELD_NUMBER: builtins.int
    BINLOG_ROW_IMAGE_FIELD_NUMBER: builtins.int
    BINLOG_ROWS_QUERY_LOG_EVENTS_FIELD_NUMBER: builtins.int
    RPL_SEMI_SYNC_MASTER_WAIT_FOR_SLAVE_COUNT_FIELD_NUMBER: builtins.int
    SLAVE_PARALLEL_TYPE_FIELD_NUMBER: builtins.int
    SLAVE_PARALLEL_WORKERS_FIELD_NUMBER: builtins.int
    REGEXP_TIME_LIMIT_FIELD_NUMBER: builtins.int
    MDB_PRESERVE_BINLOG_BYTES_FIELD_NUMBER: builtins.int
    INTERACTIVE_TIMEOUT_FIELD_NUMBER: builtins.int
    WAIT_TIMEOUT_FIELD_NUMBER: builtins.int
    MDB_OFFLINE_MODE_ENABLE_LAG_FIELD_NUMBER: builtins.int
    MDB_OFFLINE_MODE_DISABLE_LAG_FIELD_NUMBER: builtins.int
    RANGE_OPTIMIZER_MAX_MEM_SIZE_FIELD_NUMBER: builtins.int
    SLOW_QUERY_LOG_FIELD_NUMBER: builtins.int
    SLOW_QUERY_LOG_ALWAYS_WRITE_TIME_FIELD_NUMBER: builtins.int
    LOG_SLOW_RATE_TYPE_FIELD_NUMBER: builtins.int
    LOG_SLOW_RATE_LIMIT_FIELD_NUMBER: builtins.int
    LOG_SLOW_SP_STATEMENTS_FIELD_NUMBER: builtins.int
    LOG_SLOW_FILTER_FIELD_NUMBER: builtins.int
    MDB_PRIORITY_CHOICE_MAX_LAG_FIELD_NUMBER: builtins.int
    INNODB_PAGE_SIZE_FIELD_NUMBER: builtins.int
    INNODB_ONLINE_ALTER_LOG_MAX_SIZE_FIELD_NUMBER: builtins.int
    INNODB_FT_MIN_TOKEN_SIZE_FIELD_NUMBER: builtins.int
    INNODB_FT_MAX_TOKEN_SIZE_FIELD_NUMBER: builtins.int
    LOWER_CASE_TABLE_NAMES_FIELD_NUMBER: builtins.int
    MAX_SP_RECURSION_DEPTH_FIELD_NUMBER: builtins.int
    INNODB_COMPRESSION_LEVEL_FIELD_NUMBER: builtins.int
    BINLOG_TRANSACTION_DEPENDENCY_TRACKING_FIELD_NUMBER: builtins.int
    AUTOCOMMIT_FIELD_NUMBER: builtins.int
    INNODB_STATUS_OUTPUT_FIELD_NUMBER: builtins.int
    INNODB_STRICT_MODE_FIELD_NUMBER: builtins.int
    INNODB_PRINT_LOCK_WAIT_TIMEOUT_INFO_FIELD_NUMBER: builtins.int
    LOG_ERROR_VERBOSITY_FIELD_NUMBER: builtins.int
    MAX_DIGEST_LENGTH_FIELD_NUMBER: builtins.int
    LOCK_WAIT_TIMEOUT_FIELD_NUMBER: builtins.int
    MAX_PREPARED_STMT_COUNT_FIELD_NUMBER: builtins.int
    OPTIMIZER_SWITCH_FIELD_NUMBER: builtins.int
    OPTIMIZER_SEARCH_DEPTH_FIELD_NUMBER: builtins.int
    USERSTAT_FIELD_NUMBER: builtins.int
    MAX_EXECUTION_TIME_FIELD_NUMBER: builtins.int
    AUDIT_LOG_POLICY_FIELD_NUMBER: builtins.int
    REPLICATION_SENDER_OBSERVE_COMMIT_ONLY_FIELD_NUMBER: builtins.int
    REPLICATION_OPTIMIZE_FOR_STATIC_PLUGIN_CONFIG_FIELD_NUMBER: builtins.int
    INNODB_LRU_SCAN_DEPTH_FIELD_NUMBER: builtins.int
    SQL_REQUIRE_PRIMARY_KEY_FIELD_NUMBER: builtins.int
    MDB_FORCE_SSL_FIELD_NUMBER: builtins.int
    INNODB_CHANGE_BUFFERING_FIELD_NUMBER: builtins.int
    MAX_WRITE_LOCK_COUNT_FIELD_NUMBER: builtins.int
    default_authentication_plugin: global___MysqlConfig8_0.AuthPlugin.ValueType
    """Authentication plugin used in the managed MySQL cluster.

    See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_default_authentication_plugin) for details.
    """
    transaction_isolation: global___MysqlConfig8_0.TransactionIsolation.ValueType
    """Default transaction isolation level.

    See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_transaction_isolation) for details.
    """
    default_time_zone: builtins.str
    """The servers default time zone.

    See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/server-options.html#option_mysqld_default-time-zone) for details.
    """
    character_set_server: builtins.str
    """The servers default character set.

    See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_character_set_server) for details.
    """
    collation_server: builtins.str
    """The server default collation.

    See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_collation_server) for details.
    """
    binlog_row_image: global___MysqlConfig8_0.BinlogRowImage.ValueType
    """For MySQL row-based replication, this variable determines how row images are written to the binary log.

    See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_row_image) for details.
    """
    slave_parallel_type: global___MysqlConfig8_0.SlaveParallelType.ValueType
    """When using a multi-threaded replica, this variable specifies the policy used to decide which transactions are allowed to execute in parallel on the replica.

    See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_slave_parallel_type) for details.
    """
    log_slow_rate_type: global___MysqlConfig8_0.LogSlowRateType.ValueType
    """Specifies slow log granularity for `log_slow_rate_limit` QUERY or SESSION value.

    See [Percona documentation](https://www.percona.com/doc/percona-server/8.0/diagnostics/slow_extended.html#log_slow_rate_type) for details.
    """
    binlog_transaction_dependency_tracking: global___MysqlConfig8_0.BinlogTransactionDependencyTracking.ValueType
    """Specifies how the source mysqld generates the dependency information that it writes in the binary log to help replicas determine which transactions can be executed in parallel.

    For details, see [MySQL documentation for the variable](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_transaction_dependency_tracking).
    """
    optimizer_switch: builtins.str
    """The system variable enables control over optimizer behavior.

    For details, see [MySQL documentation for the variable](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_optimizer_switch)
    https://dev.mysql.com/doc/refman/8.0/en/switchable-optimizations.html
    """
    audit_log_policy: global___MysqlConfig8_0.AuditLogPolicy.ValueType
    """The policy controlling how the audit log plugin writes events to its log file

    For details, see [MySQL documentation for the variable](https://dev.mysql.com/doc/refman/8.0/en/audit-log-reference.html#sysvar_audit_log_policy)
    """
    innodb_change_buffering: global___MysqlConfig8_0.InnodbChangeBuffering.ValueType
    """An optimization for change buffering

    For details, see [MySQL documentation for the variable](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_change_buffering).
    """
    @property
    def innodb_buffer_pool_size(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Size of the InnoDB buffer pool used for caching table and index data.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_buffer_pool_size) for details.
        """

    @property
    def max_connections(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The maximum permitted number of simultaneous client connections.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_connections) for details.
        """

    @property
    def long_query_time(self) -> google.protobuf.wrappers_pb2.DoubleValue:
        """Time that it takes to process a query before it is considered slow.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_long_query_time) for details.
        """

    @property
    def general_log(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Enable writing of general query log of MySQL.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_general_log) for details.
        """

    @property
    def audit_log(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Enable writing of audit log of MySQL.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/audit-log-reference.html#audit-log-options-variables) for details.
        """

    @property
    def sql_mode(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___MysqlConfig8_0.SQLMode.ValueType]:
        """Server SQL mode of MySQL.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/sql-mode.html#sql-mode-setting) for details.
        """

    @property
    def max_allowed_packet(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The maximum size in bytes of one packet.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_allowed_packet) for details.
        """

    @property
    def innodb_flush_log_at_trx_commit(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Transaction log flush behaviour.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_flush_log_at_trx_commit) for details.
        """

    @property
    def innodb_lock_wait_timeout(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Max time in seconds for a transaction to wait for a row lock.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_lock_wait_timeout) for details.
        """

    @property
    def innodb_print_all_deadlocks(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Print information about deadlocks in error log.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_print_all_deadlocks) for details.
        """

    @property
    def net_read_timeout(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The number of seconds to wait for more data from a connection before aborting the read.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_net_read_timeout) for details.
        """

    @property
    def net_write_timeout(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The number of seconds to wait for a block to be written to a connection before aborting the write.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_net_write_timeout) for details.
        """

    @property
    def group_concat_max_len(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The maximum permitted result length in bytes for the GROUP_CONCAT() function.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_group_concat_max_len) for details.
        """

    @property
    def tmp_table_size(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The maximum size of internal in-memory temporary tables.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_tmp_table_size) for details.
        """

    @property
    def max_heap_table_size(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """This variable sets the maximum size to which user-created MEMORY tables are permitted to grow.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_heap_table_size) for details.
        """

    @property
    def innodb_adaptive_hash_index(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Enables InnoDB adaptive hash index.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_adaptive_hash_index) for details.
        """

    @property
    def innodb_numa_interleave(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Enables the NUMA interleave memory policy for allocation of the InnoDB buffer pool.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_numa_interleave) for details.
        """

    @property
    def innodb_log_buffer_size(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The size in bytes of the buffer that InnoDB uses to write to the log files on disk.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_log_buffer_size) for details.
        """

    @property
    def innodb_log_file_size(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The size in bytes of the single InnoDB Redo log file.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_log_file_size) for details.
        """

    @property
    def innodb_io_capacity(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Limits IO available for InnoDB background tasks.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_io_capacity) for details.
        """

    @property
    def innodb_io_capacity_max(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Limits IO available for InnoDB background tasks.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_io_capacity_max) for details.
        """

    @property
    def innodb_read_io_threads(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The number of I/O threads for read operations in InnoDB.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_read_io_threads) for details.
        """

    @property
    def innodb_write_io_threads(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The number of I/O threads for write operations in InnoDB.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_write_io_threads) for details.
        """

    @property
    def innodb_purge_threads(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The number of background threads devoted to the InnoDB purge operation.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_purge_threads) for details.
        """

    @property
    def innodb_thread_concurrency(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Defines the maximum number of threads permitted inside of InnoDB.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_thread_concurrency) for details.
        """

    @property
    def innodb_temp_data_file_max_size(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Limits the max size of InnoDB temp tablespace.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_temp_data_file_path) for details.
        """

    @property
    def thread_cache_size(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """How many threads the server should cache for reuse.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_cache_size) for details.
        """

    @property
    def thread_stack(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The stack size for each thread. The default is large enough for normal operation.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_thread_stack) for details.
        """

    @property
    def join_buffer_size(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The minimum size of the buffer that is used for plain index scans, range index scans, and joins that do not use indexes and thus perform full table scans.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_join_buffer_size) for details.
        """

    @property
    def sort_buffer_size(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Each session that must perform a sort allocates a buffer of this size.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sort_buffer_size) for details.
        """

    @property
    def table_definition_cache(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The number of table definitions that can be stored in the definition cache.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_table_definition_cache) for details.
        """

    @property
    def table_open_cache(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The number of open tables for all threads.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_table_open_cache) for details.
        """

    @property
    def table_open_cache_instances(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The number of open tables cache instances.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_table_open_cache_instances) for details.
        """

    @property
    def explicit_defaults_for_timestamp(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Determines whether the server enables certain nonstandard behaviors for default values and NULL-value handling in TIMESTAMP columns.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_explicit_defaults_for_timestamp) for details.
        """

    @property
    def auto_increment_increment(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Can be used to control the operation of AUTO_INCREMENT columns.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/replication-options-source.html#sysvar_auto_increment_increment) for details.
        """

    @property
    def auto_increment_offset(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Can be used to control the operation of AUTO_INCREMENT columns.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/replication-options-source.html#sysvar_auto_increment_offset) for details.
        """

    @property
    def sync_binlog(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Controls how often the MySQL server synchronizes the binary log to disk.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_sync_binlog) for details.
        """

    @property
    def binlog_cache_size(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The size of the cache to hold changes to the binary log during a transaction.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_cache_size) for details.
        """

    @property
    def binlog_group_commit_sync_delay(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Controls how many microseconds the binary log commit waits before synchronizing the binary log file to disk.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_group_commit_sync_delay) for details.
        """

    @property
    def binlog_rows_query_log_events(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """When enabled, it causes the server to write informational log events such as row query log events into its binary log.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/replication-options-binary-log.html#sysvar_binlog_rows_query_log_events) for details.
        """

    @property
    def rpl_semi_sync_master_wait_for_slave_count(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The number of replica acknowledgments the source must receive per transaction before proceeding.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/replication-options-source.html#sysvar_rpl_semi_sync_master_wait_for_slave_count) for details.
        """

    @property
    def slave_parallel_workers(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Sets the number of applier threads for executing replication transactions in parallel.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_slave_parallel_workers) for details.
        """

    @property
    def regexp_time_limit(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The time limit for regular expression matching operations performed by REGEXP_LIKE and similar functions.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_regexp_time_limit) for details.
        """

    @property
    def mdb_preserve_binlog_bytes(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The size of the binary log to hold."""

    @property
    def interactive_timeout(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The number of seconds the server waits for activity on an interactive connection before closing it.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_interactive_timeout) for details.
        """

    @property
    def wait_timeout(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The number of seconds the server waits for activity on a noninteractive connection before closing it.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_wait_timeout) for details.
        """

    @property
    def mdb_offline_mode_enable_lag(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Replication lag threshold (seconds) which will switch MySQL to 'offline_mode = ON' to prevent users from reading stale data."""

    @property
    def mdb_offline_mode_disable_lag(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Replication lag threshold (seconds) which will switch MySQL to 'offline_mode = OFF'.
        Should be less than mdb_offline_mode_enable_lag.
        """

    @property
    def range_optimizer_max_mem_size(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The limit on memory consumption for the range optimizer.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_range_optimizer_max_mem_size) for details.
        """

    @property
    def slow_query_log(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Manages slow query log.

        See [MySQL documentation](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_slow_query_log) for details.
        """

    @property
    def slow_query_log_always_write_time(self) -> google.protobuf.wrappers_pb2.DoubleValue:
        """Query execution time, after which query to be logged unconditionally, that is, `log_slow_rate_limit` will not apply to it.

        See [Percona documentation](https://www.percona.com/doc/percona-server/8.0/diagnostics/slow_extended.html#slow_query_log_always_write_time) for details.
        """

    @property
    def log_slow_rate_limit(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Specifies what fraction of session/query should be logged. Logging is enabled for every nth session/query.

        See [Percona documentation](https://www.percona.com/doc/percona-server/8.0/diagnostics/slow_extended.html#log_slow_rate_limit) for details.
        """

    @property
    def log_slow_sp_statements(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """When TRUE, statements executed by stored procedures are logged to the slow log.

        See [Percona documentation](https://www.percona.com/doc/percona-server/8.0/diagnostics/slow_extended.html#log_slow_sp_statements) for details.
        """

    @property
    def log_slow_filter(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___MysqlConfig8_0.LogSlowFilterType.ValueType]:
        """Filters the slow log by the query's execution plan.

        See [Percona documentation](https://www.percona.com/doc/percona-server/8.0/diagnostics/slow_extended.html#log_slow_filter) for details.
        """

    @property
    def mdb_priority_choice_max_lag(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Replication lag threshold (seconds) which allows replica to be promoted to master while executing "switchover from".
        Should be less than mdb_offline_mode_disable_lag.
        """

    @property
    def innodb_page_size(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Specifies the page size for InnoDB tablespaces.

        For details, see [MySQL documentation for the variable](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_page_size).
        """

    @property
    def innodb_online_alter_log_max_size(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The limit in bytes on the size of the temporary log files used during online DDL operations

        See [MySQL documentation for the variable](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_online_alter_log_max_size) for details.
        """

    @property
    def innodb_ft_min_token_size(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Minimum length of words that are stored in an InnoDB FULLTEXT index

        See [MySQL documentation for the variable](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ft_min_token_size) for details.
        """

    @property
    def innodb_ft_max_token_size(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Maximum length of words that are stored in an InnoDB FULLTEXT index

        See [MySQL documentation for the variable](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_ft_max_token_size) for details.
        """

    @property
    def lower_case_table_names(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Table names storage and comparison strategy

        See [MySQL documentation for the variable](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_lower_case_table_names) for details.
        """

    @property
    def max_sp_recursion_depth(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The number of times that any given stored procedure may be called recursively.

        For details, see [MySQL documentation for the variable](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_sp_recursion_depth).
        """

    @property
    def innodb_compression_level(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The level of zlib compression to use for InnoDB compressed tables and indexes.

        For details, see [MySQL documentation for the variable](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_compression_level).
        """

    @property
    def autocommit(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Config specific will be all changes to a table take effect immediately or you must use COMMIT to accept a transaction or ROLLBACK to cancel it.

        For details, see [MySQL documentation for the variable](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_autocommit).
        """

    @property
    def innodb_status_output(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Enables or disables periodic output for the standard InnoDB Monitor.

        For details, see [MySQL documentation for the variable](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_status_output).
        """

    @property
    def innodb_strict_mode(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """When innodb_strict_mode is enabled, InnoDB returns errors rather than warnings when checking for invalid or incompatible table options.

        For details, see [MySQL documentation for the variable](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_strict_mode).
        """

    @property
    def innodb_print_lock_wait_timeout_info(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Makes InnoDB to write information about all lock wait timeout errors into the log file.

        For details, see [Percona documentation for the variable](https://docs.percona.com/percona-server/8.0/diagnostics/innodb_show_status.html?highlight=innodb_print_lock_wait_timeout_info).
        """

    @property
    def log_error_verbosity(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """System variable specifies the verbosity for handling events intended for the error log

        For details, see [MySQL documentation for the variable](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_log_error_verbosity).
        """

    @property
    def max_digest_length(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The maximum number of bytes of memory reserved per session for computation of normalized statement digests.

        For details, see [MySQL documentation for the variable](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_digest_length).
        """

    @property
    def lock_wait_timeout(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """This variable specifies the timeout in seconds for attempts to acquire metadata locks

        For details, see [MySQL documentation for the variable](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_lock_wait_timeout).
        """

    @property
    def max_prepared_stmt_count(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """This variable limits the total number of prepared statements in the server.

        For details, see [MySQL documentation for the variable](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_prepared_stmt_count).
        """

    @property
    def optimizer_search_depth(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The maximum depth of search performed by the query optimizer

        For details, see [MySQL documentation for the variable](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html)
        """

    @property
    def userstat(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Enables or disables collection of statistics

        For details, see [Percona documentation for the variable](https://docs.percona.com/percona-server/8.0/diagnostics/user_stats.html#userstat).
        """

    @property
    def max_execution_time(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The execution timeout for SELECT statements, in milliseconds. If the value is 0, timeouts are not enabled.

        For details, see [MySQL documentation for the variable](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_execution_time)
        """

    @property
    def replication_sender_observe_commit_only(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Limit callbacks to improve performance for semisynchronous replication

        For details, see [MySQL documentation for the variable](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_replication_sender_observe_commit_only).
        """

    @property
    def replication_optimize_for_static_plugin_config(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Use shared locks, and avoid unnecessary lock acquisitions, to improve performance for semisynchronous replication

        For details, see [MySQL documentation for the variable](https://dev.mysql.com/doc/refman/8.0/en/replication-options-replica.html#sysvar_replication_optimize_for_static_plugin_config).
        """

    @property
    def innodb_lru_scan_depth(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """A parameter that influences the algorithms and heuristics for the flush operation for the InnoDB buffer pool

        For details, see [MySQL documentation for the variable](https://dev.mysql.com/doc/refman/8.0/en/innodb-parameters.html#sysvar_innodb_lru_scan_depth)
        """

    @property
    def sql_require_primary_key(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Whether statements that create new tables or alter the structure of existing tables enforce the requirement that tables have a primary key

        For details, see [MySQL documentation for the variable](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_sql_require_primary_key).
        """

    @property
    def mdb_force_ssl(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Force ssl on all hosts (require_secure_transport)"""

    @property
    def max_write_lock_count(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Permit some pending read lock requests interval
        P.S. Should be UInt64, but java fails to handle UInt64 limits

        For details, see [Percona documentation for the variable](https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_max_write_lock_count).
        """

    def __init__(
        self,
        *,
        innodb_buffer_pool_size: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        max_connections: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        long_query_time: google.protobuf.wrappers_pb2.DoubleValue | None = ...,
        general_log: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        audit_log: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        sql_mode: collections.abc.Iterable[global___MysqlConfig8_0.SQLMode.ValueType] | None = ...,
        max_allowed_packet: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        default_authentication_plugin: global___MysqlConfig8_0.AuthPlugin.ValueType = ...,
        innodb_flush_log_at_trx_commit: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        innodb_lock_wait_timeout: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        transaction_isolation: global___MysqlConfig8_0.TransactionIsolation.ValueType = ...,
        innodb_print_all_deadlocks: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        net_read_timeout: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        net_write_timeout: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        group_concat_max_len: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        tmp_table_size: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        max_heap_table_size: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        default_time_zone: builtins.str = ...,
        character_set_server: builtins.str = ...,
        collation_server: builtins.str = ...,
        innodb_adaptive_hash_index: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        innodb_numa_interleave: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        innodb_log_buffer_size: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        innodb_log_file_size: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        innodb_io_capacity: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        innodb_io_capacity_max: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        innodb_read_io_threads: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        innodb_write_io_threads: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        innodb_purge_threads: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        innodb_thread_concurrency: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        innodb_temp_data_file_max_size: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        thread_cache_size: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        thread_stack: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        join_buffer_size: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        sort_buffer_size: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        table_definition_cache: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        table_open_cache: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        table_open_cache_instances: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        explicit_defaults_for_timestamp: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        auto_increment_increment: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        auto_increment_offset: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        sync_binlog: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        binlog_cache_size: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        binlog_group_commit_sync_delay: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        binlog_row_image: global___MysqlConfig8_0.BinlogRowImage.ValueType = ...,
        binlog_rows_query_log_events: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        rpl_semi_sync_master_wait_for_slave_count: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        slave_parallel_type: global___MysqlConfig8_0.SlaveParallelType.ValueType = ...,
        slave_parallel_workers: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        regexp_time_limit: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        mdb_preserve_binlog_bytes: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        interactive_timeout: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        wait_timeout: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        mdb_offline_mode_enable_lag: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        mdb_offline_mode_disable_lag: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        range_optimizer_max_mem_size: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        slow_query_log: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        slow_query_log_always_write_time: google.protobuf.wrappers_pb2.DoubleValue | None = ...,
        log_slow_rate_type: global___MysqlConfig8_0.LogSlowRateType.ValueType = ...,
        log_slow_rate_limit: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        log_slow_sp_statements: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        log_slow_filter: collections.abc.Iterable[global___MysqlConfig8_0.LogSlowFilterType.ValueType] | None = ...,
        mdb_priority_choice_max_lag: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        innodb_page_size: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        innodb_online_alter_log_max_size: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        innodb_ft_min_token_size: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        innodb_ft_max_token_size: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        lower_case_table_names: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        max_sp_recursion_depth: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        innodb_compression_level: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        binlog_transaction_dependency_tracking: global___MysqlConfig8_0.BinlogTransactionDependencyTracking.ValueType = ...,
        autocommit: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        innodb_status_output: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        innodb_strict_mode: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        innodb_print_lock_wait_timeout_info: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        log_error_verbosity: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        max_digest_length: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        lock_wait_timeout: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        max_prepared_stmt_count: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        optimizer_switch: builtins.str = ...,
        optimizer_search_depth: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        userstat: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        max_execution_time: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        audit_log_policy: global___MysqlConfig8_0.AuditLogPolicy.ValueType = ...,
        replication_sender_observe_commit_only: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        replication_optimize_for_static_plugin_config: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        innodb_lru_scan_depth: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        sql_require_primary_key: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        mdb_force_ssl: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        innodb_change_buffering: global___MysqlConfig8_0.InnodbChangeBuffering.ValueType = ...,
        max_write_lock_count: google.protobuf.wrappers_pb2.Int64Value | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["audit_log", b"audit_log", "auto_increment_increment", b"auto_increment_increment", "auto_increment_offset", b"auto_increment_offset", "autocommit", b"autocommit", "binlog_cache_size", b"binlog_cache_size", "binlog_group_commit_sync_delay", b"binlog_group_commit_sync_delay", "binlog_rows_query_log_events", b"binlog_rows_query_log_events", "explicit_defaults_for_timestamp", b"explicit_defaults_for_timestamp", "general_log", b"general_log", "group_concat_max_len", b"group_concat_max_len", "innodb_adaptive_hash_index", b"innodb_adaptive_hash_index", "innodb_buffer_pool_size", b"innodb_buffer_pool_size", "innodb_compression_level", b"innodb_compression_level", "innodb_flush_log_at_trx_commit", b"innodb_flush_log_at_trx_commit", "innodb_ft_max_token_size", b"innodb_ft_max_token_size", "innodb_ft_min_token_size", b"innodb_ft_min_token_size", "innodb_io_capacity", b"innodb_io_capacity", "innodb_io_capacity_max", b"innodb_io_capacity_max", "innodb_lock_wait_timeout", b"innodb_lock_wait_timeout", "innodb_log_buffer_size", b"innodb_log_buffer_size", "innodb_log_file_size", b"innodb_log_file_size", "innodb_lru_scan_depth", b"innodb_lru_scan_depth", "innodb_numa_interleave", b"innodb_numa_interleave", "innodb_online_alter_log_max_size", b"innodb_online_alter_log_max_size", "innodb_page_size", b"innodb_page_size", "innodb_print_all_deadlocks", b"innodb_print_all_deadlocks", "innodb_print_lock_wait_timeout_info", b"innodb_print_lock_wait_timeout_info", "innodb_purge_threads", b"innodb_purge_threads", "innodb_read_io_threads", b"innodb_read_io_threads", "innodb_status_output", b"innodb_status_output", "innodb_strict_mode", b"innodb_strict_mode", "innodb_temp_data_file_max_size", b"innodb_temp_data_file_max_size", "innodb_thread_concurrency", b"innodb_thread_concurrency", "innodb_write_io_threads", b"innodb_write_io_threads", "interactive_timeout", b"interactive_timeout", "join_buffer_size", b"join_buffer_size", "lock_wait_timeout", b"lock_wait_timeout", "log_error_verbosity", b"log_error_verbosity", "log_slow_rate_limit", b"log_slow_rate_limit", "log_slow_sp_statements", b"log_slow_sp_statements", "long_query_time", b"long_query_time", "lower_case_table_names", b"lower_case_table_names", "max_allowed_packet", b"max_allowed_packet", "max_connections", b"max_connections", "max_digest_length", b"max_digest_length", "max_execution_time", b"max_execution_time", "max_heap_table_size", b"max_heap_table_size", "max_prepared_stmt_count", b"max_prepared_stmt_count", "max_sp_recursion_depth", b"max_sp_recursion_depth", "max_write_lock_count", b"max_write_lock_count", "mdb_force_ssl", b"mdb_force_ssl", "mdb_offline_mode_disable_lag", b"mdb_offline_mode_disable_lag", "mdb_offline_mode_enable_lag", b"mdb_offline_mode_enable_lag", "mdb_preserve_binlog_bytes", b"mdb_preserve_binlog_bytes", "mdb_priority_choice_max_lag", b"mdb_priority_choice_max_lag", "net_read_timeout", b"net_read_timeout", "net_write_timeout", b"net_write_timeout", "optimizer_search_depth", b"optimizer_search_depth", "range_optimizer_max_mem_size", b"range_optimizer_max_mem_size", "regexp_time_limit", b"regexp_time_limit", "replication_optimize_for_static_plugin_config", b"replication_optimize_for_static_plugin_config", "replication_sender_observe_commit_only", b"replication_sender_observe_commit_only", "rpl_semi_sync_master_wait_for_slave_count", b"rpl_semi_sync_master_wait_for_slave_count", "slave_parallel_workers", b"slave_parallel_workers", "slow_query_log", b"slow_query_log", "slow_query_log_always_write_time", b"slow_query_log_always_write_time", "sort_buffer_size", b"sort_buffer_size", "sql_require_primary_key", b"sql_require_primary_key", "sync_binlog", b"sync_binlog", "table_definition_cache", b"table_definition_cache", "table_open_cache", b"table_open_cache", "table_open_cache_instances", b"table_open_cache_instances", "thread_cache_size", b"thread_cache_size", "thread_stack", b"thread_stack", "tmp_table_size", b"tmp_table_size", "userstat", b"userstat", "wait_timeout", b"wait_timeout"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["audit_log", b"audit_log", "audit_log_policy", b"audit_log_policy", "auto_increment_increment", b"auto_increment_increment", "auto_increment_offset", b"auto_increment_offset", "autocommit", b"autocommit", "binlog_cache_size", b"binlog_cache_size", "binlog_group_commit_sync_delay", b"binlog_group_commit_sync_delay", "binlog_row_image", b"binlog_row_image", "binlog_rows_query_log_events", b"binlog_rows_query_log_events", "binlog_transaction_dependency_tracking", b"binlog_transaction_dependency_tracking", "character_set_server", b"character_set_server", "collation_server", b"collation_server", "default_authentication_plugin", b"default_authentication_plugin", "default_time_zone", b"default_time_zone", "explicit_defaults_for_timestamp", b"explicit_defaults_for_timestamp", "general_log", b"general_log", "group_concat_max_len", b"group_concat_max_len", "innodb_adaptive_hash_index", b"innodb_adaptive_hash_index", "innodb_buffer_pool_size", b"innodb_buffer_pool_size", "innodb_change_buffering", b"innodb_change_buffering", "innodb_compression_level", b"innodb_compression_level", "innodb_flush_log_at_trx_commit", b"innodb_flush_log_at_trx_commit", "innodb_ft_max_token_size", b"innodb_ft_max_token_size", "innodb_ft_min_token_size", b"innodb_ft_min_token_size", "innodb_io_capacity", b"innodb_io_capacity", "innodb_io_capacity_max", b"innodb_io_capacity_max", "innodb_lock_wait_timeout", b"innodb_lock_wait_timeout", "innodb_log_buffer_size", b"innodb_log_buffer_size", "innodb_log_file_size", b"innodb_log_file_size", "innodb_lru_scan_depth", b"innodb_lru_scan_depth", "innodb_numa_interleave", b"innodb_numa_interleave", "innodb_online_alter_log_max_size", b"innodb_online_alter_log_max_size", "innodb_page_size", b"innodb_page_size", "innodb_print_all_deadlocks", b"innodb_print_all_deadlocks", "innodb_print_lock_wait_timeout_info", b"innodb_print_lock_wait_timeout_info", "innodb_purge_threads", b"innodb_purge_threads", "innodb_read_io_threads", b"innodb_read_io_threads", "innodb_status_output", b"innodb_status_output", "innodb_strict_mode", b"innodb_strict_mode", "innodb_temp_data_file_max_size", b"innodb_temp_data_file_max_size", "innodb_thread_concurrency", b"innodb_thread_concurrency", "innodb_write_io_threads", b"innodb_write_io_threads", "interactive_timeout", b"interactive_timeout", "join_buffer_size", b"join_buffer_size", "lock_wait_timeout", b"lock_wait_timeout", "log_error_verbosity", b"log_error_verbosity", "log_slow_filter", b"log_slow_filter", "log_slow_rate_limit", b"log_slow_rate_limit", "log_slow_rate_type", b"log_slow_rate_type", "log_slow_sp_statements", b"log_slow_sp_statements", "long_query_time", b"long_query_time", "lower_case_table_names", b"lower_case_table_names", "max_allowed_packet", b"max_allowed_packet", "max_connections", b"max_connections", "max_digest_length", b"max_digest_length", "max_execution_time", b"max_execution_time", "max_heap_table_size", b"max_heap_table_size", "max_prepared_stmt_count", b"max_prepared_stmt_count", "max_sp_recursion_depth", b"max_sp_recursion_depth", "max_write_lock_count", b"max_write_lock_count", "mdb_force_ssl", b"mdb_force_ssl", "mdb_offline_mode_disable_lag", b"mdb_offline_mode_disable_lag", "mdb_offline_mode_enable_lag", b"mdb_offline_mode_enable_lag", "mdb_preserve_binlog_bytes", b"mdb_preserve_binlog_bytes", "mdb_priority_choice_max_lag", b"mdb_priority_choice_max_lag", "net_read_timeout", b"net_read_timeout", "net_write_timeout", b"net_write_timeout", "optimizer_search_depth", b"optimizer_search_depth", "optimizer_switch", b"optimizer_switch", "range_optimizer_max_mem_size", b"range_optimizer_max_mem_size", "regexp_time_limit", b"regexp_time_limit", "replication_optimize_for_static_plugin_config", b"replication_optimize_for_static_plugin_config", "replication_sender_observe_commit_only", b"replication_sender_observe_commit_only", "rpl_semi_sync_master_wait_for_slave_count", b"rpl_semi_sync_master_wait_for_slave_count", "slave_parallel_type", b"slave_parallel_type", "slave_parallel_workers", b"slave_parallel_workers", "slow_query_log", b"slow_query_log", "slow_query_log_always_write_time", b"slow_query_log_always_write_time", "sort_buffer_size", b"sort_buffer_size", "sql_mode", b"sql_mode", "sql_require_primary_key", b"sql_require_primary_key", "sync_binlog", b"sync_binlog", "table_definition_cache", b"table_definition_cache", "table_open_cache", b"table_open_cache", "table_open_cache_instances", b"table_open_cache_instances", "thread_cache_size", b"thread_cache_size", "thread_stack", b"thread_stack", "tmp_table_size", b"tmp_table_size", "transaction_isolation", b"transaction_isolation", "userstat", b"userstat", "wait_timeout", b"wait_timeout"]) -> None: ...

global___MysqlConfig8_0 = MysqlConfig8_0

@typing.final
class MysqlConfigSet8_0(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EFFECTIVE_CONFIG_FIELD_NUMBER: builtins.int
    USER_CONFIG_FIELD_NUMBER: builtins.int
    DEFAULT_CONFIG_FIELD_NUMBER: builtins.int
    @property
    def effective_config(self) -> global___MysqlConfig8_0:
        """Effective settings for a MySQL 8.0 cluster (a combination of settings defined
        in [user_config] and [default_config]).
        """

    @property
    def user_config(self) -> global___MysqlConfig8_0:
        """User-defined settings for a MySQL 8.0 cluster."""

    @property
    def default_config(self) -> global___MysqlConfig8_0:
        """Default configuration for a MySQL 8.0 cluster."""

    def __init__(
        self,
        *,
        effective_config: global___MysqlConfig8_0 | None = ...,
        user_config: global___MysqlConfig8_0 | None = ...,
        default_config: global___MysqlConfig8_0 | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["default_config", b"default_config", "effective_config", b"effective_config", "user_config", b"user_config"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["default_config", b"default_config", "effective_config", b"effective_config", "user_config", b"user_config"]) -> None: ...

global___MysqlConfigSet8_0 = MysqlConfigSet8_0
