"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import google.protobuf.wrappers_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Backup(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    SOURCE_CLUSTER_ID_FIELD_NUMBER: builtins.int
    STARTED_AT_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    INDICES_FIELD_NUMBER: builtins.int
    OPENSEARCH_VERSION_FIELD_NUMBER: builtins.int
    SIZE_BYTES_FIELD_NUMBER: builtins.int
    INDICES_TOTAL_FIELD_NUMBER: builtins.int
    INCREMENTAL_SIZE_BYTES_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_BYTES_FIELD_NUMBER: builtins.int
    FREE_SPACE_REQUIRED_BYTES_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Required. ID of the backup."""
    folder_id: builtins.str
    """ID of the folder that the backup belongs to."""
    source_cluster_id: builtins.str
    """ID of the OpenSearch cluster that the backup was created for."""
    opensearch_version: builtins.str
    """OpenSearch version used to create the backup."""
    size_bytes: builtins.int
    """Size of the backup in bytes."""
    indices_total: builtins.int
    """The number of indices in the backup."""
    incremental_size_bytes: builtins.int
    """Size of files which were copied as part of the incremental snapshot."""
    total_size_bytes: builtins.int
    """Size of files that are referenced by the snapshot."""
    free_space_required_bytes: builtins.int
    """The space amount required to restore from this backup."""
    @property
    def started_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Time when the backup operation was started."""

    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Time when the backup operation was completed."""

    @property
    def indices(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Names of indices in the backup."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        source_cluster_id: builtins.str = ...,
        started_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        indices: collections.abc.Iterable[builtins.str] | None = ...,
        opensearch_version: builtins.str = ...,
        size_bytes: builtins.int = ...,
        indices_total: builtins.int = ...,
        incremental_size_bytes: builtins.int = ...,
        total_size_bytes: builtins.int = ...,
        free_space_required_bytes: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "started_at", b"started_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["created_at", b"created_at", "folder_id", b"folder_id", "free_space_required_bytes", b"free_space_required_bytes", "id", b"id", "incremental_size_bytes", b"incremental_size_bytes", "indices", b"indices", "indices_total", b"indices_total", "opensearch_version", b"opensearch_version", "size_bytes", b"size_bytes", "source_cluster_id", b"source_cluster_id", "started_at", b"started_at", "total_size_bytes", b"total_size_bytes"]) -> None: ...

global___Backup = Backup

@typing.final
class SnapshotManagement(google.protobuf.message.Message):
    """Snapshot management configuration"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SNAPSHOT_SCHEDULE_FIELD_NUMBER: builtins.int
    SNAPSHOT_MAX_AGE_DAYS_FIELD_NUMBER: builtins.int
    @property
    def snapshot_schedule(self) -> global___SnapshotSchedule:
        """Snapshot creation schedule"""

    @property
    def snapshot_max_age_days(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Snapshot max age in days"""

    def __init__(
        self,
        *,
        snapshot_schedule: global___SnapshotSchedule | None = ...,
        snapshot_max_age_days: google.protobuf.wrappers_pb2.Int64Value | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["snapshot_max_age_days", b"snapshot_max_age_days", "snapshot_schedule", b"snapshot_schedule"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["snapshot_max_age_days", b"snapshot_max_age_days", "snapshot_schedule", b"snapshot_schedule"]) -> None: ...

global___SnapshotManagement = SnapshotManagement

@typing.final
class SnapshotSchedule(google.protobuf.message.Message):
    """Snapshot creation schedule"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HOURLY_SNAPSHOT_SCHEDULE_FIELD_NUMBER: builtins.int
    DAILY_SNAPSHOT_SCHEDULE_FIELD_NUMBER: builtins.int
    WEEKLY_SNAPSHOT_SCHEDULE_FIELD_NUMBER: builtins.int
    @property
    def hourly_snapshot_schedule(self) -> global___HourlySnapshotSchedule:
        """Hourly based snapshot schedule"""

    @property
    def daily_snapshot_schedule(self) -> global___DailySnapshotSchedule:
        """Daily based snapshot schedule"""

    @property
    def weekly_snapshot_schedule(self) -> global___WeeklySnapshotSchedule:
        """Weekly based snapshot schedule"""

    def __init__(
        self,
        *,
        hourly_snapshot_schedule: global___HourlySnapshotSchedule | None = ...,
        daily_snapshot_schedule: global___DailySnapshotSchedule | None = ...,
        weekly_snapshot_schedule: global___WeeklySnapshotSchedule | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["daily_snapshot_schedule", b"daily_snapshot_schedule", "hourly_snapshot_schedule", b"hourly_snapshot_schedule", "schedule", b"schedule", "weekly_snapshot_schedule", b"weekly_snapshot_schedule"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["daily_snapshot_schedule", b"daily_snapshot_schedule", "hourly_snapshot_schedule", b"hourly_snapshot_schedule", "schedule", b"schedule", "weekly_snapshot_schedule", b"weekly_snapshot_schedule"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["schedule", b"schedule"]) -> typing.Literal["hourly_snapshot_schedule", "daily_snapshot_schedule", "weekly_snapshot_schedule"] | None: ...

global___SnapshotSchedule = SnapshotSchedule

@typing.final
class HourlySnapshotSchedule(google.protobuf.message.Message):
    """Hourly based snapshot schedule"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MINUTE_FIELD_NUMBER: builtins.int
    minute: builtins.int
    """The minute of the hour at which the backup should be created."""
    def __init__(
        self,
        *,
        minute: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["minute", b"minute"]) -> None: ...

global___HourlySnapshotSchedule = HourlySnapshotSchedule

@typing.final
class DailySnapshotSchedule(google.protobuf.message.Message):
    """Daily based snapshot schedule"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HOUR_FIELD_NUMBER: builtins.int
    MINUTE_FIELD_NUMBER: builtins.int
    hour: builtins.int
    """The hour of the day in UTC timezone at which the backup should be created."""
    minute: builtins.int
    """The minute of the hour at which the backup should be created."""
    def __init__(
        self,
        *,
        hour: builtins.int = ...,
        minute: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["hour", b"hour", "minute", b"minute"]) -> None: ...

global___DailySnapshotSchedule = DailySnapshotSchedule

@typing.final
class WeeklySnapshotSchedule(google.protobuf.message.Message):
    """Weekly based snapshot schedule"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _WeekDay:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _WeekDayEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[WeeklySnapshotSchedule._WeekDay.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        WEEK_DAY_UNSPECIFIED: WeeklySnapshotSchedule._WeekDay.ValueType  # 0
        MON: WeeklySnapshotSchedule._WeekDay.ValueType  # 1
        TUE: WeeklySnapshotSchedule._WeekDay.ValueType  # 2
        WED: WeeklySnapshotSchedule._WeekDay.ValueType  # 3
        THU: WeeklySnapshotSchedule._WeekDay.ValueType  # 4
        FRI: WeeklySnapshotSchedule._WeekDay.ValueType  # 5
        SAT: WeeklySnapshotSchedule._WeekDay.ValueType  # 6
        SUN: WeeklySnapshotSchedule._WeekDay.ValueType  # 7

    class WeekDay(_WeekDay, metaclass=_WeekDayEnumTypeWrapper):
        """Day of the week"""

    WEEK_DAY_UNSPECIFIED: WeeklySnapshotSchedule.WeekDay.ValueType  # 0
    MON: WeeklySnapshotSchedule.WeekDay.ValueType  # 1
    TUE: WeeklySnapshotSchedule.WeekDay.ValueType  # 2
    WED: WeeklySnapshotSchedule.WeekDay.ValueType  # 3
    THU: WeeklySnapshotSchedule.WeekDay.ValueType  # 4
    FRI: WeeklySnapshotSchedule.WeekDay.ValueType  # 5
    SAT: WeeklySnapshotSchedule.WeekDay.ValueType  # 6
    SUN: WeeklySnapshotSchedule.WeekDay.ValueType  # 7

    DAY_FIELD_NUMBER: builtins.int
    HOUR_FIELD_NUMBER: builtins.int
    MINUTE_FIELD_NUMBER: builtins.int
    day: global___WeeklySnapshotSchedule.WeekDay.ValueType
    """Day of the week"""
    hour: builtins.int
    """The hour of the day in UTC timezone at which the backup should be created."""
    minute: builtins.int
    """The minute of the hour at which the backup should be created."""
    def __init__(
        self,
        *,
        day: global___WeeklySnapshotSchedule.WeekDay.ValueType = ...,
        hour: builtins.int = ...,
        minute: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["day", b"day", "hour", b"hour", "minute", b"minute"]) -> None: ...

global___WeeklySnapshotSchedule = WeeklySnapshotSchedule
