"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.wrappers_pb2
import typing

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Database(google.protobuf.message.Message):
    """A PostgreSQL Database resource. For more information, see
    the [Developer's Guide](/docs/managed-postgresql/concepts).
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    CLUSTER_ID_FIELD_NUMBER: builtins.int
    OWNER_FIELD_NUMBER: builtins.int
    LC_COLLATE_FIELD_NUMBER: builtins.int
    LC_CTYPE_FIELD_NUMBER: builtins.int
    EXTENSIONS_FIELD_NUMBER: builtins.int
    TEMPLATE_DB_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the database."""
    cluster_id: builtins.str
    """ID of the PostgreSQL cluster that the database belongs to."""
    owner: builtins.str
    """Name of the user assigned as the owner of the database."""
    lc_collate: builtins.str
    """POSIX locale for string sorting order.
    Can only be set at creation time.
    """
    lc_ctype: builtins.str
    """POSIX locale for character classification.
    Can only be set at creation time.
    """
    template_db: builtins.str
    """Name of the database template."""
    @property
    def extensions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Extension]:
        """PostgreSQL extensions enabled for the database."""

    @property
    def deletion_protection(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Deletion Protection inhibits deletion of the database

        Default value: `unspecified` (inherits cluster's deletion_protection)
        """

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        cluster_id: builtins.str = ...,
        owner: builtins.str = ...,
        lc_collate: builtins.str = ...,
        lc_ctype: builtins.str = ...,
        extensions: collections.abc.Iterable[global___Extension] | None = ...,
        template_db: builtins.str = ...,
        deletion_protection: google.protobuf.wrappers_pb2.BoolValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["deletion_protection", b"deletion_protection"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "deletion_protection", b"deletion_protection", "extensions", b"extensions", "lc_collate", b"lc_collate", "lc_ctype", b"lc_ctype", "name", b"name", "owner", b"owner", "template_db", b"template_db"]) -> None: ...

global___Database = Database

@typing.final
class Extension(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the extension, e.g. `pg_trgm` or `pg_btree`.
    Extensions supported by Managed Service for PostgreSQL are [listed in the Developer's Guide](/docs/managed-postgresql/operations/extensions/cluster-extensions).
    """
    version: builtins.str
    """Version of the extension. The setting is deprecated and has no effect."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        version: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["name", b"name", "version", b"version"]) -> None: ...

global___Extension = Extension

@typing.final
class DatabaseSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    OWNER_FIELD_NUMBER: builtins.int
    LC_COLLATE_FIELD_NUMBER: builtins.int
    LC_CTYPE_FIELD_NUMBER: builtins.int
    EXTENSIONS_FIELD_NUMBER: builtins.int
    TEMPLATE_DB_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the PostgreSQL database. 1-63 characters long."""
    owner: builtins.str
    """Name of the user to be assigned as the owner of the database.
    To get the list of available PostgreSQL users, make a [UserService.List] request.
    """
    lc_collate: builtins.str
    """POSIX locale for string sorting order.
    Can only be set at creation time.
    """
    lc_ctype: builtins.str
    """POSIX locale for character classification.
    Can only be set at creation time.
    """
    template_db: builtins.str
    """Name of the PostgreSQL database template."""
    @property
    def extensions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Extension]:
        """PostgreSQL extensions to be enabled for the database."""

    @property
    def deletion_protection(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Deletion Protection inhibits deletion of the database

        Default value: `unspecified` (inherits cluster's deletion_protection)
        """

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        owner: builtins.str = ...,
        lc_collate: builtins.str = ...,
        lc_ctype: builtins.str = ...,
        extensions: collections.abc.Iterable[global___Extension] | None = ...,
        template_db: builtins.str = ...,
        deletion_protection: google.protobuf.wrappers_pb2.BoolValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["deletion_protection", b"deletion_protection"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["deletion_protection", b"deletion_protection", "extensions", b"extensions", "lc_collate", b"lc_collate", "lc_ctype", b"lc_ctype", "name", b"name", "owner", b"owner", "template_db", b"template_db"]) -> None: ...

global___DatabaseSpec = DatabaseSpec
