"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.wrappers_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _AuthMethod:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _AuthMethodEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_AuthMethod.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    AUTH_METHOD_UNSPECIFIED: _AuthMethod.ValueType  # 0
    AUTH_METHOD_PASSWORD: _AuthMethod.ValueType  # 1
    AUTH_METHOD_IAM: _AuthMethod.ValueType  # 2

class AuthMethod(_AuthMethod, metaclass=_AuthMethodEnumTypeWrapper): ...

AUTH_METHOD_UNSPECIFIED: AuthMethod.ValueType  # 0
AUTH_METHOD_PASSWORD: AuthMethod.ValueType  # 1
AUTH_METHOD_IAM: AuthMethod.ValueType  # 2
global___AuthMethod = AuthMethod

class _UserPasswordEncryption:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _UserPasswordEncryptionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_UserPasswordEncryption.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    USER_PASSWORD_ENCRYPTION_UNSPECIFIED: _UserPasswordEncryption.ValueType  # 0
    USER_PASSWORD_ENCRYPTION_MD5: _UserPasswordEncryption.ValueType  # 1
    USER_PASSWORD_ENCRYPTION_SCRAM_SHA_256: _UserPasswordEncryption.ValueType  # 2

class UserPasswordEncryption(_UserPasswordEncryption, metaclass=_UserPasswordEncryptionEnumTypeWrapper): ...

USER_PASSWORD_ENCRYPTION_UNSPECIFIED: UserPasswordEncryption.ValueType  # 0
USER_PASSWORD_ENCRYPTION_MD5: UserPasswordEncryption.ValueType  # 1
USER_PASSWORD_ENCRYPTION_SCRAM_SHA_256: UserPasswordEncryption.ValueType  # 2
global___UserPasswordEncryption = UserPasswordEncryption

@typing.final
class User(google.protobuf.message.Message):
    """A PostgreSQL User resource. For more information, see
    the [Developer's Guide](/docs/managed-postgresql/concepts).
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    CLUSTER_ID_FIELD_NUMBER: builtins.int
    PERMISSIONS_FIELD_NUMBER: builtins.int
    CONN_LIMIT_FIELD_NUMBER: builtins.int
    SETTINGS_FIELD_NUMBER: builtins.int
    LOGIN_FIELD_NUMBER: builtins.int
    GRANTS_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    USER_PASSWORD_ENCRYPTION_FIELD_NUMBER: builtins.int
    CONNECTION_MANAGER_FIELD_NUMBER: builtins.int
    AUTH_METHOD_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the PostgreSQL user."""
    cluster_id: builtins.str
    """ID of the PostgreSQL cluster the user belongs to."""
    conn_limit: builtins.int
    """Maximum number of database connections available to the user.

    When used in session pooling, this setting limits the number of connections to every single host in PostgreSQL cluster. In this case, the setting's value must be greater than the total number of connections that backend services can open to access the PostgreSQL cluster. The setting's value should not exceed the value of the [Cluster.config.postgresql_config_12.effective_config.max_connections] setting.

    When used in transaction pooling, this setting limits the number of user's active transactions; therefore, in this mode user can open thousands of connections, but only `N` concurrent connections will be opened, where `N` is the value of the setting.

    Minimum value: `10` (default: `50`), when used in session pooling.
    """
    user_password_encryption: global___UserPasswordEncryption.ValueType
    """Password-based authentication method for user.
    Possible values are `` USER_PASSWORD_ENCRYPTION_MD5 `` or `` USER_PASSWORD_ENCRYPTION_SCRAM_SHA_256 ``.
    The default is `` password_encryption `` setting for cluster.
    """
    auth_method: global___AuthMethod.ValueType
    """Auth method for user"""
    @property
    def permissions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Permission]:
        """Set of permissions granted to the user to access specific databases."""

    @property
    def settings(self) -> global___UserSettings: ...
    @property
    def login(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """This flag defines whether the user can login to a PostgreSQL database.

        Default value: `true` (login is allowed).
        """

    @property
    def grants(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A set of roles and privileges that are granted to the user.

        For more information, see [the documentation](/docs/managed-postgresql/operations/grant).
        """

    @property
    def deletion_protection(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Determines whether the user deletion protection is enabled.

        The default value is `unspecified`. In this case, the user configuration inherits the cluster's deletion protection settings.
        """

    @property
    def connection_manager(self) -> global___ConnectionManager:
        """Connection Manager Connection and settings associated with user. Read only field."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        cluster_id: builtins.str = ...,
        permissions: collections.abc.Iterable[global___Permission] | None = ...,
        conn_limit: builtins.int = ...,
        settings: global___UserSettings | None = ...,
        login: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        grants: collections.abc.Iterable[builtins.str] | None = ...,
        deletion_protection: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        user_password_encryption: global___UserPasswordEncryption.ValueType = ...,
        connection_manager: global___ConnectionManager | None = ...,
        auth_method: global___AuthMethod.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["connection_manager", b"connection_manager", "deletion_protection", b"deletion_protection", "login", b"login", "settings", b"settings"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["auth_method", b"auth_method", "cluster_id", b"cluster_id", "conn_limit", b"conn_limit", "connection_manager", b"connection_manager", "deletion_protection", b"deletion_protection", "grants", b"grants", "login", b"login", "name", b"name", "permissions", b"permissions", "settings", b"settings", "user_password_encryption", b"user_password_encryption"]) -> None: ...

global___User = User

@typing.final
class Permission(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATABASE_NAME_FIELD_NUMBER: builtins.int
    database_name: builtins.str
    """Name of the database that the permission grants access to."""
    def __init__(
        self,
        *,
        database_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["database_name", b"database_name"]) -> None: ...

global___Permission = Permission

@typing.final
class ConnectionManager(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTION_ID_FIELD_NUMBER: builtins.int
    connection_id: builtins.str
    """ID of Connection Manager Connection"""
    def __init__(
        self,
        *,
        connection_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["connection_id", b"connection_id"]) -> None: ...

global___ConnectionManager = ConnectionManager

@typing.final
class UserSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    PASSWORD_FIELD_NUMBER: builtins.int
    PERMISSIONS_FIELD_NUMBER: builtins.int
    CONN_LIMIT_FIELD_NUMBER: builtins.int
    SETTINGS_FIELD_NUMBER: builtins.int
    LOGIN_FIELD_NUMBER: builtins.int
    GRANTS_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    USER_PASSWORD_ENCRYPTION_FIELD_NUMBER: builtins.int
    GENERATE_PASSWORD_FIELD_NUMBER: builtins.int
    AUTH_METHOD_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the PostgreSQL user."""
    password: builtins.str
    """Password of the PostgreSQL user."""
    user_password_encryption: global___UserPasswordEncryption.ValueType
    """Password-based authentication method for user.
    Possible values are `` USER_PASSWORD_ENCRYPTION_MD5 `` or `` USER_PASSWORD_ENCRYPTION_SCRAM_SHA_256 ``.
    The default is `` password_encryption `` setting for cluster.
    """
    auth_method: global___AuthMethod.ValueType
    """Auth method for user"""
    @property
    def permissions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Permission]:
        """Set of permissions to grant to the user to access specific databases."""

    @property
    def conn_limit(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Maximum number of database connections that should be available to the user.

        When used in session pooling, this setting limits the number of connections to every single host in PostgreSQL cluster. In this case, the setting's value must be greater than the total number of connections that backend services can open to access the PostgreSQL cluster. The setting's value should not exceed the value of the [Cluster.config.postgresql_config_12.effective_config.max_connections] setting.

        When used in transaction pooling, this setting limits the number of user's active transactions; therefore, in this mode user can open thousands of connections, but only `N` concurrent connections will be opened, where `N` is the value of the setting.

        Minimum value: `10` (default: `50`), when used in session pooling.
        """

    @property
    def settings(self) -> global___UserSettings:
        """PostgreSQL settings for the user."""

    @property
    def login(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """This flag defines whether the user can login to a PostgreSQL database.

        Default value: `true` (login is allowed).
        """

    @property
    def grants(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A set of roles and privileges that are granted to the user.

        For more information, see [the documentation](/docs/managed-postgresql/operations/grant).
        """

    @property
    def deletion_protection(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Deletion Protection inhibits deletion of the user

        Default value: `unspecified` (inherits cluster's deletion_protection)
        """

    @property
    def generate_password(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Generate password using Connection Manager."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        password: builtins.str = ...,
        permissions: collections.abc.Iterable[global___Permission] | None = ...,
        conn_limit: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        settings: global___UserSettings | None = ...,
        login: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        grants: collections.abc.Iterable[builtins.str] | None = ...,
        deletion_protection: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        user_password_encryption: global___UserPasswordEncryption.ValueType = ...,
        generate_password: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        auth_method: global___AuthMethod.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["conn_limit", b"conn_limit", "deletion_protection", b"deletion_protection", "generate_password", b"generate_password", "login", b"login", "settings", b"settings"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["auth_method", b"auth_method", "conn_limit", b"conn_limit", "deletion_protection", b"deletion_protection", "generate_password", b"generate_password", "grants", b"grants", "login", b"login", "name", b"name", "password", b"password", "permissions", b"permissions", "settings", b"settings", "user_password_encryption", b"user_password_encryption"]) -> None: ...

global___UserSpec = UserSpec

@typing.final
class PGAuditSettings(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _PGAuditSettingsLog:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _PGAuditSettingsLogEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[PGAuditSettings._PGAuditSettingsLog.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PG_AUDIT_SETTINGS_LOG_UNSPECIFIED: PGAuditSettings._PGAuditSettingsLog.ValueType  # 0
        PG_AUDIT_SETTINGS_LOG_READ: PGAuditSettings._PGAuditSettingsLog.ValueType  # 1
        PG_AUDIT_SETTINGS_LOG_WRITE: PGAuditSettings._PGAuditSettingsLog.ValueType  # 2
        PG_AUDIT_SETTINGS_LOG_FUNCTION: PGAuditSettings._PGAuditSettingsLog.ValueType  # 3
        PG_AUDIT_SETTINGS_LOG_ROLE: PGAuditSettings._PGAuditSettingsLog.ValueType  # 4
        PG_AUDIT_SETTINGS_LOG_DDL: PGAuditSettings._PGAuditSettingsLog.ValueType  # 5
        PG_AUDIT_SETTINGS_LOG_MISC: PGAuditSettings._PGAuditSettingsLog.ValueType  # 6
        PG_AUDIT_SETTINGS_LOG_MISC_SET: PGAuditSettings._PGAuditSettingsLog.ValueType  # 7

    class PGAuditSettingsLog(_PGAuditSettingsLog, metaclass=_PGAuditSettingsLogEnumTypeWrapper): ...
    PG_AUDIT_SETTINGS_LOG_UNSPECIFIED: PGAuditSettings.PGAuditSettingsLog.ValueType  # 0
    PG_AUDIT_SETTINGS_LOG_READ: PGAuditSettings.PGAuditSettingsLog.ValueType  # 1
    PG_AUDIT_SETTINGS_LOG_WRITE: PGAuditSettings.PGAuditSettingsLog.ValueType  # 2
    PG_AUDIT_SETTINGS_LOG_FUNCTION: PGAuditSettings.PGAuditSettingsLog.ValueType  # 3
    PG_AUDIT_SETTINGS_LOG_ROLE: PGAuditSettings.PGAuditSettingsLog.ValueType  # 4
    PG_AUDIT_SETTINGS_LOG_DDL: PGAuditSettings.PGAuditSettingsLog.ValueType  # 5
    PG_AUDIT_SETTINGS_LOG_MISC: PGAuditSettings.PGAuditSettingsLog.ValueType  # 6
    PG_AUDIT_SETTINGS_LOG_MISC_SET: PGAuditSettings.PGAuditSettingsLog.ValueType  # 7

    LOG_FIELD_NUMBER: builtins.int
    @property
    def log(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___PGAuditSettings.PGAuditSettingsLog.ValueType]:
        """Defines which user queries will be written to the audit log. Corresponds to the [Pg audit log](https://yandex.cloud/en/docs/managed-postgresql/concepts/settings-list#setting-pg-audit-log) user setting.

        The possible values are the following:

        * PG_AUDIT_SETTINGS_LOG_READ: `SELECT` and `COPY` queries are logged if the data source is a relation or query.
        * PG_AUDIT_SETTINGS_LOG_WRITE: `INSERT`, `UPDATE`, `DELETE`, `TRUNCATE`, and `COPY` queries are logged if the data target is a relation.
        * PG_AUDIT_SETTINGS_LOG_FUNCTION: Function invocations and `DO` sections are logged.
        * PG_AUDIT_SETTINGS_LOG_ROLE: Statements related to role and privilege management, such as `GRANT`, `REVOKE`, or `CREATE/ALTER/DROP ROLE`, are logged.
        * PG_AUDIT_SETTINGS_LOG_DDL: Any `DDL` statements that do not belong to the `ROLE` class are logged.
        * PG_AUDIT_SETTINGS_LOG_MISC: Miscellaneous commands, such as `DISCARD`, `FETCH`, `CHECKPOINT`, `VACUUM`, and `SET`, are logged.
        * PG_AUDIT_SETTINGS_LOG_MISC_SET: Miscellaneous `SET` commands, e.g., `SET ROLE`, are logged.

        The default value is PG_AUDIT_SETTINGS_LOG_UNSPECIFIED. In this case, the parameter is not configured.
        """

    def __init__(
        self,
        *,
        log: collections.abc.Iterable[global___PGAuditSettings.PGAuditSettingsLog.ValueType] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["log", b"log"]) -> None: ...

global___PGAuditSettings = PGAuditSettings

@typing.final
class UserSettings(google.protobuf.message.Message):
    """PostgreSQL user settings."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _SynchronousCommit:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _SynchronousCommitEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[UserSettings._SynchronousCommit.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SYNCHRONOUS_COMMIT_UNSPECIFIED: UserSettings._SynchronousCommit.ValueType  # 0
        SYNCHRONOUS_COMMIT_ON: UserSettings._SynchronousCommit.ValueType  # 1
        """Success is reported to the client if the data is in WAL (Write-Ahead Log), and WAL is written to the storage of both the master and its synchronous standby server. Default value."""
        SYNCHRONOUS_COMMIT_OFF: UserSettings._SynchronousCommit.ValueType  # 2
        """Success is reported to the client even if the data is not in WAL.
        There is no synchronous write operation, data may be loss in case of storage subsystem failure.
        """
        SYNCHRONOUS_COMMIT_LOCAL: UserSettings._SynchronousCommit.ValueType  # 3
        """Success is reported to the client if the data is in WAL, and WAL is written to the storage of the master server.
        The transaction may be lost due to storage subsystem failure on the master server.
        """
        SYNCHRONOUS_COMMIT_REMOTE_WRITE: UserSettings._SynchronousCommit.ValueType  # 4
        """Success is reported to the client if the data is in WAL, WAL is written to the storage of the master server, and the server's synchronous standby indicates that it has received WAL and written it out to its operating system.
        The transaction may be lost due to simultaneous storage subsystem failure on the master and operating system's failure on the synchronous standby.
        """
        SYNCHRONOUS_COMMIT_REMOTE_APPLY: UserSettings._SynchronousCommit.ValueType  # 5
        """Success is reported to the client if the data is in WAL (Write-Ahead Log), WAL is written to the storage of the master server, and its synchronous standby indicates that it has received WAL and applied it.
        The transaction may be lost due to irrecoverably failure of both the master and its synchronous standby.
        """

    class SynchronousCommit(_SynchronousCommit, metaclass=_SynchronousCommitEnumTypeWrapper): ...
    SYNCHRONOUS_COMMIT_UNSPECIFIED: UserSettings.SynchronousCommit.ValueType  # 0
    SYNCHRONOUS_COMMIT_ON: UserSettings.SynchronousCommit.ValueType  # 1
    """Success is reported to the client if the data is in WAL (Write-Ahead Log), and WAL is written to the storage of both the master and its synchronous standby server. Default value."""
    SYNCHRONOUS_COMMIT_OFF: UserSettings.SynchronousCommit.ValueType  # 2
    """Success is reported to the client even if the data is not in WAL.
    There is no synchronous write operation, data may be loss in case of storage subsystem failure.
    """
    SYNCHRONOUS_COMMIT_LOCAL: UserSettings.SynchronousCommit.ValueType  # 3
    """Success is reported to the client if the data is in WAL, and WAL is written to the storage of the master server.
    The transaction may be lost due to storage subsystem failure on the master server.
    """
    SYNCHRONOUS_COMMIT_REMOTE_WRITE: UserSettings.SynchronousCommit.ValueType  # 4
    """Success is reported to the client if the data is in WAL, WAL is written to the storage of the master server, and the server's synchronous standby indicates that it has received WAL and written it out to its operating system.
    The transaction may be lost due to simultaneous storage subsystem failure on the master and operating system's failure on the synchronous standby.
    """
    SYNCHRONOUS_COMMIT_REMOTE_APPLY: UserSettings.SynchronousCommit.ValueType  # 5
    """Success is reported to the client if the data is in WAL (Write-Ahead Log), WAL is written to the storage of the master server, and its synchronous standby indicates that it has received WAL and applied it.
    The transaction may be lost due to irrecoverably failure of both the master and its synchronous standby.
    """

    class _LogStatement:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _LogStatementEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[UserSettings._LogStatement.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        LOG_STATEMENT_UNSPECIFIED: UserSettings._LogStatement.ValueType  # 0
        LOG_STATEMENT_NONE: UserSettings._LogStatement.ValueType  # 1
        """Logs none of SQL statements. Default value."""
        LOG_STATEMENT_DDL: UserSettings._LogStatement.ValueType  # 2
        """Logs all data definition statements (such as `CREATE`, `ALTER`, `DROP` and others)."""
        LOG_STATEMENT_MOD: UserSettings._LogStatement.ValueType  # 3
        """Logs all statements that fall in the `LOG_STATEMENT_DDL` category plus data-modifying statements (such as `INSERT`, `UPDATE` and others)."""
        LOG_STATEMENT_ALL: UserSettings._LogStatement.ValueType  # 4
        """Logs all SQL statements."""

    class LogStatement(_LogStatement, metaclass=_LogStatementEnumTypeWrapper): ...
    LOG_STATEMENT_UNSPECIFIED: UserSettings.LogStatement.ValueType  # 0
    LOG_STATEMENT_NONE: UserSettings.LogStatement.ValueType  # 1
    """Logs none of SQL statements. Default value."""
    LOG_STATEMENT_DDL: UserSettings.LogStatement.ValueType  # 2
    """Logs all data definition statements (such as `CREATE`, `ALTER`, `DROP` and others)."""
    LOG_STATEMENT_MOD: UserSettings.LogStatement.ValueType  # 3
    """Logs all statements that fall in the `LOG_STATEMENT_DDL` category plus data-modifying statements (such as `INSERT`, `UPDATE` and others)."""
    LOG_STATEMENT_ALL: UserSettings.LogStatement.ValueType  # 4
    """Logs all SQL statements."""

    class _TransactionIsolation:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TransactionIsolationEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[UserSettings._TransactionIsolation.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TRANSACTION_ISOLATION_UNSPECIFIED: UserSettings._TransactionIsolation.ValueType  # 0
        TRANSACTION_ISOLATION_READ_UNCOMMITTED: UserSettings._TransactionIsolation.ValueType  # 1
        """This level behaves like `TRANSACTION_ISOLATION_READ_COMMITTED` in PostgreSQL."""
        TRANSACTION_ISOLATION_READ_COMMITTED: UserSettings._TransactionIsolation.ValueType  # 2
        """On this level query sees only data committed before the query began. Default value."""
        TRANSACTION_ISOLATION_REPEATABLE_READ: UserSettings._TransactionIsolation.ValueType  # 3
        """On this level all subsequent queries in a transaction will see the same rows, that were read by the first `SELECT` or `INSERT` query in this transaction, unchanged (these rows are locked during the first query)."""
        TRANSACTION_ISOLATION_SERIALIZABLE: UserSettings._TransactionIsolation.ValueType  # 4
        """This level provides the strictest transaction isolation.
        All queries in the current transaction see only the rows that were fixed prior to execution of the first `SELECT` or `INSERT` query in this transaction.
        If read and write operations in a concurrent set of serializable transactions overlap and this may cause an inconsistency that is not possible during the serial transaction execution, then one of the transaction will be rolled back, triggering a serialization failure.
        """

    class TransactionIsolation(_TransactionIsolation, metaclass=_TransactionIsolationEnumTypeWrapper): ...
    TRANSACTION_ISOLATION_UNSPECIFIED: UserSettings.TransactionIsolation.ValueType  # 0
    TRANSACTION_ISOLATION_READ_UNCOMMITTED: UserSettings.TransactionIsolation.ValueType  # 1
    """This level behaves like `TRANSACTION_ISOLATION_READ_COMMITTED` in PostgreSQL."""
    TRANSACTION_ISOLATION_READ_COMMITTED: UserSettings.TransactionIsolation.ValueType  # 2
    """On this level query sees only data committed before the query began. Default value."""
    TRANSACTION_ISOLATION_REPEATABLE_READ: UserSettings.TransactionIsolation.ValueType  # 3
    """On this level all subsequent queries in a transaction will see the same rows, that were read by the first `SELECT` or `INSERT` query in this transaction, unchanged (these rows are locked during the first query)."""
    TRANSACTION_ISOLATION_SERIALIZABLE: UserSettings.TransactionIsolation.ValueType  # 4
    """This level provides the strictest transaction isolation.
    All queries in the current transaction see only the rows that were fixed prior to execution of the first `SELECT` or `INSERT` query in this transaction.
    If read and write operations in a concurrent set of serializable transactions overlap and this may cause an inconsistency that is not possible during the serial transaction execution, then one of the transaction will be rolled back, triggering a serialization failure.
    """

    class _PoolingMode:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _PoolingModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[UserSettings._PoolingMode.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        POOLING_MODE_UNSPECIFIED: UserSettings._PoolingMode.ValueType  # 0
        SESSION: UserSettings._PoolingMode.ValueType  # 1
        """Server connection will be assigned to it for the whole duration the client stays connected. Default value."""
        TRANSACTION: UserSettings._PoolingMode.ValueType  # 2
        """Server connection is assigned to a client only during a transaction."""
        STATEMENT: UserSettings._PoolingMode.ValueType  # 3
        """Server connection will be put back into the pool immediately after a query completes."""

    class PoolingMode(_PoolingMode, metaclass=_PoolingModeEnumTypeWrapper): ...
    POOLING_MODE_UNSPECIFIED: UserSettings.PoolingMode.ValueType  # 0
    SESSION: UserSettings.PoolingMode.ValueType  # 1
    """Server connection will be assigned to it for the whole duration the client stays connected. Default value."""
    TRANSACTION: UserSettings.PoolingMode.ValueType  # 2
    """Server connection is assigned to a client only during a transaction."""
    STATEMENT: UserSettings.PoolingMode.ValueType  # 3
    """Server connection will be put back into the pool immediately after a query completes."""

    DEFAULT_TRANSACTION_ISOLATION_FIELD_NUMBER: builtins.int
    LOCK_TIMEOUT_FIELD_NUMBER: builtins.int
    LOG_MIN_DURATION_STATEMENT_FIELD_NUMBER: builtins.int
    SYNCHRONOUS_COMMIT_FIELD_NUMBER: builtins.int
    TEMP_FILE_LIMIT_FIELD_NUMBER: builtins.int
    LOG_STATEMENT_FIELD_NUMBER: builtins.int
    POOL_MODE_FIELD_NUMBER: builtins.int
    PREPARED_STATEMENTS_POOLING_FIELD_NUMBER: builtins.int
    CATCHUP_TIMEOUT_FIELD_NUMBER: builtins.int
    WAL_SENDER_TIMEOUT_FIELD_NUMBER: builtins.int
    IDLE_IN_TRANSACTION_SESSION_TIMEOUT_FIELD_NUMBER: builtins.int
    STATEMENT_TIMEOUT_FIELD_NUMBER: builtins.int
    PGAUDIT_FIELD_NUMBER: builtins.int
    default_transaction_isolation: global___UserSettings.TransactionIsolation.ValueType
    """SQL sets an isolation level for each transaction.
    This setting defines the default isolation level to be set for all new SQL transactions.

    For more information, see the [PostgreSQL documentation](https://www.postgresql.org/docs/current/transaction-iso.html).
    """
    synchronous_commit: global___UserSettings.SynchronousCommit.ValueType
    """This setting defines whether DBMS will commit transaction in a synchronous way.

    When synchronization is enabled, cluster waits for the synchronous operations to be completed prior to reporting `success` to the client.
    These operations guarantee different levels of the data safety and visibility in the cluster.

    For more information, see the [PostgreSQL documentation](https://www.postgresql.org/docs/current/runtime-config-wal.html#GUC-SYNCHRONOUS-COMMIT).
    """
    log_statement: global___UserSettings.LogStatement.ValueType
    """This setting specifies which SQL statements should be logged (on the user level).

    For more information, see the [PostgreSQL documentation](https://www.postgresql.org/docs/current/runtime-config-logging.html).
    """
    pool_mode: global___UserSettings.PoolingMode.ValueType
    """Mode that the connection pooler is working in with specified user.

    For more information, see the [Odyssey documentation](https://github.com/yandex/odyssey/blob/master/documentation/configuration.md#pool-string).
    """
    @property
    def lock_timeout(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The maximum time (in milliseconds) for any statement to wait for acquiring a lock on an table, index, row or other database object.
        If the wait time is longer than the specified amount, then this statement is aborted.

        Default value: `0` (no control is enforced, a statement waiting time is unlimited).
        """

    @property
    def log_min_duration_statement(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """This setting controls logging of the duration of statements.

        The duration of each completed statement will be logged if the statement ran for at least the specified amount of time (in milliseconds).
        E.g., if this setting's value is set to `500`, a statement that took 300 milliseconds to complete will not be logged; on the other hand, the one that took 2000 milliseconds to complete, will be logged.

        Value of `0` forces PostgreSQL to log the duration of all statements.

        Value of `-1` (default) disables logging of the duration of statements.

        For more information, see the [PostgreSQL documentation](https://www.postgresql.org/docs/current/runtime-config-logging.html).
        """

    @property
    def temp_file_limit(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The maximum storage space size (in kilobytes) that a single process can use to create temporary files.
        If a transaction exceeds this limit during execution, it will be aborted.

        A huge query may not fit into a server's RAM, therefore PostgreSQL will use some storage to store and execute such a query. Too big queries can make excessive use of the storage system, effectively making other quieries to run slow. This setting prevents execution of a big queries that can influence other queries by limiting size of temporary files.
        """

    @property
    def prepared_statements_pooling(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """User can use prepared statements with transaction pooling.

        For more information, see the [PostgreSQL documentation](https://www.postgresql.org/docs/current/sql-prepare.html).
        """

    @property
    def catchup_timeout(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The connection pooler setting. It determines the maximum allowed replication lag (in seconds).
        Pooler will reject connections to the replica with a lag above this threshold.
        It can be useful to prevent application from reading stale data.

        Default value: 0

        Value of `0` disables this mechanism
        """

    @property
    def wal_sender_timeout(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The maximum time (in milliseconds) to wait for WAL replication (can be set only for PostgreSQL 12+)
        Terminate replication connections that are inactive for longer than this amount of time. 

        Default value: `60000` (60 seconds).

        Value of `0` disables the timeout mechanism.

        For more information, see the [PostgreSQL documentation](https://www.postgresql.org/docs/current/runtime-config-replication.html).
        """

    @property
    def idle_in_transaction_session_timeout(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Sets the maximum allowed idle time, in milliseconds, between queries while in a transaction.

        The default value is `0`, which disables the timeout.

        For more information, see the [PostgreSQL documentation](https://www.postgresql.org/docs/current/runtime-config-client.html).
        in milliseconds.
        """

    @property
    def statement_timeout(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """The maximum time (in milliseconds) to wait for statement.
        The timeout is measured from the time a command arrives at the server until it is completed by the server. 

        If `log_min_error_statement` is set to ERROR or lower, the statement that timed out will also be logged.

        Value of `0` (default) disables the timeout

        For more information, see the [PostgreSQL documentation](https://www.postgresql.org/docs/current/runtime-config-client.html).
        """

    @property
    def pgaudit(self) -> global___PGAuditSettings:
        """Settings of the [PostgreSQL Audit Extension](https://www.pgaudit.org/) (pgaudit)."""

    def __init__(
        self,
        *,
        default_transaction_isolation: global___UserSettings.TransactionIsolation.ValueType = ...,
        lock_timeout: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        log_min_duration_statement: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        synchronous_commit: global___UserSettings.SynchronousCommit.ValueType = ...,
        temp_file_limit: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        log_statement: global___UserSettings.LogStatement.ValueType = ...,
        pool_mode: global___UserSettings.PoolingMode.ValueType = ...,
        prepared_statements_pooling: google.protobuf.wrappers_pb2.BoolValue | None = ...,
        catchup_timeout: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        wal_sender_timeout: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        idle_in_transaction_session_timeout: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        statement_timeout: google.protobuf.wrappers_pb2.Int64Value | None = ...,
        pgaudit: global___PGAuditSettings | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["catchup_timeout", b"catchup_timeout", "idle_in_transaction_session_timeout", b"idle_in_transaction_session_timeout", "lock_timeout", b"lock_timeout", "log_min_duration_statement", b"log_min_duration_statement", "pgaudit", b"pgaudit", "prepared_statements_pooling", b"prepared_statements_pooling", "statement_timeout", b"statement_timeout", "temp_file_limit", b"temp_file_limit", "wal_sender_timeout", b"wal_sender_timeout"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["catchup_timeout", b"catchup_timeout", "default_transaction_isolation", b"default_transaction_isolation", "idle_in_transaction_session_timeout", b"idle_in_transaction_session_timeout", "lock_timeout", b"lock_timeout", "log_min_duration_statement", b"log_min_duration_statement", "log_statement", b"log_statement", "pgaudit", b"pgaudit", "pool_mode", b"pool_mode", "prepared_statements_pooling", b"prepared_statements_pooling", "statement_timeout", b"statement_timeout", "synchronous_commit", b"synchronous_commit", "temp_file_limit", b"temp_file_limit", "wal_sender_timeout", b"wal_sender_timeout"]) -> None: ...

global___UserSettings = UserSettings
