"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.wrappers_pb2
import typing

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class User(google.protobuf.message.Message):
    """A Redis User resource. For more information, see the
    [Developer's Guide](/docs/managed-redis/concepts).
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    CLUSTER_ID_FIELD_NUMBER: builtins.int
    PERMISSIONS_FIELD_NUMBER: builtins.int
    ENABLED_FIELD_NUMBER: builtins.int
    ACL_OPTIONS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the Redis user."""
    cluster_id: builtins.str
    """ID of the Redis cluster the user belongs to."""
    enabled: builtins.bool
    """Is redis user enabled"""
    acl_options: builtins.str
    """Raw ACL string inside of Redis"""
    @property
    def permissions(self) -> global___Permissions:
        """Set of permissions to grant to the user."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        cluster_id: builtins.str = ...,
        permissions: global___Permissions | None = ...,
        enabled: builtins.bool = ...,
        acl_options: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["permissions", b"permissions"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["acl_options", b"acl_options", "cluster_id", b"cluster_id", "enabled", b"enabled", "name", b"name", "permissions", b"permissions"]) -> None: ...

global___User = User

@typing.final
class Permissions(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PATTERNS_FIELD_NUMBER: builtins.int
    PUB_SUB_CHANNELS_FIELD_NUMBER: builtins.int
    CATEGORIES_FIELD_NUMBER: builtins.int
    COMMANDS_FIELD_NUMBER: builtins.int
    SANITIZE_PAYLOAD_FIELD_NUMBER: builtins.int
    @property
    def patterns(self) -> google.protobuf.wrappers_pb2.StringValue:
        """Keys patterns user has permission to."""

    @property
    def pub_sub_channels(self) -> google.protobuf.wrappers_pb2.StringValue:
        """Channel patterns user has permissions to."""

    @property
    def categories(self) -> google.protobuf.wrappers_pb2.StringValue:
        """Command categories user has permissions to."""

    @property
    def commands(self) -> google.protobuf.wrappers_pb2.StringValue:
        """Commands user can execute."""

    @property
    def sanitize_payload(self) -> google.protobuf.wrappers_pb2.StringValue:
        """SanitizePayload parameter."""

    def __init__(
        self,
        *,
        patterns: google.protobuf.wrappers_pb2.StringValue | None = ...,
        pub_sub_channels: google.protobuf.wrappers_pb2.StringValue | None = ...,
        categories: google.protobuf.wrappers_pb2.StringValue | None = ...,
        commands: google.protobuf.wrappers_pb2.StringValue | None = ...,
        sanitize_payload: google.protobuf.wrappers_pb2.StringValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["categories", b"categories", "commands", b"commands", "patterns", b"patterns", "pub_sub_channels", b"pub_sub_channels", "sanitize_payload", b"sanitize_payload"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["categories", b"categories", "commands", b"commands", "patterns", b"patterns", "pub_sub_channels", b"pub_sub_channels", "sanitize_payload", b"sanitize_payload"]) -> None: ...

global___Permissions = Permissions

@typing.final
class UserSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    PASSWORDS_FIELD_NUMBER: builtins.int
    PERMISSIONS_FIELD_NUMBER: builtins.int
    ENABLED_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the Redis user."""
    @property
    def passwords(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Password of the Redis user."""

    @property
    def permissions(self) -> global___Permissions:
        """Set of permissions to grant to the user."""

    @property
    def enabled(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """Is Redis user enabled"""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        passwords: collections.abc.Iterable[builtins.str] | None = ...,
        permissions: global___Permissions | None = ...,
        enabled: google.protobuf.wrappers_pb2.BoolValue | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["enabled", b"enabled", "permissions", b"permissions"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["enabled", b"enabled", "name", b"name", "passwords", b"passwords", "permissions", b"permissions"]) -> None: ...

global___UserSpec = UserSpec
