"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import typing
import yandex.cloud.mdb.sqlserver.v1.database_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetDatabaseRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    DATABASE_NAME_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the SQL Server cluster the database belongs to.

    To get the cluster ID, use a [ClusterService.List] request.
    """
    database_name: builtins.str
    """Name of the SQL Server database to return.

    To get the name of the database use a [DatabaseService.List] request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        database_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "database_name", b"database_name"]) -> None: ...

global___GetDatabaseRequest = GetDatabaseRequest

@typing.final
class ListDatabasesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the SQL Server cluster to list databases in.

    To get the cluster ID, use a [ClusterService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return.

    If the number of available results is larger than [page_size], the service returns a [ListDatabasesResponse.next_page_token] that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token] to the [ListDatabasesResponse.next_page_token] returned by the previous list request."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListDatabasesRequest = ListDatabasesRequest

@typing.final
class ListDatabasesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATABASES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token that allows you to get the next page of results for list requests.

    If the number of results is larger than [ListDatabasesRequest.page_size], use the [next_page_token] as the value for the [ListDatabasesRequest.page_token] parameter in the next list request.

    Each subsequent list request has its own [next_page_token] to continue paging through the results.
    """
    @property
    def databases(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.mdb.sqlserver.v1.database_pb2.Database]:
        """List of SQL Server databases."""

    def __init__(
        self,
        *,
        databases: collections.abc.Iterable[yandex.cloud.mdb.sqlserver.v1.database_pb2.Database] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["databases", b"databases", "next_page_token", b"next_page_token"]) -> None: ...

global___ListDatabasesResponse = ListDatabasesResponse

@typing.final
class CreateDatabaseRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    DATABASE_SPEC_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the SQL Server cluster to create a database in.

    To get the cluster ID, use a [ClusterService.List] request.
    """
    @property
    def database_spec(self) -> yandex.cloud.mdb.sqlserver.v1.database_pb2.DatabaseSpec:
        """Configuration of the database to create."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        database_spec: yandex.cloud.mdb.sqlserver.v1.database_pb2.DatabaseSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["database_spec", b"database_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "database_spec", b"database_spec"]) -> None: ...

global___CreateDatabaseRequest = CreateDatabaseRequest

@typing.final
class CreateDatabaseMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    DATABASE_NAME_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the SQL Server cluster where the database is being created."""
    database_name: builtins.str
    """Name of the SQL Server database being created."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        database_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "database_name", b"database_name"]) -> None: ...

global___CreateDatabaseMetadata = CreateDatabaseMetadata

@typing.final
class DeleteDatabaseRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    DATABASE_NAME_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the SQL Server cluster to delete a database in.

    To get the cluster ID, use a [ClusterService.List] request.
    """
    database_name: builtins.str
    """Name of the database to delete.

    To get the name of the database, use a [DatabaseService.List] request.
    """
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        database_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "database_name", b"database_name"]) -> None: ...

global___DeleteDatabaseRequest = DeleteDatabaseRequest

@typing.final
class DeleteDatabaseMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    DATABASE_NAME_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the SQL Server cluster where the database is being deleted."""
    database_name: builtins.str
    """Name of the SQL Server database being deleted."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        database_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "database_name", b"database_name"]) -> None: ...

global___DeleteDatabaseMetadata = DeleteDatabaseMetadata

@typing.final
class RestoreDatabaseRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    DATABASE_NAME_FIELD_NUMBER: builtins.int
    FROM_DATABASE_FIELD_NUMBER: builtins.int
    BACKUP_ID_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the SQL Server cluster to restore a database in.

    To get the cluster ID, use a [ClusterService.List] request.
    """
    database_name: builtins.str
    """Name of the SQL Server database that is being restored."""
    from_database: builtins.str
    """Name of the database which backup is used to restore the database."""
    backup_id: builtins.str
    """ID of a backup to be used."""
    @property
    def time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp which is used for Point-in-Time recovery."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        database_name: builtins.str = ...,
        from_database: builtins.str = ...,
        backup_id: builtins.str = ...,
        time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["time", b"time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["backup_id", b"backup_id", "cluster_id", b"cluster_id", "database_name", b"database_name", "from_database", b"from_database", "time", b"time"]) -> None: ...

global___RestoreDatabaseRequest = RestoreDatabaseRequest

@typing.final
class RestoreDatabaseMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    DATABASE_NAME_FIELD_NUMBER: builtins.int
    FROM_DATABASE_FIELD_NUMBER: builtins.int
    BACKUP_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the SQL Server cluster where a database is being created."""
    database_name: builtins.str
    """Name of an SQL Server database that is being created."""
    from_database: builtins.str
    """Name of the database which backup is used to restore the database."""
    backup_id: builtins.str
    """ID of a backup to be used."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        database_name: builtins.str = ...,
        from_database: builtins.str = ...,
        backup_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["backup_id", b"backup_id", "cluster_id", b"cluster_id", "database_name", b"database_name", "from_database", b"from_database"]) -> None: ...

global___RestoreDatabaseMetadata = RestoreDatabaseMetadata

@typing.final
class ImportDatabaseBackupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    DATABASE_NAME_FIELD_NUMBER: builtins.int
    S3_BUCKET_FIELD_NUMBER: builtins.int
    S3_PATH_FIELD_NUMBER: builtins.int
    FILES_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the SQL Server cluster to import a database in.

    To get the cluster ID, use a [ClusterService.List] request.
    """
    database_name: builtins.str
    """Name of the SQL Server database that is being imported."""
    s3_bucket: builtins.str
    """Name of object storage bucket to import backups from."""
    s3_path: builtins.str
    """Path in object storage bucket to import backups from."""
    @property
    def files(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of .bak files in bucket containing database backup."""

    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        database_name: builtins.str = ...,
        s3_bucket: builtins.str = ...,
        s3_path: builtins.str = ...,
        files: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "database_name", b"database_name", "files", b"files", "s3_bucket", b"s3_bucket", "s3_path", b"s3_path"]) -> None: ...

global___ImportDatabaseBackupRequest = ImportDatabaseBackupRequest

@typing.final
class ImportDatabaseBackupMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    DATABASE_NAME_FIELD_NUMBER: builtins.int
    S3_BUCKET_FIELD_NUMBER: builtins.int
    S3_PATH_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the SQL Server cluster where a database is being imported."""
    database_name: builtins.str
    """Name of the SQL Server database that is being imported."""
    s3_bucket: builtins.str
    """Name of object storage bucket to import backups from."""
    s3_path: builtins.str
    """Path in object storage bucket to import backups from."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        database_name: builtins.str = ...,
        s3_bucket: builtins.str = ...,
        s3_path: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "database_name", b"database_name", "s3_bucket", b"s3_bucket", "s3_path", b"s3_path"]) -> None: ...

global___ImportDatabaseBackupMetadata = ImportDatabaseBackupMetadata

@typing.final
class ExportDatabaseBackupRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    DATABASE_NAME_FIELD_NUMBER: builtins.int
    S3_BUCKET_FIELD_NUMBER: builtins.int
    S3_PATH_FIELD_NUMBER: builtins.int
    PREFIX_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the SQL Server cluster to export a database from.

    To get the cluster ID, use a [ClusterService.List] request.
    """
    database_name: builtins.str
    """Name of the SQL Server database that is being exported."""
    s3_bucket: builtins.str
    """Name of object storage bucket to export backups to."""
    s3_path: builtins.str
    """Path in object storage bucket to export backups to."""
    prefix: builtins.str
    """Prefix for .bak files to export."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        database_name: builtins.str = ...,
        s3_bucket: builtins.str = ...,
        s3_path: builtins.str = ...,
        prefix: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "database_name", b"database_name", "prefix", b"prefix", "s3_bucket", b"s3_bucket", "s3_path", b"s3_path"]) -> None: ...

global___ExportDatabaseBackupRequest = ExportDatabaseBackupRequest

@typing.final
class ExportDatabaseBackupMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    DATABASE_NAME_FIELD_NUMBER: builtins.int
    S3_BUCKET_FIELD_NUMBER: builtins.int
    S3_PATH_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    """ID of the SQL Server cluster where a database is being exported."""
    database_name: builtins.str
    """Name of the SQL Server database that is being exported."""
    s3_bucket: builtins.str
    """Name of object storage bucket to export backups to."""
    s3_path: builtins.str
    """Path in object storage bucket to export backups to."""
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
        database_name: builtins.str = ...,
        s3_bucket: builtins.str = ...,
        s3_path: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id", "database_name", b"database_name", "s3_bucket", b"s3_bucket", "s3_path", b"s3_path"]) -> None: ...

global___ExportDatabaseBackupMetadata = ExportDatabaseBackupMetadata
