"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import abc
import collections.abc
import grpc
import grpc.aio
import typing
import yandex.cloud.operation.operation_pb2
import yandex.cloud.organizationmanager.v1.group_mapping_service_pb2

_T = typing.TypeVar("_T")

class _MaybeAsyncIterator(collections.abc.AsyncIterator[_T], collections.abc.Iterator[_T], metaclass=abc.ABCMeta): ...

class _ServicerContext(grpc.ServicerContext, grpc.aio.ServicerContext):  # type: ignore[misc, type-arg]
    ...

class GroupMappingServiceStub:
    """RPC service dedicated for federation group mapping."""

    def __init__(self, channel: typing.Union[grpc.Channel, grpc.aio.Channel]) -> None: ...
    Get: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.organizationmanager.v1.group_mapping_service_pb2.GetGroupMappingRequest,
        yandex.cloud.organizationmanager.v1.group_mapping_service_pb2.GetGroupMappingResponse,
    ]
    """Returns a group mapping configured for the specific federation
    If a federation does not exist this call will return an error
       NOT_FOUND will be returned
    If a federation exist, but has not ever been configured for group mapping
      the call FAILED_PRECONDITION will be returned.
    """

    Create: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.organizationmanager.v1.group_mapping_service_pb2.CreateGroupMappingRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Adds a group mapping for a federation
    If mapping already exist, ALREADY_EXISTS will be returned
    """

    Update: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.organizationmanager.v1.group_mapping_service_pb2.UpdateGroupMappingRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates an existing group mapping for a federation
    Errors:
    - if federation is not found
    In case of any error, no changes are applied to existing group mapping

    This call is idempotent. The following actions do nothing:
    - enabling when already enabled
    - disabling when disabled
    Such parts of request will be ignored. Others will be applied.
    """

    Delete: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.organizationmanager.v1.group_mapping_service_pb2.DeleteGroupMappingRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes a group mapping. This will remove all the mapping items
    cascade.
    """

    ListItems: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.organizationmanager.v1.group_mapping_service_pb2.ListGroupMappingItemsRequest,
        yandex.cloud.organizationmanager.v1.group_mapping_service_pb2.ListGroupMappingItemsResponse,
    ]
    """Returns all the group mappings items

    Filtering is only supported by external_group_id or internal_group_id
    """

    UpdateItems: grpc.UnaryUnaryMultiCallable[
        yandex.cloud.organizationmanager.v1.group_mapping_service_pb2.UpdateGroupMappingItemsRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates group mapping items for a specified federation
    Errors:
    - if federation is not found
    - if internal group in the mapping added does not exist
    In case of any error, no changes are applied to existing group mapping

    This call is idempotent. The following actions do nothing:
    - adding group mapping items that are already present
    - removing group mapping items that are not present
    Such parts of request will be ignored. Others will be applied.
    """

class GroupMappingServiceAsyncStub:
    """RPC service dedicated for federation group mapping."""

    Get: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.organizationmanager.v1.group_mapping_service_pb2.GetGroupMappingRequest,
        yandex.cloud.organizationmanager.v1.group_mapping_service_pb2.GetGroupMappingResponse,
    ]
    """Returns a group mapping configured for the specific federation
    If a federation does not exist this call will return an error
       NOT_FOUND will be returned
    If a federation exist, but has not ever been configured for group mapping
      the call FAILED_PRECONDITION will be returned.
    """

    Create: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.organizationmanager.v1.group_mapping_service_pb2.CreateGroupMappingRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Adds a group mapping for a federation
    If mapping already exist, ALREADY_EXISTS will be returned
    """

    Update: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.organizationmanager.v1.group_mapping_service_pb2.UpdateGroupMappingRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates an existing group mapping for a federation
    Errors:
    - if federation is not found
    In case of any error, no changes are applied to existing group mapping

    This call is idempotent. The following actions do nothing:
    - enabling when already enabled
    - disabling when disabled
    Such parts of request will be ignored. Others will be applied.
    """

    Delete: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.organizationmanager.v1.group_mapping_service_pb2.DeleteGroupMappingRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Deletes a group mapping. This will remove all the mapping items
    cascade.
    """

    ListItems: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.organizationmanager.v1.group_mapping_service_pb2.ListGroupMappingItemsRequest,
        yandex.cloud.organizationmanager.v1.group_mapping_service_pb2.ListGroupMappingItemsResponse,
    ]
    """Returns all the group mappings items

    Filtering is only supported by external_group_id or internal_group_id
    """

    UpdateItems: grpc.aio.UnaryUnaryMultiCallable[
        yandex.cloud.organizationmanager.v1.group_mapping_service_pb2.UpdateGroupMappingItemsRequest,
        yandex.cloud.operation.operation_pb2.Operation,
    ]
    """Updates group mapping items for a specified federation
    Errors:
    - if federation is not found
    - if internal group in the mapping added does not exist
    In case of any error, no changes are applied to existing group mapping

    This call is idempotent. The following actions do nothing:
    - adding group mapping items that are already present
    - removing group mapping items that are not present
    Such parts of request will be ignored. Others will be applied.
    """

class GroupMappingServiceServicer(metaclass=abc.ABCMeta):
    """RPC service dedicated for federation group mapping."""

    @abc.abstractmethod
    def Get(
        self,
        request: yandex.cloud.organizationmanager.v1.group_mapping_service_pb2.GetGroupMappingRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.organizationmanager.v1.group_mapping_service_pb2.GetGroupMappingResponse, collections.abc.Awaitable[yandex.cloud.organizationmanager.v1.group_mapping_service_pb2.GetGroupMappingResponse]]:
        """Returns a group mapping configured for the specific federation
        If a federation does not exist this call will return an error
           NOT_FOUND will be returned
        If a federation exist, but has not ever been configured for group mapping
          the call FAILED_PRECONDITION will be returned.
        """

    @abc.abstractmethod
    def Create(
        self,
        request: yandex.cloud.organizationmanager.v1.group_mapping_service_pb2.CreateGroupMappingRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Adds a group mapping for a federation
        If mapping already exist, ALREADY_EXISTS will be returned
        """

    @abc.abstractmethod
    def Update(
        self,
        request: yandex.cloud.organizationmanager.v1.group_mapping_service_pb2.UpdateGroupMappingRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Updates an existing group mapping for a federation
        Errors:
        - if federation is not found
        In case of any error, no changes are applied to existing group mapping

        This call is idempotent. The following actions do nothing:
        - enabling when already enabled
        - disabling when disabled
        Such parts of request will be ignored. Others will be applied.
        """

    @abc.abstractmethod
    def Delete(
        self,
        request: yandex.cloud.organizationmanager.v1.group_mapping_service_pb2.DeleteGroupMappingRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Deletes a group mapping. This will remove all the mapping items
        cascade.
        """

    @abc.abstractmethod
    def ListItems(
        self,
        request: yandex.cloud.organizationmanager.v1.group_mapping_service_pb2.ListGroupMappingItemsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.organizationmanager.v1.group_mapping_service_pb2.ListGroupMappingItemsResponse, collections.abc.Awaitable[yandex.cloud.organizationmanager.v1.group_mapping_service_pb2.ListGroupMappingItemsResponse]]:
        """Returns all the group mappings items

        Filtering is only supported by external_group_id or internal_group_id
        """

    @abc.abstractmethod
    def UpdateItems(
        self,
        request: yandex.cloud.organizationmanager.v1.group_mapping_service_pb2.UpdateGroupMappingItemsRequest,
        context: _ServicerContext,
    ) -> typing.Union[yandex.cloud.operation.operation_pb2.Operation, collections.abc.Awaitable[yandex.cloud.operation.operation_pb2.Operation]]:
        """Updates group mapping items for a specified federation
        Errors:
        - if federation is not found
        - if internal group in the mapping added does not exist
        In case of any error, no changes are applied to existing group mapping

        This call is idempotent. The following actions do nothing:
        - adding group mapping items that are already present
        - removing group mapping items that are not present
        Such parts of request will be ignored. Others will be applied.
        """

def add_GroupMappingServiceServicer_to_server(servicer: GroupMappingServiceServicer, server: typing.Union[grpc.Server, grpc.aio.Server]) -> None: ...
