"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _Status:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Status.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    STATUS_UNSPECIFIED: _Status.ValueType  # 0
    """The status is not specified."""
    CREATING: _Status.ValueType  # 1
    """The apllication is in the process of being created."""
    ACTIVE: _Status.ValueType  # 2
    """The apllication is active and operational."""
    SUSPENDED: _Status.ValueType  # 3
    """The apllication is suspended. I.e. authentication via this application is disabled."""
    DELETING: _Status.ValueType  # 4
    """The apllication is in the process of being deleted."""

class Status(_Status, metaclass=_StatusEnumTypeWrapper):
    """Represents the status of an application."""

STATUS_UNSPECIFIED: Status.ValueType  # 0
"""The status is not specified."""
CREATING: Status.ValueType  # 1
"""The apllication is in the process of being created."""
ACTIVE: Status.ValueType  # 2
"""The apllication is active and operational."""
SUSPENDED: Status.ValueType  # 3
"""The apllication is suspended. I.e. authentication via this application is disabled."""
DELETING: Status.ValueType  # 4
"""The apllication is in the process of being deleted."""
global___Status = Status

class _GroupDistributionType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _GroupDistributionTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_GroupDistributionType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    GROUP_DISTRIBUTION_TYPE_UNSPECIFIED: _GroupDistributionType.ValueType  # 0
    """The distribution type is unspecified"""
    NONE: _GroupDistributionType.ValueType  # 1
    """No groups are visible for the application users"""
    ASSIGNED_GROUPS: _GroupDistributionType.ValueType  # 2
    """Only assigned groups are visible for the application users"""
    ALL_GROUPS: _GroupDistributionType.ValueType  # 3
    """All groups are visible for the application users"""

class GroupDistributionType(_GroupDistributionType, metaclass=_GroupDistributionTypeEnumTypeWrapper):
    """Represents distribution type of the groups"""

GROUP_DISTRIBUTION_TYPE_UNSPECIFIED: GroupDistributionType.ValueType  # 0
"""The distribution type is unspecified"""
NONE: GroupDistributionType.ValueType  # 1
"""No groups are visible for the application users"""
ASSIGNED_GROUPS: GroupDistributionType.ValueType  # 2
"""Only assigned groups are visible for the application users"""
ALL_GROUPS: GroupDistributionType.ValueType  # 3
"""All groups are visible for the application users"""
global___GroupDistributionType = GroupDistributionType

@typing.final
class Application(google.protobuf.message.Message):
    """An OAuth application resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    GROUP_CLAIMS_SETTINGS_FIELD_NUMBER: builtins.int
    CLIENT_GRANT_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    UPDATED_AT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the application."""
    name: builtins.str
    """Name of the application.
    The name is unique within the organization. 3-63 characters long.
    """
    organization_id: builtins.str
    """ID of the organization that the application belongs to."""
    description: builtins.str
    """Description of the application. 0-256 characters long."""
    status: global___Status.ValueType
    """Current status of the application."""
    @property
    def group_claims_settings(self) -> global___GroupClaimsSettings:
        """Settings of the group claims"""

    @property
    def client_grant(self) -> global___ClientGrant:
        """Represents current connection to the OAuth client with specified scopes"""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `` key:value `` pairs."""

    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp."""

    @property
    def updated_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Modification timestamp."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        name: builtins.str = ...,
        organization_id: builtins.str = ...,
        description: builtins.str = ...,
        group_claims_settings: global___GroupClaimsSettings | None = ...,
        client_grant: global___ClientGrant | None = ...,
        status: global___Status.ValueType = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        updated_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["client_grant", b"client_grant", "created_at", b"created_at", "group_claims_settings", b"group_claims_settings", "updated_at", b"updated_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["client_grant", b"client_grant", "created_at", b"created_at", "description", b"description", "group_claims_settings", b"group_claims_settings", "id", b"id", "labels", b"labels", "name", b"name", "organization_id", b"organization_id", "status", b"status", "updated_at", b"updated_at"]) -> None: ...

global___Application = Application

@typing.final
class GroupClaimsSettings(google.protobuf.message.Message):
    """Settings of the group claims"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GROUP_DISTRIBUTION_TYPE_FIELD_NUMBER: builtins.int
    group_distribution_type: global___GroupDistributionType.ValueType
    """Represents current distribution type of the groups. I.e. which groups are visible for the application users."""
    def __init__(
        self,
        *,
        group_distribution_type: global___GroupDistributionType.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["group_distribution_type", b"group_distribution_type"]) -> None: ...

global___GroupClaimsSettings = GroupClaimsSettings

@typing.final
class ClientGrant(google.protobuf.message.Message):
    """Represents connection to the OAuth client with specified scopes"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLIENT_ID_FIELD_NUMBER: builtins.int
    AUTHORIZED_SCOPES_FIELD_NUMBER: builtins.int
    client_id: builtins.str
    """OAuth client id"""
    @property
    def authorized_scopes(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of authorized client scopes by the application"""

    def __init__(
        self,
        *,
        client_id: builtins.str = ...,
        authorized_scopes: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["authorized_scopes", b"authorized_scopes", "client_id", b"client_id"]) -> None: ...

global___ClientGrant = ClientGrant
