"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing
import yandex.cloud.operation.operation_pb2
import yandex.cloud.organizationmanager.v1.idp.application.oauth.application_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _AssignmentAction:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _AssignmentActionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_AssignmentAction.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ASSIGNMENT_ACTION_UNSPECIFIED: _AssignmentAction.ValueType  # 0
    """Action unspecified"""
    ADD: _AssignmentAction.ValueType  # 1
    """Add action"""
    REMOVE: _AssignmentAction.ValueType  # 2
    """Remove action"""

class AssignmentAction(_AssignmentAction, metaclass=_AssignmentActionEnumTypeWrapper):
    """The action within assignment delta that is being performed on an assignment"""

ASSIGNMENT_ACTION_UNSPECIFIED: AssignmentAction.ValueType  # 0
"""Action unspecified"""
ADD: AssignmentAction.ValueType  # 1
"""Add action"""
REMOVE: AssignmentAction.ValueType  # 2
"""Remove action"""
global___AssignmentAction = AssignmentAction

@typing.final
class GetApplicationRequest(google.protobuf.message.Message):
    """Request to get a OAuth application."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPLICATION_ID_FIELD_NUMBER: builtins.int
    application_id: builtins.str
    """ID of the OAuth application to return.
    To get the OAuth application ID, make a [ApplicationService.List] request.
    """
    def __init__(
        self,
        *,
        application_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["application_id", b"application_id"]) -> None: ...

global___GetApplicationRequest = GetApplicationRequest

@typing.final
class ListApplicationsRequest(google.protobuf.message.Message):
    """Request to list OAuth applications."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    organization_id: builtins.str
    """ID of the organization to list OAuth applications in."""
    page_size: builtins.int
    """The maximum number of results per page to return.
    If the number of available results is larger than [page_size],
    the service returns a [ListApplicationsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    Default value: 100.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token]
    to the [ListApplicationsResponse.next_page_token]
    returned by a previous list request.
    """
    filter: builtins.str
    """A filter expression that filters resources listed in the response."""
    def __init__(
        self,
        *,
        organization_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "organization_id", b"organization_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListApplicationsRequest = ListApplicationsRequest

@typing.final
class ListApplicationsResponse(google.protobuf.message.Message):
    """Response message for [ApplicationService.List]."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPLICATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests.
    If the number of results is larger than [ListApplicationsRequest.page_size],
    use the [next_page_token] as the value for the [ListApplicationsRequest.page_token]
    query parameter in the next list request.
    """
    @property
    def applications(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.organizationmanager.v1.idp.application.oauth.application_pb2.Application]:
        """List of OAuth applications."""

    def __init__(
        self,
        *,
        applications: collections.abc.Iterable[yandex.cloud.organizationmanager.v1.idp.application.oauth.application_pb2.Application] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["applications", b"applications", "next_page_token", b"next_page_token"]) -> None: ...

global___ListApplicationsResponse = ListApplicationsResponse

@typing.final
class CreateApplicationRequest(google.protobuf.message.Message):
    """Request to create a OAuth application."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    GROUP_CLAIMS_SETTINGS_FIELD_NUMBER: builtins.int
    CLIENT_GRANT_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the OAuth application.
    The name must be unique within the organization.
    """
    organization_id: builtins.str
    """ID of the organization to create a OAuth application in."""
    description: builtins.str
    """Description of the OAuth application."""
    @property
    def group_claims_settings(self) -> yandex.cloud.organizationmanager.v1.idp.application.oauth.application_pb2.GroupClaimsSettings:
        """Settings of the group claims"""

    @property
    def client_grant(self) -> yandex.cloud.organizationmanager.v1.idp.application.oauth.application_pb2.ClientGrant:
        """Connection to the OAuth client with specified scopes"""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as key:value pairs."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        organization_id: builtins.str = ...,
        description: builtins.str = ...,
        group_claims_settings: yandex.cloud.organizationmanager.v1.idp.application.oauth.application_pb2.GroupClaimsSettings | None = ...,
        client_grant: yandex.cloud.organizationmanager.v1.idp.application.oauth.application_pb2.ClientGrant | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["client_grant", b"client_grant", "group_claims_settings", b"group_claims_settings"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["client_grant", b"client_grant", "description", b"description", "group_claims_settings", b"group_claims_settings", "labels", b"labels", "name", b"name", "organization_id", b"organization_id"]) -> None: ...

global___CreateApplicationRequest = CreateApplicationRequest

@typing.final
class CreateApplicationMetadata(google.protobuf.message.Message):
    """Metadata for the [ApplicationService.Create] operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPLICATION_ID_FIELD_NUMBER: builtins.int
    application_id: builtins.str
    """ID of the OAuth application that is being created."""
    def __init__(
        self,
        *,
        application_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["application_id", b"application_id"]) -> None: ...

global___CreateApplicationMetadata = CreateApplicationMetadata

@typing.final
class UpdateApplicationRequest(google.protobuf.message.Message):
    """Request to update a OAuth application."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    APPLICATION_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    GROUP_CLAIMS_SETTINGS_FIELD_NUMBER: builtins.int
    CLIENT_GRANT_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    application_id: builtins.str
    """ID of the OAuth application to update.
    To get the OAuth application ID, make a [ApplicationService.List] request.
    """
    name: builtins.str
    """Name of the OAuth application.
    The name must be unique within the organization.
    """
    description: builtins.str
    """Description of the OAuth application."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which fields of the OAuth application are going to be updated."""

    @property
    def group_claims_settings(self) -> yandex.cloud.organizationmanager.v1.idp.application.oauth.application_pb2.GroupClaimsSettings:
        """Settings of the group claims"""

    @property
    def client_grant(self) -> yandex.cloud.organizationmanager.v1.idp.application.oauth.application_pb2.ClientGrant:
        """Connection to the OAuth client with specified scopes"""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as key:value pairs."""

    def __init__(
        self,
        *,
        application_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        group_claims_settings: yandex.cloud.organizationmanager.v1.idp.application.oauth.application_pb2.GroupClaimsSettings | None = ...,
        client_grant: yandex.cloud.organizationmanager.v1.idp.application.oauth.application_pb2.ClientGrant | None = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["client_grant", b"client_grant", "group_claims_settings", b"group_claims_settings", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["application_id", b"application_id", "client_grant", b"client_grant", "description", b"description", "group_claims_settings", b"group_claims_settings", "labels", b"labels", "name", b"name", "update_mask", b"update_mask"]) -> None: ...

global___UpdateApplicationRequest = UpdateApplicationRequest

@typing.final
class UpdateApplicationMetadata(google.protobuf.message.Message):
    """Metadata for the [ApplicationService.Update] operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPLICATION_ID_FIELD_NUMBER: builtins.int
    application_id: builtins.str
    """ID of the OAuth application that is being updated."""
    def __init__(
        self,
        *,
        application_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["application_id", b"application_id"]) -> None: ...

global___UpdateApplicationMetadata = UpdateApplicationMetadata

@typing.final
class SuspendApplicationRequest(google.protobuf.message.Message):
    """Request to suspend a OAuth application."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPLICATION_ID_FIELD_NUMBER: builtins.int
    application_id: builtins.str
    """ID of the OAuth application to suspend.
    To get the OAuth application ID, make a [ApplicationService.List] request.
    """
    def __init__(
        self,
        *,
        application_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["application_id", b"application_id"]) -> None: ...

global___SuspendApplicationRequest = SuspendApplicationRequest

@typing.final
class SuspendApplicationMetadata(google.protobuf.message.Message):
    """Metadata for the [ApplicationService.Suspend] operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPLICATION_ID_FIELD_NUMBER: builtins.int
    application_id: builtins.str
    """ID of the OAuth application that is being suspended."""
    def __init__(
        self,
        *,
        application_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["application_id", b"application_id"]) -> None: ...

global___SuspendApplicationMetadata = SuspendApplicationMetadata

@typing.final
class ReactivateApplicationRequest(google.protobuf.message.Message):
    """Request to reactivate a OAuth application."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPLICATION_ID_FIELD_NUMBER: builtins.int
    application_id: builtins.str
    """ID of the OAuth application to reactivate.
    To get the OAuth application ID, make a [ApplicationService.List] request.
    """
    def __init__(
        self,
        *,
        application_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["application_id", b"application_id"]) -> None: ...

global___ReactivateApplicationRequest = ReactivateApplicationRequest

@typing.final
class ReactivateApplicationMetadata(google.protobuf.message.Message):
    """Metadata for the [ApplicationService.Reactivate] operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPLICATION_ID_FIELD_NUMBER: builtins.int
    application_id: builtins.str
    """ID of the OAuth application that is being reactivated."""
    def __init__(
        self,
        *,
        application_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["application_id", b"application_id"]) -> None: ...

global___ReactivateApplicationMetadata = ReactivateApplicationMetadata

@typing.final
class DeleteApplicationRequest(google.protobuf.message.Message):
    """Request to delete a OAuth application."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPLICATION_ID_FIELD_NUMBER: builtins.int
    application_id: builtins.str
    """ID of the OAuth application to delete.
    To get the OAuth application ID, make a [ApplicationService.List] request.
    """
    def __init__(
        self,
        *,
        application_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["application_id", b"application_id"]) -> None: ...

global___DeleteApplicationRequest = DeleteApplicationRequest

@typing.final
class DeleteApplicationMetadata(google.protobuf.message.Message):
    """Metadata for the [ApplicationService.Delete] operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPLICATION_ID_FIELD_NUMBER: builtins.int
    application_id: builtins.str
    """ID of the OAuth application that is being deleted."""
    def __init__(
        self,
        *,
        application_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["application_id", b"application_id"]) -> None: ...

global___DeleteApplicationMetadata = DeleteApplicationMetadata

@typing.final
class ListApplicationOperationsRequest(google.protobuf.message.Message):
    """Request to list operations for a OAuth application."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPLICATION_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    application_id: builtins.str
    """ID of the OAuth application to list operations for."""
    page_size: builtins.int
    """The maximum number of results per page to return."""
    page_token: builtins.str
    """Page token for pagination."""
    def __init__(
        self,
        *,
        application_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["application_id", b"application_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListApplicationOperationsRequest = ListApplicationOperationsRequest

@typing.final
class ListApplicationOperationsResponse(google.protobuf.message.Message):
    """Response message for [ApplicationService.ListOperations]."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list."""
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """List of operations."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListApplicationOperationsResponse = ListApplicationOperationsResponse

@typing.final
class Assignment(google.protobuf.message.Message):
    """An assignment for the OAuth application"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBJECT_ID_FIELD_NUMBER: builtins.int
    subject_id: builtins.str
    """ID of the subject to be assigned to the OAuth application.
    Supported subject categories: UserAccount, ServiceAccount, Group, MetaGroup, PublicGroup.
    In case subject ID is ID of the group, 
    then such group becomes visible to the users of OAuth application in case [GroupDistributionType] has value ASSIGNED_GROUPS.
    """
    def __init__(
        self,
        *,
        subject_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["subject_id", b"subject_id"]) -> None: ...

global___Assignment = Assignment

@typing.final
class AssignmentDelta(google.protobuf.message.Message):
    """A delta of the"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTION_FIELD_NUMBER: builtins.int
    ASSIGNMENT_FIELD_NUMBER: builtins.int
    action: global___AssignmentAction.ValueType
    """The action that is being performed on an assignment."""
    @property
    def assignment(self) -> global___Assignment:
        """An assignment for the OAuth application."""

    def __init__(
        self,
        *,
        action: global___AssignmentAction.ValueType = ...,
        assignment: global___Assignment | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["assignment", b"assignment"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["action", b"action", "assignment", b"assignment"]) -> None: ...

global___AssignmentDelta = AssignmentDelta

@typing.final
class UpdateAssignmentsResponse(google.protobuf.message.Message):
    """Response message of the operation for the [ApplicationService.UpdateAssignments]."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ASSIGNMENT_DELTAS_FIELD_NUMBER: builtins.int
    @property
    def assignment_deltas(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AssignmentDelta]:
        """List of applied assignment deltas on the OAuth application"""

    def __init__(
        self,
        *,
        assignment_deltas: collections.abc.Iterable[global___AssignmentDelta] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["assignment_deltas", b"assignment_deltas"]) -> None: ...

global___UpdateAssignmentsResponse = UpdateAssignmentsResponse

@typing.final
class ListAssignmentsRequest(google.protobuf.message.Message):
    """Request to list assignments for a OAuth application."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPLICATION_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    application_id: builtins.str
    """ID of the OAuth application to update.
    To get the OAuth application ID, make a [ApplicationService.List] request.
    """
    page_size: builtins.int
    """The maximum number of results per page to return.
    If the number of available results is larger than [page_size],
    the service returns a [ListAssignmentsResponse.next_page_token]
    that can be used to get the next page of results in subsequent list requests.
    """
    page_token: builtins.str
    """Page token. To get the next page of results, set [page_token]
    to the [ListAssignmentsResponse.next_page_token]
    returned by a previous list request.
    """
    def __init__(
        self,
        *,
        application_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["application_id", b"application_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListAssignmentsRequest = ListAssignmentsRequest

@typing.final
class ListAssignmentsResponse(google.protobuf.message.Message):
    """Response message for [ApplicationService.ListAssignments]."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ASSIGNMENTS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """This token allows you to get the next page of results for list requests.
    If the number of results is larger than [ListAssignmentsRequest.page_size],
    use the [next_page_token] as the value for the [ListAssignmentsRequest.page_token]
    query parameter in the next list request.
    """
    @property
    def assignments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Assignment]:
        """List of assignments."""

    def __init__(
        self,
        *,
        assignments: collections.abc.Iterable[global___Assignment] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["assignments", b"assignments", "next_page_token", b"next_page_token"]) -> None: ...

global___ListAssignmentsResponse = ListAssignmentsResponse

@typing.final
class UpdateAssignmentsRequest(google.protobuf.message.Message):
    """Request to update assignments for specified OAuth application."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPLICATION_ID_FIELD_NUMBER: builtins.int
    ASSIGNMENT_DELTAS_FIELD_NUMBER: builtins.int
    application_id: builtins.str
    """ID of the OAuth application to update.
    To get the OAuth application ID, make a [ApplicationService.List] request.
    """
    @property
    def assignment_deltas(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AssignmentDelta]:
        """List of assignment deltas to be applied on the OAuth application. Duplicates or invalid assignments are ignored."""

    def __init__(
        self,
        *,
        application_id: builtins.str = ...,
        assignment_deltas: collections.abc.Iterable[global___AssignmentDelta] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["application_id", b"application_id", "assignment_deltas", b"assignment_deltas"]) -> None: ...

global___UpdateAssignmentsRequest = UpdateAssignmentsRequest

@typing.final
class UpdateAssignmentsMetadata(google.protobuf.message.Message):
    """Metadata for the [ApplicationService.UpdateAssignments] operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPLICATION_ID_FIELD_NUMBER: builtins.int
    application_id: builtins.str
    """ID of the OAuth application that is being updated."""
    def __init__(
        self,
        *,
        application_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["application_id", b"application_id"]) -> None: ...

global___UpdateAssignmentsMetadata = UpdateAssignmentsMetadata
