"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import google.protobuf.wrappers_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _GroupDistributionType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _GroupDistributionTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_GroupDistributionType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    GROUP_DISTRIBUTION_TYPE_UNSPECIFIED: _GroupDistributionType.ValueType  # 0
    """The group distribution type is not specified."""
    NONE: _GroupDistributionType.ValueType  # 1
    """No groups are provided to the application."""
    ASSIGNED_GROUPS: _GroupDistributionType.ValueType  # 2
    """Only assigned groups are provided to the application."""
    ALL_GROUPS: _GroupDistributionType.ValueType  # 3
    """All groups are provided to the application."""

class GroupDistributionType(_GroupDistributionType, metaclass=_GroupDistributionTypeEnumTypeWrapper):
    """Group distribution types for SAML applications."""

GROUP_DISTRIBUTION_TYPE_UNSPECIFIED: GroupDistributionType.ValueType  # 0
"""The group distribution type is not specified."""
NONE: GroupDistributionType.ValueType  # 1
"""No groups are provided to the application."""
ASSIGNED_GROUPS: GroupDistributionType.ValueType  # 2
"""Only assigned groups are provided to the application."""
ALL_GROUPS: GroupDistributionType.ValueType  # 3
"""All groups are provided to the application."""
global___GroupDistributionType = GroupDistributionType

@typing.final
class Application(google.protobuf.message.Message):
    """A SAML application resource."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Application._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: Application._Status.ValueType  # 0
        """The status is not specified."""
        CREATING: Application._Status.ValueType  # 1
        """The application is in the process of being created."""
        ACTIVE: Application._Status.ValueType  # 2
        """The application is active and can be used for authentication."""
        SUSPENDED: Application._Status.ValueType  # 3
        """The application is suspended. I.e. authentication via this application is disabled."""
        DELETING: Application._Status.ValueType  # 4
        """The application is in the process of being deleted."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper):
        """Represents the status of a SAML application."""

    STATUS_UNSPECIFIED: Application.Status.ValueType  # 0
    """The status is not specified."""
    CREATING: Application.Status.ValueType  # 1
    """The application is in the process of being created."""
    ACTIVE: Application.Status.ValueType  # 2
    """The application is active and can be used for authentication."""
    SUSPENDED: Application.Status.ValueType  # 3
    """The application is suspended. I.e. authentication via this application is disabled."""
    DELETING: Application.Status.ValueType  # 4
    """The application is in the process of being deleted."""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    UPDATED_AT_FIELD_NUMBER: builtins.int
    SERVICE_PROVIDER_FIELD_NUMBER: builtins.int
    SECURITY_SETTINGS_FIELD_NUMBER: builtins.int
    ATTRIBUTE_MAPPING_FIELD_NUMBER: builtins.int
    GROUP_CLAIMS_SETTINGS_FIELD_NUMBER: builtins.int
    IDENTITY_PROVIDER_METADATA_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Unique identifier of the SAML application."""
    organization_id: builtins.str
    """ID of the organization that the application belongs to."""
    name: builtins.str
    """Name of the SAML application."""
    description: builtins.str
    """Description of the SAML application."""
    status: global___Application.Status.ValueType
    """Current status of the SAML application."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `` key:value `` pairs."""

    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp."""

    @property
    def updated_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Modification timestamp."""

    @property
    def service_provider(self) -> global___ServiceProvider:
        """Service provider configuration for the SAML application."""

    @property
    def security_settings(self) -> global___SecuritySettings:
        """Security settings for the SAML application."""

    @property
    def attribute_mapping(self) -> global___AttributeMapping:
        """Attribute mapping configuration for the SAML application."""

    @property
    def group_claims_settings(self) -> global___GroupClaimsSettings:
        """Group claims settings for the SAML application."""

    @property
    def identity_provider_metadata(self) -> global___IdentityProviderMetadata:
        """Identity provider metadata for the SAML application."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        organization_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        status: global___Application.Status.ValueType = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        updated_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        service_provider: global___ServiceProvider | None = ...,
        security_settings: global___SecuritySettings | None = ...,
        attribute_mapping: global___AttributeMapping | None = ...,
        group_claims_settings: global___GroupClaimsSettings | None = ...,
        identity_provider_metadata: global___IdentityProviderMetadata | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["attribute_mapping", b"attribute_mapping", "created_at", b"created_at", "group_claims_settings", b"group_claims_settings", "identity_provider_metadata", b"identity_provider_metadata", "security_settings", b"security_settings", "service_provider", b"service_provider", "updated_at", b"updated_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["attribute_mapping", b"attribute_mapping", "created_at", b"created_at", "description", b"description", "group_claims_settings", b"group_claims_settings", "id", b"id", "identity_provider_metadata", b"identity_provider_metadata", "labels", b"labels", "name", b"name", "organization_id", b"organization_id", "security_settings", b"security_settings", "service_provider", b"service_provider", "status", b"status", "updated_at", b"updated_at"]) -> None: ...

global___Application = Application

@typing.final
class IdentityProviderMetadata(google.protobuf.message.Message):
    """Identity provider metadata for SAML applications."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ISSUER_FIELD_NUMBER: builtins.int
    SSO_URL_FIELD_NUMBER: builtins.int
    METADATA_URL_FIELD_NUMBER: builtins.int
    SLO_URL_FIELD_NUMBER: builtins.int
    issuer: builtins.str
    """Identity provider issuer identifier."""
    sso_url: builtins.str
    """Identity provider Single Sign-On URL."""
    metadata_url: builtins.str
    """Identity provider metadata URL."""
    slo_url: builtins.str
    """Identity provider Single Logout URL."""
    def __init__(
        self,
        *,
        issuer: builtins.str = ...,
        sso_url: builtins.str = ...,
        metadata_url: builtins.str = ...,
        slo_url: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["issuer", b"issuer", "metadata_url", b"metadata_url", "slo_url", b"slo_url", "sso_url", b"sso_url"]) -> None: ...

global___IdentityProviderMetadata = IdentityProviderMetadata

@typing.final
class ServiceProvider(google.protobuf.message.Message):
    """Service provider configuration for SAML applications."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENTITY_ID_FIELD_NUMBER: builtins.int
    ACS_URLS_FIELD_NUMBER: builtins.int
    SLO_URLS_FIELD_NUMBER: builtins.int
    entity_id: builtins.str
    """Service provider entity ID."""
    @property
    def acs_urls(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AssertionConsumerServiceURL]:
        """Assertion Consumer Service URLs."""

    @property
    def slo_urls(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SingleLogoutServiceURL]:
        """Single Logout Service URLs."""

    def __init__(
        self,
        *,
        entity_id: builtins.str = ...,
        acs_urls: collections.abc.Iterable[global___AssertionConsumerServiceURL] | None = ...,
        slo_urls: collections.abc.Iterable[global___SingleLogoutServiceURL] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["acs_urls", b"acs_urls", "entity_id", b"entity_id", "slo_urls", b"slo_urls"]) -> None: ...

global___ServiceProvider = ServiceProvider

@typing.final
class AssertionConsumerServiceURL(google.protobuf.message.Message):
    """Assertion Consumer Service URL configuration."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    URL_FIELD_NUMBER: builtins.int
    INDEX_FIELD_NUMBER: builtins.int
    url: builtins.str
    """The URL where SAML responses are sent."""
    @property
    def index(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """Optional index for the assertion consumer service."""

    def __init__(
        self,
        *,
        url: builtins.str = ...,
        index: google.protobuf.wrappers_pb2.Int64Value | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["index", b"index"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["index", b"index", "url", b"url"]) -> None: ...

global___AssertionConsumerServiceURL = AssertionConsumerServiceURL

@typing.final
class SingleLogoutServiceURL(google.protobuf.message.Message):
    """Single Logout Service URL configuration."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ProtocolBinding:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ProtocolBindingEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SingleLogoutServiceURL._ProtocolBinding.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PROTOCOL_BINDING_UNSPECIFIED: SingleLogoutServiceURL._ProtocolBinding.ValueType  # 0
        """The protocol binding is not specified."""
        HTTP_POST: SingleLogoutServiceURL._ProtocolBinding.ValueType  # 1
        """HTTP POST binding."""
        HTTP_REDIRECT: SingleLogoutServiceURL._ProtocolBinding.ValueType  # 2
        """HTTP Redirect binding."""

    class ProtocolBinding(_ProtocolBinding, metaclass=_ProtocolBindingEnumTypeWrapper):
        """Protocol bindings supported by the logout endpoint."""

    PROTOCOL_BINDING_UNSPECIFIED: SingleLogoutServiceURL.ProtocolBinding.ValueType  # 0
    """The protocol binding is not specified."""
    HTTP_POST: SingleLogoutServiceURL.ProtocolBinding.ValueType  # 1
    """HTTP POST binding."""
    HTTP_REDIRECT: SingleLogoutServiceURL.ProtocolBinding.ValueType  # 2
    """HTTP Redirect binding."""

    URL_FIELD_NUMBER: builtins.int
    RESPONSE_URL_FIELD_NUMBER: builtins.int
    PROTOCOL_BINDING_FIELD_NUMBER: builtins.int
    url: builtins.str
    """The URL where logout requests are sent."""
    response_url: builtins.str
    """Optional separate URL for logout responses."""
    protocol_binding: global___SingleLogoutServiceURL.ProtocolBinding.ValueType
    """Protocol binding supported by the logout endpoint."""
    def __init__(
        self,
        *,
        url: builtins.str = ...,
        response_url: builtins.str = ...,
        protocol_binding: global___SingleLogoutServiceURL.ProtocolBinding.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["protocol_binding", b"protocol_binding", "response_url", b"response_url", "url", b"url"]) -> None: ...

global___SingleLogoutServiceURL = SingleLogoutServiceURL

@typing.final
class SecuritySettings(google.protobuf.message.Message):
    """Security settings for SAML applications."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _SignatureMode:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _SignatureModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SecuritySettings._SignatureMode.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SIGNATURE_MODE_UNSPECIFIED: SecuritySettings._SignatureMode.ValueType  # 0
        """The signature mode is not specified."""
        ASSERTIONS: SecuritySettings._SignatureMode.ValueType  # 1
        """Sign individual assertions."""
        RESPONSE: SecuritySettings._SignatureMode.ValueType  # 2
        """Sign the entire response."""
        RESPONSE_AND_ASSERTIONS: SecuritySettings._SignatureMode.ValueType  # 3
        """Sign both the response and individual assertions."""

    class SignatureMode(_SignatureMode, metaclass=_SignatureModeEnumTypeWrapper):
        """Signature modes for SAML messages."""

    SIGNATURE_MODE_UNSPECIFIED: SecuritySettings.SignatureMode.ValueType  # 0
    """The signature mode is not specified."""
    ASSERTIONS: SecuritySettings.SignatureMode.ValueType  # 1
    """Sign individual assertions."""
    RESPONSE: SecuritySettings.SignatureMode.ValueType  # 2
    """Sign the entire response."""
    RESPONSE_AND_ASSERTIONS: SecuritySettings.SignatureMode.ValueType  # 3
    """Sign both the response and individual assertions."""

    SIGNATURE_MODE_FIELD_NUMBER: builtins.int
    SIGNATURE_CERTIFICATE_ID_FIELD_NUMBER: builtins.int
    signature_mode: global___SecuritySettings.SignatureMode.ValueType
    """Signature mode for SAML messages."""
    signature_certificate_id: builtins.str
    """ID of the signature certificate to use."""
    def __init__(
        self,
        *,
        signature_mode: global___SecuritySettings.SignatureMode.ValueType = ...,
        signature_certificate_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["signature_certificate_id", b"signature_certificate_id", "signature_mode", b"signature_mode"]) -> None: ...

global___SecuritySettings = SecuritySettings

@typing.final
class AttributeMapping(google.protobuf.message.Message):
    """Attribute mapping configuration for SAML applications."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_ID_FIELD_NUMBER: builtins.int
    ATTRIBUTES_FIELD_NUMBER: builtins.int
    @property
    def name_id(self) -> global___NameId:
        """NameID configuration for the SAML application."""

    @property
    def attributes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Attribute]:
        """List of attribute mappings."""

    def __init__(
        self,
        *,
        name_id: global___NameId | None = ...,
        attributes: collections.abc.Iterable[global___Attribute] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["name_id", b"name_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["attributes", b"attributes", "name_id", b"name_id"]) -> None: ...

global___AttributeMapping = AttributeMapping

@typing.final
class NameId(google.protobuf.message.Message):
    """NameID configuration for SAML applications."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Format:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _FormatEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[NameId._Format.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        FORMAT_UNSPECIFIED: NameId._Format.ValueType  # 0
        """The NameID format is not specified."""
        PERSISTENT: NameId._Format.ValueType  # 1
        """Persistent NameID format.
        This provides a stable, opaque identifier for the user.
        """
        EMAIL: NameId._Format.ValueType  # 2
        """Email NameID format.
        This uses the user's email address as the identifier.
        """

    class Format(_Format, metaclass=_FormatEnumTypeWrapper):
        """NameID formats supported by SAML."""

    FORMAT_UNSPECIFIED: NameId.Format.ValueType  # 0
    """The NameID format is not specified."""
    PERSISTENT: NameId.Format.ValueType  # 1
    """Persistent NameID format.
    This provides a stable, opaque identifier for the user.
    """
    EMAIL: NameId.Format.ValueType  # 2
    """Email NameID format.
    This uses the user's email address as the identifier.
    """

    FORMAT_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    format: global___NameId.Format.ValueType
    """Format of the NameID."""
    value: builtins.str
    """Value of the NameID."""
    def __init__(
        self,
        *,
        format: global___NameId.Format.ValueType = ...,
        value: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["format", b"format", "value", b"value"]) -> None: ...

global___NameId = NameId

@typing.final
class Attribute(google.protobuf.message.Message):
    """Attribute mapping for SAML applications."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the SAML attribute."""
    value: builtins.str
    """Value of the SAML attribute."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        value: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["name", b"name", "value", b"value"]) -> None: ...

global___Attribute = Attribute

@typing.final
class GroupClaimsSettings(google.protobuf.message.Message):
    """Group claims settings for SAML applications."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GROUP_DISTRIBUTION_TYPE_FIELD_NUMBER: builtins.int
    GROUP_ATTRIBUTE_NAME_FIELD_NUMBER: builtins.int
    group_distribution_type: global___GroupDistributionType.ValueType
    """Distribution type for group claims."""
    group_attribute_name: builtins.str
    """Name of the SAML attribute that contains group information."""
    def __init__(
        self,
        *,
        group_distribution_type: global___GroupDistributionType.ValueType = ...,
        group_attribute_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["group_attribute_name", b"group_attribute_name", "group_distribution_type", b"group_distribution_type"]) -> None: ...

global___GroupClaimsSettings = GroupClaimsSettings
