"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing
import yandex.cloud.operation.operation_pb2
import yandex.cloud.organizationmanager.v1.idp.application.saml.application_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _AssignmentAction:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _AssignmentActionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_AssignmentAction.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ASSIGNMENT_ACTION_UNSPECIFIED: _AssignmentAction.ValueType  # 0
    """The assignment action is not specified."""
    ADD: _AssignmentAction.ValueType  # 1
    """Add an assignment."""
    REMOVE: _AssignmentAction.ValueType  # 2
    """Remove an assignment."""

class AssignmentAction(_AssignmentAction, metaclass=_AssignmentActionEnumTypeWrapper):
    """Actions that can be performed on assignments."""

ASSIGNMENT_ACTION_UNSPECIFIED: AssignmentAction.ValueType  # 0
"""The assignment action is not specified."""
ADD: AssignmentAction.ValueType  # 1
"""Add an assignment."""
REMOVE: AssignmentAction.ValueType  # 2
"""Remove an assignment."""
global___AssignmentAction = AssignmentAction

@typing.final
class GetApplicationRequest(google.protobuf.message.Message):
    """Request to get a SAML application by ID."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPLICATION_ID_FIELD_NUMBER: builtins.int
    application_id: builtins.str
    """ID of the SAML application to return."""
    def __init__(
        self,
        *,
        application_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["application_id", b"application_id"]) -> None: ...

global___GetApplicationRequest = GetApplicationRequest

@typing.final
class ListApplicationsRequest(google.protobuf.message.Message):
    """Request to list SAML applications in an organization."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    organization_id: builtins.str
    """ID of the organization to list applications in."""
    page_size: builtins.int
    """The maximum number of results per page to return."""
    page_token: builtins.str
    """Page token for pagination."""
    filter: builtins.str
    """A filter expression that filters resources listed in the response."""
    def __init__(
        self,
        *,
        organization_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "organization_id", b"organization_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListApplicationsRequest = ListApplicationsRequest

@typing.final
class ListApplicationsResponse(google.protobuf.message.Message):
    """Response message for [ApplicationService.List]."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPLICATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list."""
    @property
    def applications(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.organizationmanager.v1.idp.application.saml.application_pb2.Application]:
        """List of SAML applications."""

    def __init__(
        self,
        *,
        applications: collections.abc.Iterable[yandex.cloud.organizationmanager.v1.idp.application.saml.application_pb2.Application] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["applications", b"applications", "next_page_token", b"next_page_token"]) -> None: ...

global___ListApplicationsResponse = ListApplicationsResponse

@typing.final
class CreateApplicationRequest(google.protobuf.message.Message):
    """Request to create a new SAML application."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    SERVICE_PROVIDER_FIELD_NUMBER: builtins.int
    SECURITY_SETTINGS_FIELD_NUMBER: builtins.int
    ATTRIBUTE_MAPPING_FIELD_NUMBER: builtins.int
    GROUP_CLAIMS_SETTINGS_FIELD_NUMBER: builtins.int
    organization_id: builtins.str
    """ID of the organization to create the application in."""
    name: builtins.str
    """Name of the SAML application."""
    description: builtins.str
    """Description of the SAML application."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `` key:value `` pairs."""

    @property
    def service_provider(self) -> yandex.cloud.organizationmanager.v1.idp.application.saml.application_pb2.ServiceProvider:
        """Service provider configuration for the SAML application."""

    @property
    def security_settings(self) -> global___SecuritySettingsSpec:
        """Security settings for the SAML application."""

    @property
    def attribute_mapping(self) -> global___AttributeMappingSpec:
        """Attribute mapping configuration for the SAML application."""

    @property
    def group_claims_settings(self) -> yandex.cloud.organizationmanager.v1.idp.application.saml.application_pb2.GroupClaimsSettings:
        """Group claims settings for the SAML application."""

    def __init__(
        self,
        *,
        organization_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        service_provider: yandex.cloud.organizationmanager.v1.idp.application.saml.application_pb2.ServiceProvider | None = ...,
        security_settings: global___SecuritySettingsSpec | None = ...,
        attribute_mapping: global___AttributeMappingSpec | None = ...,
        group_claims_settings: yandex.cloud.organizationmanager.v1.idp.application.saml.application_pb2.GroupClaimsSettings | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["attribute_mapping", b"attribute_mapping", "group_claims_settings", b"group_claims_settings", "security_settings", b"security_settings", "service_provider", b"service_provider"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["attribute_mapping", b"attribute_mapping", "description", b"description", "group_claims_settings", b"group_claims_settings", "labels", b"labels", "name", b"name", "organization_id", b"organization_id", "security_settings", b"security_settings", "service_provider", b"service_provider"]) -> None: ...

global___CreateApplicationRequest = CreateApplicationRequest

@typing.final
class SecuritySettingsSpec(google.protobuf.message.Message):
    """Security settings specification for SAML application creation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIGNATURE_MODE_FIELD_NUMBER: builtins.int
    signature_mode: yandex.cloud.organizationmanager.v1.idp.application.saml.application_pb2.SecuritySettings.SignatureMode.ValueType
    """Signature mode for SAML assertions and responses."""
    def __init__(
        self,
        *,
        signature_mode: yandex.cloud.organizationmanager.v1.idp.application.saml.application_pb2.SecuritySettings.SignatureMode.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["signature_mode", b"signature_mode"]) -> None: ...

global___SecuritySettingsSpec = SecuritySettingsSpec

@typing.final
class NameIdSpec(google.protobuf.message.Message):
    """NameID specification for SAML application."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FORMAT_FIELD_NUMBER: builtins.int
    format: yandex.cloud.organizationmanager.v1.idp.application.saml.application_pb2.NameId.Format.ValueType
    """Format of the NameID."""
    def __init__(
        self,
        *,
        format: yandex.cloud.organizationmanager.v1.idp.application.saml.application_pb2.NameId.Format.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["format", b"format"]) -> None: ...

global___NameIdSpec = NameIdSpec

@typing.final
class AttributeMappingSpec(google.protobuf.message.Message):
    """Attribute mapping specification for SAML application."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_ID_FIELD_NUMBER: builtins.int
    ATTRIBUTES_FIELD_NUMBER: builtins.int
    @property
    def name_id(self) -> global___NameIdSpec:
        """NameID configuration."""

    @property
    def attributes(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.organizationmanager.v1.idp.application.saml.application_pb2.Attribute]:
        """List of attribute mappings."""

    def __init__(
        self,
        *,
        name_id: global___NameIdSpec | None = ...,
        attributes: collections.abc.Iterable[yandex.cloud.organizationmanager.v1.idp.application.saml.application_pb2.Attribute] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["name_id", b"name_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["attributes", b"attributes", "name_id", b"name_id"]) -> None: ...

global___AttributeMappingSpec = AttributeMappingSpec

@typing.final
class CreateApplicationMetadata(google.protobuf.message.Message):
    """Metadata for the [ApplicationService.Create] operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPLICATION_ID_FIELD_NUMBER: builtins.int
    application_id: builtins.str
    """ID of the SAML application that is being created."""
    def __init__(
        self,
        *,
        application_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["application_id", b"application_id"]) -> None: ...

global___CreateApplicationMetadata = CreateApplicationMetadata

@typing.final
class UpdateApplicationRequest(google.protobuf.message.Message):
    """Request to update an existing SAML application."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    APPLICATION_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    SERVICE_PROVIDER_FIELD_NUMBER: builtins.int
    SECURITY_SETTINGS_FIELD_NUMBER: builtins.int
    ATTRIBUTE_MAPPING_FIELD_NUMBER: builtins.int
    GROUP_CLAIMS_SETTINGS_FIELD_NUMBER: builtins.int
    application_id: builtins.str
    """ID of the SAML application to update."""
    name: builtins.str
    """New name for the SAML application."""
    description: builtins.str
    """New description for the SAML application."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which fields of the application are going to be updated."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """New resource labels as `` key:value `` pairs."""

    @property
    def service_provider(self) -> yandex.cloud.organizationmanager.v1.idp.application.saml.application_pb2.ServiceProvider:
        """New service provider configuration for the SAML application."""

    @property
    def security_settings(self) -> yandex.cloud.organizationmanager.v1.idp.application.saml.application_pb2.SecuritySettings:
        """New security settings for the SAML application."""

    @property
    def attribute_mapping(self) -> global___AttributeMappingSpec:
        """New attribute mapping configuration for the SAML application."""

    @property
    def group_claims_settings(self) -> yandex.cloud.organizationmanager.v1.idp.application.saml.application_pb2.GroupClaimsSettings:
        """New group claims settings for the SAML application."""

    def __init__(
        self,
        *,
        application_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        service_provider: yandex.cloud.organizationmanager.v1.idp.application.saml.application_pb2.ServiceProvider | None = ...,
        security_settings: yandex.cloud.organizationmanager.v1.idp.application.saml.application_pb2.SecuritySettings | None = ...,
        attribute_mapping: global___AttributeMappingSpec | None = ...,
        group_claims_settings: yandex.cloud.organizationmanager.v1.idp.application.saml.application_pb2.GroupClaimsSettings | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["attribute_mapping", b"attribute_mapping", "group_claims_settings", b"group_claims_settings", "security_settings", b"security_settings", "service_provider", b"service_provider", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["application_id", b"application_id", "attribute_mapping", b"attribute_mapping", "description", b"description", "group_claims_settings", b"group_claims_settings", "labels", b"labels", "name", b"name", "security_settings", b"security_settings", "service_provider", b"service_provider", "update_mask", b"update_mask"]) -> None: ...

global___UpdateApplicationRequest = UpdateApplicationRequest

@typing.final
class UpdateApplicationMetadata(google.protobuf.message.Message):
    """Metadata for the [ApplicationService.Update] operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPLICATION_ID_FIELD_NUMBER: builtins.int
    application_id: builtins.str
    """ID of the SAML application that is being updated."""
    def __init__(
        self,
        *,
        application_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["application_id", b"application_id"]) -> None: ...

global___UpdateApplicationMetadata = UpdateApplicationMetadata

@typing.final
class DeleteApplicationRequest(google.protobuf.message.Message):
    """Request to delete a SAML application."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPLICATION_ID_FIELD_NUMBER: builtins.int
    application_id: builtins.str
    """ID of the SAML application to delete."""
    def __init__(
        self,
        *,
        application_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["application_id", b"application_id"]) -> None: ...

global___DeleteApplicationRequest = DeleteApplicationRequest

@typing.final
class DeleteApplicationMetadata(google.protobuf.message.Message):
    """Metadata for the [ApplicationService.Delete] operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPLICATION_ID_FIELD_NUMBER: builtins.int
    application_id: builtins.str
    """ID of the SAML application that is being deleted."""
    def __init__(
        self,
        *,
        application_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["application_id", b"application_id"]) -> None: ...

global___DeleteApplicationMetadata = DeleteApplicationMetadata

@typing.final
class SuspendApplicationRequest(google.protobuf.message.Message):
    """Request to suspend a SAML application."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPLICATION_ID_FIELD_NUMBER: builtins.int
    application_id: builtins.str
    """ID of the SAML application to suspend."""
    def __init__(
        self,
        *,
        application_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["application_id", b"application_id"]) -> None: ...

global___SuspendApplicationRequest = SuspendApplicationRequest

@typing.final
class SuspendApplicationMetadata(google.protobuf.message.Message):
    """Metadata for the [ApplicationService.Suspend] operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPLICATION_ID_FIELD_NUMBER: builtins.int
    application_id: builtins.str
    """ID of the SAML application that is being suspended."""
    def __init__(
        self,
        *,
        application_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["application_id", b"application_id"]) -> None: ...

global___SuspendApplicationMetadata = SuspendApplicationMetadata

@typing.final
class ReactivateApplicationRequest(google.protobuf.message.Message):
    """Request to reactivate a suspended SAML application."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPLICATION_ID_FIELD_NUMBER: builtins.int
    application_id: builtins.str
    """ID of the SAML application to reactivate."""
    def __init__(
        self,
        *,
        application_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["application_id", b"application_id"]) -> None: ...

global___ReactivateApplicationRequest = ReactivateApplicationRequest

@typing.final
class ReactivateApplicationMetadata(google.protobuf.message.Message):
    """Metadata for the [ApplicationService.Reactivate] operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPLICATION_ID_FIELD_NUMBER: builtins.int
    application_id: builtins.str
    """ID of the SAML application that is being reactivated."""
    def __init__(
        self,
        *,
        application_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["application_id", b"application_id"]) -> None: ...

global___ReactivateApplicationMetadata = ReactivateApplicationMetadata

@typing.final
class ListSupportedAttributeValuesRequest(google.protobuf.message.Message):
    """Request to list supported attribute values for SAML applications."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ListSupportedAttributeValuesRequest = ListSupportedAttributeValuesRequest

@typing.final
class ListSupportedAttributeValuesResponse(google.protobuf.message.Message):
    """Response message for [ApplicationService.ListSupportedAttributeValues]."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUPPORTED_ATTRIBUTE_VALUES_FIELD_NUMBER: builtins.int
    @property
    def supported_attribute_values(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SupportedAttributeValue]:
        """List of supported attribute values."""

    def __init__(
        self,
        *,
        supported_attribute_values: collections.abc.Iterable[global___SupportedAttributeValue] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["supported_attribute_values", b"supported_attribute_values"]) -> None: ...

global___ListSupportedAttributeValuesResponse = ListSupportedAttributeValuesResponse

@typing.final
class SupportedAttributeValue(google.protobuf.message.Message):
    """A supported attribute value for SAML applications."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUE_FIELD_NUMBER: builtins.int
    value: builtins.str
    """The attribute value."""
    def __init__(
        self,
        *,
        value: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["value", b"value"]) -> None: ...

global___SupportedAttributeValue = SupportedAttributeValue

@typing.final
class ListApplicationOperationsRequest(google.protobuf.message.Message):
    """Request to list operations for a SAML application."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPLICATION_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    application_id: builtins.str
    """ID of the SAML application to list operations for."""
    page_size: builtins.int
    """The maximum number of results per page to return."""
    page_token: builtins.str
    """Page token for pagination."""
    def __init__(
        self,
        *,
        application_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["application_id", b"application_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListApplicationOperationsRequest = ListApplicationOperationsRequest

@typing.final
class ListApplicationOperationsResponse(google.protobuf.message.Message):
    """Response message for [ApplicationService.ListOperations]."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list."""
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.operation.operation_pb2.Operation]:
        """List of operations."""

    def __init__(
        self,
        *,
        operations: collections.abc.Iterable[yandex.cloud.operation.operation_pb2.Operation] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "operations", b"operations"]) -> None: ...

global___ListApplicationOperationsResponse = ListApplicationOperationsResponse

@typing.final
class Assignment(google.protobuf.message.Message):
    """An assignment for a SAML application."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBJECT_ID_FIELD_NUMBER: builtins.int
    subject_id: builtins.str
    """ID of the subject being assigned."""
    def __init__(
        self,
        *,
        subject_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["subject_id", b"subject_id"]) -> None: ...

global___Assignment = Assignment

@typing.final
class AssignmentDelta(google.protobuf.message.Message):
    """A delta operation on assignments."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTION_FIELD_NUMBER: builtins.int
    ASSIGNMENT_FIELD_NUMBER: builtins.int
    action: global___AssignmentAction.ValueType
    """Action to perform on the assignment."""
    @property
    def assignment(self) -> global___Assignment:
        """Assignment to perform the action on."""

    def __init__(
        self,
        *,
        action: global___AssignmentAction.ValueType = ...,
        assignment: global___Assignment | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["assignment", b"assignment"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["action", b"action", "assignment", b"assignment"]) -> None: ...

global___AssignmentDelta = AssignmentDelta

@typing.final
class UpdateAssignmentsResponse(google.protobuf.message.Message):
    """Response message for [ApplicationService.UpdateAssignments]."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ASSIGNMENT_DELTAS_FIELD_NUMBER: builtins.int
    @property
    def assignment_deltas(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AssignmentDelta]:
        """List of assignment deltas that were applied."""

    def __init__(
        self,
        *,
        assignment_deltas: collections.abc.Iterable[global___AssignmentDelta] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["assignment_deltas", b"assignment_deltas"]) -> None: ...

global___UpdateAssignmentsResponse = UpdateAssignmentsResponse

@typing.final
class ListAssignmentsRequest(google.protobuf.message.Message):
    """Request to list assignments for a SAML application."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPLICATION_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    application_id: builtins.str
    """ID of the SAML application to list assignments for."""
    page_size: builtins.int
    """The maximum number of results per page to return."""
    page_token: builtins.str
    """Page token for pagination."""
    def __init__(
        self,
        *,
        application_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["application_id", b"application_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListAssignmentsRequest = ListAssignmentsRequest

@typing.final
class ListAssignmentsResponse(google.protobuf.message.Message):
    """Response message for [ApplicationService.ListAssignments]."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ASSIGNMENTS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list."""
    @property
    def assignments(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Assignment]:
        """List of assignments."""

    def __init__(
        self,
        *,
        assignments: collections.abc.Iterable[global___Assignment] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["assignments", b"assignments", "next_page_token", b"next_page_token"]) -> None: ...

global___ListAssignmentsResponse = ListAssignmentsResponse

@typing.final
class UpdateAssignmentsRequest(google.protobuf.message.Message):
    """Request to update assignments for a SAML application."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPLICATION_ID_FIELD_NUMBER: builtins.int
    ASSIGNMENT_DELTAS_FIELD_NUMBER: builtins.int
    application_id: builtins.str
    """ID of the SAML application to update assignments for."""
    @property
    def assignment_deltas(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AssignmentDelta]:
        """List of assignment deltas to apply."""

    def __init__(
        self,
        *,
        application_id: builtins.str = ...,
        assignment_deltas: collections.abc.Iterable[global___AssignmentDelta] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["application_id", b"application_id", "assignment_deltas", b"assignment_deltas"]) -> None: ...

global___UpdateAssignmentsRequest = UpdateAssignmentsRequest

@typing.final
class UpdateAssignmentsMetadata(google.protobuf.message.Message):
    """Metadata for the [ApplicationService.UpdateAssignments] operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPLICATION_ID_FIELD_NUMBER: builtins.int
    application_id: builtins.str
    """ID of the SAML application whose assignments are being updated."""
    def __init__(
        self,
        *,
        application_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["application_id", b"application_id"]) -> None: ...

global___UpdateAssignmentsMetadata = UpdateAssignmentsMetadata
