"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import google.protobuf.descriptor
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class SignatureCertificate(google.protobuf.message.Message):
    """A signature certificate for SAML applications."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SignatureCertificate._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: SignatureCertificate._Status.ValueType  # 0
        """The status is not specified."""
        ACTIVE: SignatureCertificate._Status.ValueType  # 1
        """The certificate is active and can be used for signing."""
        INACTIVE: SignatureCertificate._Status.ValueType  # 2
        """The certificate is inactive and cannot be used for signing."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper):
        """Represents the current status of a signature certificate."""

    STATUS_UNSPECIFIED: SignatureCertificate.Status.ValueType  # 0
    """The status is not specified."""
    ACTIVE: SignatureCertificate.Status.ValueType  # 1
    """The certificate is active and can be used for signing."""
    INACTIVE: SignatureCertificate.Status.ValueType  # 2
    """The certificate is inactive and cannot be used for signing."""

    ID_FIELD_NUMBER: builtins.int
    APPLICATION_ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    FINGERPRINT_FIELD_NUMBER: builtins.int
    NOT_AFTER_FIELD_NUMBER: builtins.int
    NOT_BEFORE_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Unique identifier of the signature certificate."""
    application_id: builtins.str
    """ID of the SAML application that the signature certificate belongs to."""
    status: global___SignatureCertificate.Status.ValueType
    """Current status of the signature certificate."""
    name: builtins.str
    """Name of the signature certificate."""
    description: builtins.str
    """Description of the signature certificate."""
    data: builtins.str
    """Certificate data in PEM format."""
    fingerprint: builtins.str
    """SHA256-fingerprint of the signature certificate."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp."""

    @property
    def not_after(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Time after which the signature certificate is not valid."""

    @property
    def not_before(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Time before which the signature certificate is not valid."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        application_id: builtins.str = ...,
        status: global___SignatureCertificate.Status.ValueType = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        data: builtins.str = ...,
        fingerprint: builtins.str = ...,
        not_after: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        not_before: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "not_after", b"not_after", "not_before", b"not_before"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["application_id", b"application_id", "created_at", b"created_at", "data", b"data", "description", b"description", "fingerprint", b"fingerprint", "id", b"id", "name", b"name", "not_after", b"not_after", "not_before", b"not_before", "status", b"status"]) -> None: ...

global___SignatureCertificate = SignatureCertificate
