"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.organizationmanager.v1.idp.application.saml.signature_certificate_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetSignatureCertificateRequest(google.protobuf.message.Message):
    """Request to get a signature certificate by ID."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIGNATURE_CERTIFICATE_ID_FIELD_NUMBER: builtins.int
    signature_certificate_id: builtins.str
    """ID of the signature certificate to return."""
    def __init__(
        self,
        *,
        signature_certificate_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["signature_certificate_id", b"signature_certificate_id"]) -> None: ...

global___GetSignatureCertificateRequest = GetSignatureCertificateRequest

@typing.final
class ListSignatureCertificatesRequest(google.protobuf.message.Message):
    """Request to list signature certificates for a SAML application."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPLICATION_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    application_id: builtins.str
    """ID of the SAML application to list certificates for."""
    page_size: builtins.int
    """The maximum number of results per page to return."""
    page_token: builtins.str
    """Page token for pagination."""
    filter: builtins.str
    """A filter expression that filters resources listed in the response."""
    def __init__(
        self,
        *,
        application_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["application_id", b"application_id", "filter", b"filter", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListSignatureCertificatesRequest = ListSignatureCertificatesRequest

@typing.final
class ListSignatureCertificatesResponse(google.protobuf.message.Message):
    """Response message for [SignatureCertificateService.List]."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIGNATURE_CERTIFICATES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    """Token for getting the next page of the list."""
    @property
    def signature_certificates(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.organizationmanager.v1.idp.application.saml.signature_certificate_pb2.SignatureCertificate]:
        """List of signature certificates."""

    def __init__(
        self,
        *,
        signature_certificates: collections.abc.Iterable[yandex.cloud.organizationmanager.v1.idp.application.saml.signature_certificate_pb2.SignatureCertificate] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "signature_certificates", b"signature_certificates"]) -> None: ...

global___ListSignatureCertificatesResponse = ListSignatureCertificatesResponse

@typing.final
class CreateSignatureCertificateRequest(google.protobuf.message.Message):
    """Request to create a new signature certificate."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APPLICATION_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    application_id: builtins.str
    """ID of the SAML application to create the certificate for."""
    name: builtins.str
    """Name of the signature certificate.
    The name is unique within the application. 3-63 characters long.
    """
    description: builtins.str
    """Description of the signature certificate. 0-256 characters long."""
    def __init__(
        self,
        *,
        application_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["application_id", b"application_id", "description", b"description", "name", b"name"]) -> None: ...

global___CreateSignatureCertificateRequest = CreateSignatureCertificateRequest

@typing.final
class CreateSignatureCertificateMetadata(google.protobuf.message.Message):
    """Metadata for the [SignatureCertificateService.Create] operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIGNATURE_CERTIFICATE_ID_FIELD_NUMBER: builtins.int
    signature_certificate_id: builtins.str
    """ID of the signature certificate that is being created."""
    def __init__(
        self,
        *,
        signature_certificate_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["signature_certificate_id", b"signature_certificate_id"]) -> None: ...

global___CreateSignatureCertificateMetadata = CreateSignatureCertificateMetadata

@typing.final
class UpdateSignatureCertificateRequest(google.protobuf.message.Message):
    """Request to update an existing signature certificate."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIGNATURE_CERTIFICATE_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    signature_certificate_id: builtins.str
    """ID of the signature certificate to update."""
    name: builtins.str
    """New name for the signature certificate."""
    description: builtins.str
    """New description for the signature certificate."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which fields of the certificate are going to be updated."""

    def __init__(
        self,
        *,
        signature_certificate_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["description", b"description", "name", b"name", "signature_certificate_id", b"signature_certificate_id", "update_mask", b"update_mask"]) -> None: ...

global___UpdateSignatureCertificateRequest = UpdateSignatureCertificateRequest

@typing.final
class UpdateSignatureCertificateMetadata(google.protobuf.message.Message):
    """Metadata for the [SignatureCertificateService.Update] operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIGNATURE_CERTIFICATE_ID_FIELD_NUMBER: builtins.int
    signature_certificate_id: builtins.str
    """ID of the signature certificate that is being updated."""
    def __init__(
        self,
        *,
        signature_certificate_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["signature_certificate_id", b"signature_certificate_id"]) -> None: ...

global___UpdateSignatureCertificateMetadata = UpdateSignatureCertificateMetadata

@typing.final
class DeleteSignatureCertificateRequest(google.protobuf.message.Message):
    """Request to delete a signature certificate."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIGNATURE_CERTIFICATE_ID_FIELD_NUMBER: builtins.int
    signature_certificate_id: builtins.str
    """ID of the signature certificate to delete."""
    def __init__(
        self,
        *,
        signature_certificate_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["signature_certificate_id", b"signature_certificate_id"]) -> None: ...

global___DeleteSignatureCertificateRequest = DeleteSignatureCertificateRequest

@typing.final
class DeleteSignatureCertificateMetadata(google.protobuf.message.Message):
    """Metadata for the [SignatureCertificateService.Delete] operation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIGNATURE_CERTIFICATE_ID_FIELD_NUMBER: builtins.int
    signature_certificate_id: builtins.str
    """ID of the signature certificate that is being deleted."""
    def __init__(
        self,
        *,
        signature_certificate_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["signature_certificate_id", b"signature_certificate_id"]) -> None: ...

global___DeleteSignatureCertificateMetadata = DeleteSignatureCertificateMetadata
