"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Userpool(google.protobuf.message.Message):
    """A userpool is a container for users in the Identity Provider system."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Userpool._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: Userpool._Status.ValueType  # 0
        """The status is not specified."""
        CREATING: Userpool._Status.ValueType  # 1
        """The userpool is in the process of being created."""
        ACTIVE: Userpool._Status.ValueType  # 2
        """The userpool is active and operational."""
        DELETING: Userpool._Status.ValueType  # 3
        """The userpool is in the process of being deleted."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper):
        """Represents the current status of a userpool."""

    STATUS_UNSPECIFIED: Userpool.Status.ValueType  # 0
    """The status is not specified."""
    CREATING: Userpool.Status.ValueType  # 1
    """The userpool is in the process of being created."""
    ACTIVE: Userpool.Status.ValueType  # 2
    """The userpool is active and operational."""
    DELETING: Userpool.Status.ValueType  # 3
    """The userpool is in the process of being deleted."""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    UPDATED_AT_FIELD_NUMBER: builtins.int
    DOMAINS_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    USER_SETTINGS_FIELD_NUMBER: builtins.int
    PASSWORD_QUALITY_POLICY_FIELD_NUMBER: builtins.int
    PASSWORD_LIFETIME_POLICY_FIELD_NUMBER: builtins.int
    BRUTEFORCE_PROTECTION_POLICY_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Unique identifier of the userpool."""
    organization_id: builtins.str
    """ID of the organization this userpool belongs to."""
    name: builtins.str
    """Name of the userpool."""
    description: builtins.str
    """Description of the userpool."""
    status: global___Userpool.Status.ValueType
    """Current status of the userpool."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as key:value pairs."""

    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp when the userpool was created."""

    @property
    def updated_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp when the userpool was last updated."""

    @property
    def domains(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of domains associated with this userpool."""

    @property
    def user_settings(self) -> global___UserSettings:
        """User settings for this userpool."""

    @property
    def password_quality_policy(self) -> global___PasswordQualityPolicy:
        """Password quality policy for this userpool."""

    @property
    def password_lifetime_policy(self) -> global___PasswordLifetimePolicy:
        """Password lifetime policy for this userpool."""

    @property
    def bruteforce_protection_policy(self) -> global___BruteforceProtectionPolicy:
        """Bruteforce protection policy for this userpool."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        organization_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        updated_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        domains: collections.abc.Iterable[builtins.str] | None = ...,
        status: global___Userpool.Status.ValueType = ...,
        user_settings: global___UserSettings | None = ...,
        password_quality_policy: global___PasswordQualityPolicy | None = ...,
        password_lifetime_policy: global___PasswordLifetimePolicy | None = ...,
        bruteforce_protection_policy: global___BruteforceProtectionPolicy | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["bruteforce_protection_policy", b"bruteforce_protection_policy", "created_at", b"created_at", "password_lifetime_policy", b"password_lifetime_policy", "password_quality_policy", b"password_quality_policy", "updated_at", b"updated_at", "user_settings", b"user_settings"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["bruteforce_protection_policy", b"bruteforce_protection_policy", "created_at", b"created_at", "description", b"description", "domains", b"domains", "id", b"id", "labels", b"labels", "name", b"name", "organization_id", b"organization_id", "password_lifetime_policy", b"password_lifetime_policy", "password_quality_policy", b"password_quality_policy", "status", b"status", "updated_at", b"updated_at", "user_settings", b"user_settings"]) -> None: ...

global___Userpool = Userpool

@typing.final
class UserSettings(google.protobuf.message.Message):
    """Settings that control user capabilities within a userpool."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ALLOW_EDIT_SELF_PASSWORD_FIELD_NUMBER: builtins.int
    ALLOW_EDIT_SELF_INFO_FIELD_NUMBER: builtins.int
    ALLOW_EDIT_SELF_CONTACTS_FIELD_NUMBER: builtins.int
    ALLOW_EDIT_SELF_LOGIN_FIELD_NUMBER: builtins.int
    allow_edit_self_password: builtins.bool
    """Whether users can change their own passwords."""
    allow_edit_self_info: builtins.bool
    """Whether users can edit their own profile information."""
    allow_edit_self_contacts: builtins.bool
    """Whether users can edit their own contact information."""
    allow_edit_self_login: builtins.bool
    """Whether users can edit their own login information."""
    def __init__(
        self,
        *,
        allow_edit_self_password: builtins.bool = ...,
        allow_edit_self_info: builtins.bool = ...,
        allow_edit_self_contacts: builtins.bool = ...,
        allow_edit_self_login: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["allow_edit_self_contacts", b"allow_edit_self_contacts", "allow_edit_self_info", b"allow_edit_self_info", "allow_edit_self_login", b"allow_edit_self_login", "allow_edit_self_password", b"allow_edit_self_password"]) -> None: ...

global___UserSettings = UserSettings

@typing.final
class Domain(google.protobuf.message.Message):
    """A domain associated with a userpool."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Domain._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: Domain._Status.ValueType  # 0
        """The status is not specified."""
        NEED_TO_VALIDATE: Domain._Status.ValueType  # 1
        """The domain needs to be validated."""
        VALIDATING: Domain._Status.ValueType  # 2
        """The domain is in the process of being validated."""
        VALID: Domain._Status.ValueType  # 3
        """The domain has been successfully validated."""
        INVALID: Domain._Status.ValueType  # 4
        """The domain validation has failed."""
        DELETING: Domain._Status.ValueType  # 5
        """The domain is in the process of being deleted."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper):
        """Represents the current status of a domain."""

    STATUS_UNSPECIFIED: Domain.Status.ValueType  # 0
    """The status is not specified."""
    NEED_TO_VALIDATE: Domain.Status.ValueType  # 1
    """The domain needs to be validated."""
    VALIDATING: Domain.Status.ValueType  # 2
    """The domain is in the process of being validated."""
    VALID: Domain.Status.ValueType  # 3
    """The domain has been successfully validated."""
    INVALID: Domain.Status.ValueType  # 4
    """The domain validation has failed."""
    DELETING: Domain.Status.ValueType  # 5
    """The domain is in the process of being deleted."""

    DOMAIN_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    STATUS_CODE_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    VALIDATED_AT_FIELD_NUMBER: builtins.int
    CHALLENGES_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    domain: builtins.str
    """Domain name."""
    status: global___Domain.Status.ValueType
    """Current status of the domain."""
    status_code: builtins.str
    """Optional code providing details about validation errors."""
    deletion_protection: builtins.bool
    """Whether the domain is protected from deletion."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp when the domain was created."""

    @property
    def validated_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp when the domain was validated."""

    @property
    def challenges(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___DomainChallenge]:
        """List of challenges associated with this domain."""

    def __init__(
        self,
        *,
        domain: builtins.str = ...,
        status: global___Domain.Status.ValueType = ...,
        status_code: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        validated_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        challenges: collections.abc.Iterable[global___DomainChallenge] | None = ...,
        deletion_protection: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "validated_at", b"validated_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["challenges", b"challenges", "created_at", b"created_at", "deletion_protection", b"deletion_protection", "domain", b"domain", "status", b"status", "status_code", b"status_code", "validated_at", b"validated_at"]) -> None: ...

global___Domain = Domain

@typing.final
class DomainChallenge(google.protobuf.message.Message):
    """A challenge used to validate domain ownership."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Type:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[DomainChallenge._Type.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TYPE_UNSPECIFIED: DomainChallenge._Type.ValueType  # 0
        """The type is not specified."""
        DNS_TXT: DomainChallenge._Type.ValueType  # 1
        """DNS TXT record challenge."""

    class Type(_Type, metaclass=_TypeEnumTypeWrapper):
        """Type of domain challenge."""

    TYPE_UNSPECIFIED: DomainChallenge.Type.ValueType  # 0
    """The type is not specified."""
    DNS_TXT: DomainChallenge.Type.ValueType  # 1
    """DNS TXT record challenge."""

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[DomainChallenge._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: DomainChallenge._Status.ValueType  # 0
        """The status is not specified."""
        PENDING: DomainChallenge._Status.ValueType  # 1
        """The challenge is pending verification."""
        PROCESSING: DomainChallenge._Status.ValueType  # 2
        """The challenge verification is in progress."""
        VALID: DomainChallenge._Status.ValueType  # 3
        """The challenge has been successfully verified."""
        INVALID: DomainChallenge._Status.ValueType  # 4
        """The challenge verification has failed."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper):
        """Status of the domain challenge."""

    STATUS_UNSPECIFIED: DomainChallenge.Status.ValueType  # 0
    """The status is not specified."""
    PENDING: DomainChallenge.Status.ValueType  # 1
    """The challenge is pending verification."""
    PROCESSING: DomainChallenge.Status.ValueType  # 2
    """The challenge verification is in progress."""
    VALID: DomainChallenge.Status.ValueType  # 3
    """The challenge has been successfully verified."""
    INVALID: DomainChallenge.Status.ValueType  # 4
    """The challenge verification has failed."""

    @typing.final
    class DnsRecord(google.protobuf.message.Message):
        """DNS record information for domain validation."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _Type:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[DomainChallenge.DnsRecord._Type.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            TYPE_UNSPECIFIED: DomainChallenge.DnsRecord._Type.ValueType  # 0
            """The type is not specified."""
            TXT: DomainChallenge.DnsRecord._Type.ValueType  # 1
            """TXT record type."""

        class Type(_Type, metaclass=_TypeEnumTypeWrapper):
            """Type of DNS record."""

        TYPE_UNSPECIFIED: DomainChallenge.DnsRecord.Type.ValueType  # 0
        """The type is not specified."""
        TXT: DomainChallenge.DnsRecord.Type.ValueType  # 1
        """TXT record type."""

        NAME_FIELD_NUMBER: builtins.int
        TYPE_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        name: builtins.str
        """Name of the DNS record."""
        type: global___DomainChallenge.DnsRecord.Type.ValueType
        """Type of the DNS record."""
        value: builtins.str
        """Value of the DNS record."""
        def __init__(
            self,
            *,
            name: builtins.str = ...,
            type: global___DomainChallenge.DnsRecord.Type.ValueType = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["name", b"name", "type", b"type", "value", b"value"]) -> None: ...

    CREATED_AT_FIELD_NUMBER: builtins.int
    UPDATED_AT_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    DNS_CHALLENGE_FIELD_NUMBER: builtins.int
    type: global___DomainChallenge.Type.ValueType
    """Type of the challenge."""
    status: global___DomainChallenge.Status.ValueType
    """Current status of the challenge."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp when the challenge was created."""

    @property
    def updated_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Timestamp when the challenge was last updated."""

    @property
    def dns_challenge(self) -> global___DomainChallenge.DnsRecord:
        """DNS record challenge details."""

    def __init__(
        self,
        *,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        updated_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        type: global___DomainChallenge.Type.ValueType = ...,
        status: global___DomainChallenge.Status.ValueType = ...,
        dns_challenge: global___DomainChallenge.DnsRecord | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["challenge", b"challenge", "created_at", b"created_at", "dns_challenge", b"dns_challenge", "updated_at", b"updated_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["challenge", b"challenge", "created_at", b"created_at", "dns_challenge", b"dns_challenge", "status", b"status", "type", b"type", "updated_at", b"updated_at"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["challenge", b"challenge"]) -> typing.Literal["dns_challenge"] | None: ...

global___DomainChallenge = DomainChallenge

@typing.final
class PasswordQualityPolicy(google.protobuf.message.Message):
    """Policy that defines password quality requirements."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class RequiredClasses(google.protobuf.message.Message):
        """Character classes that can be required in passwords."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        LOWERS_FIELD_NUMBER: builtins.int
        UPPERS_FIELD_NUMBER: builtins.int
        DIGITS_FIELD_NUMBER: builtins.int
        SPECIALS_FIELD_NUMBER: builtins.int
        lowers: builtins.bool
        """Whether lowercase letters are required."""
        uppers: builtins.bool
        """Whether uppercase letters are required."""
        digits: builtins.bool
        """Whether digits are required."""
        specials: builtins.bool
        """Whether special characters are required."""
        def __init__(
            self,
            *,
            lowers: builtins.bool = ...,
            uppers: builtins.bool = ...,
            digits: builtins.bool = ...,
            specials: builtins.bool = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["digits", b"digits", "lowers", b"lowers", "specials", b"specials", "uppers", b"uppers"]) -> None: ...

    @typing.final
    class MinLengthByClassSettings(google.protobuf.message.Message):
        """Minimum password length requirements based on character class diversity."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ONE_FIELD_NUMBER: builtins.int
        TWO_FIELD_NUMBER: builtins.int
        THREE_FIELD_NUMBER: builtins.int
        one: builtins.int
        """Minimum length for passwords with one character class."""
        two: builtins.int
        """Minimum length for passwords with two character classes."""
        three: builtins.int
        """Minimum length for passwords with three character classes."""
        def __init__(
            self,
            *,
            one: builtins.int = ...,
            two: builtins.int = ...,
            three: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["one", b"one", "three", b"three", "two", b"two"]) -> None: ...

    ALLOW_SIMILAR_FIELD_NUMBER: builtins.int
    MAX_LENGTH_FIELD_NUMBER: builtins.int
    MIN_LENGTH_FIELD_NUMBER: builtins.int
    MATCH_LENGTH_FIELD_NUMBER: builtins.int
    REQUIRED_CLASSES_FIELD_NUMBER: builtins.int
    MIN_LENGTH_BY_CLASS_SETTINGS_FIELD_NUMBER: builtins.int
    allow_similar: builtins.bool
    """Whether passwords similar to previous ones are allowed."""
    max_length: builtins.int
    """Maximum password length. Zero means no maximum length is enforced."""
    min_length: builtins.int
    """Minimum password length."""
    match_length: builtins.int
    """Minimum length of substrings to check for similarity to vulnerable sequences."""
    @property
    def required_classes(self) -> global___PasswordQualityPolicy.RequiredClasses:
        """Character classes required in passwords."""

    @property
    def min_length_by_class_settings(self) -> global___PasswordQualityPolicy.MinLengthByClassSettings:
        """Minimum length requirements based on character class diversity.
        If not specified, these checks are disabled.
        """

    def __init__(
        self,
        *,
        allow_similar: builtins.bool = ...,
        max_length: builtins.int = ...,
        min_length: builtins.int = ...,
        match_length: builtins.int = ...,
        required_classes: global___PasswordQualityPolicy.RequiredClasses | None = ...,
        min_length_by_class_settings: global___PasswordQualityPolicy.MinLengthByClassSettings | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["min_length_by_class_settings", b"min_length_by_class_settings", "required_classes", b"required_classes"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["allow_similar", b"allow_similar", "match_length", b"match_length", "max_length", b"max_length", "min_length", b"min_length", "min_length_by_class_settings", b"min_length_by_class_settings", "required_classes", b"required_classes"]) -> None: ...

global___PasswordQualityPolicy = PasswordQualityPolicy

@typing.final
class PasswordLifetimePolicy(google.protobuf.message.Message):
    """Policy that defines password lifetime requirements."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MIN_DAYS_COUNT_FIELD_NUMBER: builtins.int
    MAX_DAYS_COUNT_FIELD_NUMBER: builtins.int
    min_days_count: builtins.int
    """Minimum number of days before a password can be changed."""
    max_days_count: builtins.int
    """Maximum number of days a password remains valid.
    Zero means passwords never expire.
    """
    def __init__(
        self,
        *,
        min_days_count: builtins.int = ...,
        max_days_count: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["max_days_count", b"max_days_count", "min_days_count", b"min_days_count"]) -> None: ...

global___PasswordLifetimePolicy = PasswordLifetimePolicy

@typing.final
class BruteforceProtectionPolicy(google.protobuf.message.Message):
    """Policy that defines protection against brute force attacks."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WINDOW_FIELD_NUMBER: builtins.int
    BLOCK_FIELD_NUMBER: builtins.int
    ATTEMPTS_FIELD_NUMBER: builtins.int
    attempts: builtins.int
    """Number of failed attempts allowed within the window before blocking."""
    @property
    def window(self) -> google.protobuf.duration_pb2.Duration:
        """Time window for counting failed authentication attempts."""

    @property
    def block(self) -> google.protobuf.duration_pb2.Duration:
        """Duration of the block after too many failed attempts."""

    def __init__(
        self,
        *,
        window: google.protobuf.duration_pb2.Duration | None = ...,
        block: google.protobuf.duration_pb2.Duration | None = ...,
        attempts: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["block", b"block", "window", b"window"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["attempts", b"attempts", "block", b"block", "window", b"window"]) -> None: ...

global___BruteforceProtectionPolicy = BruteforceProtectionPolicy
