"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Folder(google.protobuf.message.Message):
    """A Folder resource. For more information, see [Folder](/docs/resource-manager/concepts/resources-hierarchy#folder)."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Folder._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: Folder._Status.ValueType  # 0
        ACTIVE: Folder._Status.ValueType  # 1
        """The folder is active."""
        DELETING: Folder._Status.ValueType  # 2
        """The folder is being deleted."""
        PENDING_DELETION: Folder._Status.ValueType  # 3
        """Stopping folder resources and waiting for the deletion start timestamp."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNSPECIFIED: Folder.Status.ValueType  # 0
    ACTIVE: Folder.Status.ValueType  # 1
    """The folder is active."""
    DELETING: Folder.Status.ValueType  # 2
    """The folder is being deleted."""
    PENDING_DELETION: Folder.Status.ValueType  # 3
    """Stopping folder resources and waiting for the deletion start timestamp."""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    CLOUD_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the folder."""
    cloud_id: builtins.str
    """ID of the cloud that the folder belongs to."""
    name: builtins.str
    """Name of the folder.
    The name is unique within the cloud. 3-63 characters long.
    """
    description: builtins.str
    """Description of the folder. 0-256 characters long."""
    status: global___Folder.Status.ValueType
    """Status of the folder."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `` key:value `` pairs. Maximum of 64 per resource."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        cloud_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        status: global___Folder.Status.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cloud_id", b"cloud_id", "created_at", b"created_at", "description", b"description", "id", b"id", "labels", b"labels", "name", b"name", "status", b"status"]) -> None: ...

global___Folder = Folder
