"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing
import yandex.cloud.searchapi.v2.search_query_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _Role:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _RoleEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Role.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    ROLE_UNSPECIFIED: _Role.ValueType  # 0
    ROLE_USER: _Role.ValueType  # 1
    """The message is sent by the user."""
    ROLE_ASSISTANT: _Role.ValueType  # 2
    """The message is sent by the model."""

class Role(_Role, metaclass=_RoleEnumTypeWrapper): ...

ROLE_UNSPECIFIED: Role.ValueType  # 0
ROLE_USER: Role.ValueType  # 1
"""The message is sent by the user."""
ROLE_ASSISTANT: Role.ValueType  # 2
"""The message is sent by the model."""
global___Role = Role

@typing.final
class GenSearchMessage(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTENT_FIELD_NUMBER: builtins.int
    ROLE_FIELD_NUMBER: builtins.int
    content: builtins.str
    """Text of user query or the model's response (depending on the role value)."""
    role: global___Role.ValueType
    """Message sender's role"""
    def __init__(
        self,
        *,
        content: builtins.str = ...,
        role: global___Role.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["content", b"content", "role", b"role"]) -> None: ...

global___GenSearchMessage = GenSearchMessage

@typing.final
class GenSearchRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class SiteOption(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        SITE_FIELD_NUMBER: builtins.int
        @property
        def site(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """Restricts the search to the specific websites."""

        def __init__(
            self,
            *,
            site: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["site", b"site"]) -> None: ...

    @typing.final
    class UrlOption(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        URL_FIELD_NUMBER: builtins.int
        @property
        def url(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """Restricts the search to the specific pages."""

        def __init__(
            self,
            *,
            url: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["url", b"url"]) -> None: ...

    @typing.final
    class HostOption(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        HOST_FIELD_NUMBER: builtins.int
        @property
        def host(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """Restricts the search to the specific hosts."""

        def __init__(
            self,
            *,
            host: collections.abc.Iterable[builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["host", b"host"]) -> None: ...

    @typing.final
    class SearchFilter(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _DocFormat:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _DocFormatEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[GenSearchRequest.SearchFilter._DocFormat.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            DOC_FORMAT_UNSPECIFIED: GenSearchRequest.SearchFilter._DocFormat.ValueType  # 0
            DOC_FORMAT_PDF: GenSearchRequest.SearchFilter._DocFormat.ValueType  # 1
            DOC_FORMAT_XLS: GenSearchRequest.SearchFilter._DocFormat.ValueType  # 2
            DOC_FORMAT_ODS: GenSearchRequest.SearchFilter._DocFormat.ValueType  # 3
            DOC_FORMAT_RTF: GenSearchRequest.SearchFilter._DocFormat.ValueType  # 4
            DOC_FORMAT_PPT: GenSearchRequest.SearchFilter._DocFormat.ValueType  # 5
            DOC_FORMAT_ODP: GenSearchRequest.SearchFilter._DocFormat.ValueType  # 6
            DOC_FORMAT_SWF: GenSearchRequest.SearchFilter._DocFormat.ValueType  # 7
            DOC_FORMAT_ODT: GenSearchRequest.SearchFilter._DocFormat.ValueType  # 8
            DOC_FORMAT_ODG: GenSearchRequest.SearchFilter._DocFormat.ValueType  # 9
            DOC_FORMAT_DOC: GenSearchRequest.SearchFilter._DocFormat.ValueType  # 10

        class DocFormat(_DocFormat, metaclass=_DocFormatEnumTypeWrapper): ...
        DOC_FORMAT_UNSPECIFIED: GenSearchRequest.SearchFilter.DocFormat.ValueType  # 0
        DOC_FORMAT_PDF: GenSearchRequest.SearchFilter.DocFormat.ValueType  # 1
        DOC_FORMAT_XLS: GenSearchRequest.SearchFilter.DocFormat.ValueType  # 2
        DOC_FORMAT_ODS: GenSearchRequest.SearchFilter.DocFormat.ValueType  # 3
        DOC_FORMAT_RTF: GenSearchRequest.SearchFilter.DocFormat.ValueType  # 4
        DOC_FORMAT_PPT: GenSearchRequest.SearchFilter.DocFormat.ValueType  # 5
        DOC_FORMAT_ODP: GenSearchRequest.SearchFilter.DocFormat.ValueType  # 6
        DOC_FORMAT_SWF: GenSearchRequest.SearchFilter.DocFormat.ValueType  # 7
        DOC_FORMAT_ODT: GenSearchRequest.SearchFilter.DocFormat.ValueType  # 8
        DOC_FORMAT_ODG: GenSearchRequest.SearchFilter.DocFormat.ValueType  # 9
        DOC_FORMAT_DOC: GenSearchRequest.SearchFilter.DocFormat.ValueType  # 10

        DATE_FIELD_NUMBER: builtins.int
        LANG_FIELD_NUMBER: builtins.int
        FORMAT_FIELD_NUMBER: builtins.int
        date: builtins.str
        """Restrict by document date. See https://yandex.ru/support/search/ru/query-language/search-operators details."""
        lang: builtins.str
        """Restrict by document language. Use ISO 639-1 language codes."""
        format: global___GenSearchRequest.SearchFilter.DocFormat.ValueType
        """Restrict by document format."""
        def __init__(
            self,
            *,
            date: builtins.str = ...,
            lang: builtins.str = ...,
            format: global___GenSearchRequest.SearchFilter.DocFormat.ValueType = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["date", b"date", "filter_options", b"filter_options", "format", b"format", "lang", b"lang"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["date", b"date", "filter_options", b"filter_options", "format", b"format", "lang", b"lang"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["filter_options", b"filter_options"]) -> typing.Literal["date", "lang", "format"] | None: ...

    MESSAGES_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    SITE_FIELD_NUMBER: builtins.int
    HOST_FIELD_NUMBER: builtins.int
    URL_FIELD_NUMBER: builtins.int
    FIX_MISSPELL_FIELD_NUMBER: builtins.int
    ENABLE_NRFM_DOCS_FIELD_NUMBER: builtins.int
    SEARCH_FILTERS_FIELD_NUMBER: builtins.int
    SEARCH_TYPE_FIELD_NUMBER: builtins.int
    GET_PARTIAL_RESULTS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder."""
    fix_misspell: builtins.bool
    """Fix query misspells."""
    enable_nrfm_docs: builtins.bool
    """Use the documents inaccessible from the site's front page."""
    search_type: yandex.cloud.searchapi.v2.search_query_pb2.SearchQuery.SearchType.ValueType
    """Search type that determines the domain name that will be used for the search queries."""
    get_partial_results: builtins.bool
    """Get partial results"""
    @property
    def messages(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GenSearchMessage]:
        """Single search query or a search query with context in the form of chat with the model."""

    @property
    def site(self) -> global___GenSearchRequest.SiteOption: ...
    @property
    def host(self) -> global___GenSearchRequest.HostOption: ...
    @property
    def url(self) -> global___GenSearchRequest.UrlOption: ...
    @property
    def search_filters(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GenSearchRequest.SearchFilter]:
        """Restricts the search by date, document formats or language."""

    @property
    def metadata(self) -> yandex.cloud.searchapi.v2.search_query_pb2.SearchMetadata:
        """Search flags"""

    def __init__(
        self,
        *,
        messages: collections.abc.Iterable[global___GenSearchMessage] | None = ...,
        folder_id: builtins.str = ...,
        site: global___GenSearchRequest.SiteOption | None = ...,
        host: global___GenSearchRequest.HostOption | None = ...,
        url: global___GenSearchRequest.UrlOption | None = ...,
        fix_misspell: builtins.bool = ...,
        enable_nrfm_docs: builtins.bool = ...,
        search_filters: collections.abc.Iterable[global___GenSearchRequest.SearchFilter] | None = ...,
        search_type: yandex.cloud.searchapi.v2.search_query_pb2.SearchQuery.SearchType.ValueType = ...,
        get_partial_results: builtins.bool = ...,
        metadata: yandex.cloud.searchapi.v2.search_query_pb2.SearchMetadata | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["host", b"host", "metadata", b"metadata", "site", b"site", "site_options", b"site_options", "url", b"url"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["enable_nrfm_docs", b"enable_nrfm_docs", "fix_misspell", b"fix_misspell", "folder_id", b"folder_id", "get_partial_results", b"get_partial_results", "host", b"host", "messages", b"messages", "metadata", b"metadata", "search_filters", b"search_filters", "search_type", b"search_type", "site", b"site", "site_options", b"site_options", "url", b"url"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["site_options", b"site_options"]) -> typing.Literal["site", "host", "url"] | None: ...

global___GenSearchRequest = GenSearchRequest

@typing.final
class GenSearchResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class Source(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        URL_FIELD_NUMBER: builtins.int
        TITLE_FIELD_NUMBER: builtins.int
        USED_FIELD_NUMBER: builtins.int
        url: builtins.str
        """Document URL."""
        title: builtins.str
        """Document title."""
        used: builtins.bool
        """The document was used in the answer."""
        def __init__(
            self,
            *,
            url: builtins.str = ...,
            title: builtins.str = ...,
            used: builtins.bool = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["title", b"title", "url", b"url", "used", b"used"]) -> None: ...

    @typing.final
    class SearchQuery(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TEXT_FIELD_NUMBER: builtins.int
        REQ_ID_FIELD_NUMBER: builtins.int
        text: builtins.str
        """Query text."""
        req_id: builtins.str
        """Query ID in Yandex Search."""
        def __init__(
            self,
            *,
            text: builtins.str = ...,
            req_id: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["req_id", b"req_id", "text", b"text"]) -> None: ...

    MESSAGE_FIELD_NUMBER: builtins.int
    SOURCES_FIELD_NUMBER: builtins.int
    SEARCH_QUERIES_FIELD_NUMBER: builtins.int
    FIXED_MISSPELL_QUERY_FIELD_NUMBER: builtins.int
    IS_ANSWER_REJECTED_FIELD_NUMBER: builtins.int
    IS_BULLET_ANSWER_FIELD_NUMBER: builtins.int
    HINTS_FIELD_NUMBER: builtins.int
    PROBLEMATIC_ANSWER_FIELD_NUMBER: builtins.int
    fixed_misspell_query: builtins.str
    """The text of the search query with fixed misspells."""
    is_answer_rejected: builtins.bool
    """The model failed to answer due to the ethical concerns."""
    is_bullet_answer: builtins.bool
    """A bullet answer in case the model cannot give a proper response and returns a set of bullets with various data."""
    problematic_answer: builtins.bool
    """The answer may contain inappropriate content"""
    @property
    def message(self) -> global___GenSearchMessage:
        """The text of the generative response."""

    @property
    def sources(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GenSearchResponse.Source]:
        """The documents used to form the generative response."""

    @property
    def search_queries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___GenSearchResponse.SearchQuery]:
        """The search queries, refined by the YandexGPT model and used for the generative response."""

    @property
    def hints(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Search hints"""

    def __init__(
        self,
        *,
        message: global___GenSearchMessage | None = ...,
        sources: collections.abc.Iterable[global___GenSearchResponse.Source] | None = ...,
        search_queries: collections.abc.Iterable[global___GenSearchResponse.SearchQuery] | None = ...,
        fixed_misspell_query: builtins.str = ...,
        is_answer_rejected: builtins.bool = ...,
        is_bullet_answer: builtins.bool = ...,
        hints: collections.abc.Iterable[builtins.str] | None = ...,
        problematic_answer: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["message", b"message"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["fixed_misspell_query", b"fixed_misspell_query", "hints", b"hints", "is_answer_rejected", b"is_answer_rejected", "is_bullet_answer", b"is_bullet_answer", "message", b"message", "problematic_answer", b"problematic_answer", "search_queries", b"search_queries", "sources", b"sources"]) -> None: ...

global___GenSearchResponse = GenSearchResponse
