"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing
import yandex.cloud.searchapi.v2.search_query_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class ImageSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ImageFormat:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ImageFormatEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ImageSpec._ImageFormat.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        IMAGE_FORMAT_UNSPECIFIED: ImageSpec._ImageFormat.ValueType  # 0
        IMAGE_FORMAT_JPEG: ImageSpec._ImageFormat.ValueType  # 1
        """JPG format."""
        IMAGE_FORMAT_GIF: ImageSpec._ImageFormat.ValueType  # 2
        """GIF format."""
        IMAGE_FORMAT_PNG: ImageSpec._ImageFormat.ValueType  # 3
        """PNG format."""

    class ImageFormat(_ImageFormat, metaclass=_ImageFormatEnumTypeWrapper): ...
    IMAGE_FORMAT_UNSPECIFIED: ImageSpec.ImageFormat.ValueType  # 0
    IMAGE_FORMAT_JPEG: ImageSpec.ImageFormat.ValueType  # 1
    """JPG format."""
    IMAGE_FORMAT_GIF: ImageSpec.ImageFormat.ValueType  # 2
    """GIF format."""
    IMAGE_FORMAT_PNG: ImageSpec.ImageFormat.ValueType  # 3
    """PNG format."""

    class _ImageOrientation:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ImageOrientationEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ImageSpec._ImageOrientation.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        IMAGE_ORIENTATION_UNSPECIFIED: ImageSpec._ImageOrientation.ValueType  # 0
        IMAGE_ORIENTATION_VERTICAL: ImageSpec._ImageOrientation.ValueType  # 1
        """Horizontal orientation."""
        IMAGE_ORIENTATION_HORIZONTAL: ImageSpec._ImageOrientation.ValueType  # 2
        """Vertical orientation."""
        IMAGE_ORIENTATION_SQUARE: ImageSpec._ImageOrientation.ValueType  # 3
        """Square aspect ratio."""

    class ImageOrientation(_ImageOrientation, metaclass=_ImageOrientationEnumTypeWrapper): ...
    IMAGE_ORIENTATION_UNSPECIFIED: ImageSpec.ImageOrientation.ValueType  # 0
    IMAGE_ORIENTATION_VERTICAL: ImageSpec.ImageOrientation.ValueType  # 1
    """Horizontal orientation."""
    IMAGE_ORIENTATION_HORIZONTAL: ImageSpec.ImageOrientation.ValueType  # 2
    """Vertical orientation."""
    IMAGE_ORIENTATION_SQUARE: ImageSpec.ImageOrientation.ValueType  # 3
    """Square aspect ratio."""

    class _ImageSize:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ImageSizeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ImageSpec._ImageSize.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        IMAGE_SIZE_UNSPECIFIED: ImageSpec._ImageSize.ValueType  # 0
        IMAGE_SIZE_ENORMOUS: ImageSpec._ImageSize.ValueType  # 1
        """Very large images (larger than 1,600 × 1,200 pixels)."""
        IMAGE_SIZE_LARGE: ImageSpec._ImageSize.ValueType  # 2
        """Large images (from 800 × 600 to 1,600 × 1,200 pixels)."""
        IMAGE_SIZE_MEDIUM: ImageSpec._ImageSize.ValueType  # 3
        """Medium images (from 150 × 150 to 800 × 600 pixels)."""
        IMAGE_SIZE_SMALL: ImageSpec._ImageSize.ValueType  # 4
        """Small images (from 32 × 32 to 150 × 150 pixels)."""
        IMAGE_SIZE_TINY: ImageSpec._ImageSize.ValueType  # 5
        """Icons (up to 32 × 32 pixels)."""
        IMAGE_SIZE_WALLPAPER: ImageSpec._ImageSize.ValueType  # 6
        """Desktop wallpapers."""

    class ImageSize(_ImageSize, metaclass=_ImageSizeEnumTypeWrapper): ...
    IMAGE_SIZE_UNSPECIFIED: ImageSpec.ImageSize.ValueType  # 0
    IMAGE_SIZE_ENORMOUS: ImageSpec.ImageSize.ValueType  # 1
    """Very large images (larger than 1,600 × 1,200 pixels)."""
    IMAGE_SIZE_LARGE: ImageSpec.ImageSize.ValueType  # 2
    """Large images (from 800 × 600 to 1,600 × 1,200 pixels)."""
    IMAGE_SIZE_MEDIUM: ImageSpec.ImageSize.ValueType  # 3
    """Medium images (from 150 × 150 to 800 × 600 pixels)."""
    IMAGE_SIZE_SMALL: ImageSpec.ImageSize.ValueType  # 4
    """Small images (from 32 × 32 to 150 × 150 pixels)."""
    IMAGE_SIZE_TINY: ImageSpec.ImageSize.ValueType  # 5
    """Icons (up to 32 × 32 pixels)."""
    IMAGE_SIZE_WALLPAPER: ImageSpec.ImageSize.ValueType  # 6
    """Desktop wallpapers."""

    class _ImageColor:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ImageColorEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ImageSpec._ImageColor.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        IMAGE_COLOR_UNSPECIFIED: ImageSpec._ImageColor.ValueType  # 0
        IMAGE_COLOR_COLOR: ImageSpec._ImageColor.ValueType  # 1
        """Color images."""
        IMAGE_COLOR_GRAYSCALE: ImageSpec._ImageColor.ValueType  # 2
        """Black and white images."""
        IMAGE_COLOR_RED: ImageSpec._ImageColor.ValueType  # 3
        """Red is the main color of the image."""
        IMAGE_COLOR_ORANGE: ImageSpec._ImageColor.ValueType  # 4
        """Orange is the main color of the image."""
        IMAGE_COLOR_YELLOW: ImageSpec._ImageColor.ValueType  # 5
        """Yellow is the main color of the image."""
        IMAGE_COLOR_GREEN: ImageSpec._ImageColor.ValueType  # 6
        """Green is the main color of the image."""
        IMAGE_COLOR_CYAN: ImageSpec._ImageColor.ValueType  # 7
        """Cyan is the main color of the image."""
        IMAGE_COLOR_BLUE: ImageSpec._ImageColor.ValueType  # 8
        """Blue is the main color of the image."""
        IMAGE_COLOR_VIOLET: ImageSpec._ImageColor.ValueType  # 9
        """Violet is the main color of the image."""
        IMAGE_COLOR_WHITE: ImageSpec._ImageColor.ValueType  # 10
        """White is the main color of the image."""
        IMAGE_COLOR_BLACK: ImageSpec._ImageColor.ValueType  # 11
        """Black is the main color of the image."""

    class ImageColor(_ImageColor, metaclass=_ImageColorEnumTypeWrapper): ...
    IMAGE_COLOR_UNSPECIFIED: ImageSpec.ImageColor.ValueType  # 0
    IMAGE_COLOR_COLOR: ImageSpec.ImageColor.ValueType  # 1
    """Color images."""
    IMAGE_COLOR_GRAYSCALE: ImageSpec.ImageColor.ValueType  # 2
    """Black and white images."""
    IMAGE_COLOR_RED: ImageSpec.ImageColor.ValueType  # 3
    """Red is the main color of the image."""
    IMAGE_COLOR_ORANGE: ImageSpec.ImageColor.ValueType  # 4
    """Orange is the main color of the image."""
    IMAGE_COLOR_YELLOW: ImageSpec.ImageColor.ValueType  # 5
    """Yellow is the main color of the image."""
    IMAGE_COLOR_GREEN: ImageSpec.ImageColor.ValueType  # 6
    """Green is the main color of the image."""
    IMAGE_COLOR_CYAN: ImageSpec.ImageColor.ValueType  # 7
    """Cyan is the main color of the image."""
    IMAGE_COLOR_BLUE: ImageSpec.ImageColor.ValueType  # 8
    """Blue is the main color of the image."""
    IMAGE_COLOR_VIOLET: ImageSpec.ImageColor.ValueType  # 9
    """Violet is the main color of the image."""
    IMAGE_COLOR_WHITE: ImageSpec.ImageColor.ValueType  # 10
    """White is the main color of the image."""
    IMAGE_COLOR_BLACK: ImageSpec.ImageColor.ValueType  # 11
    """Black is the main color of the image."""

    FORMAT_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    ORIENTATION_FIELD_NUMBER: builtins.int
    COLOR_FIELD_NUMBER: builtins.int
    format: global___ImageSpec.ImageFormat.ValueType
    """Searching for images in a particular format."""
    size: global___ImageSpec.ImageSize.ValueType
    """Searching for images of a particular size."""
    orientation: global___ImageSpec.ImageOrientation.ValueType
    """Searching for images with a particular orientation."""
    color: global___ImageSpec.ImageColor.ValueType
    """Searching for images containing a particular color."""
    def __init__(
        self,
        *,
        format: global___ImageSpec.ImageFormat.ValueType = ...,
        size: global___ImageSpec.ImageSize.ValueType = ...,
        orientation: global___ImageSpec.ImageOrientation.ValueType = ...,
        color: global___ImageSpec.ImageColor.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["color", b"color", "format", b"format", "orientation", b"orientation", "size", b"size"]) -> None: ...

global___ImageSpec = ImageSpec

@typing.final
class ImageSearchRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    QUERY_FIELD_NUMBER: builtins.int
    IMAGE_SPEC_FIELD_NUMBER: builtins.int
    SITE_FIELD_NUMBER: builtins.int
    DOCS_ON_PAGE_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    USER_AGENT_FIELD_NUMBER: builtins.int
    site: builtins.str
    """Searching for images on a particular website only."""
    docs_on_page: builtins.int
    """Number of results per search result page."""
    folder_id: builtins.str
    """ID of the folder."""
    user_agent: builtins.str
    """User-Agent request header value."""
    @property
    def query(self) -> yandex.cloud.searchapi.v2.search_query_pb2.SearchQuery:
        """Search query."""

    @property
    def image_spec(self) -> global___ImageSpec:
        """Searching for images with a particular size, orientation, format or color."""

    def __init__(
        self,
        *,
        query: yandex.cloud.searchapi.v2.search_query_pb2.SearchQuery | None = ...,
        image_spec: global___ImageSpec | None = ...,
        site: builtins.str = ...,
        docs_on_page: builtins.int = ...,
        folder_id: builtins.str = ...,
        user_agent: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["image_spec", b"image_spec", "query", b"query"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["docs_on_page", b"docs_on_page", "folder_id", b"folder_id", "image_spec", b"image_spec", "query", b"query", "site", b"site", "user_agent", b"user_agent"]) -> None: ...

global___ImageSearchRequest = ImageSearchRequest

@typing.final
class ImageSearchResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RAW_DATA_FIELD_NUMBER: builtins.int
    raw_data: builtins.bytes
    """Search results in XML format."""
    def __init__(
        self,
        *,
        raw_data: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["raw_data", b"raw_data"]) -> None: ...

global___ImageSearchResponse = ImageSearchResponse

@typing.final
class ImageSearchByImageRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SITE_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    URL_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    PAGE_FIELD_NUMBER: builtins.int
    FAMILY_MODE_FIELD_NUMBER: builtins.int
    site: builtins.str
    """Restricts the search to the specific website."""
    folder_id: builtins.str
    """ID of the folder."""
    url: builtins.str
    """The image url to use for the search."""
    data: builtins.bytes
    """The image data to use for the search."""
    id: builtins.str
    """CBIR ID of the image to use for the search."""
    page: builtins.int
    """The number of a requested page with search results."""
    family_mode: yandex.cloud.searchapi.v2.search_query_pb2.SearchQuery.FamilyMode.ValueType
    """Rule for filtering search results and determines whether any documents should be excluded."""
    def __init__(
        self,
        *,
        site: builtins.str = ...,
        folder_id: builtins.str = ...,
        url: builtins.str = ...,
        data: builtins.bytes = ...,
        id: builtins.str = ...,
        page: builtins.int = ...,
        family_mode: yandex.cloud.searchapi.v2.search_query_pb2.SearchQuery.FamilyMode.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["data", b"data", "id", b"id", "image", b"image", "url", b"url"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["data", b"data", "family_mode", b"family_mode", "folder_id", b"folder_id", "id", b"id", "image", b"image", "page", b"page", "site", b"site", "url", b"url"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["image", b"image"]) -> typing.Literal["url", "data", "id"] | None: ...

global___ImageSearchByImageRequest = ImageSearchByImageRequest

@typing.final
class ImageSearchByImageResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class ImageInfo(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        URL_FIELD_NUMBER: builtins.int
        FORMAT_FIELD_NUMBER: builtins.int
        WIDTH_FIELD_NUMBER: builtins.int
        HEIGHT_FIELD_NUMBER: builtins.int
        PASSAGE_FIELD_NUMBER: builtins.int
        HOST_FIELD_NUMBER: builtins.int
        PAGE_TITLE_FIELD_NUMBER: builtins.int
        PAGE_URL_FIELD_NUMBER: builtins.int
        url: builtins.str
        """Image URL."""
        format: global___ImageSpec.ImageFormat.ValueType
        """Image format."""
        width: builtins.int
        """Image width."""
        height: builtins.int
        """Image height."""
        passage: builtins.str
        """Text passage."""
        host: builtins.str
        """Document host."""
        page_title: builtins.str
        """Document title."""
        page_url: builtins.str
        """Document URL."""
        def __init__(
            self,
            *,
            url: builtins.str = ...,
            format: global___ImageSpec.ImageFormat.ValueType = ...,
            width: builtins.int = ...,
            height: builtins.int = ...,
            passage: builtins.str = ...,
            host: builtins.str = ...,
            page_title: builtins.str = ...,
            page_url: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["format", b"format", "height", b"height", "host", b"host", "page_title", b"page_title", "page_url", b"page_url", "passage", b"passage", "url", b"url", "width", b"width"]) -> None: ...

    IMAGES_FIELD_NUMBER: builtins.int
    PAGE_FIELD_NUMBER: builtins.int
    MAX_PAGE_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    page: builtins.int
    """The number of the page with search results."""
    max_page: builtins.int
    id: builtins.str
    """CBIR ID of the image used for the search."""
    @property
    def images(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ImageSearchByImageResponse.ImageInfo]:
        """The images found."""

    def __init__(
        self,
        *,
        images: collections.abc.Iterable[global___ImageSearchByImageResponse.ImageInfo] | None = ...,
        page: builtins.int = ...,
        max_page: builtins.int = ...,
        id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["id", b"id", "images", b"images", "max_page", b"max_page", "page", b"page"]) -> None: ...

global___ImageSearchByImageResponse = ImageSearchByImageResponse
