"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing
import yandex.cloud.logging.v1.log_entry_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class ApiGateway(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ApiGateway._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: ApiGateway._Status.ValueType  # 0
        CREATING: ApiGateway._Status.ValueType  # 1
        """API gateway is being created."""
        ACTIVE: ApiGateway._Status.ValueType  # 2
        """API gateway is ready for use."""
        DELETING: ApiGateway._Status.ValueType  # 3
        """API gateway is being deleted."""
        ERROR: ApiGateway._Status.ValueType  # 4
        """API gateway failed. The only allowed action is delete."""
        UPDATING: ApiGateway._Status.ValueType  # 5
        """API gateway is being updated."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNSPECIFIED: ApiGateway.Status.ValueType  # 0
    CREATING: ApiGateway.Status.ValueType  # 1
    """API gateway is being created."""
    ACTIVE: ApiGateway.Status.ValueType  # 2
    """API gateway is ready for use."""
    DELETING: ApiGateway.Status.ValueType  # 3
    """API gateway is being deleted."""
    ERROR: ApiGateway.Status.ValueType  # 4
    """API gateway failed. The only allowed action is delete."""
    UPDATING: ApiGateway.Status.ValueType  # 5
    """API gateway is being updated."""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing.final
    class VariablesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___VariableInput: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___VariableInput | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    DOMAIN_FIELD_NUMBER: builtins.int
    LOG_GROUP_ID_FIELD_NUMBER: builtins.int
    ATTACHED_DOMAINS_FIELD_NUMBER: builtins.int
    CONNECTIVITY_FIELD_NUMBER: builtins.int
    LOG_OPTIONS_FIELD_NUMBER: builtins.int
    VARIABLES_FIELD_NUMBER: builtins.int
    CANARY_FIELD_NUMBER: builtins.int
    EXECUTION_TIMEOUT_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the API gateway. Generated at creation time."""
    folder_id: builtins.str
    """ID of the folder that the API gateway belongs to."""
    name: builtins.str
    """Name of the API gateway. The name is unique within the folder."""
    description: builtins.str
    """Description of the API gateway."""
    status: global___ApiGateway.Status.ValueType
    """Status of the API gateway."""
    domain: builtins.str
    """Default domain for the API gateway. Generated at creation time."""
    log_group_id: builtins.str
    """ID of the log group for the API gateway."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp for the API-gateway."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """API gateway labels as `key:value` pairs."""

    @property
    def attached_domains(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___AttachedDomain]:
        """List of domains attached to API gateway."""

    @property
    def connectivity(self) -> global___Connectivity:
        """Network access. If specified the gateway will be attached to specified network/subnet(s)."""

    @property
    def log_options(self) -> global___LogOptions:
        """Options for logging from the API gateway."""

    @property
    def variables(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___VariableInput]:
        """Values of variables defined in the specification."""

    @property
    def canary(self) -> global___Canary:
        """Canary release of the gateway."""

    @property
    def execution_timeout(self) -> google.protobuf.duration_pb2.Duration:
        """Timeout for gateway call execution"""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        status: global___ApiGateway.Status.ValueType = ...,
        domain: builtins.str = ...,
        log_group_id: builtins.str = ...,
        attached_domains: collections.abc.Iterable[global___AttachedDomain] | None = ...,
        connectivity: global___Connectivity | None = ...,
        log_options: global___LogOptions | None = ...,
        variables: collections.abc.Mapping[builtins.str, global___VariableInput] | None = ...,
        canary: global___Canary | None = ...,
        execution_timeout: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["canary", b"canary", "connectivity", b"connectivity", "created_at", b"created_at", "execution_timeout", b"execution_timeout", "log_options", b"log_options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["attached_domains", b"attached_domains", "canary", b"canary", "connectivity", b"connectivity", "created_at", b"created_at", "description", b"description", "domain", b"domain", "execution_timeout", b"execution_timeout", "folder_id", b"folder_id", "id", b"id", "labels", b"labels", "log_group_id", b"log_group_id", "log_options", b"log_options", "name", b"name", "status", b"status", "variables", b"variables"]) -> None: ...

global___ApiGateway = ApiGateway

@typing.final
class AttachedDomain(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DOMAIN_ID_FIELD_NUMBER: builtins.int
    CERTIFICATE_ID_FIELD_NUMBER: builtins.int
    ENABLED_FIELD_NUMBER: builtins.int
    DOMAIN_FIELD_NUMBER: builtins.int
    domain_id: builtins.str
    """ID of the domain."""
    certificate_id: builtins.str
    """ID of the domain certificate."""
    enabled: builtins.bool
    """Enabling flag."""
    domain: builtins.str
    """Name of the domain."""
    def __init__(
        self,
        *,
        domain_id: builtins.str = ...,
        certificate_id: builtins.str = ...,
        enabled: builtins.bool = ...,
        domain: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["certificate_id", b"certificate_id", "domain", b"domain", "domain_id", b"domain_id", "enabled", b"enabled"]) -> None: ...

global___AttachedDomain = AttachedDomain

@typing.final
class Connectivity(google.protobuf.message.Message):
    """Gateway connectivity specification."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NETWORK_ID_FIELD_NUMBER: builtins.int
    SUBNET_ID_FIELD_NUMBER: builtins.int
    network_id: builtins.str
    """Network the gateway will have access to.
    It's essential to specify network with subnets in all availability zones.
    """
    @property
    def subnet_id(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Complete list of subnets (from the same network) the gateway can be attached to.
        It's essential to specify at least one subnet for each availability zones.
        """

    def __init__(
        self,
        *,
        network_id: builtins.str = ...,
        subnet_id: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["network_id", b"network_id", "subnet_id", b"subnet_id"]) -> None: ...

global___Connectivity = Connectivity

@typing.final
class LogOptions(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DISABLED_FIELD_NUMBER: builtins.int
    LOG_GROUP_ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    MIN_LEVEL_FIELD_NUMBER: builtins.int
    disabled: builtins.bool
    """Is logging from API gateway disabled."""
    log_group_id: builtins.str
    """Entry should be written to log group resolved by ID."""
    folder_id: builtins.str
    """Entry should be written to default log group for specified folder."""
    min_level: yandex.cloud.logging.v1.log_entry_pb2.LogLevel.Level.ValueType
    """Minimum log entry level.

    See [LogLevel.Level] for details.
    """
    def __init__(
        self,
        *,
        disabled: builtins.bool = ...,
        log_group_id: builtins.str = ...,
        folder_id: builtins.str = ...,
        min_level: yandex.cloud.logging.v1.log_entry_pb2.LogLevel.Level.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["destination", b"destination", "folder_id", b"folder_id", "log_group_id", b"log_group_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["destination", b"destination", "disabled", b"disabled", "folder_id", b"folder_id", "log_group_id", b"log_group_id", "min_level", b"min_level"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["destination", b"destination"]) -> typing.Literal["log_group_id", "folder_id"] | None: ...

global___LogOptions = LogOptions

@typing.final
class Canary(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class VariablesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___VariableInput: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: global___VariableInput | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    WEIGHT_FIELD_NUMBER: builtins.int
    VARIABLES_FIELD_NUMBER: builtins.int
    weight: builtins.int
    """It describes percentage of requests, which will be processed by canary."""
    @property
    def variables(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___VariableInput]:
        """Values specification variables, associated with canary."""

    def __init__(
        self,
        *,
        weight: builtins.int = ...,
        variables: collections.abc.Mapping[builtins.str, global___VariableInput] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["variables", b"variables", "weight", b"weight"]) -> None: ...

global___Canary = Canary

@typing.final
class VariableInput(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STRING_VALUE_FIELD_NUMBER: builtins.int
    INT_VALUE_FIELD_NUMBER: builtins.int
    DOUBLE_VALUE_FIELD_NUMBER: builtins.int
    BOOL_VALUE_FIELD_NUMBER: builtins.int
    string_value: builtins.str
    int_value: builtins.int
    double_value: builtins.float
    bool_value: builtins.bool
    def __init__(
        self,
        *,
        string_value: builtins.str = ...,
        int_value: builtins.int = ...,
        double_value: builtins.float = ...,
        bool_value: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["bool_value", b"bool_value", "double_value", b"double_value", "int_value", b"int_value", "string_value", b"string_value", "variable_value", b"variable_value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["bool_value", b"bool_value", "double_value", b"double_value", "int_value", b"int_value", "string_value", b"string_value", "variable_value", b"variable_value"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["variable_value", b"variable_value"]) -> typing.Literal["string_value", "int_value", "double_value", "bool_value"] | None: ...

global___VariableInput = VariableInput
