"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Rule(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Rule._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: Rule._Status.ValueType  # 0
        CREATING: Rule._Status.ValueType  # 1
        """Rule creation in progress, rule is not enabled yet"""
        ENABLED: Rule._Status.ValueType  # 2
        """Rule is operating"""
        UPDATING: Rule._Status.ValueType  # 3
        """Rule update in progress, rule is disabled during update"""
        DISABLED: Rule._Status.ValueType  # 4
        """Rule is explicitly disabled by the user"""
        DELETING: Rule._Status.ValueType  # 5
        """Rule deletion in progress"""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNSPECIFIED: Rule.Status.ValueType  # 0
    CREATING: Rule.Status.ValueType  # 1
    """Rule creation in progress, rule is not enabled yet"""
    ENABLED: Rule.Status.ValueType  # 2
    """Rule is operating"""
    UPDATING: Rule.Status.ValueType  # 3
    """Rule update in progress, rule is disabled during update"""
    DISABLED: Rule.Status.ValueType  # 4
    """Rule is explicitly disabled by the user"""
    DELETING: Rule.Status.ValueType  # 5
    """Rule deletion in progress"""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    BUS_ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    CLOUD_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    TARGETS_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the rule."""
    bus_id: builtins.str
    """ID of the bus that the rule belongs to."""
    folder_id: builtins.str
    """ID of the folder that the rule resides in."""
    cloud_id: builtins.str
    """ID of the cloud that the rule resides in."""
    name: builtins.str
    """Name of the rule."""
    description: builtins.str
    """Description of the rule."""
    deletion_protection: builtins.bool
    """Flag that disallow deletion of the rule."""
    status: global___Rule.Status.ValueType
    """Rule status"""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Resource labels as `key:value` pairs."""

    @property
    def filter(self) -> global___Filter:
        """Filter for the rule."""

    @property
    def targets(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Target]:
        """Targets of the rule."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        bus_id: builtins.str = ...,
        folder_id: builtins.str = ...,
        cloud_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        filter: global___Filter | None = ...,
        targets: collections.abc.Iterable[global___Target] | None = ...,
        deletion_protection: builtins.bool = ...,
        status: global___Rule.Status.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "filter", b"filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["bus_id", b"bus_id", "cloud_id", b"cloud_id", "created_at", b"created_at", "deletion_protection", b"deletion_protection", "description", b"description", "filter", b"filter", "folder_id", b"folder_id", "id", b"id", "labels", b"labels", "name", b"name", "status", b"status", "targets", b"targets"]) -> None: ...

global___Rule = Rule

@typing.final
class Filter(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    JQ_FILTER_FIELD_NUMBER: builtins.int
    jq_filter: builtins.str
    """JQ filter for matching events."""
    def __init__(
        self,
        *,
        jq_filter: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["condition", b"condition", "jq_filter", b"jq_filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["condition", b"condition", "jq_filter", b"jq_filter"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["condition", b"condition"]) -> typing.Literal["jq_filter"] | None: ...

global___Filter = Filter

@typing.final
class Transformer(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    JQ_TRANSFORMER_FIELD_NUMBER: builtins.int
    jq_transformer: builtins.str
    """JQ string inrerpolation expression for changing event format."""
    def __init__(
        self,
        *,
        jq_transformer: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["jq_transformer", b"jq_transformer", "transformer", b"transformer"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["jq_transformer", b"jq_transformer", "transformer", b"transformer"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["transformer", b"transformer"]) -> typing.Literal["jq_transformer"] | None: ...

global___Transformer = Transformer

@typing.final
class Target(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Target._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: Target._Status.ValueType  # 0
        ENABLED: Target._Status.ValueType  # 1
        """Target is enabled."""
        DISABLED: Target._Status.ValueType  # 2
        """Target is disabled."""
        RESOURCE_NOT_FOUND: Target._Status.ValueType  # 3
        """Target does not exist."""
        PERMISSION_DENIED: Target._Status.ValueType  # 4
        """Service account does not have read permission on source."""
        SUBJECT_NOT_FOUND: Target._Status.ValueType  # 5
        """Service account not found."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper):
        """Status of the target."""

    STATUS_UNSPECIFIED: Target.Status.ValueType  # 0
    ENABLED: Target.Status.ValueType  # 1
    """Target is enabled."""
    DISABLED: Target.Status.ValueType  # 2
    """Target is disabled."""
    RESOURCE_NOT_FOUND: Target.Status.ValueType  # 3
    """Target does not exist."""
    PERMISSION_DENIED: Target.Status.ValueType  # 4
    """Service account does not have read permission on source."""
    SUBJECT_NOT_FOUND: Target.Status.ValueType  # 5
    """Service account not found."""

    YDS_FIELD_NUMBER: builtins.int
    YMQ_FIELD_NUMBER: builtins.int
    FUNCTION_FIELD_NUMBER: builtins.int
    CONTAINER_FIELD_NUMBER: builtins.int
    GATEWAY_WS_BROADCAST_FIELD_NUMBER: builtins.int
    LOGGING_FIELD_NUMBER: builtins.int
    WORKFLOW_FIELD_NUMBER: builtins.int
    TRANSFORMER_FIELD_NUMBER: builtins.int
    RETRY_SETTINGS_FIELD_NUMBER: builtins.int
    DEAD_LETTER_QUEUE_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    status: global___Target.Status.ValueType
    """Status of the target."""
    @property
    def yds(self) -> global___YdsTarget: ...
    @property
    def ymq(self) -> global___YmqTarget: ...
    @property
    def function(self) -> global___FunctionTarget: ...
    @property
    def container(self) -> global___ContainerTarget: ...
    @property
    def gateway_ws_broadcast(self) -> global___GatewayWebsocketBroadcastTarget: ...
    @property
    def logging(self) -> global___LoggingTarget: ...
    @property
    def workflow(self) -> global___WorkflowTarget: ...
    @property
    def transformer(self) -> global___Transformer:
        """Transformer of the target."""

    @property
    def retry_settings(self) -> global___RetrySettings:
        """Retry settings of the target."""

    @property
    def dead_letter_queue(self) -> global___PutQueueMessage:
        """Dead letter queue."""

    def __init__(
        self,
        *,
        yds: global___YdsTarget | None = ...,
        ymq: global___YmqTarget | None = ...,
        function: global___FunctionTarget | None = ...,
        container: global___ContainerTarget | None = ...,
        gateway_ws_broadcast: global___GatewayWebsocketBroadcastTarget | None = ...,
        logging: global___LoggingTarget | None = ...,
        workflow: global___WorkflowTarget | None = ...,
        transformer: global___Transformer | None = ...,
        retry_settings: global___RetrySettings | None = ...,
        dead_letter_queue: global___PutQueueMessage | None = ...,
        status: global___Target.Status.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["container", b"container", "dead_letter", b"dead_letter", "dead_letter_queue", b"dead_letter_queue", "function", b"function", "gateway_ws_broadcast", b"gateway_ws_broadcast", "logging", b"logging", "retry_settings", b"retry_settings", "target", b"target", "transformer", b"transformer", "workflow", b"workflow", "yds", b"yds", "ymq", b"ymq"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["container", b"container", "dead_letter", b"dead_letter", "dead_letter_queue", b"dead_letter_queue", "function", b"function", "gateway_ws_broadcast", b"gateway_ws_broadcast", "logging", b"logging", "retry_settings", b"retry_settings", "status", b"status", "target", b"target", "transformer", b"transformer", "workflow", b"workflow", "yds", b"yds", "ymq", b"ymq"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["dead_letter", b"dead_letter"]) -> typing.Literal["dead_letter_queue"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["target", b"target"]) -> typing.Literal["yds", "ymq", "function", "container", "gateway_ws_broadcast", "logging", "workflow"] | None: ...

global___Target = Target

@typing.final
class YdsTarget(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATABASE_FIELD_NUMBER: builtins.int
    STREAM_NAME_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    database: builtins.str
    """Stream database."""
    stream_name: builtins.str
    """Full stream name, like /ru-central1/aoegtvhtp8ob********/cc8004q4lbo6********/test."""
    service_account_id: builtins.str
    """Service account, which has write permission on the stream."""
    def __init__(
        self,
        *,
        database: builtins.str = ...,
        stream_name: builtins.str = ...,
        service_account_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["database", b"database", "service_account_id", b"service_account_id", "stream_name", b"stream_name"]) -> None: ...

global___YdsTarget = YdsTarget

@typing.final
class YmqTarget(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    QUEUE_ARN_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    queue_arn: builtins.str
    """Queue ARN.
    Example: yrn:yc:ymq:ru-central1:aoe***:test
    """
    service_account_id: builtins.str
    """Service account which has write access to the queue."""
    def __init__(
        self,
        *,
        queue_arn: builtins.str = ...,
        service_account_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["queue_arn", b"queue_arn", "service_account_id", b"service_account_id"]) -> None: ...

global___YmqTarget = YmqTarget

@typing.final
class FunctionTarget(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FUNCTION_ID_FIELD_NUMBER: builtins.int
    FUNCTION_TAG_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    BATCH_SETTINGS_FIELD_NUMBER: builtins.int
    function_id: builtins.str
    """Function ID."""
    function_tag: builtins.str
    """Function tag, optional."""
    service_account_id: builtins.str
    """Service account which has call permission on the function, optional."""
    @property
    def batch_settings(self) -> global___BatchSettings:
        """Batch settings."""

    def __init__(
        self,
        *,
        function_id: builtins.str = ...,
        function_tag: builtins.str = ...,
        service_account_id: builtins.str = ...,
        batch_settings: global___BatchSettings | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["batch_settings", b"batch_settings"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["batch_settings", b"batch_settings", "function_id", b"function_id", "function_tag", b"function_tag", "service_account_id", b"service_account_id"]) -> None: ...

global___FunctionTarget = FunctionTarget

@typing.final
class ContainerTarget(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    CONTAINER_REVISION_ID_FIELD_NUMBER: builtins.int
    PATH_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    BATCH_SETTINGS_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """Container ID."""
    container_revision_id: builtins.str
    """Container revision ID."""
    path: builtins.str
    """Endpoint HTTP path to invoke."""
    service_account_id: builtins.str
    """Service account which should be used to call a container, optional."""
    @property
    def batch_settings(self) -> global___BatchSettings:
        """Batch settings."""

    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
        container_revision_id: builtins.str = ...,
        path: builtins.str = ...,
        service_account_id: builtins.str = ...,
        batch_settings: global___BatchSettings | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["batch_settings", b"batch_settings"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["batch_settings", b"batch_settings", "container_id", b"container_id", "container_revision_id", b"container_revision_id", "path", b"path", "service_account_id", b"service_account_id"]) -> None: ...

global___ContainerTarget = ContainerTarget

@typing.final
class GatewayWebsocketBroadcastTarget(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GATEWAY_ID_FIELD_NUMBER: builtins.int
    PATH_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    BATCH_SETTINGS_FIELD_NUMBER: builtins.int
    gateway_id: builtins.str
    """Gateway ID."""
    path: builtins.str
    """Path."""
    service_account_id: builtins.str
    """Service account which has permission for writing to websockets."""
    @property
    def batch_settings(self) -> global___BatchSettings:
        """Batch settings."""

    def __init__(
        self,
        *,
        gateway_id: builtins.str = ...,
        path: builtins.str = ...,
        service_account_id: builtins.str = ...,
        batch_settings: global___BatchSettings | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["batch_settings", b"batch_settings"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["batch_settings", b"batch_settings", "gateway_id", b"gateway_id", "path", b"path", "service_account_id", b"service_account_id"]) -> None: ...

global___GatewayWebsocketBroadcastTarget = GatewayWebsocketBroadcastTarget

@typing.final
class LoggingTarget(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOG_GROUP_ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    log_group_id: builtins.str
    folder_id: builtins.str
    service_account_id: builtins.str
    """Service account which has permission for writing logs."""
    def __init__(
        self,
        *,
        log_group_id: builtins.str = ...,
        folder_id: builtins.str = ...,
        service_account_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["destination", b"destination", "folder_id", b"folder_id", "log_group_id", b"log_group_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["destination", b"destination", "folder_id", b"folder_id", "log_group_id", b"log_group_id", "service_account_id", b"service_account_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["destination", b"destination"]) -> typing.Literal["log_group_id", "folder_id"] | None: ...

global___LoggingTarget = LoggingTarget

@typing.final
class WorkflowTarget(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WORKFLOW_ID_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    BATCH_SETTINGS_FIELD_NUMBER: builtins.int
    workflow_id: builtins.str
    """Workflow ID."""
    service_account_id: builtins.str
    """SA which should be used to start workflow."""
    @property
    def batch_settings(self) -> global___BatchSettings:
        """Batch settings."""

    def __init__(
        self,
        *,
        workflow_id: builtins.str = ...,
        service_account_id: builtins.str = ...,
        batch_settings: global___BatchSettings | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["batch_settings", b"batch_settings"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["batch_settings", b"batch_settings", "service_account_id", b"service_account_id", "workflow_id", b"workflow_id"]) -> None: ...

global___WorkflowTarget = WorkflowTarget

@typing.final
class RetrySettings(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RETRY_ATTEMPTS_FIELD_NUMBER: builtins.int
    MAXIMUM_AGE_FIELD_NUMBER: builtins.int
    retry_attempts: builtins.int
    """Maximum number of retries (extra calls) before an action fails."""
    @property
    def maximum_age(self) -> google.protobuf.duration_pb2.Duration:
        """Event goes to dlq when its age exceeds this value. Default is 24h."""

    def __init__(
        self,
        *,
        retry_attempts: builtins.int = ...,
        maximum_age: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["maximum_age", b"maximum_age"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["maximum_age", b"maximum_age", "retry_attempts", b"retry_attempts"]) -> None: ...

global___RetrySettings = RetrySettings

@typing.final
class PutQueueMessage(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    QUEUE_ARN_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    queue_arn: builtins.str
    """ID of the queue."""
    service_account_id: builtins.str
    """Service account which has write permission on the queue."""
    def __init__(
        self,
        *,
        queue_arn: builtins.str = ...,
        service_account_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["queue_arn", b"queue_arn", "service_account_id", b"service_account_id"]) -> None: ...

global___PutQueueMessage = PutQueueMessage

@typing.final
class BatchSettings(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MAX_COUNT_FIELD_NUMBER: builtins.int
    MAX_BYTES_FIELD_NUMBER: builtins.int
    CUTOFF_FIELD_NUMBER: builtins.int
    max_count: builtins.int
    """Maximum batch size: trigger will send a batch if number of events exceeds this value."""
    max_bytes: builtins.int
    """Maximum batch size: trigger will send a batch if total size of events exceeds this value."""
    @property
    def cutoff(self) -> google.protobuf.duration_pb2.Duration:
        """Maximum batch size: trigger will send a batch if its lifetime exceeds this value."""

    def __init__(
        self,
        *,
        max_count: builtins.int = ...,
        max_bytes: builtins.int = ...,
        cutoff: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["cutoff", b"cutoff"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cutoff", b"cutoff", "max_bytes", b"max_bytes", "max_count", b"max_count"]) -> None: ...

global___BatchSettings = BatchSettings
