"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing
import yandex.cloud.logging.v1.log_entry_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _HttpMethod:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _HttpMethodEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_HttpMethod.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    HTTP_METHOD_UNSPECIFIED: _HttpMethod.ValueType  # 0
    OPTIONS: _HttpMethod.ValueType  # 1
    GET: _HttpMethod.ValueType  # 2
    HEAD: _HttpMethod.ValueType  # 3
    POST: _HttpMethod.ValueType  # 4
    PUT: _HttpMethod.ValueType  # 5
    PATCH: _HttpMethod.ValueType  # 6
    DELETE: _HttpMethod.ValueType  # 7
    TRACE: _HttpMethod.ValueType  # 8
    CONNECT: _HttpMethod.ValueType  # 9

class HttpMethod(_HttpMethod, metaclass=_HttpMethodEnumTypeWrapper): ...

HTTP_METHOD_UNSPECIFIED: HttpMethod.ValueType  # 0
OPTIONS: HttpMethod.ValueType  # 1
GET: HttpMethod.ValueType  # 2
HEAD: HttpMethod.ValueType  # 3
POST: HttpMethod.ValueType  # 4
PUT: HttpMethod.ValueType  # 5
PATCH: HttpMethod.ValueType  # 6
DELETE: HttpMethod.ValueType  # 7
TRACE: HttpMethod.ValueType  # 8
CONNECT: HttpMethod.ValueType  # 9
global___HttpMethod = HttpMethod

@typing.final
class McpGateway(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[McpGateway._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: McpGateway._Status.ValueType  # 0
        CREATING: McpGateway._Status.ValueType  # 1
        """MCP Gateway is being created."""
        ACTIVE: McpGateway._Status.ValueType  # 2
        """MCP Gateway is ready to use."""
        UPDATING: McpGateway._Status.ValueType  # 3
        """MCP Gateway is being updated."""
        DELETING: McpGateway._Status.ValueType  # 4
        """MCP Gateway is being deleted."""
        ERROR: McpGateway._Status.ValueType  # 5
        """MCP Gateway is in an error state. The only allowed action is delete."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNSPECIFIED: McpGateway.Status.ValueType  # 0
    CREATING: McpGateway.Status.ValueType  # 1
    """MCP Gateway is being created."""
    ACTIVE: McpGateway.Status.ValueType  # 2
    """MCP Gateway is ready to use."""
    UPDATING: McpGateway.Status.ValueType  # 3
    """MCP Gateway is being updated."""
    DELETING: McpGateway.Status.ValueType  # 4
    """MCP Gateway is being deleted."""
    ERROR: McpGateway.Status.ValueType  # 5
    """MCP Gateway is in an error state. The only allowed action is delete."""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    TOOLS_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    BASE_DOMAIN_FIELD_NUMBER: builtins.int
    LOG_OPTIONS_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    NETWORK_ID_FIELD_NUMBER: builtins.int
    CLOUD_ID_FIELD_NUMBER: builtins.int
    PUBLIC_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the MCP Gateway. Generated at creation time."""
    folder_id: builtins.str
    """ID of the folder that the MCP Gateway belongs to."""
    name: builtins.str
    """Name of the MCP Gateway."""
    description: builtins.str
    """Description of the MCP Gateway."""
    status: global___McpGateway.Status.ValueType
    """Status of the MCP Gateway."""
    base_domain: builtins.str
    """Base domain of the MCP Gateway."""
    service_account_id: builtins.str
    """ID of the Service Account which will be used for resource access in MCP Gateway call."""
    network_id: builtins.str
    """ID of the VPC network MCP Gateway will be executed in, in order to access private resources."""
    cloud_id: builtins.str
    """ID of the cloud that the MCP Gateway belongs to."""
    public: builtins.bool
    """Publicity of the MCP Gateway. Public MCP Gateway can be accessed by anybody."""
    @property
    def tools(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___McpTool]:
        """Tools of the MCP Gateway."""

    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp for the MCP Gateway."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """MCP Gateway labels as `key:value` pairs."""

    @property
    def log_options(self) -> global___LogOptions:
        """Log options for the MCP Gateway."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        tools: collections.abc.Iterable[global___McpTool] | None = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        status: global___McpGateway.Status.ValueType = ...,
        base_domain: builtins.str = ...,
        log_options: global___LogOptions | None = ...,
        service_account_id: builtins.str = ...,
        network_id: builtins.str = ...,
        cloud_id: builtins.str = ...,
        public: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "log_options", b"log_options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["base_domain", b"base_domain", "cloud_id", b"cloud_id", "created_at", b"created_at", "description", b"description", "folder_id", b"folder_id", "id", b"id", "labels", b"labels", "log_options", b"log_options", "name", b"name", "network_id", b"network_id", "public", b"public", "service_account_id", b"service_account_id", "status", b"status", "tools", b"tools"]) -> None: ...

global___McpGateway = McpGateway

@typing.final
class McpGatewayPreview(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    BASE_DOMAIN_FIELD_NUMBER: builtins.int
    LOG_OPTIONS_FIELD_NUMBER: builtins.int
    NETWORK_ID_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    PUBLIC_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the MCP Gateway. Generated at creation time."""
    folder_id: builtins.str
    """ID of the folder that the MCP Gateway belongs to."""
    name: builtins.str
    """Name of the MCP Gateway."""
    description: builtins.str
    """Description of the MCP Gateway."""
    status: global___McpGateway.Status.ValueType
    """Status of the MCP Gateway."""
    base_domain: builtins.str
    """Base domain of the MCP Gateway."""
    network_id: builtins.str
    """ID of the VPC network MCP Gateway will be executed in, in order to access private resources."""
    service_account_id: builtins.str
    """ID of the Service Account which will be used for resource access in MCP Gateway call."""
    public: builtins.bool
    """Publicity of the MCP Gateway. Public MCP Gateway can be accessed by anybody."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp for the MCP Gateway."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """MCP Gateway labels as `key:value` pairs."""

    @property
    def log_options(self) -> global___LogOptions:
        """Log options for the MCP Gateway."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        status: global___McpGateway.Status.ValueType = ...,
        base_domain: builtins.str = ...,
        log_options: global___LogOptions | None = ...,
        network_id: builtins.str = ...,
        service_account_id: builtins.str = ...,
        public: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "log_options", b"log_options"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["base_domain", b"base_domain", "created_at", b"created_at", "description", b"description", "folder_id", b"folder_id", "id", b"id", "labels", b"labels", "log_options", b"log_options", "name", b"name", "network_id", b"network_id", "public", b"public", "service_account_id", b"service_account_id", "status", b"status"]) -> None: ...

global___McpGatewayPreview = McpGatewayPreview

@typing.final
class LogOptions(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DISABLED_FIELD_NUMBER: builtins.int
    LOG_GROUP_ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    MIN_LEVEL_FIELD_NUMBER: builtins.int
    disabled: builtins.bool
    """Is logging from MCP Gateway disabled."""
    log_group_id: builtins.str
    """ID of the logging group which should be used for MCP Gateway logs."""
    folder_id: builtins.str
    """ID of the folder which default logging group should be used for MCP Gateway logs."""
    min_level: yandex.cloud.logging.v1.log_entry_pb2.LogLevel.Level.ValueType
    """Minimum logs level.

    See [LogLevel.Level] for details.
    """
    def __init__(
        self,
        *,
        disabled: builtins.bool = ...,
        log_group_id: builtins.str = ...,
        folder_id: builtins.str = ...,
        min_level: yandex.cloud.logging.v1.log_entry_pb2.LogLevel.Level.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["destination", b"destination", "folder_id", b"folder_id", "log_group_id", b"log_group_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["destination", b"destination", "disabled", b"disabled", "folder_id", b"folder_id", "log_group_id", b"log_group_id", "min_level", b"min_level"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["destination", b"destination"]) -> typing.Literal["log_group_id", "folder_id"] | None: ...

global___LogOptions = LogOptions

@typing.final
class McpTool(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    INPUT_JSON_SCHEMA_FIELD_NUMBER: builtins.int
    ACTION_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the tool."""
    description: builtins.str
    """Description of the tool."""
    input_json_schema: builtins.str
    """JSON Schema describing tool input."""
    @property
    def action(self) -> global___McpToolAction:
        """Action to perform when this tool is invoked."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: builtins.str = ...,
        input_json_schema: builtins.str = ...,
        action: global___McpToolAction | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["action", b"action"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["action", b"action", "description", b"description", "input_json_schema", b"input_json_schema", "name", b"name"]) -> None: ...

global___McpTool = McpTool

@typing.final
class McpToolAction(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FUNCTION_CALL_FIELD_NUMBER: builtins.int
    CONTAINER_CALL_FIELD_NUMBER: builtins.int
    HTTP_CALL_FIELD_NUMBER: builtins.int
    MCP_CALL_FIELD_NUMBER: builtins.int
    GRPC_CALL_FIELD_NUMBER: builtins.int
    START_WORKFLOW_FIELD_NUMBER: builtins.int
    @property
    def function_call(self) -> global___FunctionCall:
        """Call Serverless Function."""

    @property
    def container_call(self) -> global___ContainerCall:
        """Call Serverless Container."""

    @property
    def http_call(self) -> global___HttpCall:
        """Send HTTP request."""

    @property
    def mcp_call(self) -> global___McpCall:
        """Call MCP Gateway."""

    @property
    def grpc_call(self) -> global___GrpcCall:
        """Call gRPC endpoint. Server must support gRPC reflection."""

    @property
    def start_workflow(self) -> global___StartWorkflow:
        """Start Workflow."""

    def __init__(
        self,
        *,
        function_call: global___FunctionCall | None = ...,
        container_call: global___ContainerCall | None = ...,
        http_call: global___HttpCall | None = ...,
        mcp_call: global___McpCall | None = ...,
        grpc_call: global___GrpcCall | None = ...,
        start_workflow: global___StartWorkflow | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["action", b"action", "container_call", b"container_call", "function_call", b"function_call", "grpc_call", b"grpc_call", "http_call", b"http_call", "mcp_call", b"mcp_call", "start_workflow", b"start_workflow"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["action", b"action", "container_call", b"container_call", "function_call", b"function_call", "grpc_call", b"grpc_call", "http_call", b"http_call", "mcp_call", b"mcp_call", "start_workflow", b"start_workflow"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["action", b"action"]) -> typing.Literal["function_call", "container_call", "http_call", "mcp_call", "grpc_call", "start_workflow"] | None: ...

global___McpToolAction = McpToolAction

@typing.final
class FunctionCall(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FUNCTION_ID_FIELD_NUMBER: builtins.int
    TAG_FIELD_NUMBER: builtins.int
    function_id: builtins.str
    """ID of serverless function to call."""
    tag: builtins.str
    """Tag of serverless function. If empty, $latest tag will be used."""
    def __init__(
        self,
        *,
        function_id: builtins.str = ...,
        tag: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["function_id", b"function_id", "tag", b"tag"]) -> None: ...

global___FunctionCall = FunctionCall

@typing.final
class ContainerCall(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class HeadersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing.final
    class QueryEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    PATH_FIELD_NUMBER: builtins.int
    METHOD_FIELD_NUMBER: builtins.int
    BODY_FIELD_NUMBER: builtins.int
    HEADERS_FIELD_NUMBER: builtins.int
    QUERY_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of serverless container to call."""
    path: builtins.str
    """Relative request path inside the container."""
    method: global___HttpMethod.ValueType
    """HTTP method to use for the request."""
    body: builtins.str
    """Request body to send to the container."""
    @property
    def headers(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """HTTP headers to include in the request."""

    @property
    def query(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Query string parameters to include in the request."""

    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
        path: builtins.str = ...,
        method: global___HttpMethod.ValueType = ...,
        body: builtins.str = ...,
        headers: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        query: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["body", b"body", "container_id", b"container_id", "headers", b"headers", "method", b"method", "path", b"path", "query", b"query"]) -> None: ...

global___ContainerCall = ContainerCall

@typing.final
class HttpCall(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class HeadersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing.final
    class QueryEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    URL_FIELD_NUMBER: builtins.int
    METHOD_FIELD_NUMBER: builtins.int
    BODY_FIELD_NUMBER: builtins.int
    HEADERS_FIELD_NUMBER: builtins.int
    QUERY_FIELD_NUMBER: builtins.int
    USE_SERVICE_ACCOUNT_FIELD_NUMBER: builtins.int
    url: builtins.str
    """Absolute URL to send the request to. (required)"""
    method: global___HttpMethod.ValueType
    """HTTP method to use."""
    body: builtins.str
    """Request body payload."""
    use_service_account: builtins.bool
    """Use MCP Gateway service account credentials for the request."""
    @property
    def headers(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """HTTP headers to include."""

    @property
    def query(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Query string parameters to include."""

    def __init__(
        self,
        *,
        url: builtins.str = ...,
        method: global___HttpMethod.ValueType = ...,
        body: builtins.str = ...,
        headers: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        query: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        use_service_account: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["body", b"body", "headers", b"headers", "method", b"method", "query", b"query", "url", b"url", "use_service_account", b"use_service_account"]) -> None: ...

global___HttpCall = HttpCall

@typing.final
class McpCall(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Transport:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TransportEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[McpCall._Transport.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        TRANSPORT_UNSPECIFIED: McpCall._Transport.ValueType  # 0
        """Unspecified transport."""
        SSE: McpCall._Transport.ValueType  # 1
        """Server-Sent Events (HTTP SSE)."""
        STREAMABLE: McpCall._Transport.ValueType  # 2
        """Streamable HTTP transport."""

    class Transport(_Transport, metaclass=_TransportEnumTypeWrapper): ...
    TRANSPORT_UNSPECIFIED: McpCall.Transport.ValueType  # 0
    """Unspecified transport."""
    SSE: McpCall.Transport.ValueType  # 1
    """Server-Sent Events (HTTP SSE)."""
    STREAMABLE: McpCall.Transport.ValueType  # 2
    """Streamable HTTP transport."""

    @typing.final
    class ForwardHeadersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing.final
    class NoAuthorization(google.protobuf.message.Message):
        """No authorization will be sent."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        def __init__(
            self,
        ) -> None: ...

    @typing.final
    class SaAuthorization(google.protobuf.message.Message):
        """Use MCP Gateway service account to authorize."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        def __init__(
            self,
        ) -> None: ...

    @typing.final
    class HeaderAuthorization(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        HEADER_NAME_FIELD_NUMBER: builtins.int
        HEADER_VALUE_FIELD_NUMBER: builtins.int
        header_name: builtins.str
        """Name of the authorization header to send."""
        header_value: builtins.str
        """Value of the authorization header to send."""
        def __init__(
            self,
            *,
            header_name: builtins.str = ...,
            header_value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["header_name", b"header_name", "header_value", b"header_value"]) -> None: ...

    @typing.final
    class ToolCall(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TOOL_NAME_FIELD_NUMBER: builtins.int
        PARAMETERS_JSON_FIELD_NUMBER: builtins.int
        tool_name: builtins.str
        """Name of the tool to invoke on the MCP endpoint. (required)"""
        parameters_json: builtins.str
        """JSON-encoded parameters to pass to the tool."""
        def __init__(
            self,
            *,
            tool_name: builtins.str = ...,
            parameters_json: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["parameters_json", b"parameters_json", "tool_name", b"tool_name"]) -> None: ...

    URL_FIELD_NUMBER: builtins.int
    TOOL_CALL_FIELD_NUMBER: builtins.int
    TRANSPORT_FIELD_NUMBER: builtins.int
    UNAUTHORIZED_FIELD_NUMBER: builtins.int
    HEADER_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_FIELD_NUMBER: builtins.int
    FORWARD_HEADERS_FIELD_NUMBER: builtins.int
    url: builtins.str
    """MCP endpoint base URL. (required)"""
    transport: global___McpCall.Transport.ValueType
    """Transport to use for MCP communication."""
    @property
    def tool_call(self) -> global___McpCall.ToolCall: ...
    @property
    def unauthorized(self) -> global___McpCall.NoAuthorization: ...
    @property
    def header(self) -> global___McpCall.HeaderAuthorization: ...
    @property
    def service_account(self) -> global___McpCall.SaAuthorization: ...
    @property
    def forward_headers(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Headers from the incoming request to forward downstream by name."""

    def __init__(
        self,
        *,
        url: builtins.str = ...,
        tool_call: global___McpCall.ToolCall | None = ...,
        transport: global___McpCall.Transport.ValueType = ...,
        unauthorized: global___McpCall.NoAuthorization | None = ...,
        header: global___McpCall.HeaderAuthorization | None = ...,
        service_account: global___McpCall.SaAuthorization | None = ...,
        forward_headers: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["action", b"action", "authorization", b"authorization", "header", b"header", "service_account", b"service_account", "tool_call", b"tool_call", "unauthorized", b"unauthorized"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["action", b"action", "authorization", b"authorization", "forward_headers", b"forward_headers", "header", b"header", "service_account", b"service_account", "tool_call", b"tool_call", "transport", b"transport", "unauthorized", b"unauthorized", "url", b"url"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["action", b"action"]) -> typing.Literal["tool_call"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["authorization", b"authorization"]) -> typing.Literal["unauthorized", "header", "service_account"] | None: ...

global___McpCall = McpCall

@typing.final
class GrpcCall(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class HeadersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ENDPOINT_FIELD_NUMBER: builtins.int
    METHOD_FIELD_NUMBER: builtins.int
    USE_SERVICE_ACCOUNT_FIELD_NUMBER: builtins.int
    BODY_FIELD_NUMBER: builtins.int
    HEADERS_FIELD_NUMBER: builtins.int
    endpoint: builtins.str
    """gRPC server endpoint, e.g., host:port. (required)"""
    method: builtins.str
    """Fully qualified gRPC method name, e.g., package.Service/Method. (required)"""
    use_service_account: builtins.bool
    """Use MCP Gateway service account for authentication."""
    body: builtins.str
    """Request body payload for the call."""
    @property
    def headers(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """gRPC/HTTP headers to include with the call."""

    def __init__(
        self,
        *,
        endpoint: builtins.str = ...,
        method: builtins.str = ...,
        use_service_account: builtins.bool = ...,
        body: builtins.str = ...,
        headers: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["body", b"body", "endpoint", b"endpoint", "headers", b"headers", "method", b"method", "use_service_account", b"use_service_account"]) -> None: ...

global___GrpcCall = GrpcCall

@typing.final
class StartWorkflow(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Mode:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ModeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[StartWorkflow._Mode.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        MODE_UNSPECIFIED: StartWorkflow._Mode.ValueType  # 0
        """Unspecified mode. When not set, defaults to SYNC behavior."""
        SYNC: StartWorkflow._Mode.ValueType  # 1
        """Synchronous mode. The call blocks until the workflow execution completes."""
        ASYNC: StartWorkflow._Mode.ValueType  # 2
        """Asynchronous mode. The call returns immediately after starting the workflow.
        Returns the execution ID for tracking the workflow progress separately.
        """

    class Mode(_Mode, metaclass=_ModeEnumTypeWrapper): ...
    MODE_UNSPECIFIED: StartWorkflow.Mode.ValueType  # 0
    """Unspecified mode. When not set, defaults to SYNC behavior."""
    SYNC: StartWorkflow.Mode.ValueType  # 1
    """Synchronous mode. The call blocks until the workflow execution completes."""
    ASYNC: StartWorkflow.Mode.ValueType  # 2
    """Asynchronous mode. The call returns immediately after starting the workflow.
    Returns the execution ID for tracking the workflow progress separately.
    """

    WORKFLOW_ID_FIELD_NUMBER: builtins.int
    INPUT_JSON_FIELD_NUMBER: builtins.int
    MODE_FIELD_NUMBER: builtins.int
    workflow_id: builtins.str
    """ID of the Workflow to start. (required)"""
    input_json: builtins.str
    """JSON-encoded workflow input payload."""
    mode: global___StartWorkflow.Mode.ValueType
    """Execution mode for the workflow.
    Determines whether the call should wait for workflow completion (SYNC)
    or return immediately after starting the workflow (ASYNC).
    """
    def __init__(
        self,
        *,
        workflow_id: builtins.str = ...,
        input_json: builtins.str = ...,
        mode: global___StartWorkflow.Mode.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["input_json", b"input_json", "mode", b"mode", "workflow_id", b"workflow_id"]) -> None: ...

global___StartWorkflow = StartWorkflow
