"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing
import yandex.cloud.logging.v1.log_entry_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _TriggerType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _TriggerTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_TriggerType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    TRIGGER_TYPE_UNSPECIFIED: _TriggerType.ValueType  # 0
    TIMER: _TriggerType.ValueType  # 2
    """The trigger is activated on a timer."""
    MESSAGE_QUEUE: _TriggerType.ValueType  # 3
    """The trigger is activated by messages from a message queue.

    Only Message Queue is currently supported.
    """
    IOT_MESSAGE: _TriggerType.ValueType  # 4
    """The trigger is activated by messages from IoT Core."""
    IOT_BROKER_MESSAGE: _TriggerType.ValueType  # 12
    OBJECT_STORAGE: _TriggerType.ValueType  # 5
    CONTAINER_REGISTRY: _TriggerType.ValueType  # 6
    CLOUD_LOGS: _TriggerType.ValueType  # 7
    """The trigger is activated by cloud log group events"""
    LOGGING: _TriggerType.ValueType  # 8
    """The trigger is activated by logging group events"""
    BILLING_BUDGET: _TriggerType.ValueType  # 9
    """The trigger is activated by billing events"""
    YDS: _TriggerType.ValueType  # 10
    """The trigger is activated by YDS events"""
    MAIL: _TriggerType.ValueType  # 11
    """The trigger is activated by email"""

class TriggerType(_TriggerType, metaclass=_TriggerTypeEnumTypeWrapper): ...

TRIGGER_TYPE_UNSPECIFIED: TriggerType.ValueType  # 0
TIMER: TriggerType.ValueType  # 2
"""The trigger is activated on a timer."""
MESSAGE_QUEUE: TriggerType.ValueType  # 3
"""The trigger is activated by messages from a message queue.

Only Message Queue is currently supported.
"""
IOT_MESSAGE: TriggerType.ValueType  # 4
"""The trigger is activated by messages from IoT Core."""
IOT_BROKER_MESSAGE: TriggerType.ValueType  # 12
OBJECT_STORAGE: TriggerType.ValueType  # 5
CONTAINER_REGISTRY: TriggerType.ValueType  # 6
CLOUD_LOGS: TriggerType.ValueType  # 7
"""The trigger is activated by cloud log group events"""
LOGGING: TriggerType.ValueType  # 8
"""The trigger is activated by logging group events"""
BILLING_BUDGET: TriggerType.ValueType  # 9
"""The trigger is activated by billing events"""
YDS: TriggerType.ValueType  # 10
"""The trigger is activated by YDS events"""
MAIL: TriggerType.ValueType  # 11
"""The trigger is activated by email"""
global___TriggerType = TriggerType

@typing.final
class Trigger(google.protobuf.message.Message):
    """A trigger to invoke a serverless function. For more information, see [Triggers](/docs/functions/concepts/trigger)."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ObjectStorageEventType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ObjectStorageEventTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Trigger._ObjectStorageEventType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        OBJECT_STORAGE_EVENT_TYPE_UNSPECIFIED: Trigger._ObjectStorageEventType.ValueType  # 0
        OBJECT_STORAGE_EVENT_TYPE_CREATE_OBJECT: Trigger._ObjectStorageEventType.ValueType  # 1
        OBJECT_STORAGE_EVENT_TYPE_UPDATE_OBJECT: Trigger._ObjectStorageEventType.ValueType  # 2
        OBJECT_STORAGE_EVENT_TYPE_DELETE_OBJECT: Trigger._ObjectStorageEventType.ValueType  # 3

    class ObjectStorageEventType(_ObjectStorageEventType, metaclass=_ObjectStorageEventTypeEnumTypeWrapper): ...
    OBJECT_STORAGE_EVENT_TYPE_UNSPECIFIED: Trigger.ObjectStorageEventType.ValueType  # 0
    OBJECT_STORAGE_EVENT_TYPE_CREATE_OBJECT: Trigger.ObjectStorageEventType.ValueType  # 1
    OBJECT_STORAGE_EVENT_TYPE_UPDATE_OBJECT: Trigger.ObjectStorageEventType.ValueType  # 2
    OBJECT_STORAGE_EVENT_TYPE_DELETE_OBJECT: Trigger.ObjectStorageEventType.ValueType  # 3

    class _ContainerRegistryEventType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ContainerRegistryEventTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Trigger._ContainerRegistryEventType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        CONTAINER_REGISTRY_EVENT_TYPE_UNSPECIFIED: Trigger._ContainerRegistryEventType.ValueType  # 0
        CONTAINER_REGISTRY_EVENT_TYPE_CREATE_IMAGE: Trigger._ContainerRegistryEventType.ValueType  # 1
        CONTAINER_REGISTRY_EVENT_TYPE_DELETE_IMAGE: Trigger._ContainerRegistryEventType.ValueType  # 2
        CONTAINER_REGISTRY_EVENT_TYPE_CREATE_IMAGE_TAG: Trigger._ContainerRegistryEventType.ValueType  # 3
        CONTAINER_REGISTRY_EVENT_TYPE_DELETE_IMAGE_TAG: Trigger._ContainerRegistryEventType.ValueType  # 4

    class ContainerRegistryEventType(_ContainerRegistryEventType, metaclass=_ContainerRegistryEventTypeEnumTypeWrapper): ...
    CONTAINER_REGISTRY_EVENT_TYPE_UNSPECIFIED: Trigger.ContainerRegistryEventType.ValueType  # 0
    CONTAINER_REGISTRY_EVENT_TYPE_CREATE_IMAGE: Trigger.ContainerRegistryEventType.ValueType  # 1
    CONTAINER_REGISTRY_EVENT_TYPE_DELETE_IMAGE: Trigger.ContainerRegistryEventType.ValueType  # 2
    CONTAINER_REGISTRY_EVENT_TYPE_CREATE_IMAGE_TAG: Trigger.ContainerRegistryEventType.ValueType  # 3
    CONTAINER_REGISTRY_EVENT_TYPE_DELETE_IMAGE_TAG: Trigger.ContainerRegistryEventType.ValueType  # 4

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Trigger._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNSPECIFIED: Trigger._Status.ValueType  # 0
        ACTIVE: Trigger._Status.ValueType  # 1
        PAUSED: Trigger._Status.ValueType  # 2

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNSPECIFIED: Trigger.Status.ValueType  # 0
    ACTIVE: Trigger.Status.ValueType  # 1
    PAUSED: Trigger.Status.ValueType  # 2

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    @typing.final
    class Rule(google.protobuf.message.Message):
        """Description of a rule for trigger activation."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TIMER_FIELD_NUMBER: builtins.int
        MESSAGE_QUEUE_FIELD_NUMBER: builtins.int
        IOT_MESSAGE_FIELD_NUMBER: builtins.int
        IOT_BROKER_MESSAGE_FIELD_NUMBER: builtins.int
        OBJECT_STORAGE_FIELD_NUMBER: builtins.int
        CONTAINER_REGISTRY_FIELD_NUMBER: builtins.int
        CLOUD_LOGS_FIELD_NUMBER: builtins.int
        LOGGING_FIELD_NUMBER: builtins.int
        BILLING_BUDGET_FIELD_NUMBER: builtins.int
        DATA_STREAM_FIELD_NUMBER: builtins.int
        MAIL_FIELD_NUMBER: builtins.int
        @property
        def timer(self) -> global___Trigger.Timer:
            """Rule for a timed trigger."""

        @property
        def message_queue(self) -> global___Trigger.MessageQueue:
            """Rule for a message queue trigger."""

        @property
        def iot_message(self) -> global___Trigger.IoTMessage:
            """Rule for a IoT Core trigger."""

        @property
        def iot_broker_message(self) -> global___Trigger.IoTBrokerMessage: ...
        @property
        def object_storage(self) -> global___Trigger.ObjectStorage: ...
        @property
        def container_registry(self) -> global___Trigger.ContainerRegistry: ...
        @property
        def cloud_logs(self) -> global___Trigger.CloudLogs: ...
        @property
        def logging(self) -> global___Trigger.Logging: ...
        @property
        def billing_budget(self) -> global___BillingBudget: ...
        @property
        def data_stream(self) -> global___DataStream: ...
        @property
        def mail(self) -> global___Mail: ...
        def __init__(
            self,
            *,
            timer: global___Trigger.Timer | None = ...,
            message_queue: global___Trigger.MessageQueue | None = ...,
            iot_message: global___Trigger.IoTMessage | None = ...,
            iot_broker_message: global___Trigger.IoTBrokerMessage | None = ...,
            object_storage: global___Trigger.ObjectStorage | None = ...,
            container_registry: global___Trigger.ContainerRegistry | None = ...,
            cloud_logs: global___Trigger.CloudLogs | None = ...,
            logging: global___Trigger.Logging | None = ...,
            billing_budget: global___BillingBudget | None = ...,
            data_stream: global___DataStream | None = ...,
            mail: global___Mail | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["billing_budget", b"billing_budget", "cloud_logs", b"cloud_logs", "container_registry", b"container_registry", "data_stream", b"data_stream", "iot_broker_message", b"iot_broker_message", "iot_message", b"iot_message", "logging", b"logging", "mail", b"mail", "message_queue", b"message_queue", "object_storage", b"object_storage", "rule", b"rule", "timer", b"timer"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["billing_budget", b"billing_budget", "cloud_logs", b"cloud_logs", "container_registry", b"container_registry", "data_stream", b"data_stream", "iot_broker_message", b"iot_broker_message", "iot_message", b"iot_message", "logging", b"logging", "mail", b"mail", "message_queue", b"message_queue", "object_storage", b"object_storage", "rule", b"rule", "timer", b"timer"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["rule", b"rule"]) -> typing.Literal["timer", "message_queue", "iot_message", "iot_broker_message", "object_storage", "container_registry", "cloud_logs", "logging", "billing_budget", "data_stream", "mail"] | None: ...

    @typing.final
    class Timer(google.protobuf.message.Message):
        """Rule for activating a timed trigger."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        CRON_EXPRESSION_FIELD_NUMBER: builtins.int
        PAYLOAD_FIELD_NUMBER: builtins.int
        INVOKE_FUNCTION_FIELD_NUMBER: builtins.int
        INVOKE_FUNCTION_WITH_RETRY_FIELD_NUMBER: builtins.int
        INVOKE_CONTAINER_WITH_RETRY_FIELD_NUMBER: builtins.int
        GATEWAY_WEBSOCKET_BROADCAST_FIELD_NUMBER: builtins.int
        cron_expression: builtins.str
        """Description of a schedule as a [cron expression](/docs/functions/concepts/trigger/timer)."""
        payload: builtins.str
        """Payload to be passed to function."""
        @property
        def invoke_function(self) -> global___InvokeFunctionOnce:
            """Instructions for invoking a function once."""

        @property
        def invoke_function_with_retry(self) -> global___InvokeFunctionWithRetry:
            """Instructions for invoking a function with retry."""

        @property
        def invoke_container_with_retry(self) -> global___InvokeContainerWithRetry:
            """Instructions for invoking a container with retry."""

        @property
        def gateway_websocket_broadcast(self) -> global___GatewayWebsocketBroadcast:
            """Instructions for broadcasting to API gateway websocket once."""

        def __init__(
            self,
            *,
            cron_expression: builtins.str = ...,
            payload: builtins.str = ...,
            invoke_function: global___InvokeFunctionOnce | None = ...,
            invoke_function_with_retry: global___InvokeFunctionWithRetry | None = ...,
            invoke_container_with_retry: global___InvokeContainerWithRetry | None = ...,
            gateway_websocket_broadcast: global___GatewayWebsocketBroadcast | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["action", b"action", "gateway_websocket_broadcast", b"gateway_websocket_broadcast", "invoke_container_with_retry", b"invoke_container_with_retry", "invoke_function", b"invoke_function", "invoke_function_with_retry", b"invoke_function_with_retry"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["action", b"action", "cron_expression", b"cron_expression", "gateway_websocket_broadcast", b"gateway_websocket_broadcast", "invoke_container_with_retry", b"invoke_container_with_retry", "invoke_function", b"invoke_function", "invoke_function_with_retry", b"invoke_function_with_retry", "payload", b"payload"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["action", b"action"]) -> typing.Literal["invoke_function", "invoke_function_with_retry", "invoke_container_with_retry", "gateway_websocket_broadcast"] | None: ...

    @typing.final
    class MessageQueue(google.protobuf.message.Message):
        """Rule for activating a message queue trigger."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        QUEUE_ID_FIELD_NUMBER: builtins.int
        SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
        BATCH_SETTINGS_FIELD_NUMBER: builtins.int
        VISIBILITY_TIMEOUT_FIELD_NUMBER: builtins.int
        INVOKE_FUNCTION_FIELD_NUMBER: builtins.int
        INVOKE_CONTAINER_FIELD_NUMBER: builtins.int
        GATEWAY_WEBSOCKET_BROADCAST_FIELD_NUMBER: builtins.int
        queue_id: builtins.str
        """ID of the message queue in Message Queue."""
        service_account_id: builtins.str
        """ID of the service account which has read access to the message queue."""
        @property
        def batch_settings(self) -> global___BatchSettings:
            """Batch settings for processing messages in the queue."""

        @property
        def visibility_timeout(self) -> google.protobuf.duration_pb2.Duration:
            """Queue visibility timeout override."""

        @property
        def invoke_function(self) -> global___InvokeFunctionOnce:
            """Instructions for invoking a function once."""

        @property
        def invoke_container(self) -> global___InvokeContainerOnce:
            """Instructions for invoking a container once."""

        @property
        def gateway_websocket_broadcast(self) -> global___GatewayWebsocketBroadcast:
            """Instructions for broadcasting to API gateway websocket once."""

        def __init__(
            self,
            *,
            queue_id: builtins.str = ...,
            service_account_id: builtins.str = ...,
            batch_settings: global___BatchSettings | None = ...,
            visibility_timeout: google.protobuf.duration_pb2.Duration | None = ...,
            invoke_function: global___InvokeFunctionOnce | None = ...,
            invoke_container: global___InvokeContainerOnce | None = ...,
            gateway_websocket_broadcast: global___GatewayWebsocketBroadcast | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["action", b"action", "batch_settings", b"batch_settings", "gateway_websocket_broadcast", b"gateway_websocket_broadcast", "invoke_container", b"invoke_container", "invoke_function", b"invoke_function", "visibility_timeout", b"visibility_timeout"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["action", b"action", "batch_settings", b"batch_settings", "gateway_websocket_broadcast", b"gateway_websocket_broadcast", "invoke_container", b"invoke_container", "invoke_function", b"invoke_function", "queue_id", b"queue_id", "service_account_id", b"service_account_id", "visibility_timeout", b"visibility_timeout"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["action", b"action"]) -> typing.Literal["invoke_function", "invoke_container", "gateway_websocket_broadcast"] | None: ...

    @typing.final
    class IoTMessage(google.protobuf.message.Message):
        """Rule for activating a IoT Core trigger."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        REGISTRY_ID_FIELD_NUMBER: builtins.int
        DEVICE_ID_FIELD_NUMBER: builtins.int
        MQTT_TOPIC_FIELD_NUMBER: builtins.int
        BATCH_SETTINGS_FIELD_NUMBER: builtins.int
        INVOKE_FUNCTION_FIELD_NUMBER: builtins.int
        INVOKE_CONTAINER_FIELD_NUMBER: builtins.int
        GATEWAY_WEBSOCKET_BROADCAST_FIELD_NUMBER: builtins.int
        registry_id: builtins.str
        """ID of the IoT Core registry."""
        device_id: builtins.str
        """ID of the IoT Core device in the registry."""
        mqtt_topic: builtins.str
        """MQTT topic whose messages activate the trigger."""
        @property
        def batch_settings(self) -> global___BatchSettings:
            """Batch settings for processing events."""

        @property
        def invoke_function(self) -> global___InvokeFunctionWithRetry:
            """Instructions for invoking a function with retries as needed."""

        @property
        def invoke_container(self) -> global___InvokeContainerWithRetry:
            """Instructions for invoking a container with retries as needed."""

        @property
        def gateway_websocket_broadcast(self) -> global___GatewayWebsocketBroadcast:
            """Instructions for broadcasting to API gateway websocket once."""

        def __init__(
            self,
            *,
            registry_id: builtins.str = ...,
            device_id: builtins.str = ...,
            mqtt_topic: builtins.str = ...,
            batch_settings: global___BatchSettings | None = ...,
            invoke_function: global___InvokeFunctionWithRetry | None = ...,
            invoke_container: global___InvokeContainerWithRetry | None = ...,
            gateway_websocket_broadcast: global___GatewayWebsocketBroadcast | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["action", b"action", "batch_settings", b"batch_settings", "gateway_websocket_broadcast", b"gateway_websocket_broadcast", "invoke_container", b"invoke_container", "invoke_function", b"invoke_function"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["action", b"action", "batch_settings", b"batch_settings", "device_id", b"device_id", "gateway_websocket_broadcast", b"gateway_websocket_broadcast", "invoke_container", b"invoke_container", "invoke_function", b"invoke_function", "mqtt_topic", b"mqtt_topic", "registry_id", b"registry_id"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["action", b"action"]) -> typing.Literal["invoke_function", "invoke_container", "gateway_websocket_broadcast"] | None: ...

    @typing.final
    class IoTBrokerMessage(google.protobuf.message.Message):
        """Rule for activating a IoT Core Broker trigger."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        BROKER_ID_FIELD_NUMBER: builtins.int
        MQTT_TOPIC_FIELD_NUMBER: builtins.int
        BATCH_SETTINGS_FIELD_NUMBER: builtins.int
        INVOKE_FUNCTION_FIELD_NUMBER: builtins.int
        INVOKE_CONTAINER_FIELD_NUMBER: builtins.int
        GATEWAY_WEBSOCKET_BROADCAST_FIELD_NUMBER: builtins.int
        broker_id: builtins.str
        """ID of the IoT Core broker."""
        mqtt_topic: builtins.str
        """MQTT topic whose messages activate the trigger."""
        @property
        def batch_settings(self) -> global___BatchSettings:
            """Batch settings for processing events."""

        @property
        def invoke_function(self) -> global___InvokeFunctionWithRetry:
            """Instructions for invoking a function with retries as needed."""

        @property
        def invoke_container(self) -> global___InvokeContainerWithRetry:
            """Instructions for invoking a container with retries as needed."""

        @property
        def gateway_websocket_broadcast(self) -> global___GatewayWebsocketBroadcast:
            """Instructions for broadcasting to API gateway websocket once."""

        def __init__(
            self,
            *,
            broker_id: builtins.str = ...,
            mqtt_topic: builtins.str = ...,
            batch_settings: global___BatchSettings | None = ...,
            invoke_function: global___InvokeFunctionWithRetry | None = ...,
            invoke_container: global___InvokeContainerWithRetry | None = ...,
            gateway_websocket_broadcast: global___GatewayWebsocketBroadcast | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["action", b"action", "batch_settings", b"batch_settings", "gateway_websocket_broadcast", b"gateway_websocket_broadcast", "invoke_container", b"invoke_container", "invoke_function", b"invoke_function"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["action", b"action", "batch_settings", b"batch_settings", "broker_id", b"broker_id", "gateway_websocket_broadcast", b"gateway_websocket_broadcast", "invoke_container", b"invoke_container", "invoke_function", b"invoke_function", "mqtt_topic", b"mqtt_topic"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["action", b"action"]) -> typing.Literal["invoke_function", "invoke_container", "gateway_websocket_broadcast"] | None: ...

    @typing.final
    class ObjectStorage(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        EVENT_TYPE_FIELD_NUMBER: builtins.int
        BUCKET_ID_FIELD_NUMBER: builtins.int
        PREFIX_FIELD_NUMBER: builtins.int
        SUFFIX_FIELD_NUMBER: builtins.int
        BATCH_SETTINGS_FIELD_NUMBER: builtins.int
        INVOKE_FUNCTION_FIELD_NUMBER: builtins.int
        INVOKE_CONTAINER_FIELD_NUMBER: builtins.int
        GATEWAY_WEBSOCKET_BROADCAST_FIELD_NUMBER: builtins.int
        bucket_id: builtins.str
        """ID of the bucket."""
        prefix: builtins.str
        """Prefix of the object key. Filter, optional."""
        suffix: builtins.str
        """Suffix of the object key. Filter, optional."""
        @property
        def event_type(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___Trigger.ObjectStorageEventType.ValueType]:
            """Type (name) of events, at least one value is required."""

        @property
        def batch_settings(self) -> global___BatchSettings:
            """Batch settings for processing events."""

        @property
        def invoke_function(self) -> global___InvokeFunctionWithRetry:
            """Instructions for invoking a function with retries as needed."""

        @property
        def invoke_container(self) -> global___InvokeContainerWithRetry:
            """Instructions for invoking a container with retries as needed."""

        @property
        def gateway_websocket_broadcast(self) -> global___GatewayWebsocketBroadcast:
            """Instructions for broadcasting to API gateway websocket once."""

        def __init__(
            self,
            *,
            event_type: collections.abc.Iterable[global___Trigger.ObjectStorageEventType.ValueType] | None = ...,
            bucket_id: builtins.str = ...,
            prefix: builtins.str = ...,
            suffix: builtins.str = ...,
            batch_settings: global___BatchSettings | None = ...,
            invoke_function: global___InvokeFunctionWithRetry | None = ...,
            invoke_container: global___InvokeContainerWithRetry | None = ...,
            gateway_websocket_broadcast: global___GatewayWebsocketBroadcast | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["action", b"action", "batch_settings", b"batch_settings", "gateway_websocket_broadcast", b"gateway_websocket_broadcast", "invoke_container", b"invoke_container", "invoke_function", b"invoke_function"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["action", b"action", "batch_settings", b"batch_settings", "bucket_id", b"bucket_id", "event_type", b"event_type", "gateway_websocket_broadcast", b"gateway_websocket_broadcast", "invoke_container", b"invoke_container", "invoke_function", b"invoke_function", "prefix", b"prefix", "suffix", b"suffix"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["action", b"action"]) -> typing.Literal["invoke_function", "invoke_container", "gateway_websocket_broadcast"] | None: ...

    @typing.final
    class ContainerRegistry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        EVENT_TYPE_FIELD_NUMBER: builtins.int
        REGISTRY_ID_FIELD_NUMBER: builtins.int
        IMAGE_NAME_FIELD_NUMBER: builtins.int
        TAG_FIELD_NUMBER: builtins.int
        BATCH_SETTINGS_FIELD_NUMBER: builtins.int
        INVOKE_FUNCTION_FIELD_NUMBER: builtins.int
        INVOKE_CONTAINER_FIELD_NUMBER: builtins.int
        GATEWAY_WEBSOCKET_BROADCAST_FIELD_NUMBER: builtins.int
        registry_id: builtins.str
        """ID of the registry."""
        image_name: builtins.str
        """Docker-image name. Filter, optional."""
        tag: builtins.str
        """Docker-image tag. Filter, optional."""
        @property
        def event_type(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___Trigger.ContainerRegistryEventType.ValueType]:
            """Type (name) of events, at least one value is required."""

        @property
        def batch_settings(self) -> global___BatchSettings:
            """Batch settings for processing events."""

        @property
        def invoke_function(self) -> global___InvokeFunctionWithRetry:
            """Instructions for invoking a function with retries as needed."""

        @property
        def invoke_container(self) -> global___InvokeContainerWithRetry:
            """Instructions for invoking a container with retries as needed."""

        @property
        def gateway_websocket_broadcast(self) -> global___GatewayWebsocketBroadcast:
            """Instructions for broadcasting to API gateway websocket once."""

        def __init__(
            self,
            *,
            event_type: collections.abc.Iterable[global___Trigger.ContainerRegistryEventType.ValueType] | None = ...,
            registry_id: builtins.str = ...,
            image_name: builtins.str = ...,
            tag: builtins.str = ...,
            batch_settings: global___BatchSettings | None = ...,
            invoke_function: global___InvokeFunctionWithRetry | None = ...,
            invoke_container: global___InvokeContainerWithRetry | None = ...,
            gateway_websocket_broadcast: global___GatewayWebsocketBroadcast | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["action", b"action", "batch_settings", b"batch_settings", "gateway_websocket_broadcast", b"gateway_websocket_broadcast", "invoke_container", b"invoke_container", "invoke_function", b"invoke_function"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["action", b"action", "batch_settings", b"batch_settings", "event_type", b"event_type", "gateway_websocket_broadcast", b"gateway_websocket_broadcast", "image_name", b"image_name", "invoke_container", b"invoke_container", "invoke_function", b"invoke_function", "registry_id", b"registry_id", "tag", b"tag"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["action", b"action"]) -> typing.Literal["invoke_function", "invoke_container", "gateway_websocket_broadcast"] | None: ...

    @typing.final
    class CloudLogs(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        LOG_GROUP_ID_FIELD_NUMBER: builtins.int
        BATCH_SETTINGS_FIELD_NUMBER: builtins.int
        INVOKE_FUNCTION_FIELD_NUMBER: builtins.int
        INVOKE_CONTAINER_FIELD_NUMBER: builtins.int
        @property
        def log_group_id(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """Log group identifiers, at least one value is required."""

        @property
        def batch_settings(self) -> global___CloudLogsBatchSettings:
            """Batch settings for processing log events."""

        @property
        def invoke_function(self) -> global___InvokeFunctionWithRetry:
            """Instructions for invoking a function with retries as needed."""

        @property
        def invoke_container(self) -> global___InvokeContainerWithRetry:
            """Instructions for invoking a container with retries as needed."""

        def __init__(
            self,
            *,
            log_group_id: collections.abc.Iterable[builtins.str] | None = ...,
            batch_settings: global___CloudLogsBatchSettings | None = ...,
            invoke_function: global___InvokeFunctionWithRetry | None = ...,
            invoke_container: global___InvokeContainerWithRetry | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["action", b"action", "batch_settings", b"batch_settings", "invoke_container", b"invoke_container", "invoke_function", b"invoke_function"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["action", b"action", "batch_settings", b"batch_settings", "invoke_container", b"invoke_container", "invoke_function", b"invoke_function", "log_group_id", b"log_group_id"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["action", b"action"]) -> typing.Literal["invoke_function", "invoke_container"] | None: ...

    @typing.final
    class Logging(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        LOG_GROUP_ID_FIELD_NUMBER: builtins.int
        RESOURCE_TYPE_FIELD_NUMBER: builtins.int
        RESOURCE_ID_FIELD_NUMBER: builtins.int
        STREAM_NAME_FIELD_NUMBER: builtins.int
        LEVELS_FIELD_NUMBER: builtins.int
        BATCH_SETTINGS_FIELD_NUMBER: builtins.int
        INVOKE_FUNCTION_FIELD_NUMBER: builtins.int
        INVOKE_CONTAINER_FIELD_NUMBER: builtins.int
        GATEWAY_WEBSOCKET_BROADCAST_FIELD_NUMBER: builtins.int
        log_group_id: builtins.str
        """Log events filter settings."""
        @property
        def resource_type(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
        @property
        def resource_id(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
        @property
        def stream_name(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
        @property
        def levels(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[yandex.cloud.logging.v1.log_entry_pb2.LogLevel.Level.ValueType]: ...
        @property
        def batch_settings(self) -> global___LoggingBatchSettings:
            """Batch settings for processing log events."""

        @property
        def invoke_function(self) -> global___InvokeFunctionWithRetry:
            """Instructions for invoking a function with retries as needed."""

        @property
        def invoke_container(self) -> global___InvokeContainerWithRetry:
            """Instructions for invoking a container with retries as needed."""

        @property
        def gateway_websocket_broadcast(self) -> global___GatewayWebsocketBroadcast:
            """Instructions for broadcasting to API gateway websocket once."""

        def __init__(
            self,
            *,
            log_group_id: builtins.str = ...,
            resource_type: collections.abc.Iterable[builtins.str] | None = ...,
            resource_id: collections.abc.Iterable[builtins.str] | None = ...,
            stream_name: collections.abc.Iterable[builtins.str] | None = ...,
            levels: collections.abc.Iterable[yandex.cloud.logging.v1.log_entry_pb2.LogLevel.Level.ValueType] | None = ...,
            batch_settings: global___LoggingBatchSettings | None = ...,
            invoke_function: global___InvokeFunctionWithRetry | None = ...,
            invoke_container: global___InvokeContainerWithRetry | None = ...,
            gateway_websocket_broadcast: global___GatewayWebsocketBroadcast | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["action", b"action", "batch_settings", b"batch_settings", "gateway_websocket_broadcast", b"gateway_websocket_broadcast", "invoke_container", b"invoke_container", "invoke_function", b"invoke_function"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["action", b"action", "batch_settings", b"batch_settings", "gateway_websocket_broadcast", b"gateway_websocket_broadcast", "invoke_container", b"invoke_container", "invoke_function", b"invoke_function", "levels", b"levels", "log_group_id", b"log_group_id", "resource_id", b"resource_id", "resource_type", b"resource_type", "stream_name", b"stream_name"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["action", b"action"]) -> typing.Literal["invoke_function", "invoke_container", "gateway_websocket_broadcast"] | None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    RULE_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """ID of the trigger. Generated at creation time."""
    folder_id: builtins.str
    """ID of the folder that the trigger belongs to."""
    name: builtins.str
    """Name of the trigger."""
    description: builtins.str
    """Description of the trigger."""
    status: global___Trigger.Status.ValueType
    """Trigger status."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Creation timestamp for the trigger."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Trigger labels as `key:value` pairs."""

    @property
    def rule(self) -> global___Trigger.Rule:
        """Rule for trigger activation (always consistent with the trigger type)."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        rule: global___Trigger.Rule | None = ...,
        status: global___Trigger.Status.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["created_at", b"created_at", "rule", b"rule"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["created_at", b"created_at", "description", b"description", "folder_id", b"folder_id", "id", b"id", "labels", b"labels", "name", b"name", "rule", b"rule", "status", b"status"]) -> None: ...

global___Trigger = Trigger

@typing.final
class InvokeFunctionOnce(google.protobuf.message.Message):
    """A single function invocation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FUNCTION_ID_FIELD_NUMBER: builtins.int
    FUNCTION_TAG_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    function_id: builtins.str
    """ID of the function to invoke."""
    function_tag: builtins.str
    """Version tag of the function to execute."""
    service_account_id: builtins.str
    """ID of the service account that should be used to invoke the function."""
    def __init__(
        self,
        *,
        function_id: builtins.str = ...,
        function_tag: builtins.str = ...,
        service_account_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["function_id", b"function_id", "function_tag", b"function_tag", "service_account_id", b"service_account_id"]) -> None: ...

global___InvokeFunctionOnce = InvokeFunctionOnce

@typing.final
class InvokeFunctionWithRetry(google.protobuf.message.Message):
    """A function invocation with retries."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FUNCTION_ID_FIELD_NUMBER: builtins.int
    FUNCTION_TAG_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    RETRY_SETTINGS_FIELD_NUMBER: builtins.int
    DEAD_LETTER_QUEUE_FIELD_NUMBER: builtins.int
    function_id: builtins.str
    """ID of the function to invoke."""
    function_tag: builtins.str
    """Version tag of the function to execute."""
    service_account_id: builtins.str
    """ID of the service account which has permission to invoke the function."""
    @property
    def retry_settings(self) -> global___RetrySettings:
        """Retry policy. If the field is not specified, or the value is empty, no retries will be attempted."""

    @property
    def dead_letter_queue(self) -> global___PutQueueMessage:
        """DLQ policy (no value means discarding a message)."""

    def __init__(
        self,
        *,
        function_id: builtins.str = ...,
        function_tag: builtins.str = ...,
        service_account_id: builtins.str = ...,
        retry_settings: global___RetrySettings | None = ...,
        dead_letter_queue: global___PutQueueMessage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["dead_letter_queue", b"dead_letter_queue", "retry_settings", b"retry_settings"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["dead_letter_queue", b"dead_letter_queue", "function_id", b"function_id", "function_tag", b"function_tag", "retry_settings", b"retry_settings", "service_account_id", b"service_account_id"]) -> None: ...

global___InvokeFunctionWithRetry = InvokeFunctionWithRetry

@typing.final
class InvokeContainerOnce(google.protobuf.message.Message):
    """A single container invocation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    PATH_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the container to invoke."""
    path: builtins.str
    """Endpoint HTTP path to invoke."""
    service_account_id: builtins.str
    """ID of the service account which has permission to invoke the container."""
    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
        path: builtins.str = ...,
        service_account_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["container_id", b"container_id", "path", b"path", "service_account_id", b"service_account_id"]) -> None: ...

global___InvokeContainerOnce = InvokeContainerOnce

@typing.final
class InvokeContainerWithRetry(google.protobuf.message.Message):
    """A container invocation with retries."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTAINER_ID_FIELD_NUMBER: builtins.int
    PATH_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    RETRY_SETTINGS_FIELD_NUMBER: builtins.int
    DEAD_LETTER_QUEUE_FIELD_NUMBER: builtins.int
    container_id: builtins.str
    """ID of the container to invoke."""
    path: builtins.str
    """Endpoint HTTP path to invoke."""
    service_account_id: builtins.str
    """ID of the service account which has permission to invoke the container."""
    @property
    def retry_settings(self) -> global___RetrySettings:
        """Retry policy. If the field is not specified, or the value is empty, no retries will be attempted."""

    @property
    def dead_letter_queue(self) -> global___PutQueueMessage:
        """DLQ policy (no value means discarding a message)."""

    def __init__(
        self,
        *,
        container_id: builtins.str = ...,
        path: builtins.str = ...,
        service_account_id: builtins.str = ...,
        retry_settings: global___RetrySettings | None = ...,
        dead_letter_queue: global___PutQueueMessage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["dead_letter_queue", b"dead_letter_queue", "retry_settings", b"retry_settings"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["container_id", b"container_id", "dead_letter_queue", b"dead_letter_queue", "path", b"path", "retry_settings", b"retry_settings", "service_account_id", b"service_account_id"]) -> None: ...

global___InvokeContainerWithRetry = InvokeContainerWithRetry

@typing.final
class GatewayWebsocketBroadcast(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    GATEWAY_ID_FIELD_NUMBER: builtins.int
    PATH_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    gateway_id: builtins.str
    path: builtins.str
    service_account_id: builtins.str
    """sa which has permission for writing to websockets"""
    def __init__(
        self,
        *,
        gateway_id: builtins.str = ...,
        path: builtins.str = ...,
        service_account_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["gateway_id", b"gateway_id", "path", b"path", "service_account_id", b"service_account_id"]) -> None: ...

global___GatewayWebsocketBroadcast = GatewayWebsocketBroadcast

@typing.final
class PutQueueMessage(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    QUEUE_ID_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    queue_id: builtins.str
    """ID of the queue."""
    service_account_id: builtins.str
    """Service account which has write permission on the queue."""
    def __init__(
        self,
        *,
        queue_id: builtins.str = ...,
        service_account_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["queue_id", b"queue_id", "service_account_id", b"service_account_id"]) -> None: ...

global___PutQueueMessage = PutQueueMessage

@typing.final
class BatchSettings(google.protobuf.message.Message):
    """Settings for batch processing of messages in a queue."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIZE_FIELD_NUMBER: builtins.int
    CUTOFF_FIELD_NUMBER: builtins.int
    size: builtins.int
    """Batch size. Trigger will send the batch of messages to the function
    when the number of messages in the queue reaches [size], or the [cutoff] time has passed.
    """
    @property
    def cutoff(self) -> google.protobuf.duration_pb2.Duration:
        """Maximum wait time. Trigger will send the batch of messages to the function when
        the number of messages in the queue reaches [size], or the [cutoff] time has passed.
        """

    def __init__(
        self,
        *,
        size: builtins.int = ...,
        cutoff: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["cutoff", b"cutoff"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cutoff", b"cutoff", "size", b"size"]) -> None: ...

global___BatchSettings = BatchSettings

@typing.final
class CloudLogsBatchSettings(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIZE_FIELD_NUMBER: builtins.int
    CUTOFF_FIELD_NUMBER: builtins.int
    size: builtins.int
    """Batch size. Trigger will send the batch of messages to the function
    when the number of messages in the log group reaches [size], or the [cutoff] time has passed.
    """
    @property
    def cutoff(self) -> google.protobuf.duration_pb2.Duration:
        """Maximum wait time. Trigger will send the batch of messages to the function when
        the number of messages in the log group reaches [size], or the [cutoff] time has passed.
        """

    def __init__(
        self,
        *,
        size: builtins.int = ...,
        cutoff: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["cutoff", b"cutoff"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cutoff", b"cutoff", "size", b"size"]) -> None: ...

global___CloudLogsBatchSettings = CloudLogsBatchSettings

@typing.final
class LoggingBatchSettings(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIZE_FIELD_NUMBER: builtins.int
    CUTOFF_FIELD_NUMBER: builtins.int
    size: builtins.int
    """Batch size. Trigger will send the batch of messages to the associated function
    when the number of log events reaches this value, or the [cutoff] time has passed.
    """
    @property
    def cutoff(self) -> google.protobuf.duration_pb2.Duration:
        """Maximum wait time. Trigger will send the batch of messages the time since the last batch
        exceeds the `cutoff` value, regardless of the amount of log events.
        """

    def __init__(
        self,
        *,
        size: builtins.int = ...,
        cutoff: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["cutoff", b"cutoff"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cutoff", b"cutoff", "size", b"size"]) -> None: ...

global___LoggingBatchSettings = LoggingBatchSettings

@typing.final
class RetrySettings(google.protobuf.message.Message):
    """Settings for retrying to invoke a function."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RETRY_ATTEMPTS_FIELD_NUMBER: builtins.int
    INTERVAL_FIELD_NUMBER: builtins.int
    retry_attempts: builtins.int
    """Maximum number of retries (extra invokes) before the action is considered failed."""
    @property
    def interval(self) -> google.protobuf.duration_pb2.Duration:
        """Time in seconds to wait between individual retries."""

    def __init__(
        self,
        *,
        retry_attempts: builtins.int = ...,
        interval: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["interval", b"interval"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["interval", b"interval", "retry_attempts", b"retry_attempts"]) -> None: ...

global___RetrySettings = RetrySettings

@typing.final
class BillingBudget(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BILLING_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    BUDGET_ID_FIELD_NUMBER: builtins.int
    INVOKE_FUNCTION_FIELD_NUMBER: builtins.int
    INVOKE_CONTAINER_FIELD_NUMBER: builtins.int
    GATEWAY_WEBSOCKET_BROADCAST_FIELD_NUMBER: builtins.int
    billing_account_id: builtins.str
    budget_id: builtins.str
    @property
    def invoke_function(self) -> global___InvokeFunctionWithRetry: ...
    @property
    def invoke_container(self) -> global___InvokeContainerWithRetry: ...
    @property
    def gateway_websocket_broadcast(self) -> global___GatewayWebsocketBroadcast: ...
    def __init__(
        self,
        *,
        billing_account_id: builtins.str = ...,
        budget_id: builtins.str = ...,
        invoke_function: global___InvokeFunctionWithRetry | None = ...,
        invoke_container: global___InvokeContainerWithRetry | None = ...,
        gateway_websocket_broadcast: global___GatewayWebsocketBroadcast | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["action", b"action", "gateway_websocket_broadcast", b"gateway_websocket_broadcast", "invoke_container", b"invoke_container", "invoke_function", b"invoke_function"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["action", b"action", "billing_account_id", b"billing_account_id", "budget_id", b"budget_id", "gateway_websocket_broadcast", b"gateway_websocket_broadcast", "invoke_container", b"invoke_container", "invoke_function", b"invoke_function"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["action", b"action"]) -> typing.Literal["invoke_function", "invoke_container", "gateway_websocket_broadcast"] | None: ...

global___BillingBudget = BillingBudget

@typing.final
class DataStreamBatchSettings(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIZE_FIELD_NUMBER: builtins.int
    CUTOFF_FIELD_NUMBER: builtins.int
    size: builtins.int
    """Batch size in bytes. Trigger will send the batch of messages to the associated function
    when size of log events reaches this value, or the [cutoff] time has passed.
    """
    @property
    def cutoff(self) -> google.protobuf.duration_pb2.Duration:
        """Maximum wait time. Trigger will send the batch of messages the time since the last batch
        exceeds the `cutoff` value, regardless of the amount of log events.
        """

    def __init__(
        self,
        *,
        size: builtins.int = ...,
        cutoff: google.protobuf.duration_pb2.Duration | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["cutoff", b"cutoff"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["cutoff", b"cutoff", "size", b"size"]) -> None: ...

global___DataStreamBatchSettings = DataStreamBatchSettings

@typing.final
class DataStream(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENDPOINT_FIELD_NUMBER: builtins.int
    DATABASE_FIELD_NUMBER: builtins.int
    STREAM_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    BATCH_SETTINGS_FIELD_NUMBER: builtins.int
    INVOKE_FUNCTION_FIELD_NUMBER: builtins.int
    INVOKE_CONTAINER_FIELD_NUMBER: builtins.int
    GATEWAY_WEBSOCKET_BROADCAST_FIELD_NUMBER: builtins.int
    endpoint: builtins.str
    """Data stream endpoint."""
    database: builtins.str
    """Data stream database."""
    stream: builtins.str
    """Stream name."""
    service_account_id: builtins.str
    """ID of the service account which has permission to read data stream."""
    @property
    def batch_settings(self) -> global___DataStreamBatchSettings:
        """Batch settings for processing events."""

    @property
    def invoke_function(self) -> global___InvokeFunctionWithRetry: ...
    @property
    def invoke_container(self) -> global___InvokeContainerWithRetry: ...
    @property
    def gateway_websocket_broadcast(self) -> global___GatewayWebsocketBroadcast: ...
    def __init__(
        self,
        *,
        endpoint: builtins.str = ...,
        database: builtins.str = ...,
        stream: builtins.str = ...,
        service_account_id: builtins.str = ...,
        batch_settings: global___DataStreamBatchSettings | None = ...,
        invoke_function: global___InvokeFunctionWithRetry | None = ...,
        invoke_container: global___InvokeContainerWithRetry | None = ...,
        gateway_websocket_broadcast: global___GatewayWebsocketBroadcast | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["action", b"action", "batch_settings", b"batch_settings", "gateway_websocket_broadcast", b"gateway_websocket_broadcast", "invoke_container", b"invoke_container", "invoke_function", b"invoke_function"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["action", b"action", "batch_settings", b"batch_settings", "database", b"database", "endpoint", b"endpoint", "gateway_websocket_broadcast", b"gateway_websocket_broadcast", "invoke_container", b"invoke_container", "invoke_function", b"invoke_function", "service_account_id", b"service_account_id", "stream", b"stream"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["action", b"action"]) -> typing.Literal["invoke_function", "invoke_container", "gateway_websocket_broadcast"] | None: ...

global___DataStream = DataStream

@typing.final
class ObjectStorageBucketSettings(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BUCKET_ID_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    bucket_id: builtins.str
    """Bucket for saving."""
    service_account_id: builtins.str
    """SA which has write permission on storage."""
    def __init__(
        self,
        *,
        bucket_id: builtins.str = ...,
        service_account_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["bucket_id", b"bucket_id", "service_account_id", b"service_account_id"]) -> None: ...

global___ObjectStorageBucketSettings = ObjectStorageBucketSettings

@typing.final
class Mail(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EMAIL_FIELD_NUMBER: builtins.int
    BATCH_SETTINGS_FIELD_NUMBER: builtins.int
    ATTACHMENTS_BUCKET_FIELD_NUMBER: builtins.int
    INVOKE_FUNCTION_FIELD_NUMBER: builtins.int
    INVOKE_CONTAINER_FIELD_NUMBER: builtins.int
    GATEWAY_WEBSOCKET_BROADCAST_FIELD_NUMBER: builtins.int
    email: builtins.str
    """Address to receive emails for trigger activation.
    Field is ignored for write requests and populated on trigger creation.
    """
    @property
    def batch_settings(self) -> global___BatchSettings:
        """Batch settings for processing events."""

    @property
    def attachments_bucket(self) -> global___ObjectStorageBucketSettings:
        """Bucket settings for saving attachments."""

    @property
    def invoke_function(self) -> global___InvokeFunctionWithRetry: ...
    @property
    def invoke_container(self) -> global___InvokeContainerWithRetry: ...
    @property
    def gateway_websocket_broadcast(self) -> global___GatewayWebsocketBroadcast: ...
    def __init__(
        self,
        *,
        email: builtins.str = ...,
        batch_settings: global___BatchSettings | None = ...,
        attachments_bucket: global___ObjectStorageBucketSettings | None = ...,
        invoke_function: global___InvokeFunctionWithRetry | None = ...,
        invoke_container: global___InvokeContainerWithRetry | None = ...,
        gateway_websocket_broadcast: global___GatewayWebsocketBroadcast | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["action", b"action", "attachments_bucket", b"attachments_bucket", "batch_settings", b"batch_settings", "gateway_websocket_broadcast", b"gateway_websocket_broadcast", "invoke_container", b"invoke_container", "invoke_function", b"invoke_function"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["action", b"action", "attachments_bucket", b"attachments_bucket", "batch_settings", b"batch_settings", "email", b"email", "gateway_websocket_broadcast", b"gateway_websocket_broadcast", "invoke_container", b"invoke_container", "invoke_function", b"invoke_function"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["action", b"action"]) -> typing.Literal["invoke_function", "invoke_container", "gateway_websocket_broadcast"] | None: ...

global___Mail = Mail
