"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import typing
import yandex.cloud.smartwebsecurity.v1.waf.waf_profile_pb2

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetWafProfileRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WAF_PROFILE_ID_FIELD_NUMBER: builtins.int
    waf_profile_id: builtins.str
    """ID of the WafProfile resource to return."""
    def __init__(
        self,
        *,
        waf_profile_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["waf_profile_id", b"waf_profile_id"]) -> None: ...

global___GetWafProfileRequest = GetWafProfileRequest

@typing.final
class ListWafProfilesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FOLDER_ID_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder that the WAF profile belongs to.
    Currently page_size, page_token, filter and order_by are not supported and List method will return all WAF profiles in the folder.
    """
    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["folder_id", b"folder_id"]) -> None: ...

global___ListWafProfilesRequest = ListWafProfilesRequest

@typing.final
class ListWafProfilesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WAF_PROFILES_FIELD_NUMBER: builtins.int
    @property
    def waf_profiles(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.smartwebsecurity.v1.waf.waf_profile_pb2.WafProfile]:
        """List of WafProfile resources.
        Currently next_page_token is not supported and List method will return all WAF profiles in the folder.
        """

    def __init__(
        self,
        *,
        waf_profiles: collections.abc.Iterable[yandex.cloud.smartwebsecurity.v1.waf.waf_profile_pb2.WafProfile] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["waf_profiles", b"waf_profiles"]) -> None: ...

global___ListWafProfilesResponse = ListWafProfilesResponse

@typing.final
class CreateWafProfileRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    FOLDER_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    RULES_FIELD_NUMBER: builtins.int
    EXCLUSION_RULES_FIELD_NUMBER: builtins.int
    CORE_RULE_SET_FIELD_NUMBER: builtins.int
    ANALYZE_REQUEST_BODY_FIELD_NUMBER: builtins.int
    RULE_SETS_FIELD_NUMBER: builtins.int
    MATCH_ALL_RULE_SETS_FIELD_NUMBER: builtins.int
    folder_id: builtins.str
    """ID of the folder to create a WAF profile in."""
    name: builtins.str
    """Name of the WAF profile. The name is unique within the folder. 1-50 characters long."""
    description: builtins.str
    """Optional description of the WAF profile."""
    match_all_rule_sets: builtins.bool
    """Parameter determines should all rule sets be matched."""
    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Labels as `` key:value `` pairs. Maximum of 64 per resource."""

    @property
    def rules(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.smartwebsecurity.v1.waf.waf_profile_pb2.WafProfileRule]:
        """Settings for each rule in rule set."""

    @property
    def exclusion_rules(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.smartwebsecurity.v1.waf.waf_profile_pb2.WafProfileExclusionRule]:
        """List of exclusion rules. See [Rules](/docs/smartwebsecurity/concepts/waf#exclusion-rules)."""

    @property
    def core_rule_set(self) -> yandex.cloud.smartwebsecurity.v1.waf.waf_profile_pb2.WafProfile.CoreRuleSet:
        """Core rule set settings. See [Basic rule set](/docs/smartwebsecurity/concepts/waf#rules-set) for details."""

    @property
    def analyze_request_body(self) -> yandex.cloud.smartwebsecurity.v1.waf.waf_profile_pb2.WafProfile.AnalyzeRequestBody:
        """Parameters for request body analyzer."""

    @property
    def rule_sets(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.smartwebsecurity.v1.waf.waf_profile_pb2.WafProfile.WafProfileRuleSet]:
        """List of rule sets. See [Rules](/docs/smartwebsecurity/concepts/waf#rules-set)."""

    def __init__(
        self,
        *,
        folder_id: builtins.str = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        rules: collections.abc.Iterable[yandex.cloud.smartwebsecurity.v1.waf.waf_profile_pb2.WafProfileRule] | None = ...,
        exclusion_rules: collections.abc.Iterable[yandex.cloud.smartwebsecurity.v1.waf.waf_profile_pb2.WafProfileExclusionRule] | None = ...,
        core_rule_set: yandex.cloud.smartwebsecurity.v1.waf.waf_profile_pb2.WafProfile.CoreRuleSet | None = ...,
        analyze_request_body: yandex.cloud.smartwebsecurity.v1.waf.waf_profile_pb2.WafProfile.AnalyzeRequestBody | None = ...,
        rule_sets: collections.abc.Iterable[yandex.cloud.smartwebsecurity.v1.waf.waf_profile_pb2.WafProfile.WafProfileRuleSet] | None = ...,
        match_all_rule_sets: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["analyze_request_body", b"analyze_request_body", "core_rule_set", b"core_rule_set", "rule_set", b"rule_set"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["analyze_request_body", b"analyze_request_body", "core_rule_set", b"core_rule_set", "description", b"description", "exclusion_rules", b"exclusion_rules", "folder_id", b"folder_id", "labels", b"labels", "match_all_rule_sets", b"match_all_rule_sets", "name", b"name", "rule_set", b"rule_set", "rule_sets", b"rule_sets", "rules", b"rules"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["rule_set", b"rule_set"]) -> typing.Literal["core_rule_set"] | None: ...

global___CreateWafProfileRequest = CreateWafProfileRequest

@typing.final
class CreateWafProfileMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WAF_PROFILE_ID_FIELD_NUMBER: builtins.int
    waf_profile_id: builtins.str
    """ID of the WAF profile that is being created."""
    def __init__(
        self,
        *,
        waf_profile_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["waf_profile_id", b"waf_profile_id"]) -> None: ...

global___CreateWafProfileMetadata = CreateWafProfileMetadata

@typing.final
class UpdateWafProfileRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    WAF_PROFILE_ID_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    RULES_FIELD_NUMBER: builtins.int
    EXCLUSION_RULES_FIELD_NUMBER: builtins.int
    CORE_RULE_SET_FIELD_NUMBER: builtins.int
    ANALYZE_REQUEST_BODY_FIELD_NUMBER: builtins.int
    RULE_SETS_FIELD_NUMBER: builtins.int
    MATCH_ALL_RULE_SETS_FIELD_NUMBER: builtins.int
    waf_profile_id: builtins.str
    """ID of the WAF profile to update."""
    name: builtins.str
    """Name of the WAF profile. The name is unique within the folder. 1-50 characters long."""
    description: builtins.str
    """Optional description of the WAF profile."""
    match_all_rule_sets: builtins.bool
    """Parameter determines should all rule sets be matched."""
    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """Field mask that specifies which fields of the WafProfile resource are going to be updated."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Labels as `` key:value `` pairs. Maximum of 64 per resource."""

    @property
    def rules(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.smartwebsecurity.v1.waf.waf_profile_pb2.WafProfileRule]:
        """Settings for each rule in rule set."""

    @property
    def exclusion_rules(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.smartwebsecurity.v1.waf.waf_profile_pb2.WafProfileExclusionRule]:
        """List of exclusion rules. See [Rules](/docs/smartwebsecurity/concepts/waf#exclusion-rules)."""

    @property
    def core_rule_set(self) -> yandex.cloud.smartwebsecurity.v1.waf.waf_profile_pb2.WafProfile.CoreRuleSet:
        """Core rule set settings. See [Basic rule set](/docs/smartwebsecurity/concepts/waf#rules-set) for details."""

    @property
    def analyze_request_body(self) -> yandex.cloud.smartwebsecurity.v1.waf.waf_profile_pb2.WafProfile.AnalyzeRequestBody:
        """Parameters for request body analyzer."""

    @property
    def rule_sets(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[yandex.cloud.smartwebsecurity.v1.waf.waf_profile_pb2.WafProfile.WafProfileRuleSet]:
        """List of rule sets. See [Rules](/docs/smartwebsecurity/concepts/waf#rules-set)."""

    def __init__(
        self,
        *,
        waf_profile_id: builtins.str = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        rules: collections.abc.Iterable[yandex.cloud.smartwebsecurity.v1.waf.waf_profile_pb2.WafProfileRule] | None = ...,
        exclusion_rules: collections.abc.Iterable[yandex.cloud.smartwebsecurity.v1.waf.waf_profile_pb2.WafProfileExclusionRule] | None = ...,
        core_rule_set: yandex.cloud.smartwebsecurity.v1.waf.waf_profile_pb2.WafProfile.CoreRuleSet | None = ...,
        analyze_request_body: yandex.cloud.smartwebsecurity.v1.waf.waf_profile_pb2.WafProfile.AnalyzeRequestBody | None = ...,
        rule_sets: collections.abc.Iterable[yandex.cloud.smartwebsecurity.v1.waf.waf_profile_pb2.WafProfile.WafProfileRuleSet] | None = ...,
        match_all_rule_sets: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["analyze_request_body", b"analyze_request_body", "core_rule_set", b"core_rule_set", "rule_set", b"rule_set", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["analyze_request_body", b"analyze_request_body", "core_rule_set", b"core_rule_set", "description", b"description", "exclusion_rules", b"exclusion_rules", "labels", b"labels", "match_all_rule_sets", b"match_all_rule_sets", "name", b"name", "rule_set", b"rule_set", "rule_sets", b"rule_sets", "rules", b"rules", "update_mask", b"update_mask", "waf_profile_id", b"waf_profile_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["rule_set", b"rule_set"]) -> typing.Literal["core_rule_set"] | None: ...

global___UpdateWafProfileRequest = UpdateWafProfileRequest

@typing.final
class UpdateWafProfileMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WAF_PROFILE_ID_FIELD_NUMBER: builtins.int
    waf_profile_id: builtins.str
    """ID of the WafProfile resource that is being updated."""
    def __init__(
        self,
        *,
        waf_profile_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["waf_profile_id", b"waf_profile_id"]) -> None: ...

global___UpdateWafProfileMetadata = UpdateWafProfileMetadata

@typing.final
class DeleteWafProfileRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WAF_PROFILE_ID_FIELD_NUMBER: builtins.int
    waf_profile_id: builtins.str
    """ID of the WAF profile to delete."""
    def __init__(
        self,
        *,
        waf_profile_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["waf_profile_id", b"waf_profile_id"]) -> None: ...

global___DeleteWafProfileRequest = DeleteWafProfileRequest

@typing.final
class DeleteWafProfileMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WAF_PROFILE_ID_FIELD_NUMBER: builtins.int
    waf_profile_id: builtins.str
    """ID of the WafProfile resource that is being deleted."""
    def __init__(
        self,
        *,
        waf_profile_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["waf_profile_id", b"waf_profile_id"]) -> None: ...

global___DeleteWafProfileMetadata = DeleteWafProfileMetadata
