"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing
import yandex.cloud.spark.v1.maintenance_pb2

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _Health:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _HealthEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Health.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    HEALTH_UNKNOWN: _Health.ValueType  # 0
    """Cluster is in unknown state (we have no data)."""
    ALIVE: _Health.ValueType  # 1
    """Cluster is alive and well."""
    DEAD: _Health.ValueType  # 2
    """Cluster is inoperable (it cannot perform any of its essential functions)."""
    DEGRADED: _Health.ValueType  # 3
    """Cluster is partially alive (it can perform some of its essential functions)."""

class Health(_Health, metaclass=_HealthEnumTypeWrapper): ...

HEALTH_UNKNOWN: Health.ValueType  # 0
"""Cluster is in unknown state (we have no data)."""
ALIVE: Health.ValueType  # 1
"""Cluster is alive and well."""
DEAD: Health.ValueType  # 2
"""Cluster is inoperable (it cannot perform any of its essential functions)."""
DEGRADED: Health.ValueType  # 3
"""Cluster is partially alive (it can perform some of its essential functions)."""
global___Health = Health

@typing.final
class Cluster(google.protobuf.message.Message):
    """Spark cluster."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Cluster._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STATUS_UNKNOWN: Cluster._Status.ValueType  # 0
        """Cluster status is unknown"""
        CREATING: Cluster._Status.ValueType  # 1
        """Cluster is being created"""
        RUNNING: Cluster._Status.ValueType  # 2
        """Cluster is running normally."""
        UPDATING: Cluster._Status.ValueType  # 3
        """Cluster is being updated."""
        ERROR: Cluster._Status.ValueType  # 4
        """Cluster encountered a problem and cannot operate."""
        STOPPING: Cluster._Status.ValueType  # 5
        """Cluster is stopping."""
        STOPPED: Cluster._Status.ValueType  # 6
        """Cluster is stopped."""
        STARTING: Cluster._Status.ValueType  # 7
        """Cluster is starting."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    STATUS_UNKNOWN: Cluster.Status.ValueType  # 0
    """Cluster status is unknown"""
    CREATING: Cluster.Status.ValueType  # 1
    """Cluster is being created"""
    RUNNING: Cluster.Status.ValueType  # 2
    """Cluster is running normally."""
    UPDATING: Cluster.Status.ValueType  # 3
    """Cluster is being updated."""
    ERROR: Cluster.Status.ValueType  # 4
    """Cluster encountered a problem and cannot operate."""
    STOPPING: Cluster.Status.ValueType  # 5
    """Cluster is stopping."""
    STOPPED: Cluster.Status.ValueType  # 6
    """Cluster is stopped."""
    STARTING: Cluster.Status.ValueType  # 7
    """Cluster is starting."""

    @typing.final
    class LabelsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["key", b"key", "value", b"value"]) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    LABELS_FIELD_NUMBER: builtins.int
    CONFIG_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    NETWORK_FIELD_NUMBER: builtins.int
    DELETION_PROTECTION_FIELD_NUMBER: builtins.int
    SERVICE_ACCOUNT_ID_FIELD_NUMBER: builtins.int
    LOGGING_FIELD_NUMBER: builtins.int
    HEALTH_FIELD_NUMBER: builtins.int
    LINKS_FIELD_NUMBER: builtins.int
    MAINTENANCE_WINDOW_FIELD_NUMBER: builtins.int
    PLANNED_OPERATION_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Unique ID of the Spark cluster.
    This ID is assigned by Cloud in the process of creating a Spark cluster.
    """
    folder_id: builtins.str
    """ID of the folder that the Spark cluster belongs to."""
    name: builtins.str
    """Name of the Spark cluster.
    The name is unique within the folder. 1-64 characters long.
    """
    description: builtins.str
    """Description of the Spark cluster. 0-256 characters long."""
    status: global___Cluster.Status.ValueType
    """Cluster status."""
    deletion_protection: builtins.bool
    """Deletion Protection inhibits deletion of the cluster"""
    service_account_id: builtins.str
    """Service account that will be used to access a YC resources"""
    health: global___Health.ValueType
    """Aggregated cluster health."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time when the Spark cluster was created."""

    @property
    def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]: ...
    @property
    def config(self) -> global___ClusterConfig:
        """Configuration of the Spark cluster."""

    @property
    def network(self) -> global___NetworkConfig: ...
    @property
    def logging(self) -> global___LoggingConfig:
        """Cloud logging configuration."""

    @property
    def links(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___UILink]:
        """UI URLs"""

    @property
    def maintenance_window(self) -> yandex.cloud.spark.v1.maintenance_pb2.MaintenanceWindow:
        """Window of maintenance operations."""

    @property
    def planned_operation(self) -> yandex.cloud.spark.v1.maintenance_pb2.MaintenanceOperation:
        """Maintenance operation planned at nearest maintenance_window."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        folder_id: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        name: builtins.str = ...,
        description: builtins.str = ...,
        labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        config: global___ClusterConfig | None = ...,
        status: global___Cluster.Status.ValueType = ...,
        network: global___NetworkConfig | None = ...,
        deletion_protection: builtins.bool = ...,
        service_account_id: builtins.str = ...,
        logging: global___LoggingConfig | None = ...,
        health: global___Health.ValueType = ...,
        links: collections.abc.Iterable[global___UILink] | None = ...,
        maintenance_window: yandex.cloud.spark.v1.maintenance_pb2.MaintenanceWindow | None = ...,
        planned_operation: yandex.cloud.spark.v1.maintenance_pb2.MaintenanceOperation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["config", b"config", "created_at", b"created_at", "logging", b"logging", "maintenance_window", b"maintenance_window", "network", b"network", "planned_operation", b"planned_operation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["config", b"config", "created_at", b"created_at", "deletion_protection", b"deletion_protection", "description", b"description", "folder_id", b"folder_id", "health", b"health", "id", b"id", "labels", b"labels", "links", b"links", "logging", b"logging", "maintenance_window", b"maintenance_window", "name", b"name", "network", b"network", "planned_operation", b"planned_operation", "service_account_id", b"service_account_id", "status", b"status"]) -> None: ...

global___Cluster = Cluster

@typing.final
class ClusterConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCE_POOLS_FIELD_NUMBER: builtins.int
    HISTORY_SERVER_FIELD_NUMBER: builtins.int
    DEPENDENCIES_FIELD_NUMBER: builtins.int
    METASTORE_FIELD_NUMBER: builtins.int
    @property
    def resource_pools(self) -> global___ResourcePools: ...
    @property
    def history_server(self) -> global___HistoryServerConfig:
        """Configuration for HistoryServer"""

    @property
    def dependencies(self) -> global___Dependencies:
        """Container custom environment dependencies"""

    @property
    def metastore(self) -> global___Metastore:
        """Metastore Cluster"""

    def __init__(
        self,
        *,
        resource_pools: global___ResourcePools | None = ...,
        history_server: global___HistoryServerConfig | None = ...,
        dependencies: global___Dependencies | None = ...,
        metastore: global___Metastore | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["dependencies", b"dependencies", "history_server", b"history_server", "metastore", b"metastore", "resource_pools", b"resource_pools"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["dependencies", b"dependencies", "history_server", b"history_server", "metastore", b"metastore", "resource_pools", b"resource_pools"]) -> None: ...

global___ClusterConfig = ClusterConfig

@typing.final
class UpdateClusterConfigSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCE_POOLS_FIELD_NUMBER: builtins.int
    HISTORY_SERVER_FIELD_NUMBER: builtins.int
    DEPENDENCIES_FIELD_NUMBER: builtins.int
    METASTORE_FIELD_NUMBER: builtins.int
    @property
    def resource_pools(self) -> global___ResourcePools: ...
    @property
    def history_server(self) -> global___HistoryServerConfig:
        """Configuration for HistoryServer"""

    @property
    def dependencies(self) -> global___Dependencies:
        """Container custom environment dependencies"""

    @property
    def metastore(self) -> global___Metastore:
        """Metastore Cluster"""

    def __init__(
        self,
        *,
        resource_pools: global___ResourcePools | None = ...,
        history_server: global___HistoryServerConfig | None = ...,
        dependencies: global___Dependencies | None = ...,
        metastore: global___Metastore | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["dependencies", b"dependencies", "history_server", b"history_server", "metastore", b"metastore", "resource_pools", b"resource_pools"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["dependencies", b"dependencies", "history_server", b"history_server", "metastore", b"metastore", "resource_pools", b"resource_pools"]) -> None: ...

global___UpdateClusterConfigSpec = UpdateClusterConfigSpec

@typing.final
class HistoryServerConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENABLED_FIELD_NUMBER: builtins.int
    enabled: builtins.bool
    def __init__(
        self,
        *,
        enabled: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["enabled", b"enabled"]) -> None: ...

global___HistoryServerConfig = HistoryServerConfig

@typing.final
class NetworkConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBNET_IDS_FIELD_NUMBER: builtins.int
    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    @property
    def subnet_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """IDs of VPC network subnets where instances of the cluster are attached."""

    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """User security groups"""

    def __init__(
        self,
        *,
        subnet_ids: collections.abc.Iterable[builtins.str] | None = ...,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["security_group_ids", b"security_group_ids", "subnet_ids", b"subnet_ids"]) -> None: ...

global___NetworkConfig = NetworkConfig

@typing.final
class UpdateNetworkConfigSpec(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SECURITY_GROUP_IDS_FIELD_NUMBER: builtins.int
    @property
    def security_group_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """User security groups."""

    def __init__(
        self,
        *,
        security_group_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["security_group_ids", b"security_group_ids"]) -> None: ...

global___UpdateNetworkConfigSpec = UpdateNetworkConfigSpec

@typing.final
class ResourcePools(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DRIVER_FIELD_NUMBER: builtins.int
    EXECUTOR_FIELD_NUMBER: builtins.int
    @property
    def driver(self) -> global___ResourcePool: ...
    @property
    def executor(self) -> global___ResourcePool: ...
    def __init__(
        self,
        *,
        driver: global___ResourcePool | None = ...,
        executor: global___ResourcePool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["driver", b"driver", "executor", b"executor"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["driver", b"driver", "executor", b"executor"]) -> None: ...

global___ResourcePools = ResourcePools

@typing.final
class ResourcePool(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCE_PRESET_ID_FIELD_NUMBER: builtins.int
    SCALE_POLICY_FIELD_NUMBER: builtins.int
    resource_preset_id: builtins.str
    """ID of the preset for computational resources allocated to a instance (e.g., CPU, memory, etc.)."""
    @property
    def scale_policy(self) -> global___ScalePolicy: ...
    def __init__(
        self,
        *,
        resource_preset_id: builtins.str = ...,
        scale_policy: global___ScalePolicy | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["scale_policy", b"scale_policy"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["resource_preset_id", b"resource_preset_id", "scale_policy", b"scale_policy"]) -> None: ...

global___ResourcePool = ResourcePool

@typing.final
class ScalePolicy(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class FixedScale(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        SIZE_FIELD_NUMBER: builtins.int
        size: builtins.int
        def __init__(
            self,
            *,
            size: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["size", b"size"]) -> None: ...

    @typing.final
    class AutoScale(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        MIN_SIZE_FIELD_NUMBER: builtins.int
        MAX_SIZE_FIELD_NUMBER: builtins.int
        min_size: builtins.int
        max_size: builtins.int
        def __init__(
            self,
            *,
            min_size: builtins.int = ...,
            max_size: builtins.int = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["max_size", b"max_size", "min_size", b"min_size"]) -> None: ...

    FIXED_SCALE_FIELD_NUMBER: builtins.int
    AUTO_SCALE_FIELD_NUMBER: builtins.int
    @property
    def fixed_scale(self) -> global___ScalePolicy.FixedScale: ...
    @property
    def auto_scale(self) -> global___ScalePolicy.AutoScale: ...
    def __init__(
        self,
        *,
        fixed_scale: global___ScalePolicy.FixedScale | None = ...,
        auto_scale: global___ScalePolicy.AutoScale | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["auto_scale", b"auto_scale", "fixed_scale", b"fixed_scale", "scale_type", b"scale_type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["auto_scale", b"auto_scale", "fixed_scale", b"fixed_scale", "scale_type", b"scale_type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["scale_type", b"scale_type"]) -> typing.Literal["fixed_scale", "auto_scale"] | None: ...

global___ScalePolicy = ScalePolicy

@typing.final
class Dependencies(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PIP_PACKAGES_FIELD_NUMBER: builtins.int
    DEB_PACKAGES_FIELD_NUMBER: builtins.int
    @property
    def pip_packages(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def deb_packages(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        pip_packages: collections.abc.Iterable[builtins.str] | None = ...,
        deb_packages: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["deb_packages", b"deb_packages", "pip_packages", b"pip_packages"]) -> None: ...

global___Dependencies = Dependencies

@typing.final
class Metastore(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CLUSTER_ID_FIELD_NUMBER: builtins.int
    cluster_id: builtins.str
    def __init__(
        self,
        *,
        cluster_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cluster_id", b"cluster_id"]) -> None: ...

global___Metastore = Metastore

@typing.final
class LoggingConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENABLED_FIELD_NUMBER: builtins.int
    FOLDER_ID_FIELD_NUMBER: builtins.int
    LOG_GROUP_ID_FIELD_NUMBER: builtins.int
    enabled: builtins.bool
    folder_id: builtins.str
    log_group_id: builtins.str
    def __init__(
        self,
        *,
        enabled: builtins.bool = ...,
        folder_id: builtins.str = ...,
        log_group_id: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["destination", b"destination", "folder_id", b"folder_id", "log_group_id", b"log_group_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["destination", b"destination", "enabled", b"enabled", "folder_id", b"folder_id", "log_group_id", b"log_group_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["destination", b"destination"]) -> typing.Literal["folder_id", "log_group_id"] | None: ...

global___LoggingConfig = LoggingConfig

@typing.final
class UILink(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    URL_FIELD_NUMBER: builtins.int
    name: builtins.str
    url: builtins.str
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        url: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["name", b"name", "url", b"url"]) -> None: ...

global___UILink = UILink
